/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.jms.client;

import com.rabbitmq.jms.client.RMQConnection;
import com.rabbitmq.jms.client.RMQSession;
import com.rabbitmq.jms.client.RmqJmsConsumer;
import com.rabbitmq.jms.client.RmqJmsProducer;
import com.rabbitmq.jms.client.Utils;
import jakarta.jms.BytesMessage;
import jakarta.jms.ConnectionMetaData;
import jakarta.jms.Destination;
import jakarta.jms.ExceptionListener;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSProducer;
import jakarta.jms.JMSRuntimeException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.StreamMessage;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RmqJmsContext
implements JMSContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(RmqJmsContext.class);
    private final RMQConnection connection;
    private final int sessionMode;
    private final Lock sessionLock = new ReentrantLock();
    private volatile RMQSession session;
    private volatile boolean autoStart = true;

    public RmqJmsContext(RMQConnection connection, int sessionMode) {
        if (!RMQSession.validateSessionMode(sessionMode)) {
            throw new JMSRuntimeException(String.format("cannot create session with acknowledgement mode = %d.", sessionMode));
        }
        this.connection = connection;
        this.sessionMode = sessionMode;
        this.session = null;
    }

    public JMSContext createContext(int contextSessionMode) {
        return Utils.wrap(() -> new RmqJmsContext(this.connection, contextSessionMode));
    }

    public JMSProducer createProducer() {
        return new RmqJmsProducer(this.session(), Utils.wrap(() -> this.session().createProducer(null)));
    }

    public String getClientID() {
        return Utils.wrap(() -> this.connection.getClientID());
    }

    public void setClientID(String clientID) {
        Utils.wrap(() -> this.connection.setClientID(clientID));
    }

    public ConnectionMetaData getMetaData() {
        return Utils.wrap(this.connection::getMetaData);
    }

    public ExceptionListener getExceptionListener() {
        return Utils.wrap(this.connection::getExceptionListener);
    }

    public void setExceptionListener(ExceptionListener listener) {
        Utils.wrap(() -> this.connection.setExceptionListener(listener));
    }

    public void start() {
        Utils.wrap(this.connection::start);
    }

    public void stop() {
        Utils.wrap(this.connection::stop);
    }

    public boolean getAutoStart() {
        return this.autoStart;
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public void close() {
        try {
            Utils.wrap(this.session()::close);
        }
        catch (Exception e) {
            LOGGER.warn("Error while closing context session: {}", (Object)e.getMessage());
        }
        if (!this.connection.hasSessions()) {
            Utils.wrap(this.connection::close);
        }
    }

    public BytesMessage createBytesMessage() {
        return Utils.wrap(this.session()::createBytesMessage);
    }

    public MapMessage createMapMessage() {
        return Utils.wrap(this.session()::createMapMessage);
    }

    public Message createMessage() {
        return Utils.wrap(this.session()::createMessage);
    }

    public ObjectMessage createObjectMessage() {
        return Utils.wrap(() -> this.session().createObjectMessage());
    }

    public ObjectMessage createObjectMessage(Serializable object) {
        return Utils.wrap(() -> this.session().createObjectMessage(object));
    }

    public StreamMessage createStreamMessage() {
        return Utils.wrap(this.session()::createStreamMessage);
    }

    public TextMessage createTextMessage() {
        return Utils.wrap(() -> this.session().createTextMessage());
    }

    public TextMessage createTextMessage(String text) {
        return Utils.wrap(() -> this.session().createTextMessage(text));
    }

    public boolean getTransacted() {
        return Utils.wrap(this.session()::getTransacted);
    }

    public int getSessionMode() {
        return Utils.wrap(this.session()::getAcknowledgeMode);
    }

    public void commit() {
        Utils.wrap(this.session()::commit);
    }

    public void rollback() {
        Utils.wrap(this.session()::rollback);
    }

    public void recover() {
        Utils.wrap(this.session()::recover);
    }

    public JMSConsumer createConsumer(Destination destination) {
        return this.createConsumer(destination, null);
    }

    public JMSConsumer createConsumer(Destination destination, String messageSelector) {
        return this.createConsumer(destination, messageSelector, false);
    }

    public JMSConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) {
        this.maybeAutoStart();
        return new RmqJmsConsumer(this.session(), Utils.wrap(() -> this.session().createConsumer(destination, messageSelector, noLocal)));
    }

    private void maybeAutoStart() {
        if (this.autoStart) {
            this.start();
        }
    }

    public Queue createQueue(String queueName) {
        return Utils.wrap(() -> this.session().createQueue(queueName));
    }

    public Topic createTopic(String topicName) {
        return Utils.wrap(() -> this.session().createTopic(topicName));
    }

    public JMSConsumer createDurableConsumer(Topic topic, String name) {
        return this.createDurableConsumer(topic, name, null, false);
    }

    public JMSConsumer createDurableConsumer(Topic topic, String name, String messageSelector, boolean noLocal) {
        this.maybeAutoStart();
        return new RmqJmsConsumer(this.session(), Utils.wrap(() -> this.session().createDurableConsumer(topic, name, messageSelector, noLocal)));
    }

    public JMSConsumer createSharedDurableConsumer(Topic topic, String name) {
        return this.createSharedDurableConsumer(topic, name, null);
    }

    public JMSConsumer createSharedDurableConsumer(Topic topic, String name, String messageSelector) {
        this.maybeAutoStart();
        return new RmqJmsConsumer(this.session(), Utils.wrap(() -> this.session().createSharedDurableConsumer(topic, name, messageSelector)));
    }

    public JMSConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName) {
        return this.createSharedConsumer(topic, sharedSubscriptionName, null);
    }

    public JMSConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName, String messageSelector) {
        this.maybeAutoStart();
        return new RmqJmsConsumer(this.session(), Utils.wrap(() -> this.session().createSharedConsumer(topic, sharedSubscriptionName, messageSelector)));
    }

    public QueueBrowser createBrowser(Queue queue) {
        return Utils.wrap(() -> this.session().createBrowser(queue));
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) {
        return Utils.wrap(() -> this.session().createBrowser(queue, messageSelector));
    }

    public TemporaryQueue createTemporaryQueue() {
        return Utils.wrap(this.session()::createTemporaryQueue);
    }

    public TemporaryTopic createTemporaryTopic() {
        return Utils.wrap(this.session()::createTemporaryTopic);
    }

    public void unsubscribe(String name) {
        Utils.wrap(() -> this.session().unsubscribe(name));
    }

    public void acknowledge() {
        Utils.wrap(this.session()::acknowledgeMessages);
    }

    private RMQSession session() {
        block4: {
            try {
                if (this.sessionLock.tryLock(1L, TimeUnit.MILLISECONDS)) {
                    if (this.session == null) {
                        this.session = Utils.wrap(() -> (RMQSession)this.connection.createSession(this.sessionMode));
                    }
                    break block4;
                }
                throw new JMSRuntimeException("Impossible to access context session");
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new JMSRuntimeException("Thread interrupted while trying to access context session", "", (Throwable)e);
            }
        }
        return this.session;
    }
}

