/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.utils;

import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.config.XlrConfig$;
import com.xebialabs.xlrelease.config.XlrConfig$ServerSettings$UploadSettings$;
import com.xebialabs.xlrelease.utils.AttachmentUploadException;
import com.xebialabs.xlrelease.utils.AttachmentUploadException$;
import com.xebialabs.xlrelease.utils.UploadSettings;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FilenameUtils;
import org.apache.tika.detect.DefaultDetector;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import scala.util.Try$;
import scala.util.Using;
import scala.util.Using$;

public final class FileContentValidation$ {
    public static final FileContentValidation$ MODULE$ = new FileContentValidation$();
    private static final DefaultDetector tikaDetector = new DefaultDetector();
    private static final XlrConfig xlrConfig = XlrConfig$.MODULE$.getInstance();
    private static final XlrConfig$ServerSettings$UploadSettings$ uploadConfig = MODULE$.xlrConfig().server().upload();
    private static final UploadSettings uploadSettings = new UploadSettings(MODULE$.uploadConfig().shouldAnalyzeContent(), MODULE$.uploadConfig().allowedFileTypes());

    private DefaultDetector tikaDetector() {
        return tikaDetector;
    }

    private XlrConfig xlrConfig() {
        return xlrConfig;
    }

    private XlrConfig$ServerSettings$UploadSettings$ uploadConfig() {
        return uploadConfig;
    }

    private UploadSettings uploadSettings() {
        return uploadSettings;
    }

    public Try<InputStream> apply(String filename, InputStream in) {
        return this.filter(this.uploadSettings(), filename, in);
    }

    public Try<InputStream> filter(UploadSettings uploadSettings, String filename, InputStream in) {
        String sanitizedFilename = org.apache.tika.io.FilenameUtils.normalize((String)filename);
        return this.filterByFileName(uploadSettings, sanitizedFilename).flatMap((Function1 & Serializable)matchedFileTypes -> MODULE$.filterByContent(new UploadSettings(uploadSettings.shouldAnalyzeContent(), (Map<String, List<String>>)matchedFileTypes), sanitizedFilename, in).map((Function1 & Serializable)filteredInputStream -> filteredInputStream));
    }

    private Try<Map<String, List<String>>> filterByFileName(UploadSettings uploadSettings, String filename) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            Map matchingFileTypes;
            block0: {
                matchingFileTypes = (Map)uploadSettings.allowedFileTypes().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)FileContentValidation$.$anonfun$filterByFileName$2(filename, x0$1)));
                if (!matchingFileTypes.isEmpty()) break block0;
                MODULE$.fail("Filename '" + filename + "' is not allowed");
            }
            return matchingFileTypes;
        });
    }

    private Try<InputStream> filterByContent(UploadSettings uploadSettings, String filename, InputStream in) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            if (uploadSettings.shouldAnalyzeContent()) {
                Path path = Files.createTempFile("upload", ".tmp", new FileAttribute[0]);
                Files.copy(in, path, StandardCopyOption.REPLACE_EXISTING);
                Using$.MODULE$.resource((Object)TikaInputStream.get((Path)path), (Function1 & Serializable)tikaInputStream -> {
                    FileContentValidation$.$anonfun$filterByContent$2(filename, uploadSettings, path, tikaInputStream);
                    return BoxedUnit.UNIT;
                }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                return Files.newInputStream(path, StandardOpenOption.DELETE_ON_CLOSE);
            }
            return in;
        });
    }

    private void fail(String message) {
        throw new AttachmentUploadException(message, AttachmentUploadException$.MODULE$.$lessinit$greater$default$2());
    }

    public static final /* synthetic */ boolean $anonfun$filterByFileName$3(String filename$1, String x$1) {
        return FilenameUtils.wildcardMatch((String)filename$1, (String)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$filterByFileName$2(String filename$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            List filenames = (List)tuple2._2();
            return filenames.exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FileContentValidation$.$anonfun$filterByFileName$3(filename$1, x$1)));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$filterByContent$3(String mediaType$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String allowedMediaType = (String)tuple2._1();
            return FilenameUtils.wildcardMatch((String)mediaType$1, (String)allowedMediaType);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$filterByContent$2(String filename$2, UploadSettings uploadSettings$3, Path path$1, TikaInputStream tikaInputStream) {
        Metadata metadata = new Metadata();
        metadata.set("resourceName", filename$2);
        String mediaType = MODULE$.tikaDetector().detect((InputStream)tikaInputStream, metadata).toString();
        Option matchedMediaType = uploadSettings$3.allowedFileTypes().find((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)FileContentValidation$.$anonfun$filterByContent$3(mediaType, x0$1)));
        if (matchedMediaType.isEmpty()) {
            Files.delete(path$1);
            MODULE$.fail("The file of MIME type '" + mediaType + "' with filename '" + filename$2 + "' is not allowed");
            return;
        }
    }

    private FileContentValidation$() {
    }
}

