/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plumbing;

import com.google.common.annotations.VisibleForTesting;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plumbing.PropertyDescriptorJsonWriter;
import com.xebialabs.xltype.serialization.json.JsonWriter;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.nio.charset.StandardCharsets;
import org.springframework.stereotype.Component;

@Component
@Provider
@Produces(value={"application/json"})
public class DescriptorJsonWriter
implements MessageBodyWriter<Descriptor> {
    public boolean isWriteable(Class<?> type, java.lang.reflect.Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    public long getSize(Descriptor descriptor, Class<?> type, java.lang.reflect.Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Descriptor descriptor, Class<?> type, java.lang.reflect.Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        entityStream.write(this.toJson(descriptor).getBytes(StandardCharsets.UTF_8));
    }

    @VisibleForTesting
    String toJson(Descriptor descriptor) {
        StringWriter stringWriter = new StringWriter();
        JsonWriter writer = new JsonWriter((Writer)stringWriter);
        this.writeJson(descriptor, writer);
        return stringWriter.toString();
    }

    public void writeJson(Descriptor descriptor, JsonWriter writer) {
        writer.object();
        DescriptorJsonWriter.descriptorProperties(writer, descriptor);
        DescriptorJsonWriter.writePropertyDescriptors(writer, descriptor);
        DescriptorJsonWriter.writeSuperTypes(writer, descriptor);
        writer.endObject();
    }

    protected static void descriptorProperties(JsonWriter writer, Descriptor descriptor) {
        writer.key("type").value((Object)descriptor.getType().toString());
        writer.key("label").value((Object)descriptor.getLabel());
        if (descriptor.getDeployableType() != null) {
            writer.key("deployableType").value((Object)descriptor.getDeployableType().toString());
        }
        if (descriptor.getContainerType() != null) {
            writer.key("containerType").value((Object)descriptor.getContainerType().toString());
        }
        writer.key("virtual").value(descriptor.isVirtual());
        if (!descriptor.isVirtual() && descriptor.getRoot().getRootNodeName() != null) {
            writer.key("root").value((Object)descriptor.getRoot().getRootNodeName());
        }
        writer.key("description").value((Object)descriptor.getDescription());
    }

    private static void writePropertyDescriptors(JsonWriter writer, Descriptor descriptor) {
        writer.key("properties");
        writer.array();
        for (PropertyDescriptor pd : descriptor.getPropertyDescriptors()) {
            PropertyDescriptorJsonWriter.writePropertyDescriptor(writer, pd);
        }
        writer.endArray();
    }

    protected static void writeSuperTypes(JsonWriter writer, Descriptor descriptor) {
        writer.key("superTypes");
        writer.array();
        for (Type sc : descriptor.getSuperClasses()) {
            writer.value((Object)sc.toString());
        }
        writer.endArray();
    }
}

