/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.kohsuke.github.GHGist;
import org.kohsuke.github.Requester;

public class GHGistUpdater {
    private final GHGist base;
    private final Requester builder;
    LinkedHashMap<String, Map<String, String>> files;

    GHGistUpdater(GHGist base) {
        this.base = base;
        this.builder = base.root().createRequest();
        this.files = new LinkedHashMap();
    }

    public GHGistUpdater addFile(@Nonnull String fileName, @Nonnull String content) throws IOException {
        this.updateFile(fileName, content);
        return this;
    }

    public GHGistUpdater deleteFile(@Nonnull String fileName) throws IOException {
        this.files.put(fileName, null);
        return this;
    }

    public GHGistUpdater renameFile(@Nonnull String fileName, @Nonnull String newFileName) throws IOException {
        Map file = this.files.computeIfAbsent(fileName, d -> new HashMap());
        file.put("filename", newFileName);
        return this;
    }

    public GHGistUpdater updateFile(@Nonnull String fileName, @Nonnull String content) throws IOException {
        Map file = this.files.computeIfAbsent(fileName, d -> new HashMap());
        file.put("content", content);
        return this;
    }

    public GHGistUpdater updateFile(@Nonnull String fileName, @Nonnull String newFileName, @Nonnull String content) throws IOException {
        Map file = this.files.computeIfAbsent(fileName, d -> new HashMap());
        file.put("content", content);
        file.put("filename", newFileName);
        this.files.put(fileName, file);
        return this;
    }

    public GHGistUpdater description(String desc) {
        this.builder.with("description", desc);
        return this;
    }

    public GHGist update() throws IOException {
        this.builder.with("files", this.files);
        return ((Requester)((Requester)this.builder.method("PATCH")).withUrlPath(this.base.getApiTailUrl(""), new String[0])).fetch(GHGist.class);
    }
}

