/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.rsocket.netty;

import io.rsocket.SocketAcceptor;
import io.rsocket.core.RSocketServer;
import io.rsocket.transport.ServerTransport;
import io.rsocket.transport.netty.server.CloseableChannel;
import io.rsocket.transport.netty.server.TcpServerTransport;
import io.rsocket.transport.netty.server.WebsocketServerTransport;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.rsocket.netty.NettyRSocketServer;
import org.springframework.boot.rsocket.server.ConfigurableRSocketServerFactory;
import org.springframework.boot.rsocket.server.RSocketServer;
import org.springframework.boot.rsocket.server.RSocketServerCustomizer;
import org.springframework.boot.rsocket.server.RSocketServerFactory;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.boot.web.embedded.netty.SslServerCustomizer;
import org.springframework.boot.web.server.Ssl;
import org.springframework.boot.web.server.SslStoreProvider;
import org.springframework.boot.web.server.WebServerSslBundle;
import org.springframework.http.client.ReactorResourceFactory;
import org.springframework.util.Assert;
import org.springframework.util.unit.DataSize;
import reactor.core.publisher.Mono;
import reactor.netty.http.server.HttpServer;
import reactor.netty.tcp.AbstractProtocolSslContextSpec;
import reactor.netty.tcp.SslProvider;
import reactor.netty.tcp.TcpServer;

public class NettyRSocketServerFactory
implements RSocketServerFactory,
ConfigurableRSocketServerFactory {
    private int port = 9898;
    private DataSize fragmentSize;
    private InetAddress address;
    private RSocketServer.Transport transport = RSocketServer.Transport.TCP;
    private ReactorResourceFactory resourceFactory;
    private Duration lifecycleTimeout;
    private List<RSocketServerCustomizer> rSocketServerCustomizers = new ArrayList<RSocketServerCustomizer>();
    private Ssl ssl;
    private SslStoreProvider sslStoreProvider;
    private SslBundles sslBundles;

    @Override
    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public void setFragmentSize(DataSize fragmentSize) {
        this.fragmentSize = fragmentSize;
    }

    @Override
    public void setAddress(InetAddress address) {
        this.address = address;
    }

    @Override
    public void setTransport(RSocketServer.Transport transport) {
        this.transport = transport;
    }

    @Override
    public void setSsl(Ssl ssl) {
        this.ssl = ssl;
    }

    @Override
    public void setSslStoreProvider(SslStoreProvider sslStoreProvider) {
        this.sslStoreProvider = sslStoreProvider;
    }

    @Override
    public void setSslBundles(SslBundles sslBundles) {
        this.sslBundles = sslBundles;
    }

    public void setResourceFactory(ReactorResourceFactory resourceFactory) {
        this.resourceFactory = resourceFactory;
    }

    public void setRSocketServerCustomizers(Collection<? extends RSocketServerCustomizer> rSocketServerCustomizers) {
        Assert.notNull(rSocketServerCustomizers, (String)"RSocketServerCustomizers must not be null");
        this.rSocketServerCustomizers = new ArrayList<RSocketServerCustomizer>(rSocketServerCustomizers);
    }

    public void addRSocketServerCustomizers(RSocketServerCustomizer ... rSocketServerCustomizers) {
        Assert.notNull((Object)rSocketServerCustomizers, (String)"RSocketServerCustomizers must not be null");
        this.rSocketServerCustomizers.addAll(Arrays.asList(rSocketServerCustomizers));
    }

    public void setLifecycleTimeout(Duration lifecycleTimeout) {
        this.lifecycleTimeout = lifecycleTimeout;
    }

    @Override
    public NettyRSocketServer create(SocketAcceptor socketAcceptor) {
        ServerTransport<CloseableChannel> transport = this.createTransport();
        RSocketServer server = RSocketServer.create((SocketAcceptor)socketAcceptor);
        this.configureServer(server);
        Mono starter = server.bind(transport);
        return new NettyRSocketServer((Mono<CloseableChannel>)starter, this.lifecycleTimeout);
    }

    private void configureServer(RSocketServer server) {
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(this.fragmentSize).asInt(DataSize::toBytes).to(arg_0 -> ((RSocketServer)server).fragment(arg_0));
        this.rSocketServerCustomizers.forEach(customizer -> customizer.customize(server));
    }

    private ServerTransport<CloseableChannel> createTransport() {
        if (this.transport == RSocketServer.Transport.WEBSOCKET) {
            return this.createWebSocketTransport();
        }
        return this.createTcpTransport();
    }

    private ServerTransport<CloseableChannel> createWebSocketTransport() {
        HttpServer httpServer = HttpServer.create();
        if (this.resourceFactory != null) {
            httpServer = (HttpServer)httpServer.runOn(this.resourceFactory.getLoopResources());
        }
        if (Ssl.isEnabled(this.ssl)) {
            httpServer = this.customizeSslConfiguration(httpServer);
        }
        return WebsocketServerTransport.create((HttpServer)httpServer.bindAddress(this::getListenAddress));
    }

    private HttpServer customizeSslConfiguration(HttpServer httpServer) {
        return new SslServerCustomizer(null, this.ssl.getClientAuth(), this.getSslBundle()).apply(httpServer);
    }

    private ServerTransport<CloseableChannel> createTcpTransport() {
        TcpServer tcpServer = TcpServer.create();
        if (this.resourceFactory != null) {
            tcpServer = tcpServer.runOn(this.resourceFactory.getLoopResources());
        }
        if (Ssl.isEnabled(this.ssl)) {
            tcpServer = new TcpSslServerCustomizer(this.ssl.getClientAuth(), this.getSslBundle()).apply(tcpServer);
        }
        return TcpServerTransport.create((TcpServer)tcpServer.bindAddress(this::getListenAddress));
    }

    private SslBundle getSslBundle() {
        return WebServerSslBundle.get(this.ssl, this.sslBundles, this.sslStoreProvider);
    }

    private InetSocketAddress getListenAddress() {
        if (this.address != null) {
            return new InetSocketAddress(this.address.getHostAddress(), this.port);
        }
        return new InetSocketAddress(this.port);
    }

    private static final class TcpSslServerCustomizer
    extends SslServerCustomizer {
        private final SslBundle sslBundle;

        private TcpSslServerCustomizer(Ssl.ClientAuth clientAuth, SslBundle sslBundle) {
            super(null, clientAuth, sslBundle);
            this.sslBundle = sslBundle;
        }

        @Override
        private TcpServer apply(TcpServer server) {
            AbstractProtocolSslContextSpec<?> sslContextSpec = this.createSslContextSpec(this.sslBundle);
            return server.secure(spec -> spec.sslContext((SslProvider.ProtocolSslContextSpec)sslContextSpec));
        }
    }
}

