/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.domain.ScheduledTrigger;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.utils.FolderId;
import com.xebialabs.xlrelease.variable.VariableHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(versioned=false, virtual=false)
public class ReleaseTrigger
extends ScheduledTrigger {
    public static final String SCRIPT_VARS_CATEGORY = "variables";
    @PublicApiMember
    @Property(label="Release title", description="Name given to releases created by this trigger. This field can contain variables.")
    private String releaseTitle;
    @Property(required=false, category="hidden", description="Not in Use. Keep it for backwards compatibility.")
    private String executionId;
    @PublicApiMember
    @Property(asContainment=true, required=false, category="hidden")
    protected List<Variable> variables = Lists.newArrayList();
    @Property(required=false, category="hidden")
    private String template;
    @PublicApiMember
    @Property(required=false, category="hidden")
    protected List<String> tags = Lists.newArrayList();
    @PublicApiMember
    @Property(required=false, category="hidden", description="Folder where releases generated by the trigger will be created.")
    private String releaseFolder;

    @PublicApiMember
    public String getReleaseTitle() {
        return this.releaseTitle;
    }

    @PublicApiMember
    public void setReleaseTitle(String releaseTitle) {
        this.releaseTitle = releaseTitle;
    }

    @Override
    public List<String> getInternalProperties() {
        ArrayList<String> properties = new ArrayList<String>(super.getInternalProperties());
        properties.addAll(this.getScriptVariableNames());
        properties.add("executionId");
        return properties;
    }

    @PublicApiMember
    public Map<String, String> getTemplateVariables() {
        return VariableHelper.getVariableValuesAsStrings(this.variables);
    }

    @PublicApiMember
    public Map<String, String> getTemplatePasswordVariables() {
        return VariableHelper.getPasswordVariableValuesAsStrings(this.variables);
    }

    @PublicApiMember
    public List<Variable> getVariables() {
        return Lists.newArrayList(this.variables);
    }

    public void setVariables(List<Variable> variables) {
        VariableHelper.checkVariables(variables);
        this.variables = variables;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public boolean hasExecutionId() {
        return this.executionId != null;
    }

    @PublicApiMember
    public String getReleaseFolder() {
        return this.releaseFolder;
    }

    @PublicApiMember
    public void setReleaseFolder(String releaseFolder) {
        this.releaseFolder = releaseFolder;
    }

    @VisibleForTesting
    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    public void resetExecutionId() {
        this.executionId = null;
    }

    public void setTriggerStateFromResults(String state) {
        if (state != null && !state.trim().isEmpty()) {
            this.setTriggerState(state);
        }
    }

    public List<String> getScriptVariableNames() {
        return this.getType().getDescriptor().getPropertyDescriptors().stream().filter(pd -> SCRIPT_VARS_CATEGORY.equals(pd.getCategory())).map(PropertyDescriptor::getName).collect(Collectors.toList());
    }

    public void setScriptVariablesFromResults(Map<String, Object> variableValues) {
        for (String scriptVariable : this.getScriptVariableNames()) {
            this.setProperty(scriptVariable, variableValues.get(scriptVariable));
        }
    }

    public Map<String, String> getStringScriptVariableValues() {
        return (Map)this.getScriptVariableValues().entrySet().stream().filter(e -> e.getValue() != null).collect(com.xebialabs.xlrelease.utils.Collectors.toMap(e -> VariableHelper.withVariableSyntax((String)e.getKey()), e -> e.getValue().toString()));
    }

    public Map<String, Object> getScriptVariableValues() {
        return (Map)this.getScriptVariableNames().stream().collect(com.xebialabs.xlrelease.utils.Collectors.toMap(Function.identity(), arg_0 -> ((ReleaseTrigger)this).getProperty(arg_0)));
    }

    public Map<String, Object> getTemplateVariableValues(Predicate<Variable> variablePredicate) {
        return (Map)this.getVariables().stream().filter(variablePredicate).collect(com.xebialabs.xlrelease.utils.Collectors.toMap(Variable::getKey, Variable::getValue));
    }

    public Map<String, Variable> getVariablesByKeys() {
        return VariableHelper.indexByKey(this.getVariables());
    }

    @Override
    public String getContainerId() {
        FolderId folder = FolderId.apply((String)this.getFolderId());
        String containerId = folder.isEmpty() ? this.getTemplate() : folder.absolute();
        return containerId;
    }
}

