/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers.oauth2.client;

import java.util.function.Function;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.DefaultOidcLogoutTokenValidatorFactory;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OidcBackChannelLogoutAuthentication;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OidcLogoutAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.client.oidc.authentication.OidcIdTokenDecoderFactory;
import org.springframework.security.oauth2.client.oidc.authentication.logout.OidcLogoutToken;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.jwt.BadJwtException;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtDecoderFactory;
import org.springframework.util.Assert;

final class OidcBackChannelLogoutAuthenticationProvider
implements AuthenticationProvider {
    private JwtDecoderFactory<ClientRegistration> logoutTokenDecoderFactory;

    OidcBackChannelLogoutAuthenticationProvider() {
        OidcIdTokenDecoderFactory logoutTokenDecoderFactory = new OidcIdTokenDecoderFactory();
        logoutTokenDecoderFactory.setJwtValidatorFactory((Function)new DefaultOidcLogoutTokenValidatorFactory());
        this.logoutTokenDecoderFactory = logoutTokenDecoderFactory;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (!(authentication instanceof OidcLogoutAuthenticationToken)) {
            return null;
        }
        OidcLogoutAuthenticationToken token = (OidcLogoutAuthenticationToken)authentication;
        String logoutToken = token.getLogoutToken();
        ClientRegistration registration = token.getClientRegistration();
        Jwt jwt = this.decode(registration, logoutToken);
        OidcLogoutToken oidcLogoutToken = OidcLogoutToken.withTokenValue((String)logoutToken).claims(claims -> claims.putAll(jwt.getClaims())).build();
        return new OidcBackChannelLogoutAuthentication(oidcLogoutToken);
    }

    public boolean supports(Class<?> authentication) {
        return OidcLogoutAuthenticationToken.class.isAssignableFrom(authentication);
    }

    private Jwt decode(ClientRegistration registration, String token) {
        JwtDecoder logoutTokenDecoder = this.logoutTokenDecoderFactory.createDecoder((Object)registration);
        try {
            return logoutTokenDecoder.decode(token);
        }
        catch (BadJwtException failed) {
            OAuth2Error error = new OAuth2Error("invalid_request", failed.getMessage(), "https://openid.net/specs/openid-connect-backchannel-1_0.html#Validation");
            throw new OAuth2AuthenticationException(error, (Throwable)failed);
        }
        catch (Exception failed) {
            throw new AuthenticationServiceException(failed.getMessage(), (Throwable)failed);
        }
    }

    void setLogoutTokenDecoderFactory(JwtDecoderFactory<ClientRegistration> logoutTokenDecoderFactory) {
        Assert.notNull(logoutTokenDecoderFactory, (String)"logoutTokenDecoderFactory cannot be null");
        this.logoutTokenDecoderFactory = logoutTokenDecoderFactory;
    }
}

