/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.springboot.common;

import jakarta.ws.rs.ApplicationPath;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.ext.Provider;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.resteasy.springboot.common.JaxrsApplicationScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.ConfigurableEnvironment;

public class ResteasyResourcesFinder {
    private static final Logger logger = LoggerFactory.getLogger(ResteasyResourcesFinder.class);
    private static final String JAXRS_APP_CLASSES_PROPERTY_LEGACY = "resteasy.jaxrs.app";
    private static final String JAXRS_APP_CLASSES_PROPERTY = "resteasy.jaxrs.app.classes";
    private static final String JAXRS_APP_CLASSES_DEFINITION_PROPERTY = "resteasy.jaxrs.app.registration";
    private Set<Class<? extends Application>> applications = new HashSet<Class<? extends Application>>();
    private final Set<Class<?>> allResources = new HashSet();
    private final Set<Class<?>> providers = new HashSet();

    public void findJaxrsApplications(ConfigurableListableBeanFactory beanFactory) {
        logger.info("Finding JAX-RS Application classes");
        JaxrsAppClassesRegistration registration = this.getJaxrsAppClassesRegistration(beanFactory);
        switch (registration.ordinal()) {
            case 3: {
                this.findJaxrsApplicationBeans(beanFactory);
                if (this.applications.isEmpty()) {
                    this.findJaxrsApplicationProperty(beanFactory);
                }
                if (!this.applications.isEmpty()) break;
                this.findJaxrsApplicationScanning((BeanFactory)beanFactory);
                break;
            }
            case 0: {
                this.findJaxrsApplicationBeans(beanFactory);
                break;
            }
            case 1: {
                this.findJaxrsApplicationProperty(beanFactory);
                break;
            }
            case 2: {
                this.findJaxrsApplicationScanning((BeanFactory)beanFactory);
                break;
            }
            default: {
                logger.error("JAX-RS application registration method (%s) not known, no application will be configured", (Object)registration.name());
            }
        }
        this.applications = this.applications.stream().filter(app -> {
            ApplicationPath path = (ApplicationPath)AnnotationUtils.findAnnotation((Class)app, ApplicationPath.class);
            if (path == null) {
                logger.warn("JAX-RS Application class {} has no ApplicationPath annotation, so it will not be configured", (Object)app.getName());
            } else {
                logger.info("JAX-RS Application class found: {}", (Object)app.getName());
            }
            return path != null;
        }).collect(Collectors.toSet());
    }

    private JaxrsAppClassesRegistration getJaxrsAppClassesRegistration(ConfigurableListableBeanFactory beanFactory) {
        ConfigurableEnvironment configurableEnvironment = (ConfigurableEnvironment)beanFactory.getBean(ConfigurableEnvironment.class);
        String jaxrsAppClassesRegistration = configurableEnvironment.getProperty(JAXRS_APP_CLASSES_DEFINITION_PROPERTY);
        JaxrsAppClassesRegistration registration = JaxrsAppClassesRegistration.AUTO;
        if (jaxrsAppClassesRegistration == null) {
            logger.info("Property {} has not been set, JAX-RS Application classes registration is being set to AUTO", (Object)JAXRS_APP_CLASSES_DEFINITION_PROPERTY);
        } else {
            logger.info("Property {} has been set to {}", (Object)JAXRS_APP_CLASSES_DEFINITION_PROPERTY, (Object)jaxrsAppClassesRegistration);
            try {
                registration = JaxrsAppClassesRegistration.valueOf(jaxrsAppClassesRegistration.toUpperCase());
            }
            catch (IllegalArgumentException ex) {
                String errorMesage = String.format("Property %s has not been properly set, value %s is invalid. JAX-RS Application classes registration is being set to AUTO.", JAXRS_APP_CLASSES_DEFINITION_PROPERTY, jaxrsAppClassesRegistration);
                logger.error(errorMesage);
                throw new IllegalArgumentException(errorMesage, ex);
            }
        }
        return registration;
    }

    private void findJaxrsApplicationBeans(ConfigurableListableBeanFactory beanFactory) {
        logger.info("Searching for JAX-RS Application Spring beans");
        Map applicationBeans = beanFactory.getBeansOfType(Application.class, true, false);
        if (applicationBeans == null || applicationBeans.isEmpty()) {
            logger.info("No JAX-RS Application Spring beans found");
            return;
        }
        for (Application application : applicationBeans.values()) {
            this.applications.add(application.getClass());
        }
    }

    private void findJaxrsApplicationProperty(ConfigurableListableBeanFactory beanFactory) {
        String[] jaxrsClassNames;
        ConfigurableEnvironment configurableEnvironment = (ConfigurableEnvironment)beanFactory.getBean(ConfigurableEnvironment.class);
        String jaxrsAppsProperty = configurableEnvironment.getProperty(JAXRS_APP_CLASSES_PROPERTY);
        if (jaxrsAppsProperty == null) {
            jaxrsAppsProperty = configurableEnvironment.getProperty(JAXRS_APP_CLASSES_PROPERTY_LEGACY);
            if (jaxrsAppsProperty == null) {
                logger.info("No JAX-RS Application set via property {}", (Object)JAXRS_APP_CLASSES_PROPERTY);
                return;
            }
            logger.warn("Property {} has been set. Notice that this property has been deprecated and will be removed soon. Please replace it by property {}", (Object)JAXRS_APP_CLASSES_PROPERTY_LEGACY, (Object)JAXRS_APP_CLASSES_PROPERTY);
        } else {
            logger.info("Property {} has been set to {}", (Object)JAXRS_APP_CLASSES_PROPERTY, (Object)jaxrsAppsProperty);
        }
        for (String jaxrsClassName : jaxrsClassNames = jaxrsAppsProperty.split(",")) {
            Class<?> jaxrsClass = null;
            try {
                jaxrsClass = Class.forName(jaxrsClassName.trim());
            }
            catch (ClassNotFoundException e) {
                String exceptionMessage = String.format("JAX-RS Application class %s has not been found", jaxrsClassName.trim());
                logger.error(exceptionMessage, (Throwable)e);
                throw new BeansException(exceptionMessage, e){};
            }
            this.applications.add(jaxrsClass);
        }
    }

    private void findJaxrsApplicationScanning(BeanFactory beanFactory) {
        List<String> packagesToBeScanned = this.getSpringApplicationPackages(beanFactory);
        Set<Class<? extends Application>> applications = JaxrsApplicationScanner.getApplications(packagesToBeScanned);
        if (applications == null || applications.isEmpty()) {
            return;
        }
        this.applications.addAll(applications);
    }

    private List<String> getSpringApplicationPackages(BeanFactory beanFactory) {
        return AutoConfigurationPackages.get((BeanFactory)beanFactory);
    }

    public void findJaxrsResourcesAndProviderClasses(ConfigurableListableBeanFactory beanFactory) {
        logger.debug("Finding JAX-RS resources and providers Spring bean classes");
        String[] resourceBeans = beanFactory.getBeanNamesForAnnotation(Path.class);
        String[] providerBeans = beanFactory.getBeanNamesForAnnotation(Provider.class);
        if (resourceBeans != null) {
            for (String resourceBean : resourceBeans) {
                this.allResources.add(beanFactory.getType(resourceBean));
            }
        }
        if (this.getAllResources().isEmpty()) {
            logger.warn("No JAX-RS resource Spring beans have been found");
        }
        if (providerBeans != null) {
            for (String providerBean : providerBeans) {
                this.providers.add(beanFactory.getType(providerBean));
            }
        }
        if (logger.isDebugEnabled()) {
            for (Object resourceClass : this.allResources.toArray()) {
                logger.debug("JAX-RS resource class found: {}", (Object)((Class)resourceClass).getName());
            }
        }
        if (logger.isDebugEnabled()) {
            for (Object providerClass : this.providers.toArray()) {
                logger.debug("JAX-RS provider class found: {}", (Object)((Class)providerClass).getName());
            }
        }
    }

    public Set<Class<? extends Application>> getApplications() {
        return this.applications;
    }

    public Set<Class<?>> getAllResources() {
        return this.allResources;
    }

    public Set<Class<?>> getProviders() {
        return this.providers;
    }

    private static enum JaxrsAppClassesRegistration {
        BEANS,
        PROPERTY,
        SCANNING,
        AUTO;

    }
}

