/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.application.jmx.remote.server;

import com.caucho.hessian4.io.AbstractSerializerFactory;
import com.caucho.hessian4.io.SerializerFactory;
import io.netty.channel.ChannelHandler;
import io.netty.util.concurrent.EventExecutorGroup;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerFactory;
import org.rzo.netty.ahessian.application.jmx.remote.service.JmxSerializerFactory;
import org.rzo.netty.ahessian.bootstrap.ChannelPipelineFactory;
import org.rzo.netty.ahessian.io.InputStreamHandler;
import org.rzo.netty.ahessian.io.OutputStreamHandler;
import org.rzo.netty.ahessian.io.PullInputStreamConsumer;
import org.rzo.netty.ahessian.rpc.message.HessianRPCCallDecoder;
import org.rzo.netty.ahessian.rpc.message.HessianRPCReplyEncoder;
import org.rzo.netty.ahessian.rpc.server.HessianRPCServiceHandler;
import org.rzo.netty.ahessian.rpc.server.ImmediateInvokeService;

public class RPCServerMixinPipelineFactory
extends ChannelPipelineFactory {
    Executor _executor;
    SerializerFactory _serializerFactory = new JmxSerializerFactory();

    RPCServerMixinPipelineFactory(Executor executor, EventExecutorGroup group) {
        super(group);
        this._executor = executor;
    }

    @Override
    public ChannelPipelineFactory.HandlerList getPipeline() throws Exception {
        ChannelPipelineFactory.HandlerList pipeline = new ChannelPipelineFactory.HandlerList();
        pipeline.addLast("inputStream", new InputStreamHandler());
        pipeline.addLast("callDecoder", new PullInputStreamConsumer(new HessianRPCCallDecoder((AbstractSerializerFactory)this._serializerFactory)));
        pipeline.addLast("outputStream", new OutputStreamHandler(), this.getGroup());
        pipeline.addLast("replyEncoder", new HessianRPCReplyEncoder((AbstractSerializerFactory)this._serializerFactory, this._executor), this.getGroup());
        HessianRPCServiceHandler factory = new HessianRPCServiceHandler(this._executor);
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        MBeanServer server = null;
        if (servers != null && servers.size() > 0) {
            server = servers.get(0);
        }
        if (server == null) {
            server = MBeanServerFactory.createMBeanServer();
        }
        factory.addService("default", new ImmediateInvokeService(server, MBeanServerConnection.class, factory));
        pipeline.addLast("hessianRPCServer", (ChannelHandler)factory, this.getGroup());
        return pipeline;
    }
}

