/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence.jdbc.snapshot.dao.legacy;

import java.io.Serializable;
import org.apache.pekko.persistence.SnapshotMetadata;
import org.apache.pekko.persistence.jdbc.config.SnapshotConfig;
import org.apache.pekko.persistence.jdbc.snapshot.dao.SnapshotDao;
import org.apache.pekko.persistence.jdbc.snapshot.dao.legacy.ByteArraySnapshotSerializer;
import org.apache.pekko.persistence.jdbc.snapshot.dao.legacy.SnapshotQueries;
import org.apache.pekko.persistence.jdbc.snapshot.dao.legacy.SnapshotTables;
import org.apache.pekko.serialization.Serialization;
import org.apache.pekko.stream.Materializer;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.Tuple3;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import slick.dbio.DBIOAction;
import slick.jdbc.JdbcActionComponent;
import slick.jdbc.JdbcBackend;
import slick.jdbc.JdbcProfile;
import slick.lifted.RunnableCompiled;

@ScalaSignature(bytes="\u0006\u0005\u0005}f\u0001\u0002\r\u001a\u0001)B\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005\u0003\"AA\t\u0001B\u0001B\u0003%Q\t\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003M\u0011!\t\u0006A!A!\u0002\u0017\u0011\u0006\u0002\u0003-\u0001\u0005\u000b\u0007I1A-\t\u0011\u0001\u0004!\u0011!Q\u0001\niCQ!\u0019\u0001\u0005\u0002\tDq\u0001\u001c\u0001C\u0002\u0013\u0005Q\u000e\u0003\u0004r\u0001\u0001\u0006IA\u001c\u0005\be\u0002\u0011\r\u0011\"\u0001t\u0011\u00199\b\u0001)A\u0005i\")\u0001\u0010\u0001C\u0001s\"9\u0011Q\u0007\u0001\u0005B\u0005]\u0002bBA0\u0001\u0011\u0005\u0013\u0011\r\u0005\b\u0003_\u0002A\u0011IA9\u0011\u001d\tI\b\u0001C!\u0003wBq!a!\u0001\t\u0003\n)\tC\u0004\u0002\u0016\u0002!\t%a&\t\u000f\u0005}\u0005\u0001\"\u0011\u0002\"\"9\u0011Q\u0015\u0001\u0005B\u0005\u001d\u0006bBAW\u0001\u0011\u0005\u0013q\u0016\u0005\b\u0003k\u0003A\u0011IA\\\u0005Q\u0011\u0015\u0010^3BeJ\f\u0017p\u00158baNDw\u000e\u001e#b_*\u0011!dG\u0001\u0007Y\u0016<\u0017mY=\u000b\u0005qi\u0012a\u00013b_*\u0011adH\u0001\tg:\f\u0007o\u001d5pi*\u0011\u0001%I\u0001\u0005U\u0012\u00147M\u0003\u0002#G\u0005Y\u0001/\u001a:tSN$XM\\2f\u0015\t!S%A\u0003qK.\\wN\u0003\u0002'O\u00051\u0011\r]1dQ\u0016T\u0011\u0001K\u0001\u0004_J<7\u0001A\n\u0004\u0001-\n\u0004C\u0001\u00170\u001b\u0005i#\"\u0001\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Aj#AB!osJ+g\r\u0005\u00023g5\t1$\u0003\u000257\tY1K\\1qg\"|G\u000fR1p\u0003\t!'\r\u0005\u00028}A\u0011\u0001\bP\u0007\u0002s)\u0011\u0001E\u000f\u0006\u0002w\u0005)1\u000f\\5dW&\u0011Q(\u000f\u0002\f\u0015\u0012\u00147MQ1dW\u0016tG-\u0003\u0002@y\tYA)\u0019;bE\u0006\u001cX\rR3g\u0003\u001d\u0001(o\u001c4jY\u0016\u0004\"\u0001\u000f\"\n\u0005\rK$a\u0003&eE\u000e\u0004&o\u001c4jY\u0016\fab\u001d8baNDw\u000e^\"p]\u001aLw\r\u0005\u0002G\u00136\tqI\u0003\u0002I?\u000511m\u001c8gS\u001eL!AS$\u0003\u001dMs\u0017\r]:i_R\u001cuN\u001c4jO\u0006i1/\u001a:jC2L'0\u0019;j_:\u0004\"!T(\u000e\u00039S!aS\u0012\n\u0005As%!D*fe&\fG.\u001b>bi&|g.\u0001\u0002fGB\u00111KV\u0007\u0002)*\u0011Q+L\u0001\u000bG>t7-\u001e:sK:$\u0018BA,U\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH/A\u0002nCR,\u0012A\u0017\t\u00037zk\u0011\u0001\u0018\u0006\u0003;\u000e\naa\u001d;sK\u0006l\u0017BA0]\u00051i\u0015\r^3sS\u0006d\u0017N_3s\u0003\u0011i\u0017\r\u001e\u0011\u0002\rqJg.\u001b;?)\u0015\u0019\u0007.\u001b6l)\r!gm\u001a\t\u0003K\u0002i\u0011!\u0007\u0005\u0006#\"\u0001\u001dA\u0015\u0005\u00061\"\u0001\u001dA\u0017\u0005\u0006k!\u0001\rA\u000e\u0005\u0006\u0001\"\u0001\r!\u0011\u0005\u0006\t\"\u0001\r!\u0012\u0005\u0006\u0017\"\u0001\r\u0001T\u0001\bcV,'/[3t+\u0005q\u0007CA3p\u0013\t\u0001\u0018DA\bT]\u0006\u00048\u000f[8u#V,'/[3t\u0003!\tX/\u001a:jKN\u0004\u0013AC:fe&\fG.\u001b>feV\tA\u000f\u0005\u0002fk&\u0011a/\u0007\u0002\u001c\u0005f$X-\u0011:sCf\u001cf.\u00199tQ>$8+\u001a:jC2L'0\u001a:\u0002\u0017M,'/[1mSj,'\u000fI\u0001\u000fi>\u001cf.\u00199tQ>$H)\u0019;b)\rQ\u0018\u0011\u0002\t\u0006Yml\u00181A\u0005\u0003y6\u0012a\u0001V;qY\u0016\u0014\u0004C\u0001@\u0000\u001b\u0005\t\u0013bAA\u0001C\t\u00012K\\1qg\"|G/T3uC\u0012\fG/\u0019\t\u0004Y\u0005\u0015\u0011bAA\u0004[\t\u0019\u0011I\\=\t\u000f\u0005-Q\u00021\u0001\u0002\u000e\u0005\u0019!o\\<\u0011\t\u0005=\u0011q\u0006\b\u0005\u0003#\tYC\u0004\u0003\u0002\u0014\u0005%b\u0002BA\u000b\u0003OqA!a\u0006\u0002&9!\u0011\u0011DA\u0012\u001d\u0011\tY\"!\t\u000f\t\u0005u\u0011qD\u0007\u0002K%\u0011A%J\u0005\u0003E\rJ!\u0001I\u0011\n\u0005yy\u0012B\u0001\u000f\u001e\u0013\tQ2$C\u0002\u0002.e\tab\u00158baNDw\u000e\u001e+bE2,7/\u0003\u0003\u00022\u0005M\"aC*oCB\u001c\bn\u001c;S_^T1!!\f\u001a\u00039a\u0017\r^3tiNs\u0017\r]:i_R$B!!\u000f\u0002FA)1+a\u000f\u0002@%\u0019\u0011Q\b+\u0003\r\u0019+H/\u001e:f!\u0011a\u0013\u0011\t>\n\u0007\u0005\rSF\u0001\u0004PaRLwN\u001c\u0005\b\u0003\u000fr\u0001\u0019AA%\u00035\u0001XM]:jgR,gnY3JIB!\u00111JA-\u001d\u0011\ti%!\u0016\u0011\u0007\u0005=S&\u0004\u0002\u0002R)\u0019\u00111K\u0015\u0002\rq\u0012xn\u001c;?\u0013\r\t9&L\u0001\u0007!J,G-\u001a4\n\t\u0005m\u0013Q\f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005]S&A\ft]\u0006\u00048\u000f[8u\r>\u0014X*\u0019=US6,7\u000f^1naR1\u0011\u0011HA2\u0003KBq!a\u0012\u0010\u0001\u0004\tI\u0005C\u0004\u0002h=\u0001\r!!\u001b\u0002\u00195\f\u0007\u0010V5nKN$\u0018-\u001c9\u0011\u00071\nY'C\u0002\u0002n5\u0012A\u0001T8oO\u0006A2O\\1qg\"|GOR8s\u001b\u0006D8+Z9vK:\u001cWM\u0014:\u0015\r\u0005e\u00121OA;\u0011\u001d\t9\u0005\u0005a\u0001\u0003\u0013Bq!a\u001e\u0011\u0001\u0004\tI'A\u0007nCb\u001cV-];f]\u000e,gJ]\u0001(g:\f\u0007o\u001d5pi\u001a{'/T1y'\u0016\fX/\u001a8dK:\u0013\u0018I\u001c3NCb$\u0016.\\3ti\u0006l\u0007\u000f\u0006\u0005\u0002:\u0005u\u0014qPAA\u0011\u001d\t9%\u0005a\u0001\u0003\u0013Bq!a\u001e\u0012\u0001\u0004\tI\u0007C\u0004\u0002hE\u0001\r!!\u001b\u0002\tM\fg/\u001a\u000b\u0007\u0003\u000f\u000by)a%\u0011\u000bM\u000bY$!#\u0011\u00071\nY)C\u0002\u0002\u000e6\u0012A!\u00168ji\"1\u0011\u0011\u0013\nA\u0002u\f\u0001c\u001d8baNDw\u000e^'fi\u0006$\u0017\r^1\t\ry\u0011\u0002\u0019AA\u0002\u0003\u0019!W\r\\3uKR1\u0011qQAM\u00037Cq!a\u0012\u0014\u0001\u0004\tI\u0005C\u0004\u0002\u001eN\u0001\r!!\u001b\u0002\u0015M,\u0017/^3oG\u0016t%/\u0001\neK2,G/Z!mYNs\u0017\r]:i_R\u001cH\u0003BAD\u0003GCq!a\u0012\u0015\u0001\u0004\tI%A\feK2,G/Z+q)>l\u0015\r_*fcV,gnY3OeR1\u0011qQAU\u0003WCq!a\u0012\u0016\u0001\u0004\tI\u0005C\u0004\u0002xU\u0001\r!!\u001b\u0002-\u0011,G.\u001a;f+B$v.T1y)&lWm\u001d;b[B$b!a\"\u00022\u0006M\u0006bBA$-\u0001\u0007\u0011\u0011\n\u0005\b\u0003O2\u0002\u0019AA5\u0003\u0019\"W\r\\3uKV\u0003Hk\\'bqN+\u0017/^3oG\u0016t%/\u00118e\u001b\u0006DH+[7fgR\fW\u000e\u001d\u000b\t\u0003\u000f\u000bI,a/\u0002>\"9\u0011qI\fA\u0002\u0005%\u0003bBA</\u0001\u0007\u0011\u0011\u000e\u0005\b\u0003O:\u0002\u0019AA5\u0001")
public class ByteArraySnapshotDao
implements SnapshotDao {
    private final JdbcBackend.DatabaseDef db;
    private final JdbcProfile profile;
    private final ExecutionContext ec;
    private final Materializer mat;
    private final SnapshotQueries queries;
    private final ByteArraySnapshotSerializer serializer;

    public Materializer mat() {
        return this.mat;
    }

    public SnapshotQueries queries() {
        return this.queries;
    }

    public ByteArraySnapshotSerializer serializer() {
        return this.serializer;
    }

    public Tuple2<SnapshotMetadata, Object> toSnapshotData(SnapshotTables.SnapshotRow row) {
        Try<Tuple2<SnapshotMetadata, Object>> try_ = this.serializer().deserialize(row);
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Tuple2 deserialized = (Tuple2)success.value();
            return deserialized;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable cause = failure.exception();
            throw cause;
        }
        throw new MatchError(try_);
    }

    @Override
    public Future<Option<Tuple2<SnapshotMetadata, Object>>> latestSnapshot(String persistenceId) {
        return this.db.run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.profile.api().streamableAppliedCompiledFunctionActionExtensionMethods(this.queries().selectLatestByPersistenceId().apply((Object)persistenceId))).result()).map((Function1 & Serializable)rows -> rows.headOption().map((Function1 & Serializable)row -> this.toSnapshotData((SnapshotTables.SnapshotRow)row)), this.ec);
    }

    @Override
    public Future<Option<Tuple2<SnapshotMetadata, Object>>> snapshotForMaxTimestamp(String persistenceId, long maxTimestamp) {
        return this.db.run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.profile.api().streamableAppliedCompiledFunctionActionExtensionMethods(this.queries().selectOneByPersistenceIdAndMaxTimestamp().apply((Object)new Tuple2((Object)persistenceId, (Object)BoxesRunTime.boxToLong((long)maxTimestamp))))).result()).map((Function1 & Serializable)rows -> rows.headOption().map((Function1 & Serializable)row -> this.toSnapshotData((SnapshotTables.SnapshotRow)row)), this.ec);
    }

    @Override
    public Future<Option<Tuple2<SnapshotMetadata, Object>>> snapshotForMaxSequenceNr(String persistenceId, long maxSequenceNr) {
        return this.db.run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.profile.api().streamableAppliedCompiledFunctionActionExtensionMethods(this.queries().selectOneByPersistenceIdAndMaxSequenceNr().apply((Object)new Tuple2((Object)persistenceId, (Object)BoxesRunTime.boxToLong((long)maxSequenceNr))))).result()).map((Function1 & Serializable)rows -> rows.headOption().map((Function1 & Serializable)row -> this.toSnapshotData((SnapshotTables.SnapshotRow)row)), this.ec);
    }

    @Override
    public Future<Option<Tuple2<SnapshotMetadata, Object>>> snapshotForMaxSequenceNrAndMaxTimestamp(String persistenceId, long maxSequenceNr, long maxTimestamp) {
        return this.db.run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.profile.api().streamableAppliedCompiledFunctionActionExtensionMethods(this.queries().selectOneByPersistenceIdAndMaxSequenceNrAndMaxTimestamp().apply((Object)new Tuple3((Object)persistenceId, (Object)BoxesRunTime.boxToLong((long)maxSequenceNr), (Object)BoxesRunTime.boxToLong((long)maxTimestamp))))).result()).map((Function1 & Serializable)rows -> rows.headOption().map((Function1 & Serializable)row -> this.toSnapshotData((SnapshotTables.SnapshotRow)row)), this.ec);
    }

    @Override
    public Future<BoxedUnit> save(SnapshotMetadata snapshotMetadata, Object snapshot) {
        Future eventualSnapshotRow = Future$.MODULE$.fromTry(this.serializer().serialize(snapshotMetadata, snapshot));
        return eventualSnapshotRow.map((Function1 & Serializable)snapshotRow -> this.queries().insertOrUpdate((SnapshotTables.SnapshotRow)snapshotRow), this.ec).flatMap((Function1 & Serializable)a -> $this.db.run(a), this.ec).map((Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> {}, this.ec);
    }

    @Override
    public Future<BoxedUnit> delete(String persistenceId, long sequenceNr) {
        return this.db.run((DBIOAction)this.profile.api().runnableCompiledDeleteActionExtensionMethods((RunnableCompiled)this.queries().selectByPersistenceIdAndSequenceNr().apply((Object)new Tuple2((Object)persistenceId, (Object)BoxesRunTime.boxToLong((long)sequenceNr)))).delete()).map((Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> {
            int n = x$2;
        }, this.ec);
    }

    @Override
    public Future<BoxedUnit> deleteAllSnapshots(String persistenceId) {
        return this.db.run((DBIOAction)this.profile.api().runnableCompiledDeleteActionExtensionMethods((RunnableCompiled)this.queries().selectAll().apply((Object)persistenceId)).delete()).map((Function1)(JFunction1.mcVI.sp & Serializable)x$3 -> {
            int n = x$3;
        }, this.ec);
    }

    @Override
    public Future<BoxedUnit> deleteUpToMaxSequenceNr(String persistenceId, long maxSequenceNr) {
        return this.db.run((DBIOAction)this.profile.api().runnableCompiledDeleteActionExtensionMethods((RunnableCompiled)this.queries().selectByPersistenceIdUpToMaxSequenceNr().apply((Object)new Tuple2((Object)persistenceId, (Object)BoxesRunTime.boxToLong((long)maxSequenceNr)))).delete()).map((Function1)(JFunction1.mcVI.sp & Serializable)x$4 -> {
            int n = x$4;
        }, this.ec);
    }

    @Override
    public Future<BoxedUnit> deleteUpToMaxTimestamp(String persistenceId, long maxTimestamp) {
        return this.db.run((DBIOAction)this.profile.api().runnableCompiledDeleteActionExtensionMethods((RunnableCompiled)this.queries().selectByPersistenceIdUpToMaxTimestamp().apply((Object)new Tuple2((Object)persistenceId, (Object)BoxesRunTime.boxToLong((long)maxTimestamp)))).delete()).map((Function1)(JFunction1.mcVI.sp & Serializable)x$5 -> {
            int n = x$5;
        }, this.ec);
    }

    @Override
    public Future<BoxedUnit> deleteUpToMaxSequenceNrAndMaxTimestamp(String persistenceId, long maxSequenceNr, long maxTimestamp) {
        return this.db.run((DBIOAction)this.profile.api().runnableCompiledDeleteActionExtensionMethods((RunnableCompiled)this.queries().selectByPersistenceIdUpToMaxSequenceNrAndMaxTimestamp().apply((Object)new Tuple3((Object)persistenceId, (Object)BoxesRunTime.boxToLong((long)maxSequenceNr), (Object)BoxesRunTime.boxToLong((long)maxTimestamp)))).delete()).map((Function1)(JFunction1.mcVI.sp & Serializable)x$6 -> {
            int n = x$6;
        }, this.ec);
    }

    public ByteArraySnapshotDao(JdbcBackend.DatabaseDef db, JdbcProfile profile, SnapshotConfig snapshotConfig, Serialization serialization, ExecutionContext ec, Materializer mat) {
        this.db = db;
        this.profile = profile;
        this.ec = ec;
        this.mat = mat;
        this.queries = new SnapshotQueries(profile, snapshotConfig.legacySnapshotTableConfiguration());
        this.serializer = new ByteArraySnapshotSerializer(serialization);
    }
}

