/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.script.jython;

import com.typesafe.config.Config;
import com.xebialabs.xlrelease.script.Jsr223EngineFactory;
import com.xebialabs.xlrelease.script.jython.JythonScriptClassLoader;
import com.xebialabs.xlrelease.script.jython.SandboxAwarePackageManager$;
import com.xebialabs.xlrelease.script.jython.XlrJythonEngine;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Iterator;
import java.util.concurrent.locks.ReentrantLock;
import javax.script.ScriptEngine;
import org.apache.commons.lang.reflect.FieldUtils;
import org.python.core.Py;
import org.python.core.PyJavaPackage;
import org.python.core.PyModule;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PySystemState;
import org.python.jsr223.PyScriptEngine;
import org.python.jsr223.PyScriptEngineFactory;
import org.python.util.PythonInterpreter;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.util.Try$;

public final class JythonEngineInstance$
implements Jsr223EngineFactory,
Logging {
    public static final JythonEngineInstance$ MODULE$ = new JythonEngineInstance$();
    private static ScriptEngine restrictedEngine;
    private static ScriptEngine unrestrictedEngine;
    private static Config cacheSettings;
    private static final PyScriptEngineFactory engineFactory;
    private static transient Logger grizzled$slf4j$Logging$$_logger;
    private static volatile transient boolean bitmap$trans$0;
    private static volatile byte bitmap$0;

    static {
        Logging.$init$((Logging)MODULE$);
        engineFactory = new PyScriptEngineFactory(){
            {
                PySystemState.initialize();
                PySystemState.packageManager = SandboxAwarePackageManager$.MODULE$.getInstance();
            }
        };
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        JythonEngineInstance$ jythonEngineInstance$ = this;
        synchronized (jythonEngineInstance$) {
            if (!bitmap$trans$0) {
                grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                bitmap$trans$0 = true;
            }
        }
        return grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return grizzled$slf4j$Logging$$_logger;
    }

    private Config cacheSettings() {
        return cacheSettings;
    }

    private void cacheSettings_$eq(Config x$1) {
        cacheSettings = x$1;
    }

    private PyScriptEngineFactory engineFactory() {
        return engineFactory;
    }

    public Jsr223EngineFactory apply(Config cacheSettings) {
        this.cacheSettings_$eq(cacheSettings);
        this.restrictedEngine();
        this.unrestrictedEngine();
        return this;
    }

    private ScriptEngine restrictedEngine$lzycompute() {
        JythonEngineInstance$ jythonEngineInstance$ = this;
        synchronized (jythonEngineInstance$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                restrictedEngine = this.createEngine(true);
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return restrictedEngine;
    }

    private ScriptEngine restrictedEngine() {
        if ((byte)(bitmap$0 & 1) == 0) {
            return this.restrictedEngine$lzycompute();
        }
        return restrictedEngine;
    }

    private ScriptEngine unrestrictedEngine$lzycompute() {
        JythonEngineInstance$ jythonEngineInstance$ = this;
        synchronized (jythonEngineInstance$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                unrestrictedEngine = this.createEngine(false);
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return unrestrictedEngine;
    }

    private ScriptEngine unrestrictedEngine() {
        if ((byte)(bitmap$0 & 2) == 0) {
            return this.unrestrictedEngine$lzycompute();
        }
        return unrestrictedEngine;
    }

    @Override
    public ScriptEngine getScriptEngine(boolean restricted) {
        this.logger().debug((Function0 & Serializable)() -> "Jython engine [restricted: " + restricted + "] instance started.");
        if (restricted) {
            return this.restrictedEngine();
        }
        return this.unrestrictedEngine();
    }

    /*
     * WARNING - void declaration
     */
    private ScriptEngine createEngine(boolean restricted) {
        Object object;
        try {
            void var2_5;
            PyScriptEngine pyScriptEngine;
            SandboxAwarePackageManager$.MODULE$.setSandboxed(restricted);
            if (restricted) {
                PyScriptEngine engine = (PyScriptEngine)this.engineFactory().getScriptEngine();
                PythonInterpreter interpreter = (PythonInterpreter)FieldUtils.readField((Object)engine, (String)"interp", (boolean)true);
                ClassLoader parentLoader = Thread.currentThread().getContextClassLoader();
                interpreter.getSystemState().setClassLoader((ClassLoader)new JythonScriptClassLoader(parentLoader));
                pyScriptEngine = engine;
            } else {
                pyScriptEngine = (PyScriptEngine)this.engineFactory().getScriptEngine();
            }
            PyScriptEngine engine = pyScriptEngine;
            String engineName = restricted ? "jython-restricted" : "jython-unrestricted";
            boolean cacheEnabled = this.cacheSettings().getBoolean(engineName + ".enabled");
            this.logger().info((Function0 & Serializable)() -> "Creating " + engineName + " engine with cache " + (cacheEnabled ? "enabled" : "disabled"));
            object = cacheEnabled ? new XlrJythonEngine(engine, engineName, this.cacheSettings()) : var2_5;
        }
        finally {
            SandboxAwarePackageManager$.MODULE$.setSandboxed(false);
        }
        return object;
    }

    public void reload() {
        this.logger().info((Function0 & Serializable)() -> "Reloading jython engine modules");
        this.reload((PyScriptEngine)this.restrictedEngine());
        this.reload((PyScriptEngine)this.unrestrictedEngine());
    }

    private void reload(PyScriptEngine engine) {
        PythonInterpreter interpreter = (PythonInterpreter)FieldUtils.readField((Object)engine, (String)"interp", (boolean)true);
        interpreter.exec("import imp");
        PySystemState pySystemState = Py.getSystemState();
        PySystemState systemState = interpreter.getSystemState();
        ReentrantLock importLock = systemState.getImportLock();
        importLock.lock();
        try {
            scala.collection.immutable.Seq moduleNames = (scala.collection.immutable.Seq)CollectionConverters$.MODULE$.IteratorHasAsScala((Iterator)((PyStringMap)systemState.modules).keys().listIterator()).asScala().toSeq().map((Function1 & Serializable)x$2 -> x$2.toString());
            scala.collection.immutable.Seq builtinModuleNames = (scala.collection.immutable.Seq)CollectionConverters$.MODULE$.IteratorHasAsScala((Iterator)PySystemState.builtin_module_names.listIterator()).asScala().toSeq().map((Function1 & Serializable)x$3 -> x$3.toString());
            List modulesToReload = (List)moduleNames.toList().diff((Seq)builtinModuleNames.toList());
            PyModule impModule = (PyModule)systemState.modules.__getitem__((PyObject)new PyString("imp"));
            modulesToReload.foreach((Function1 & Serializable)m -> {
                PyObject maybeModule;
                MODULE$.logger().info((Function0 & Serializable)() -> "Reloading module: " + m);
                PyObject pyObject = maybeModule = systemState$1.modules.__getitem__((PyObject)new PyString(m));
                if (pyObject instanceof PyModule) {
                    PyModule pyModule = (PyModule)pyObject;
                    return Try$.MODULE$.apply((Function0 & Serializable)() -> impModule.invoke("reload", (PyObject)pyModule)).recover((PartialFunction)new Serializable((String)m){
                        private static final long serialVersionUID = 0L;
                        private final String m$1;

                        public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            A1 A1 = x1;
                            if (A1 != null) {
                                A1 A12 = A1;
                                JythonEngineInstance$.MODULE$.logger().warn((Function0 & Serializable)() -> "Unable to log python module " + $this.m$1, (Function0 & Serializable)() -> A12);
                                return (B1)BoxedUnit.UNIT;
                            }
                            return (B1)function1.apply(x1);
                        }

                        public final boolean isDefinedAt(Throwable x1) {
                            Throwable throwable = x1;
                            return throwable != null;
                        }
                        {
                            this.m$1 = m$1;
                        }

                        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(com.xebialabs.xlrelease.script.jython.JythonEngineInstance$$anonfun$$nestedInanonfun$reload$4$1 ), $anonfun$applyOrElse$2(java.lang.Throwable )}, serializedLambda);
                        }
                    });
                }
                if (pyObject instanceof PyJavaPackage) {
                    MODULE$.logger().info((Function0 & Serializable)() -> "Unable to reload " + m + " as it is pyJavaPackage");
                    return BoxedUnit.UNIT;
                }
                MODULE$.logger().info((Function0 & Serializable)() -> "Unable to reload " + m + " as it is " + pyObject.getType());
                return BoxedUnit.UNIT;
            });
        }
        finally {
            importLock.unlock();
        }
    }

    private JythonEngineInstance$() {
    }
}

