/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.server.jetty;

import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.xlrelease.XLReleaseBootstrapper$;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.exception.PortAlreadyInUseException;
import com.xebialabs.xlrelease.server.jetty.ReleaseJettyServerCustomizer;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.jetty.InstrumentedQueuedThreadPool;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Marker;
import org.springframework.boot.web.embedded.jetty.JettyServerCustomizer;
import org.springframework.boot.web.embedded.jetty.JettyServletWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import scala.Function0;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005ma\u0001B\u0006\r\u0001]A\u0001\u0002\u0010\u0001\u0003\u0006\u0004%\t!\u0010\u0005\t\t\u0002\u0011\t\u0011)A\u0005}!AQ\t\u0001BC\u0002\u0013\u0005a\t\u0003\u0005N\u0001\t\u0005\t\u0015!\u0003H\u0011!q\u0005A!A!\u0002\u0013y\u0005\"B.\u0001\t\u0003a\u0006\"\u00022\u0001\t\u0003\u001a\u0007\"\u00027\u0001\t\u0013i\u0007\"B=\u0001\t\u0013Q\b\"B>\u0001\t\u0013a(a\u0003&fiRL8+\u001a:wKJT!!\u0004\b\u0002\u000b),G\u000f^=\u000b\u0005=\u0001\u0012AB:feZ,'O\u0003\u0002\u0012%\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003'Q\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003U\t1aY8n\u0007\u0001\u0019B\u0001\u0001\r!iA\u0011\u0011DH\u0007\u00025)\u00111\u0004H\u0001\u0005Y\u0006twMC\u0001\u001e\u0003\u0011Q\u0017M^1\n\u0005}Q\"AB(cU\u0016\u001cG\u000fE\u0002\"W5j\u0011A\t\u0006\u0003\u001f\rR!\u0001J\u0013\u0002\u0007],'M\u0003\u0002'O\u0005!!m\\8u\u0015\tA\u0013&A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005Q\u0013aA8sO&\u0011AF\t\u0002\u001b/\u0016\u00147+\u001a:wKJ4\u0015m\u0019;pef\u001cUo\u001d;p[&TXM\u001d\t\u0003]Ij\u0011a\f\u0006\u0003\u001bAR!!M\u0012\u0002\u0011\u0015l'-\u001a3eK\u0012L!aM\u0018\u00039)+G\u000f^=TKJ4H.\u001a;XK\n\u001cVM\u001d<fe\u001a\u000b7\r^8ssB\u0011QGO\u0007\u0002m)\u0011q\u0007O\u0001\u0006g24GG\u001b\u0006\u0002s\u0005AqM]5{u2,G-\u0003\u0002<m\t9Aj\\4hS:<\u0017aE:feZ,'oQ8oM&<WO]1uS>tW#\u0001 \u0011\u0005}\u0012U\"\u0001!\u000b\u0005\u0005\u0013\u0012\u0001\u00033fa2|\u00170\u001b;\n\u0005\r\u0003%aE*feZ,'oQ8oM&<WO]1uS>t\u0017\u0001F:feZ,'oQ8oM&<WO]1uS>t\u0007%A\u0005yYJ\u001cuN\u001c4jOV\tq\t\u0005\u0002I\u00176\t\u0011J\u0003\u0002K!\u000511m\u001c8gS\u001eL!\u0001T%\u0003\u0013ac'oQ8oM&<\u0017A\u0003=me\u000e{gNZ5hA\u0005iQ.\u001a;feJ+w-[:uef\u0004\"\u0001U-\u000e\u0003ES!AU*\u0002\u0015%t7\u000f\u001e:v[\u0016tGO\u0003\u0002U+\u0006!1m\u001c:f\u0015\t1v+\u0001\u0006nS\u000e\u0014x.\\3uKJT\u0011\u0001W\u0001\u0003S>L!AW)\u0003\u001b5+G/\u001a:SK\u001eL7\u000f\u001e:z\u0003\u0019a\u0014N\\5u}Q!Ql\u00181b!\tq\u0006!D\u0001\r\u0011\u0015ad\u00011\u0001?\u0011\u0015)e\u00011\u0001H\u0011\u0015qe\u00011\u0001P\u0003%\u0019Wo\u001d;p[&TX\r\u0006\u0002eUB\u0011Q\r[\u0007\u0002M*\tq-A\u0003tG\u0006d\u0017-\u0003\u0002jM\n!QK\\5u\u0011\u0015Yw\u00011\u0001.\u0003\u001d1\u0017m\u0019;pef\fqBY;jY\u0012$\u0006N]3bIB{w\u000e\\\u000b\u0002]B\u0011qn^\u0007\u0002a*\u0011\u0011O]\u0001\u0007i\"\u0014X-\u00193\u000b\u0005M$\u0018\u0001B;uS2T!!D;\u000b\u0005YL\u0013aB3dY&\u00048/Z\u0005\u0003qB\u0014\u0001#U;fk\u0016$G\u000b\u001b:fC\u0012\u0004vn\u001c7\u0002%\rDWmY6Q_J$\u0018I^1jY\u0006\u0014G.\u001a\u000b\u0002I\u0006y\u0011n\u001d)peR\fe/Y5mC\ndW\rF\u0003~\u0003\u0003\tY\u0001\u0005\u0002f}&\u0011qP\u001a\u0002\b\u0005>|G.Z1o\u0011\u001d\t\u0019A\u0003a\u0001\u0003\u000b\tA\u0001]8siB\u0019Q-a\u0002\n\u0007\u0005%aMA\u0002J]RDq!!\u0004\u000b\u0001\u0004\ty!A\u0004bI\u0012\u0014Xm]:\u0011\t\u0005E\u0011qC\u0007\u0003\u0003'Q1!!\u0006\u001d\u0003\rqW\r^\u0005\u0005\u00033\t\u0019BA\u0006J]\u0016$\u0018\t\u001a3sKN\u001c\b")
public class JettyServer
implements WebServerFactoryCustomizer<JettyServletWebServerFactory>,
Logging {
    private final ServerConfiguration serverConfiguration;
    private final XlrConfig xlrConfig;
    private final MeterRegistry meterRegistry;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        JettyServer jettyServer = this;
        synchronized (jettyServer) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public ServerConfiguration serverConfiguration() {
        return this.serverConfiguration;
    }

    public XlrConfig xlrConfig() {
        return this.xlrConfig;
    }

    public void customize(JettyServletWebServerFactory factory) {
        int port = this.serverConfiguration().getHttpPort();
        String webContextRoot = this.serverConfiguration().getWebContextRoot();
        this.checkPortAvailable();
        if (!"/".equals(webContextRoot)) {
            factory.setContextPath(webContextRoot);
        }
        factory.setPort(port);
        factory.setThreadPool((ThreadPool)this.buildThreadPool());
        factory.addServerCustomizers(new JettyServerCustomizer[]{ReleaseJettyServerCustomizer.create(this.serverConfiguration(), this.xlrConfig(), this.meterRegistry)});
    }

    private QueuedThreadPool buildThreadPool() {
        int maxThreads = this.serverConfiguration().getMaxThreads();
        int minThreads = this.serverConfiguration().getMinThreads();
        if (this.xlrConfig().metrics().enabled()) {
            return new InstrumentedQueuedThreadPool(this.meterRegistry, (Iterable)Tags.of((String[])new String[]{"name", "release-jetty-thread-pool", "type", "jetty.thread-pool"}), maxThreads, minThreads);
        }
        return new QueuedThreadPool(maxThreads, minThreads);
    }

    private void checkPortAvailable() {
        InetAddress address = null;
        try {
            address = InetAddress.getByName(this.serverConfiguration().getHttpBindAddress());
        }
        catch (UnknownHostException ex) {
            String message = "Cannot start " + XLReleaseBootstrapper$.MODULE$.PRODUCT_DIGITALAI() + "; invalid bind address: " + this.serverConfiguration().getHttpBindAddress();
            this.logger().error((Function0 & Serializable)() -> message);
            throw ex;
        }
        if (!this.isPortAvailable(this.serverConfiguration().getHttpPort(), address)) {
            String message = "Cannot start " + XLReleaseBootstrapper$.MODULE$.PRODUCT_DIGITALAI() + "; port " + this.serverConfiguration().getHttpPort() + " already in use.";
            this.logger().error((Function0 & Serializable)() -> message);
            this.logger().error((Function0 & Serializable)() -> "Perhaps another instance of " + XLReleaseBootstrapper$.MODULE$.PRODUCT_DIGITALAI() + " is running.");
            throw new PortAlreadyInUseException(message);
        }
    }

    private boolean isPortAvailable(int port, InetAddress address) {
        boolean isAvailable = true;
        try {
            ServerSocket socket = new ServerSocket(port, 1, address);
            socket.close();
        }
        catch (Exception exception) {
            isAvailable = false;
        }
        return isAvailable;
    }

    public JettyServer(ServerConfiguration serverConfiguration, XlrConfig xlrConfig, MeterRegistry meterRegistry) {
        this.serverConfiguration = serverConfiguration;
        this.xlrConfig = xlrConfig;
        this.meterRegistry = meterRegistry;
        Logging.$init$((Logging)this);
    }
}

