import com.xhaus.jyson.JysonCodec as Json

from xlrelease.HttpRequest import HttpRequest


def _serialize(content):
    return Json.dumps(content)


def _deserialize(text):
    return Json.loads(text)


class PlatformClient:

    def __init__(self, platform_server=None):
        self.httpRequest = HttpRequest(platform_server)

    def get_token(self):
        token = self.httpRequest._oauth_provider._token_issuer.get_access_token()
        return token

    def get_agent_runtimes(self, filter=None):
        filter_query = "" if not filter else "filter={}".format(filter)
        response = self.httpRequest.get("/workload/v1/agent_runtimes?{}".format(filter_query))
        if not response.isSuccessful():
            raise Exception("HTTP response code %s (%s)" % (response.status, response.response))

        data = _deserialize(response.response)
        return data["agent_runtimes"]

    def get_agent_instances(self, filter=None):
        filter_query = "" if not filter else "filter={}".format(filter)
        response = self.httpRequest.get("/workload/v1/agent_instances?{}".format(filter_query))
        if not response.isSuccessful():
            raise Exception("HTTP response code %s (%s)" % (response.status, response.response))

        data = _deserialize(response.response)
        return data["agent_instances"]

    def delete_agent_instance(self, agent_instance_id):
        response = self.httpRequest.delete("/workload/v1/agent_instances/{}".format(agent_instance_id))
        if not response.isSuccessful():
            raise Exception("HTTP response code %s (%s)" % (response.status, response.response))

    def get_cloud_connectors(self):
        response = self.httpRequest.get("/workload/v1/cloud_connectors")
        if not response.isSuccessful():
            raise Exception("HTTP response code %s (%s)" % (response.status, response.response))

        data = _deserialize(response.response)
        return data["cloud_connector_definitions"]

    def create_agent_instance(self, agent_id, alias, description, images, variables, account_id, cloud_connector_id):
        body = {
            "agent_id": agent_id,
            "alias": alias,
            "description": description,
            "images": images,
            "variables": variables,
            "account_id": account_id,
            "cloud_connector_id": cloud_connector_id
        }

        response = self.httpRequest.post("/workload/v1/agent_instances/", _serialize(body),
                                         contentType='application/json')
        if not response.isSuccessful():
            raise Exception("HTTP response code %s (%s)" % (response.status, response.response))

        data = _deserialize(response.response)
        return data

    def create_cloud_connector(self, account_id, agent_manager_version, cloud_connector_name):
        body = {
            "account_id": account_id,
            "agent_manager_version": agent_manager_version,
            "name": cloud_connector_name
        }

        response = self.httpRequest.post("/workload/v1/cloud_connectors/", _serialize(body),
                                         contentType='application/json')
        if not response.isSuccessful():
            raise Exception("HTTP response code %s (%s)" % (response.status, response.response))

        data = _deserialize(response.response)
        return data["cloud_connector_definition"]

    def delete_cloud_connector(self, cloud_connector_id):
        response = self.httpRequest.delete("/workload/v1/cloud_connectors/{}".format(cloud_connector_id))
        if not response.isSuccessful():
            raise Exception("HTTP response code %s (%s)" % (response.status, response.response))
