/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.extension.quartz;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import java.io.Serializable;
import java.text.ParseException;
import java.util.TimeZone;
import org.apache.pekko.extension.quartz.QuartzCronSchedule;
import org.apache.pekko.extension.quartz.QuartzSchedule;
import org.quartz.CronExpression;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Seq;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.Exception;
import scala.util.control.Exception$;

public final class QuartzSchedules$ {
    public static final QuartzSchedules$ MODULE$ = new QuartzSchedules$();
    private static final Exception.Catch<Nothing$> catchMissing = Exception$.MODULE$.catching((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ConfigException.Missing.class}));
    private static final Exception.Catch<Nothing$> catchWrongType = Exception$.MODULE$.catching((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ConfigException.WrongType.class}));
    private static final Exception.Catch<Nothing$> catchParseErr = Exception$.MODULE$.catching((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ParseException.class}));

    public Exception.Catch<Nothing$> catchMissing() {
        return catchMissing;
    }

    public Exception.Catch<Nothing$> catchWrongType() {
        return catchWrongType;
    }

    public Exception.Catch<Nothing$> catchParseErr() {
        return catchParseErr;
    }

    public Map<String, QuartzSchedule> apply(Config config, TimeZone defaultTimezone) {
        return (Map)this.catchMissing().opt((Function0 & Serializable)() -> (Map)((IterableOnceOps)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)config.getConfig("schedules").root()).asScala()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                ConfigValue value = (ConfigValue)tuple2._2();
                if (value instanceof ConfigObject) {
                    ConfigObject configObject = (ConfigObject)value;
                    return new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)MODULE$.parseSchedule(key, configObject.toConfig(), defaultTimezone)));
                }
            }
            return None$.MODULE$;
        })).getOrElse((Function0 & Serializable)() -> Map$.MODULE$.empty());
    }

    public QuartzSchedule parseSchedule(String name, Config config, TimeZone defaultTimezone) {
        TimeZone timezone = (TimeZone)this.catchMissing().opt((Function0 & Serializable)() -> TimeZone.getTimeZone(config.getString("timezone"))).getOrElse((Function0 & Serializable)() -> defaultTimezone);
        Option calendar = (Option)this.catchMissing().opt((Function0 & Serializable)() -> Option$.MODULE$.apply((Object)config.getString("calendar"))).getOrElse((Function0 & Serializable)() -> None$.MODULE$);
        Option desc = this.catchMissing().opt((Function0 & Serializable)() -> config.getString("description"));
        return this.parseCronSchedule(name, (Option<String>)desc, config, timezone, (Option<String>)calendar);
    }

    public QuartzCronSchedule parseCronSchedule(String name, Option<String> desc, Config config, TimeZone tz, Option<String> calendar) {
        Either either;
        Either either2 = this.catchMissing().or(this.catchWrongType()).either((Function0 & Serializable)() -> config.getString("expression"));
        if (either2 instanceof Left) {
            Left left = (Left)either2;
            Throwable t = (Throwable)left.value();
            throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Invalid or Missing Configuration entry 'expression' for Cron Schedule '%s'. You must provide a valid Quartz CronExpression."), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{name})), t);
        }
        if (either2 instanceof Right) {
            Right right = (Right)either2;
            String str = (String)right.value();
            either = this.catchParseErr().either((Function0 & Serializable)() -> new CronExpression(str));
            if (either instanceof Left) {
                Left left = (Left)either;
                Throwable t = (Throwable)left.value();
                throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Invalid 'expression' for Cron Schedule '%s'. Failed to validate CronExpression."), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{name})), t);
            }
            if (!(either instanceof Right)) {
                throw new MatchError((Object)either);
            }
        } else {
            throw new MatchError((Object)either2);
        }
        Right right = (Right)either;
        CronExpression expr = (CronExpression)right.value();
        CronExpression expression = expr;
        return new QuartzCronSchedule(name, desc, expression, tz, calendar);
    }

    private QuartzSchedules$() {
    }
}

