/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service.blackout;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.xlrelease.actors.ExceptionTranslate;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.actors.ReleaseExecutionActor;
import com.xebialabs.xlrelease.actors.ReleaseExecutionActorMessages;
import com.xebialabs.xlrelease.actors.extension.ActorExtensionHandlerFactory;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.blackout.BlackoutMetadata;
import com.xebialabs.xlrelease.domain.blackout.BlackoutMetadata$;
import com.xebialabs.xlrelease.domain.blackout.BlackoutPeriod;
import com.xebialabs.xlrelease.domain.events.BlackoutDeletedEvent;
import com.xebialabs.xlrelease.domain.events.BlackoutUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.TaskUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.EventBus;
import com.xebialabs.xlrelease.events.Subscribe;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.service.blackout.BlackoutReleaseExecutionActorMessages;
import com.xebialabs.xlrelease.service.blackout.BlackoutTaskEventHandler$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Date;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.slf4j.Marker;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;

@Service
@ScalaSignature(bytes="\u0006\u0005\t\rc\u0001B\u000b\u0017\u0001\u0005B\u0001\u0002\u000f\u0001\u0003\u0006\u0004%\t!\u000f\u0005\t\r\u0002\u0011\t\u0011)A\u0005u!Aq\t\u0001BC\u0002\u0013\u0005\u0001\n\u0003\u0005P\u0001\t\u0005\t\u0015!\u0003J\u0011!\u0001\u0006A!b\u0001\n\u0003\t\u0006\u0002\u0003,\u0001\u0005\u0003\u0005\u000b\u0011\u0002*\t\u0011]\u0003!Q1A\u0005\u0002aC\u0001b\u0018\u0001\u0003\u0002\u0003\u0006I!\u0017\u0005\u0006A\u0002!\t!\u0019\u0005\u0006Q\u0002!\t!\u001b\u0005\u0006m\u0002!\t!\u001b\u0005\u0006w\u0002!\t\u0001 \u0005\b\u0003S\u0001A\u0011AA\u0016\u0011\u001d\tI\u0004\u0001C\u0005\u0003wAq!!\u0017\u0001\t\u0013\tY\u0006C\u0004\u0002\u001a\u0002!\t%a'\t\u000f\u0005\u0005\b\u0001\"\u0003\u0002d\"9\u0011\u0011 \u0001\u0005\n\u0005m\bb\u0002B\u0003\u0001\u0011%!q\u0001\u0005\b\u0005\u0017\u0001A\u0011\tB\u0007\u0005a\u0011E.Y2l_V$H+Y:l\u000bZ,g\u000e\u001e%b]\u0012dWM\u001d\u0006\u0003/a\t\u0001B\u00197bG.|W\u000f\u001e\u0006\u00033i\tqa]3sm&\u001cWM\u0003\u0002\u001c9\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003;y\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003}\t1aY8n\u0007\u0001\u0019B\u0001\u0001\u0012)aA\u00111EJ\u0007\u0002I)\tQ%A\u0003tG\u0006d\u0017-\u0003\u0002(I\t1\u0011I\\=SK\u001a\u0004\"!\u000b\u0018\u000e\u0003)R!a\u000b\u0017\u0002\u0013\u0015DH/\u001a8tS>t'BA\u0017\u001b\u0003\u0019\t7\r^8sg&\u0011qF\u000b\u0002\u001d\u0003\u000e$xN]#yi\u0016t7/[8o\u0011\u0006tG\r\\3s\r\u0006\u001cGo\u001c:z!\t\td'D\u00013\u0015\t\u0019D'A\u0003tY\u001a$$NC\u00016\u0003!9'/\u001b>{Y\u0016$\u0017BA\u001c3\u0005\u001daunZ4j]\u001e\f1\"Y2u_J\u001c\u0016p\u001d;f[V\t!\b\u0005\u0002<\t6\tAH\u0003\u0002>}\u0005)\u0011m\u0019;pe*\u0011q\bQ\u0001\u0006a\u0016\\7n\u001c\u0006\u0003\u0003\n\u000ba!\u00199bG\",'\"A\"\u0002\u0007=\u0014x-\u0003\u0002Fy\tY\u0011i\u0019;peNK8\u000f^3n\u00031\t7\r^8s'f\u001cH/Z7!\u0003!)g/\u001a8u\u0005V\u001cX#A%\u0011\u0005)kU\"A&\u000b\u00051S\u0012AB3wK:$8/\u0003\u0002O\u0017\nAQI^3oi\n+8/A\u0005fm\u0016tGOQ;tA\u0005\u0019\"/\u001a7fCN,\u0017i\u0019;peN+'O^5dKV\t!\u000b\u0005\u0002T)6\tA&\u0003\u0002VY\t\u0019\"+\u001a7fCN,\u0017i\u0019;peN+'O^5dK\u0006!\"/\u001a7fCN,\u0017i\u0019;peN+'O^5dK\u0002\na\u0002^1tWJ+\u0007o\\:ji>\u0014\u00180F\u0001Z!\tQV,D\u0001\\\u0015\ta&$\u0001\u0006sKB|7/\u001b;pefL!AX.\u0003\u001dQ\u000b7o\u001b*fa>\u001c\u0018\u000e^8ss\u0006yA/Y:l%\u0016\u0004xn]5u_JL\b%\u0001\u0004=S:LGO\u0010\u000b\u0006E\u0012,gm\u001a\t\u0003G\u0002i\u0011A\u0006\u0005\u0006q%\u0001\rA\u000f\u0005\u0006\u000f&\u0001\r!\u0013\u0005\u0006!&\u0001\rA\u0015\u0005\u0006/&\u0001\r!W\u0001\te\u0016<\u0017n\u001d;feR\t!\u000e\u0005\u0002$W&\u0011A\u000e\n\u0002\u0005+:LG\u000f\u000b\u0002\u000b]B\u0011q\u000e^\u0007\u0002a*\u0011\u0011O]\u0001\u000bC:tw\u000e^1uS>t'\"A:\u0002\u000f)\f7.\u0019:uC&\u0011Q\u000f\u001d\u0002\u000e!>\u001cHoQ8ogR\u0014Xo\u0019;\u0002\u0015Ut'/Z4jgR,'\u000f\u000b\u0002\fqB\u0011q._\u0005\u0003uB\u0014!\u0002\u0015:f\t\u0016\u001cHO]8z\u0003EygN\u00117bG.|W\u000f^+qI\u0006$X\r\u001a\u000b\u0003UvDQA \u0007A\u0002}\fQ!\u001a<f]R\u0004B!!\u0001\u0002\n5\u0011\u00111\u0001\u0006\u0004\u0019\u0006\u0015!bAA\u00045\u00051Am\\7bS:LA!a\u0003\u0002\u0004\t!\"\t\\1dW>,H/\u00169eCR,G-\u0012<f]RD3\u0001DA\b!\rQ\u0015\u0011C\u0005\u0004\u0003'Y%!C*vEN\u001c'/\u001b2fQ\ra\u0011q\u0003\t\u0005\u00033\t)#\u0004\u0002\u0002\u001c)\u0019\u0011/!\b\u000b\t\u0005}\u0011\u0011E\u0001\b[\u0016$(/[2t\u0015\r\t\u0019CH\u0001\tG>$\u0017\r[1mK&!\u0011qEA\u000e\u0005\u0015!\u0016.\\3e\u0003EygN\u00117bG.|W\u000f\u001e#fY\u0016$X\r\u001a\u000b\u0004U\u00065\u0002B\u0002@\u000e\u0001\u0004\ty\u0003\u0005\u0003\u0002\u0002\u0005E\u0012\u0002BA\u001a\u0003\u0007\u0011AC\u00117bG.|W\u000f\u001e#fY\u0016$X\rZ#wK:$\bfA\u0007\u0002\u0010!\u001aQ\"a\u0006\u0002!%\u001c\u0018I\u001a4fGRLgn\u001a+bg.\u001cHCBA\u001f\u0003\u0007\n)\u0005E\u0002$\u0003\u007fI1!!\u0011%\u0005\u001d\u0011un\u001c7fC:DQA \bA\u0002}Dq!a\u0012\u000f\u0001\u0004\tI%A\u0002o_^\u0004B!a\u0013\u0002V5\u0011\u0011Q\n\u0006\u0005\u0003\u001f\n\t&\u0001\u0003vi&d'BAA*\u0003\u0011Q\u0017M^1\n\t\u0005]\u0013Q\n\u0002\u0005\t\u0006$X-\u0001\ntG\",G-\u001e7f)\u0006\u001c8.\u00169eCR,G#\u00026\u0002^\u0005]\u0004bBA0\u001f\u0001\u0007\u0011\u0011M\u0001\u0007i\u0006\u001c8.\u00133\u0011\t\u0005\r\u0014\u0011\u000f\b\u0005\u0003K\ni\u0007E\u0002\u0002h\u0011j!!!\u001b\u000b\u0007\u0005-\u0004%\u0001\u0004=e>|GOP\u0005\u0004\u0003_\"\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002t\u0005U$AB*ue&twMC\u0002\u0002p\u0011Bq!!\u001f\u0010\u0001\u0004\tY(A\u0004d_6l\u0017M\u001c3\u0011\t\u0005u\u00141\u0013\b\u0005\u0003\u007f\nyI\u0004\u0003\u0002\u0002\u00065e\u0002BAB\u0003\u0017sA!!\"\u0002\n:!\u0011qMAD\u0013\u0005y\u0012BA\u000f\u001f\u0013\tYB$\u0003\u0002.5%\u0019\u0011\u0011\u0013\u0017\u0002;I+G.Z1tK\u0016CXmY;uS>t\u0017i\u0019;pe6+7o]1hKNLA!!&\u0002\u0018\n\u0001R\t\u001f;f]NLwN\\\"p[6\fg\u000e\u001a\u0006\u0004\u0003#c\u0013AC4fi\"\u000bg\u000e\u001a7feRA\u0011QTA^\u0003\u000b\fy\r\u0005\u0003\u0002 \u0006Uf\u0002BAQ\u0003csA!a)\u00020:!\u0011QUAW\u001d\u0011\t9+a+\u000f\t\u0005\u001d\u0014\u0011V\u0005\u0002\u0007&\u0011\u0011IQ\u0005\u0003\u007f\u0001K!!\u0010 \n\u0007\u0005MF(A\u0003BGR|'/\u0003\u0003\u00028\u0006e&a\u0002*fG\u0016Lg/\u001a\u0006\u0004\u0003gc\u0004bBA_!\u0001\u0007\u0011qX\u0001\u0005g\u0016dg\rE\u0002<\u0003\u0003L1!a1=\u0005!\t5\r^8s%\u00164\u0007bBAd!\u0001\u0007\u0011\u0011Z\u0001\u0007g\u0016tG-\u001a:\u0011\u000b\r\nY-a0\n\u0007\u00055GEA\u0005Gk:\u001cG/[8oa!A\u0011\u0011\u001b\t\u0005\u0002\u0004\t\u0019.A\u0004sK2,\u0017m]3\u0011\u000b\r\n).!7\n\u0007\u0005]GE\u0001\u0005=Eft\u0017-\\3?!\u0011\tY.!8\u000e\u0005\u0005\u0015\u0011\u0002BAp\u0003\u000b\u0011qAU3mK\u0006\u001cX-\u0001\bva\u0012\fG/\u001a+bg.<\u0016\u000e\u001e5\u0015\t\u0005\u0015\u0018q\u001f\u000b\u0004U\u0006\u001d\bbBAu#\u0001\u0007\u00111^\u0001\bkB$\u0017\r^3s!\u0019\u0019\u0013Q^AyU&\u0019\u0011q\u001e\u0013\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\u0003BAn\u0003gLA!!>\u0002\u0006\t!A+Y:l\u0011\u001d\ty&\u0005a\u0001\u0003C\n\u0001$\u001e9eCR,7k\u00195fIVdW\rZ*uCJ$H)\u0019;f)\u0015Q\u0017Q B\u0001\u0011\u001d\tyP\u0005a\u0001\u0003c\fA\u0001^1tW\"9!1\u0001\nA\u0002\u0005%\u0013!\u00068foN\u001b\u0007.\u001a3vY\u0016$7\u000b^1si\u0012\u000bG/Z\u0001\u0018e\u0016\u001cX\r^*dQ\u0016$W\u000f\\3e'R\f'\u000f\u001e#bi\u0016$2A\u001bB\u0005\u0011\u001d\typ\u0005a\u0001\u0003c\f\u0001b];qa>\u0014Ho\u001d\u000b\u0005\u0003{\u0011y\u0001C\u0004\u0003\u0012Q\u0001\rAa\u0005\u0002\u000b\rd\u0017M\u001f>1\t\tU!q\u0004\t\u0007\u0003G\u00129Ba\u0007\n\t\te\u0011Q\u000f\u0002\u0006\u00072\f7o\u001d\t\u0005\u0005;\u0011y\u0002\u0004\u0001\u0005\u0019\t\u0005\"qBA\u0001\u0002\u0003\u0015\tAa\t\u0003\u0007}#\u0013'\u0005\u0003\u0003&\t-\u0002cA\u0012\u0003(%\u0019!\u0011\u0006\u0013\u0003\u000f9{G\u000f[5oOB\u00191H!\f\n\u0007\t=BHA\u0003BGR|'\u000fK\u0002\u0001\u0005g\u0001BA!\u000e\u0003@5\u0011!q\u0007\u0006\u0005\u0005s\u0011Y$\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016T1A!\u0010C\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\\u0017\u0002\u0002B!\u0005o\u0011qaU3sm&\u001cW\r")
public class BlackoutTaskEventHandler
implements ActorExtensionHandlerFactory,
Logging {
    private final ActorSystem actorSystem;
    private final EventBus eventBus;
    private final ReleaseActorService releaseActorService;
    private final TaskRepository taskRepository;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public <T> void replyOrFail(Function0<ActorRef> sender, Function0<T> call) {
        ActorExtensionHandlerFactory.replyOrFail$(this, sender, call);
    }

    @Override
    public Throwable translate(Throwable ex) {
        return ExceptionTranslate.translate$(this, ex);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        BlackoutTaskEventHandler blackoutTaskEventHandler = this;
        synchronized (blackoutTaskEventHandler) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public ActorSystem actorSystem() {
        return this.actorSystem;
    }

    public EventBus eventBus() {
        return this.eventBus;
    }

    public ReleaseActorService releaseActorService() {
        return this.releaseActorService;
    }

    public TaskRepository taskRepository() {
        return this.taskRepository;
    }

    @PostConstruct
    public void register() {
        this.eventBus().register((Object)this);
        this.logger().debug((Function0 & Serializable)() -> "Blackout task event handler registered in event bus.");
    }

    @PreDestroy
    public void unregister() {
        this.eventBus().deregister((Object)this);
        this.logger().debug((Function0 & Serializable)() -> "Blackout task event handler de-registered from event bus.");
    }

    @Subscribe
    @Timed
    public void onBlackoutUpdated(BlackoutUpdatedEvent event) {
        Date now = new Date();
        if (this.isAffectingTasks(event, now)) {
            Buffer taskIds = CollectionConverters$.MODULE$.ListHasAsScala(this.taskRepository().findAffectedByBlackout(event.original())).asScala();
            this.logger().debug((Function0 & Serializable)() -> taskIds.length() + " taskIds to be updated after blackout " + event.original().getLabel() + " update.");
            BlackoutMetadata metadata = BlackoutMetadata$.MODULE$.apply((Seq)new .colon.colon((Object)new BlackoutPeriod(event.updated().getStartDate(), event.updated().getEndDate()), (List)Nil$.MODULE$));
            boolean isInBlackout = metadata.isInBlackout(now);
            Date newScheduledStartDate = metadata.getEndOfBlackout(now);
            taskIds.foreach((Function1 & Serializable)taskId -> {
                this.scheduleTaskUpdate(taskId, isInBlackout ? new BlackoutReleaseExecutionActorMessages.UpdateScheduledStartDate(taskId, newScheduledStartDate) : new BlackoutReleaseExecutionActorMessages.ResetScheduledStartDate(taskId));
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    @Subscribe
    @Timed
    public void onBlackoutDeleted(BlackoutDeletedEvent event) {
        Buffer taskIds = CollectionConverters$.MODULE$.ListHasAsScala(this.taskRepository().findAffectedByBlackout(event.blackout())).asScala();
        this.logger().debug((Function0 & Serializable)() -> taskIds.length() + " taskIds to be started after blackout " + event.blackout().getLabel() + " removal.");
        taskIds.foreach((Function1 & Serializable)taskId -> {
            this.scheduleTaskUpdate(taskId, new BlackoutReleaseExecutionActorMessages.ResetScheduledStartDate(taskId));
            return BoxedUnit.UNIT;
        });
    }

    private boolean isAffectingTasks(BlackoutUpdatedEvent event, Date now) {
        Date date = event.original().getEndDate();
        Date date2 = event.updated().getEndDate();
        boolean endDateChanged = date == null ? date2 != null : !((Object)date).equals(date2);
        boolean startDateMovedIntoFuture = now.after(event.original().getStartDate()) && now.before(event.updated().getStartDate());
        return endDateChanged || startDateMovedIntoFuture;
    }

    private void scheduleTaskUpdate(String taskId, ReleaseExecutionActorMessages.ExtensionCommand command) {
        this.releaseActorService().executeCommandAsync(taskId, command);
    }

    @Override
    public PartialFunction<Object, BoxedUnit> getHandler(ActorRef self, Function0<ActorRef> sender, Function0<Release> release) {
        return new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ BlackoutTaskEventHandler $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof BlackoutReleaseExecutionActorMessages.UpdateScheduledStartDate) {
                    BlackoutReleaseExecutionActorMessages.UpdateScheduledStartDate updateScheduledStartDate = (BlackoutReleaseExecutionActorMessages.UpdateScheduledStartDate)A1;
                    String taskId = updateScheduledStartDate.taskId();
                    Date newScheduledStartDate = updateScheduledStartDate.newScheduledStartDate();
                    this.$outer.com$xebialabs$xlrelease$service$blackout$BlackoutTaskEventHandler$$updateTaskWith(taskId, (Function1<Task, BoxedUnit>)(Function1 & Serializable)x$1 -> {
                        $anonfun$getHandler$1.$anonfun$applyOrElse$1(this, newScheduledStartDate, x$1);
                        return BoxedUnit.UNIT;
                    });
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof BlackoutReleaseExecutionActorMessages.ResetScheduledStartDate) {
                    BlackoutReleaseExecutionActorMessages.ResetScheduledStartDate resetScheduledStartDate = (BlackoutReleaseExecutionActorMessages.ResetScheduledStartDate)A1;
                    String taskId = resetScheduledStartDate.taskId();
                    this.$outer.com$xebialabs$xlrelease$service$blackout$BlackoutTaskEventHandler$$updateTaskWith(taskId, (Function1<Task, BoxedUnit>)(Function1 & Serializable)task -> {
                        $anonfun$getHandler$1.$anonfun$applyOrElse$2(this, task);
                        return BoxedUnit.UNIT;
                    });
                    return (B1)BoxedUnit.UNIT;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                if (object instanceof BlackoutReleaseExecutionActorMessages.UpdateScheduledStartDate) {
                    return true;
                }
                return object instanceof BlackoutReleaseExecutionActorMessages.ResetScheduledStartDate;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$1($anonfun$getHandler$1 $this, Date newScheduledStartDate$2, Task x$1) {
                $this.$outer.com$xebialabs$xlrelease$service$blackout$BlackoutTaskEventHandler$$updateScheduledStartDate(x$1, newScheduledStartDate$2);
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$2($anonfun$getHandler$1 $this, Task task) {
                $this.$outer.com$xebialabs$xlrelease$service$blackout$BlackoutTaskEventHandler$$resetScheduledStartDate(task);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(com.xebialabs.xlrelease.service.blackout.BlackoutTaskEventHandler$$anonfun$getHandler$1 java.util.Date com.xebialabs.xlrelease.domain.Task ), $anonfun$applyOrElse$2$adapted(com.xebialabs.xlrelease.service.blackout.BlackoutTaskEventHandler$$anonfun$getHandler$1 com.xebialabs.xlrelease.domain.Task )}, serializedLambda);
            }
        };
    }

    public void com$xebialabs$xlrelease$service$blackout$BlackoutTaskEventHandler$$updateTaskWith(String taskId, Function1<Task, BoxedUnit> updater) {
        Object task = this.taskRepository().findById(taskId);
        Task original = (Task)CiCloneHelper.cloneCi(task);
        updater.apply(task);
        this.taskRepository().update((Task)task);
        this.eventBus().publish((XLReleaseEvent)new TaskUpdatedEvent(original, task));
    }

    public void com$xebialabs$xlrelease$service$blackout$BlackoutTaskEventHandler$$updateScheduledStartDate(Task task, Date newScheduledStartDate) {
        this.logger().debug((Function0 & Serializable)() -> "Updating task '" + task.getId() + "' scheduled start date due to new blackout end date '" + newScheduledStartDate + "'");
        Date originalScheduledStartDate = task.getOriginalScheduledStartDate();
        task.setScheduledStartDate(newScheduledStartDate);
        task.setPostponedDueToBlackout(true);
        task.setOriginalScheduledStartDate(originalScheduledStartDate);
    }

    public void com$xebialabs$xlrelease$service$blackout$BlackoutTaskEventHandler$$resetScheduledStartDate(Task task) {
        this.logger().debug((Function0 & Serializable)() -> "Resetting task '" + task.getId() + "' scheduled start date due to blackout not being applicable anymore.");
        task.setScheduledStartDate(task.getOriginalScheduledStartDate());
        task.setPostponedDueToBlackout(false);
    }

    @Override
    public boolean supports(Class<? extends Actor> clazz) {
        return ReleaseExecutionActor.class.isAssignableFrom(clazz);
    }

    public BlackoutTaskEventHandler(ActorSystem actorSystem, EventBus eventBus, ReleaseActorService releaseActorService, TaskRepository taskRepository) {
        this.actorSystem = actorSystem;
        this.eventBus = eventBus;
        this.releaseActorService = releaseActorService;
        this.taskRepository = taskRepository;
        ExceptionTranslate.$init$(this);
        ActorExtensionHandlerFactory.$init$(this);
        Logging.$init$((Logging)this);
    }
}

