/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.security;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.PermissionChecker$;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.BreakInheritanceOperation;
import com.xebialabs.xlrelease.service.CreateTeamOperation;
import com.xebialabs.xlrelease.service.DeleteTeamOperation;
import com.xebialabs.xlrelease.service.TeamMembership;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.service.TeamUpdateOperation;
import com.xebialabs.xlrelease.service.UpdateTeamOperation;
import com.xebialabs.xlrelease.user.User;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.Set;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u00055a\u0001\u0003\u0006\f!\u0003\r\t\u0001\u0006@\t\u000bm\u0001A\u0011\u0001\u000f\t\u000b\u0001\u0002a\u0011A\u0011\t\u000b!\u0002a\u0011A\u0015\t\u000bE\u0002A\u0011\u0001\u001a\t\u000bA\u0003A\u0011B)\t\u000bu\u0003A\u0011\u00010\t\u000b=\u0004A\u0011\u00029\t\u000bQ\u0004A\u0011A;\t\u000b]\u0004A\u0011\u0001=\u00039A+'/\\5tg&|gn\u00115fG.,'o\u00155be\u0016$Gj\\4jG*\u0011A\"D\u0001\tg\u0016\u001cWO]5us*\u0011abD\u0001\nq2\u0014X\r\\3bg\u0016T!\u0001E\t\u0002\u0013a,'-[1mC\n\u001c(\"\u0001\n\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001)\u0002C\u0001\f\u001a\u001b\u00059\"\"\u0001\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005i9\"AB!osJ+g-\u0001\u0004%S:LG\u000f\n\u000b\u0002;A\u0011aCH\u0005\u0003?]\u0011A!\u00168ji\u0006YA/Z1n'\u0016\u0014h/[2f+\u0005\u0011\u0003CA\u0012'\u001b\u0005!#BA\u0013\u000e\u0003\u001d\u0019XM\u001d<jG\u0016L!a\n\u0013\u0003\u0017Q+\u0017-\\*feZL7-Z\u0001\fe>dWmU3sm&\u001cW-F\u0001+!\tYs&D\u0001-\u0015\taQF\u0003\u0002/\u001f\u0005AA-\u001a9m_fLG/\u0003\u00021Y\tY!k\u001c7f'\u0016\u0014h/[2f\u0003u\u0019\u0007.Z2l\u000b\u0012LG\u000fV3b[N\fu-Y5ogR,\u00050[:uS:<GcA\u000f4\u0001\")A\u0007\u0002a\u0001k\u0005yA/Z1n\u0007>tG/Y5oKJLE\r\u0005\u00027{9\u0011qg\u000f\t\u0003q]i\u0011!\u000f\u0006\u0003uM\ta\u0001\u0010:p_Rt\u0014B\u0001\u001f\u0018\u0003\u0019\u0001&/\u001a3fM&\u0011ah\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005q:\u0002\"B!\u0005\u0001\u0004\u0011\u0015!\u0002;fC6\u001c\bcA\"I\u00156\tAI\u0003\u0002F\r\u0006!Q\u000f^5m\u0015\u00059\u0015\u0001\u00026bm\u0006L!!\u0013#\u0003\u0015\r{G\u000e\\3di&|g\u000e\u0005\u0002L\u001d6\tAJ\u0003\u0002N\u001b\u00051Am\\7bS:L!a\u0014'\u0003\tQ+\u0017-\\\u0001$G\",7m[#eSR4u\u000e\u001c3feR+\u0017-\\:BO\u0006Lgn\u001d;Fq&\u001cH/\u001b8h)\ri\"k\u0015\u0005\u0006i\u0015\u0001\r!\u000e\u0005\u0006\u0003\u0016\u0001\r\u0001\u0016\t\u0004+jSeB\u0001,Y\u001d\tAt+C\u0001\u0019\u0013\tIv#A\u0004qC\u000e\\\u0017mZ3\n\u0005mc&aA*fc*\u0011\u0011lF\u0001\u000fG\",7m[#eSR$V-Y7t)\rir\f\u0019\u0005\u0006i\u0019\u0001\r!\u000e\u0005\u0006C\u001a\u0001\rAY\u0001\u000b_B,'/\u0019;j_:\u001c\bGA2g!\r)&\f\u001a\t\u0003K\u001ad\u0001\u0001B\u0005hA\u0006\u0005\t\u0011!B\u0001Q\n\u0019q\fJ\u0019\u0012\u0005%d\u0007C\u0001\fk\u0013\tYwCA\u0004O_RD\u0017N\\4\u0011\u0005\rj\u0017B\u00018%\u0005M!V-Y7Va\u0012\fG/Z(qKJ\fG/[8o\u0003Q\u0019\u0007.Z2l\u000b\u0012LGOR8mI\u0016\u0014H+Z1ngR\u0019Q$\u001d:\t\u000bQ:\u0001\u0019A\u001b\t\u000b\u0005<\u0001\u0019A:\u0011\u0007USF.A\ndQ\u0016\u001c7\u000eR3mKR,wj\u001e8UK\u0006l7\u000f\u0006\u0002\u001em\")A\u0007\u0003a\u0001k\u0005\u0011r-\u001a;Vg\u0016\u0014hi\u001c7eKJ$V-Y7t)\tIH\u0010E\u0002Du*K!a\u001f#\u0003\t1K7\u000f\u001e\u0005\u0006{&\u0001\r!N\u0001\tM>dG-\u001a:JIJ)q0a\u0001\u0002\b\u0019)\u0011\u0011\u0001\u0001\u0001}\naAH]3gS:,W.\u001a8u}A\u0019\u0011Q\u0001\u0001\u000e\u0003-\u0001B!!\u0002\u0002\n%\u0019\u00111B\u0006\u0003#A+'/\\5tg&|gn\u00115fG.,'\u000f")
public interface PermissionCheckerSharedLogic {
    public TeamService teamService();

    public RoleService roleService();

    public static /* synthetic */ void checkEditTeamsAgainstExisting$(PermissionCheckerSharedLogic $this, String teamContainerId, Collection teams) {
        $this.checkEditTeamsAgainstExisting(teamContainerId, teams);
    }

    default public void checkEditTeamsAgainstExisting(String teamContainerId, Collection<Team> teams) {
        if (Ids.isReleaseId((String)teamContainerId)) {
            ((PermissionChecker)((Object)this)).checkEdit(teamContainerId);
            return;
        }
        if (Ids.isFolderId((String)teamContainerId)) {
            this.checkEditFolderTeamsAgainstExisting(teamContainerId, (Seq<Team>)CollectionConverters$.MODULE$.CollectionHasAsScala(teams).asScala().toSeq());
            return;
        }
        throw new Checks.IncorrectArgumentException("[%s] is not a release or a folder", new Object[]{teamContainerId});
    }

    private void checkEditFolderTeamsAgainstExisting(String teamContainerId, Seq<Team> teams) {
        boolean superUser = ((PermissionChecker)((Object)this)).isCurrentUserAdmin();
        boolean folderSecurityAdministrator = ((PermissionChecker)((Object)this)).hasPermission(XLReleasePermissions.EDIT_FOLDER_SECURITY, teamContainerId);
        boolean folderTeamAdmin = ((PermissionChecker)((Object)this)).hasPermission(XLReleasePermissions.EDIT_FOLDER_TEAMS, teamContainerId);
        if (folderTeamAdmin && !folderSecurityAdministrator && !superUser) {
            Buffer folderTeams = CollectionConverters$.MODULE$.ListHasAsScala(this.teamService().getEffectiveTeams(teamContainerId)).asScala();
            Seq newAndUpdatedTeams = (Seq)teams.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)PermissionCheckerSharedLogic.$anonfun$checkEditFolderTeamsAgainstExisting$1(folderTeams, x$1)));
            newAndUpdatedTeams.foreach((Function1 & Serializable)team -> {
                PermissionCheckerSharedLogic.$anonfun$checkEditFolderTeamsAgainstExisting$2(folderTeams, team);
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (!superUser && !folderSecurityAdministrator) {
            throw PermissionChecker$.MODULE$.userCannotManageTeamException();
        }
    }

    public static /* synthetic */ void checkEditTeams$(PermissionCheckerSharedLogic $this, String teamContainerId, Seq operations) {
        $this.checkEditTeams(teamContainerId, (Seq<TeamUpdateOperation>)operations);
    }

    default public void checkEditTeams(String teamContainerId, Seq<TeamUpdateOperation> operations) {
        if (Ids.isReleaseId((String)teamContainerId)) {
            ((PermissionChecker)((Object)this)).checkEdit(teamContainerId);
            return;
        }
        if (Ids.isFolderId((String)teamContainerId)) {
            this.checkEditFolderTeams(teamContainerId, operations);
            return;
        }
        throw new Checks.IncorrectArgumentException("[%s] is not a release or a folder", new Object[]{teamContainerId});
    }

    private void checkEditFolderTeams(String teamContainerId, Seq<TeamUpdateOperation> operations) {
        boolean superUser = ((PermissionChecker)((Object)this)).isCurrentUserAdmin();
        boolean folderOwner = ((PermissionChecker)((Object)this)).hasPermission(XLReleasePermissions.EDIT_FOLDER_SECURITY, teamContainerId);
        boolean folderAdmin = ((PermissionChecker)((Object)this)).hasPermission(XLReleasePermissions.EDIT_FOLDER_TEAMS, teamContainerId);
        if (folderAdmin && !folderOwner && !superUser) {
            operations.foreach((Function1 & Serializable)x0$1 -> {
                PermissionCheckerSharedLogic.$anonfun$checkEditFolderTeams$1(x0$1);
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (!superUser && !folderOwner) {
            throw PermissionChecker$.MODULE$.userCannotManageTeamException();
        }
    }

    public static /* synthetic */ void checkDeleteOwnTeams$(PermissionCheckerSharedLogic $this, String teamContainerId) {
        $this.checkDeleteOwnTeams(teamContainerId);
    }

    default public void checkDeleteOwnTeams(String teamContainerId) {
        if (Ids.isReleaseId((String)teamContainerId)) {
            ((PermissionChecker)((Object)this)).checkEdit(teamContainerId);
            return;
        }
        if (Ids.isFolderId((String)teamContainerId)) {
            boolean superUser = ((PermissionChecker)((Object)this)).isCurrentUserAdmin();
            boolean owner = ((PermissionChecker)((Object)this)).hasPermission(XLReleasePermissions.EDIT_FOLDER_SECURITY, teamContainerId);
            boolean admin = ((PermissionChecker)((Object)this)).hasPermission(XLReleasePermissions.EDIT_FOLDER_TEAMS, teamContainerId);
            if (admin && !owner && !superUser) {
                Buffer userFolderTeams = CollectionConverters$.MODULE$.ListHasAsScala(this.getUserFolderTeams(teamContainerId)).asScala();
                userFolderTeams.foreach((Function1 & Serializable)team -> {
                    PermissionCheckerSharedLogic.$anonfun$checkDeleteOwnTeams$1(team);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            if (!superUser && !owner) {
                throw PermissionChecker$.MODULE$.userCannotManageTeamException();
            }
            return;
        }
        throw new Checks.IncorrectArgumentException("[%s] is not a release or a folder", new Object[]{teamContainerId});
    }

    public static /* synthetic */ List getUserFolderTeams$(PermissionCheckerSharedLogic $this, String folderId) {
        return $this.getUserFolderTeams(folderId);
    }

    default public List<Team> getUserFolderTeams(String folderId) {
        String username = User.AUTHENTICATED_USER.getName();
        List<Team> folderTeams = this.teamService().getEffectiveTeams(folderId);
        List userRoles = this.roleService().getRolesFor(Permissions.getAuthentication());
        return folderTeams.stream().filter(team -> team.hasMember(username) || team.hasAnyRole(userRoles)).collect(Collectors.toList());
    }

    public static /* synthetic */ boolean $anonfun$checkEditFolderTeamsAgainstExisting$1(Buffer folderTeams$1, Team x$1) {
        return !folderTeams$1.contains((Object)x$1);
    }

    public static /* synthetic */ boolean $anonfun$checkEditFolderTeamsAgainstExisting$3(Team team$1, Team x$2) {
        String string = x$2.getTeamName();
        String string2 = team$1.getTeamName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static /* synthetic */ void $anonfun$checkEditFolderTeamsAgainstExisting$4(Team old) {
        if (old.isFolderOwnerTeam() || old.isFolderAdminTeam()) {
            throw PermissionChecker$.MODULE$.folderAdminCannotEditTeamException();
        }
    }

    public static /* synthetic */ void $anonfun$checkEditFolderTeamsAgainstExisting$2(Buffer folderTeams$1, Team team) {
        if (team.isFolderOwnerTeam() || team.isFolderAdminTeam()) {
            throw PermissionChecker$.MODULE$.folderAdminCannotAssignPermissionException();
        }
        if (team.hasPermission(XLReleasePermissions.EDIT_FOLDER.getPermissionName())) {
            throw PermissionChecker$.MODULE$.folderAdminCannotAssignPermissionException();
        }
        Option oldTeam = folderTeams$1.find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)PermissionCheckerSharedLogic.$anonfun$checkEditFolderTeamsAgainstExisting$3(team, x$2)));
        oldTeam.foreach((Function1 & Serializable)old -> {
            PermissionCheckerSharedLogic.$anonfun$checkEditFolderTeamsAgainstExisting$4(old);
            return BoxedUnit.UNIT;
        });
    }

    private static void checkEditOperation$1(TeamUpdateOperation teamOperation) {
        if (teamOperation.isFolderOwnerTeam() || teamOperation.isFolderAdminTeam()) {
            throw PermissionChecker$.MODULE$.folderAdminCannotAssignPermissionException();
        }
        if (teamOperation.hasPermission(XLReleasePermissions.EDIT_FOLDER.getPermissionName())) {
            throw PermissionChecker$.MODULE$.folderAdminCannotAssignPermissionException();
        }
    }

    private static void checkCreate$1(CreateTeamOperation teamOperation) {
        PermissionCheckerSharedLogic.checkEditOperation$1(teamOperation);
    }

    private static void checkUpdate$1(UpdateTeamOperation teamOperation) {
        PermissionCheckerSharedLogic.checkEditOperation$1(teamOperation);
        TeamMembership removedMembership = teamOperation.removedMembership();
        scala.collection.immutable.Set permissionsToCheck = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{XLReleasePermissions.EDIT_FOLDER_SECURITY.getPermissionName(), XLReleasePermissions.EDIT_FOLDER_TEAMS.getPermissionName()}));
        if (removedMembership.permissions().intersect((Set)permissionsToCheck).nonEmpty()) {
            throw PermissionChecker$.MODULE$.folderAdminCannotEditTeamException();
        }
    }

    private static void checkDelete$1(DeleteTeamOperation teamOperation) {
        if (teamOperation.isFolderOwnerTeam() || teamOperation.isFolderAdminTeam()) {
            throw PermissionChecker$.MODULE$.folderAdminCannotDeleteTeamException();
        }
    }

    public static /* synthetic */ void $anonfun$checkEditFolderTeams$1(TeamUpdateOperation x0$1) {
        TeamUpdateOperation teamUpdateOperation = x0$1;
        if (teamUpdateOperation instanceof BreakInheritanceOperation) {
            return;
        }
        if (teamUpdateOperation instanceof CreateTeamOperation) {
            CreateTeamOperation createTeamOperation = (CreateTeamOperation)teamUpdateOperation;
            PermissionCheckerSharedLogic.checkCreate$1(createTeamOperation);
            return;
        }
        if (teamUpdateOperation instanceof UpdateTeamOperation) {
            UpdateTeamOperation updateTeamOperation = (UpdateTeamOperation)teamUpdateOperation;
            PermissionCheckerSharedLogic.checkUpdate$1(updateTeamOperation);
            return;
        }
        if (teamUpdateOperation instanceof DeleteTeamOperation) {
            DeleteTeamOperation deleteTeamOperation = (DeleteTeamOperation)teamUpdateOperation;
            PermissionCheckerSharedLogic.checkDelete$1(deleteTeamOperation);
            return;
        }
        throw new MatchError((Object)teamUpdateOperation);
    }

    public static /* synthetic */ void $anonfun$checkDeleteOwnTeams$1(Team team) {
        if (team.isFolderOwnerTeam() || team.isFolderAdminTeam()) {
            throw PermissionChecker$.MODULE$.folderAdminCannotDeleteTeamException();
        }
    }

    public static void $init$(PermissionCheckerSharedLogic $this) {
    }
}

