/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jgroups.Address;
import org.jgroups.EmptyMessage;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.Property;
import org.jgroups.conf.AttributeType;
import org.jgroups.stack.Protocol;
import org.jgroups.util.DefaultThreadFactory;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.Util;

@MBean(description="Double-checks suspicions reports")
public class VERIFY_SUSPECT2
extends Protocol
implements Runnable {
    @Property(description="Number of millis to wait for verification that a suspect is really dead (approximation)", type=AttributeType.TIME)
    protected long timeout = 1000L;
    @Property(description="Number of verify heartbeats sent to a suspected member")
    protected int num_msgs = 1;
    @Property(description="Send the I_AM_NOT_DEAD message back as a multicast rather than as multiple unicasts (default is false)")
    protected boolean use_mcast_rsps;
    protected final Set<Entry> suspects = new HashSet<Entry>();
    @ManagedAttribute(description="Is the verifying task is running?")
    protected boolean running;
    protected ExecutorService thread_pool;

    @ManagedAttribute(description="List of currently suspected members")
    public synchronized String getSuspects() {
        return this.suspects.toString();
    }

    public VERIFY_SUSPECT2 setTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public long getTimeout() {
        return this.timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                View v = (View)evt.getArg();
                VERIFY_SUSPECT2 vERIFY_SUSPECT2 = this;
                synchronized (vERIFY_SUSPECT2) {
                    this.suspects.removeIf(e -> !v.containsMember(e.suspect));
                    break;
                }
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 9: {
                if (evt.arg() == null) {
                    return null;
                }
                ArrayList<Address> s = new ArrayList<Address>((Collection)evt.arg());
                s.remove(this.local_addr);
                this.verifySuspect(s);
                return null;
            }
        }
        return this.up_prot.up(evt);
    }

    @Override
    public Object up(Message msg) {
        VerifyHeader hdr = (VerifyHeader)msg.getHeader(this.id);
        if (hdr == null) {
            return this.up_prot.up(msg);
        }
        return this.handle(hdr);
    }

    @Override
    public void up(MessageBatch batch) {
        Iterator<Message> it = batch.iterator();
        while (it.hasNext()) {
            Message msg = it.next();
            VerifyHeader hdr = (VerifyHeader)msg.getHeader(this.id);
            if (hdr == null) continue;
            it.remove();
            this.handle(hdr);
        }
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ArrayList suspected_mbrs = new ArrayList();
        while (this.running) {
            long target_time = System.currentTimeMillis() + this.timeout;
            do {
                LockSupport.parkUntil(target_time);
            } while (System.currentTimeMillis() < target_time);
            suspected_mbrs.clear();
            VERIFY_SUSPECT2 vERIFY_SUSPECT2 = this;
            synchronized (vERIFY_SUSPECT2) {
                this.suspects.forEach(e -> {
                    if (e.target_time <= target_time) {
                        suspected_mbrs.add(e.suspect);
                    }
                });
                this.suspects.removeIf(e -> e.target_time <= target_time);
            }
            if (!suspected_mbrs.isEmpty()) {
                this.log.debug("%s: sending up SUSPECT(%s)", this.local_addr, suspected_mbrs);
                this.up_prot.up(new Event(9, suspected_mbrs));
                continue;
            }
            vERIFY_SUSPECT2 = this;
            synchronized (vERIFY_SUSPECT2) {
                if (this.suspects.isEmpty()) {
                    this.running = false;
                    break;
                }
            }
        }
    }

    protected Object handle(VerifyHeader hdr) {
        switch (hdr.type) {
            case 1: {
                if (hdr.from == null) {
                    this.log.error(Util.getMessage("AREYOUDEADHdrFromIsNull"));
                    return null;
                }
                Address target = this.use_mcast_rsps ? null : hdr.from;
                for (int i = 0; i < this.num_msgs; ++i) {
                    Message rsp = new EmptyMessage(target).putHeader(this.id, new VerifyHeader(2, this.local_addr));
                    this.down_prot.down(rsp);
                }
                return null;
            }
            case 2: {
                if (hdr.from == null) {
                    this.log.error(Util.getMessage("IAMNOTDEADHdrFromIsNull"));
                    return null;
                }
                this.unsuspect(hdr.from);
                return null;
            }
        }
        return null;
    }

    protected void verifySuspect(Collection<Address> mbrs) {
        if (mbrs == null || mbrs.isEmpty()) {
            return;
        }
        if (this.addSuspects(mbrs)) {
            this.startTask();
            this.log.trace("verifying that %s %s dead", mbrs, mbrs.size() == 1 ? "is" : "are");
        }
        for (Address mbr : mbrs) {
            for (int i = 0; i < this.num_msgs; ++i) {
                Message msg = new EmptyMessage(mbr).putHeader(this.id, new VerifyHeader(1, this.local_addr));
                this.down_prot.down(msg);
            }
        }
    }

    protected synchronized boolean addSuspects(Collection<Address> list) {
        if (list == null || list.isEmpty()) {
            return false;
        }
        long target_time = VERIFY_SUSPECT2.getCurrentTimeMillis();
        List tmp = list.stream().map(a -> new Entry((Address)a, target_time)).collect(Collectors.toList());
        return this.suspects.addAll(tmp);
    }

    protected synchronized boolean removeSuspect(Address suspect) {
        return this.suspects.removeIf(e -> Objects.equals(e.suspect, suspect));
    }

    public void unsuspect(Address mbr) {
        boolean removed;
        boolean bl = removed = mbr != null && this.removeSuspect(mbr);
        if (removed) {
            this.log.trace("member %s was unsuspected", mbr);
            this.down_prot.down(new Event(51, mbr));
            this.up_prot.up(new Event(51, mbr));
        }
    }

    protected synchronized void startTask() {
        if (!this.running) {
            this.running = true;
            this.thread_pool.execute(this);
        }
    }

    protected void stopThreadPool() {
        if (this.thread_pool != null) {
            this.thread_pool.shutdown();
        }
    }

    @Override
    public void init() throws Exception {
        super.init();
        DefaultThreadFactory f = new DefaultThreadFactory(this.getClass().getSimpleName() + ".Runner", true, true);
        this.thread_pool = new ThreadPoolExecutor(0, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), f);
    }

    @Override
    public synchronized void stop() {
        this.suspects.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        this.stopThreadPool();
        VERIFY_SUSPECT2 vERIFY_SUSPECT2 = this;
        synchronized (vERIFY_SUSPECT2) {
            this.running = false;
        }
        super.destroy();
    }

    private static long getCurrentTimeMillis() {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
    }

    public static class VerifyHeader
    extends Header {
        static final short ARE_YOU_DEAD = 1;
        static final short I_AM_NOT_DEAD = 2;
        short type = 1;
        Address from;

        public VerifyHeader() {
        }

        VerifyHeader(short type) {
            this.type = type;
        }

        VerifyHeader(short type, Address from) {
            this(type);
            this.from = from;
        }

        @Override
        public short getMagicId() {
            return 94;
        }

        @Override
        public Supplier<? extends Header> create() {
            return VerifyHeader::new;
        }

        @Override
        public String toString() {
            switch (this.type) {
                case 1: {
                    return "[ARE_YOU_DEAD]";
                }
                case 2: {
                    return "[I_AM_NOT_DEAD]";
                }
            }
            return "[unknown type (" + this.type + ")]";
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            out.writeShort(this.type);
            Util.writeAddress(this.from, out);
        }

        @Override
        public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
            this.type = in.readShort();
            this.from = Util.readAddress(in);
        }

        @Override
        public int serializedSize() {
            return 2 + Util.size(this.from);
        }
    }

    protected static class Entry
    implements Comparable<Entry> {
        protected final Address suspect;
        protected final long target_time;

        public Entry(Address suspect, long target_time) {
            this.suspect = suspect;
            this.target_time = target_time;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)obj;
            return Objects.equals(this.suspect, other.suspect);
        }

        public int hashCode() {
            return this.suspect.hashCode();
        }

        public String toString() {
            return String.format("%s (expires in %d ms)", this.suspect, this.expiry());
        }

        protected long expiry() {
            return this.target_time - VERIFY_SUSPECT2.getCurrentTimeMillis();
        }

        @Override
        public int compareTo(Entry o) {
            return this.suspect.compareTo(o.suspect);
        }
    }
}

