import { createSlice, PayloadAction } from '@reduxjs/toolkit';
import noop from 'lodash/noop';
import { RootState } from '../../../../../../../../../core/xlr-ui/app/js/store.types';
import { AnalyticsCardData } from '../types';
import { CustomConfiguration } from '../../../../../../../../../core/xlr-ui/app/types';
import { SupersetDetailsDashboardResponse } from './analytics.saga';

export interface CardSearch {
    authorNames?: string[];
    categories?: string[];
    name?: string;
}

export interface AnalyticsState {
    authors: string[];
    cardSearch?: CardSearch;
    cards: AnalyticsCardData[];
    categories: string[];
    intelligenceConfiguration?: CustomConfiguration;
    isAnalyticsConfigured: boolean;
    isDrawerOpened: boolean;
    isLoading: boolean;
    selectedDashboard?: SupersetDetailsDashboardResponse;
}

export const initialState: AnalyticsState = {
    authors: [],
    cards: [],
    categories: [],
    isAnalyticsConfigured: true, // set as true so banner doesn't blink
    isDrawerOpened: false,
    isLoading: true,
};

export const analytics = createSlice({
    name: 'analytics',
    initialState,
    reducers: {
        init: (_state, _action: PayloadAction<Partial<CardSearch> | undefined>) => noop(),
        filterCards: (_state, _action: PayloadAction<CardSearch>) => noop(),
        setCards: (state, action: PayloadAction<AnalyticsCardData[]>) => {
            state.cards = action.payload;
        },
        setCategories: (state, action: PayloadAction<string[]>) => {
            state.categories = action.payload;
        },
        setAuthors: (state, action: PayloadAction<string[]>) => {
            state.authors = action.payload;
        },
        setIsDrawerOpened: (state, action: PayloadAction<boolean>) => {
            state.isDrawerOpened = action.payload;
        },
        setIsAnalyticsConfigured: (state, action: PayloadAction<boolean>) => {
            state.isAnalyticsConfigured = action.payload;
        },
        setIntelligenceConfiguration: (state, action: PayloadAction<CustomConfiguration>) => {
            state.isAnalyticsConfigured = true;
            state.intelligenceConfiguration = action.payload;
        },
        setCardSearch: (state, action: PayloadAction<CardSearch | undefined>) => {
            state.cardSearch = action.payload;
        },
        setIsLoading: (state, action: PayloadAction<boolean>) => {
            state.isLoading = action.payload;
        },
        loadDashboard: (_state, _action: PayloadAction<number>) => noop(),
        setSelectedDashboard: (state, action: PayloadAction<SupersetDetailsDashboardResponse>) => {
            state.selectedDashboard = action.payload;
        },
        clearSelectedDashboard: (state) => {
            state.selectedDashboard = undefined;
        },
    },
});

export const getAnalyticsState = (state: RootState): AnalyticsState => state.analytics;
