import { AnalyticsCardData } from '../types';

export const INTELLIGENCE_URL = 'https://supersetbi-dev.intelligence-platform.digital.ai';

const imageSrc = 'static/@project.version@/include/analytics-dashboard/assets/test-illustration.svg';

export const ANALYTICS_CATEGORIES: string[] = ['DevOps COE', 'Engineering manager', 'Platform team', 'Release manager'];

export const ANALYTICS_AUTHORS: string[] = ['Digital.ai', 'Custom', 'Drago', 'Nikolina', 'Super long name'];

export const ANALYTICS_SAMPLE_CARDS: AnalyticsCardData[] = [
    {
        contentText:
            'Efficiently monitor team and application onboarding and maturation rates on the Digital.ai Release-orchestrated pipeline. Identify areas for improvement.',
        id: 1,
        imageSrc,
        subtitle: 'Digital.ai',
        tags: [ANALYTICS_CATEGORIES[0]],
        title: 'On-boarding Plan and Progress',
    },
    {
        contentText:
            'A performance Dashboard is a powerful tool used by businesses to monitor, analyze, and visualize various aspects of their sales operations. This dashboard typically provides real-time or periodic insights into the performance of a sales team or department.',
        id: 2,
        imageSrc,
        subtitle: 'Custom',
        tags: [ANALYTICS_CATEGORIES[0], ANALYTICS_CATEGORIES[3]],
        title: 'Release Overview',
    },
    {
        contentText:
            'Take a proactive approach to release management by swiftly addressing delays and efficiently handling gate tasks and dependencies. Gain valuable insights from an overview down to granular details within the release processes.',
        id: 3,
        imageSrc,
        subtitle: 'Digital.ai',
        tags: [ANALYTICS_CATEGORIES[3]],
        title: 'Release Late Task and Its Impact #1',
    },
    {
        contentText:
            "Unlock the potential of DORA Analytics to gain insights into your organization's DevOps practices within software development and delivery processes. Discover areas for improvement and drive meaningful change.",
        id: 4,
        imageSrc,
        subtitle: 'Digital.ai',
        tags: [ANALYTICS_CATEGORIES[1]],
        title: 'DORA Overview',
    },
    {
        contentText: 'Release Late Task and Its Impact #2 description',
        id: 5,
        imageSrc,
        subtitle: 'Digital.ai',
        tags: [ANALYTICS_CATEGORIES[3]],
        title: 'Release Late Task and Its Impact #2',
    },
    {
        contentText: 'Release Executive Overview description',
        id: 6,
        imageSrc,
        subtitle: 'Digital.ai',
        tags: [ANALYTICS_CATEGORIES[3]],
        title: 'Release Executive Overview',
    },
    {
        contentText: 'Release Task Open Work Analysis',
        id: 7,
        imageSrc,
        subtitle: 'Digital.ai',
        tags: [ANALYTICS_CATEGORIES[3]],
        title: 'Release Task Open Work Analysis',
    },
    {
        contentText: 'Release Dependency Dashboard #1 description',
        id: 8,
        imageSrc,
        subtitle: 'Digital.ai',
        tags: [ANALYTICS_CATEGORIES[3]],
        title: 'Release Dependency Dashboard #1',
    },
    {
        contentText: 'Release Dependency Dashboard #2 description',
        id: 9,
        imageSrc,
        subtitle: 'Digital.ai',
        tags: [ANALYTICS_CATEGORIES[3]],
        title: 'Release Dependency Dashboard #2',
    },
    {
        contentText:
            'Gain insights on team adoption of services and automation via Workflows. Identify what works best and manage your developer platform as a product.',
        id: 10,
        imageSrc,
        subtitle: 'Digital.ai',
        tags: [ANALYTICS_CATEGORIES[2]],
        title: 'Workflow Adoption and Usage Patterns',
    },
    {
        contentText: 'Custom Workflow Adoption and Usage Patterns description',
        id: 11,
        imageSrc,
        subtitle: 'Custom',
        tags: [ANALYTICS_CATEGORIES[2]],
        title: 'Workflow Adoption and Usage Patterns (1)',
    },
];
