import React from 'react';
import { DotButton, DotDialog, DotIconButton, DotMenu } from '@digital-ai/dot-components';

import { mountWithStoreAndTheme, preparePortalContainer, ReactWrapper } from '../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { AnalyticsDashboardPagePortal } from './analytics-dashboard-page.portal';
import { profile } from '../../../../../../../../../../core/xlr-ui/app/features/profile/ducks/profile.reducer';

const { toggleFavouriteDashboard } = profile.actions;

describe('AnalyticsDashboardPagePortal', () => {
    let wrapper: ReactWrapper;

    const defaultState = {
        profile: {
            favouriteDashboards: [],
        },
    };

    const dispatch = jest.fn();

    const mount = () => {
        wrapper = mountWithStoreAndTheme(<AnalyticsDashboardPagePortal dashboardId={1} />, dispatch, defaultState);
    };

    const getBackButton = () => wrapper.findWhere((node) => node.is(DotButton) && node.props()['data-testid'] === 'back-btn');
    const getFavouriteButton = () => wrapper.findWhere((node) => node.is(DotButton) && node.props()['data-testid'] === 'fav-btn');
    const getEditButton = () => wrapper.findWhere((node) => node.is(DotButton) && node.props()['data-testid'] === 'edit-btn');
    const getOptionsButton = () => wrapper.findWhere((node) => node.is(DotIconButton) && node.props()['data-testid'] === 'options-btn');
    const getDialog = () => wrapper.find(DotDialog);
    const getMenu = () => wrapper.find(DotMenu);

    beforeEach(() => {
        preparePortalContainer();
    });

    it('should render all buttons', () => {
        mount();
        const backButton = getBackButton();
        expect(backButton).toExist();
        expect(backButton).toIncludeText('Back');
        expect(backButton.props().type).toBe('text');
        const favouriteButton = getFavouriteButton();
        expect(favouriteButton).toExist();
        expect(favouriteButton).toIncludeText('Add to favourites');
        expect(favouriteButton.props().type).toBe('outlined');
        const editButton = getEditButton();
        expect(editButton).toExist();
        expect(editButton).toIncludeText('Edit dashboard');
        expect(editButton.props().type).toBe('outlined');
        const optionsButton = getOptionsButton();
        expect(optionsButton).toExist();
        expect(optionsButton.props().iconId).toBe('options');
    });

    it('should handle back button', () => {
        mount();
        getBackButton().invoke('onClick')();
        expect(window.location.href).toBe('http://localhost/#/analytics');
    });

    it('should handle favourite button', () => {
        mount();
        const favouriteButton = getFavouriteButton();
        expect(favouriteButton).toIncludeText('Add to favourites');
        favouriteButton.invoke('onClick')();
        expect(dispatch).toHaveBeenCalledWith(toggleFavouriteDashboard('1'));
    });

    it('should handle edit button', () => {
        mount();
        expect(getDialog().props().open).toBe(false);

        getEditButton().invoke('onClick')();
        expect(getDialog().props().open).toBe(true);
        expect(getDialog().props().title).toBe('Edit dashboard');

        getDialog().invoke('onSubmit')?.('' as never);
        expect(getDialog().props().open).toBe(false);
    });

    it('should open menu with options', () => {
        mount();
        expect(getDialog().props().open).toBe(false);
        expect(getMenu().props().open).toBe(false);
        getOptionsButton().find('button').simulate('click');
        expect(getMenu().props().open).toBe(true);
        expect(getMenu().props().menuItems.length).toBe(2);
        getMenu().invoke('onSelect')?.('' as never, '', 'export');
        expect(getDialog().props().title).toBe('Export');
    });
});
