import React from 'react';
import { DotProgress } from '@digital-ai/dot-components';

import { mountWithStoreAndTheme, ReactWrapper, preparePortalContainer } from '../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { AnalyticsDashboardPage, dashboardDivId } from './analytics-dashboard-page.component';
import { navigation } from '../../../../../../../../../../core/xlr-ui/app/features/main-navigation/ducks/navigation.reducer';
import { analytics } from '../../ducks/analytics.reducer';
import { AnalyticsDashboardPagePortal } from './analytics-dashboard-page.portal';

const { setMenuOpen } = navigation.actions;

const { loadDashboard, clearSelectedDashboard } = analytics.actions;

describe('AnalyticsDashboardPage', () => {
    let wrapper: ReactWrapper;
    const dispatch = jest.fn();
    const defaultState = {
        analytics: {
            selectedDashboard: undefined,
            intelligenceConfiguration: undefined,
        },
        navigation: {
            menuIsOpen: true,
        },
        profile: {
            favouriteDashboards: [],
        },
    };

    const prepareBody = () => {
        const portal = global.document.createElement('div');
        portal.setAttribute('id', dashboardDivId);
        const body = global.document.querySelector('body');
        body?.appendChild(portal);
    };

    const mount = (state = defaultState) => {
        wrapper = mountWithStoreAndTheme(<AnalyticsDashboardPage dashboardId={1} />, dispatch, state);
    };

    const getDotProgress = () => wrapper.find(DotProgress);
    const getPortal = () => wrapper.find(AnalyticsDashboardPagePortal);

    beforeEach(() => {
        preparePortalContainer();
        prepareBody();
    });

    it('should dispatch actions on init', () => {
        mount();
        expect(dispatch).toHaveBeenCalledWith(setMenuOpen(false));
        expect(dispatch).toHaveBeenCalledWith(loadDashboard(1));
    });

    it('should reopen the sidebar if it was open', () => {
        mount();
        dispatch.mockReset();
        wrapper.unmount();
        expect(dispatch).toHaveBeenCalledWith(setMenuOpen(true));
        expect(dispatch).toHaveBeenCalledWith(clearSelectedDashboard());
    });

    it('should not reopen the sidebar if it was closed', () => {
        mount({ ...defaultState, navigation: { menuIsOpen: false } });
        dispatch.mockReset();
        wrapper.unmount();
        expect(dispatch).not.toHaveBeenCalledWith(setMenuOpen(true));
        expect(dispatch).toHaveBeenCalledWith(clearSelectedDashboard());
    });

    it('should show loader if there is no dashboard loaded', () => {
        mount();
        const progress = getDotProgress();
        expect(progress).toExist();
        expect(progress.props().ariaLabel).toBe('Loading dashboard data');
        expect(progress.props().size).toBe(100);
    });

    // since the connection to intelligence is broken it throws an error breaking jest suite
    it.skip('should show the unique div if dashboard is loaded', async () => {
        mount({
            ...defaultState,
            analytics: { selectedDashboard: { uuid: 'someid' }, intelligenceConfiguration: {} },
        } as never);
        const progress = getDotProgress();
        expect(progress).not.toExist();
        expect(wrapper.find(`div#${dashboardDivId}`)).toExist();
        // we can't test the iframe since we can't connect from unit tests...
    });

    it('should include portal', () => {
        mount();
        const portal = getPortal();
        expect(portal).toExist();
        expect(portal.props().dashboardId).toBe(1);
    });
});
