import React from 'react';
import { DotIcon } from '@digital-ai/dot-components';

import './menu-item.component.less';

interface MenuItemProps {
    endIconId?: string;
    iconId?: string;
    label: string;
}

export const MenuItem = ({ endIconId, label, iconId }: MenuItemProps) => {
    return (
        <div className="menu-item-wrapper">
            {iconId && <DotIcon iconId={iconId} />}
            {label}
            {endIconId && <DotIcon iconId={endIconId} />}
        </div>
    );
};
