import React from 'react';
import { mount } from 'enzyme';
import { MenuItem } from './menu-item.component';
import { DotIcon } from '@digital-ai/dot-components';

describe('MenuItem', () => {
    it('should render label', () => {
        const wrapper = mount(<MenuItem label="Duplicate" />);
        expect(wrapper.exists()).toBeTruthy();
        expect(wrapper.contains('Duplicate')).toBeTruthy();
        expect(wrapper.find(`DotIcon`).exists()).toBeFalsy();
    });

    it('should render icon', () => {
        const wrapper = mount(<MenuItem iconId="duplicate" label="Duplicate" />);
        expect(wrapper.exists()).toBeTruthy();
        expect(wrapper.contains('Duplicate')).toBeTruthy();
        expect(wrapper.find(`DotIcon`).exists()).toBeTruthy();
        expect(wrapper.find(`DotIcon`).prop('iconId')).toBe('duplicate');
    });

    it('should render end icon', () => {
        const wrapper = mount(<MenuItem endIconId="open-new-tab" iconId="duplicate" label="Duplicate" />);
        const icons = wrapper.find(DotIcon);
        expect(icons.length).toBe(2);
        expect(icons.at(0).props().iconId).toBe('duplicate');
        expect(icons.at(1).props().iconId).toBe('open-new-tab');
    });
});
