/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.delta.SVNDeltaCombiner;
import org.tmatesoft.svn.core.internal.io.fs.CountingOutputStream;
import org.tmatesoft.svn.core.internal.io.fs.FSCopyInheritance;
import org.tmatesoft.svn.core.internal.io.fs.FSErrors;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSFile;
import org.tmatesoft.svn.core.internal.io.fs.FSInputStream;
import org.tmatesoft.svn.core.internal.io.fs.FSParentPath;
import org.tmatesoft.svn.core.internal.io.fs.FSPathChange;
import org.tmatesoft.svn.core.internal.io.fs.FSPathChangeKind;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryUtil;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.io.fs.index.FSL2PEntry;
import org.tmatesoft.svn.core.internal.io.fs.index.FSL2PProtoIndex;
import org.tmatesoft.svn.core.internal.io.fs.index.FSP2LEntry;
import org.tmatesoft.svn.core.internal.io.fs.index.FSP2LProtoIndex;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNSpillBuffer;
import org.tmatesoft.svn.core.internal.util.SVNSpillBufferInputStream;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNChecksumOutputStream;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.util.SVNLogType;

public abstract class FSRoot {
    private RevisionCache myRevNodesCache;
    private FSFS myFSFS;
    protected FSRevisionNode myRootRevisionNode;

    protected FSRoot(FSFS owner) {
        this.myFSFS = owner;
    }

    public FSFS getOwner() {
        return this.myFSFS;
    }

    public FSRevisionNode getRevisionNode(String path) throws SVNException {
        FSRevisionNode node = this.fetchRevNodeFromCache(path = SVNPathUtil.canonicalizeAbsolutePath(path));
        if (node == null) {
            FSParentPath parentPath = this.openPath(path, true, false);
            node = parentPath.getRevNode();
        }
        return node;
    }

    public abstract long getRevision();

    public abstract FSRevisionNode getRootRevisionNode() throws SVNException;

    public abstract Map getChangedPaths() throws SVNException;

    public abstract FSCopyInheritance getCopyInheritance(FSParentPath var1) throws SVNException;

    public FSParentPath openPath(String path, boolean lastEntryMustExist, boolean storeParents) throws SVNException {
        if (path == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "null path is not supported");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        String canonPath = SVNPathUtil.canonicalizeAbsolutePath(path);
        FSRevisionNode here = this.getRootRevisionNode();
        String pathSoFar = "/";
        FSParentPath parentPath = new FSParentPath(here, null, null);
        parentPath.setCopyStyle(1);
        String rest = canonPath.substring(1);
        while (true) {
            String entry = SVNPathUtil.head(rest);
            String next = SVNPathUtil.removeHead(rest);
            pathSoFar = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(pathSoFar, entry));
            FSRevisionNode child = null;
            if (entry == null || "".equals(entry)) {
                child = here;
            } else {
                FSCopyInheritance copyInheritance;
                FSRevisionNode cachedRevNode = this.fetchRevNodeFromCache(pathSoFar);
                if (cachedRevNode != null) {
                    child = cachedRevNode;
                } else {
                    try {
                        child = here.getChildDirNode(entry, this.getOwner());
                    }
                    catch (SVNException svne) {
                        if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.FS_NOT_FOUND) {
                            if (!lastEntryMustExist && (next == null || "".equals(next))) {
                                return new FSParentPath(null, entry, parentPath);
                            }
                            SVNErrorManager.error(FSErrors.errorNotFound(this, path), svne, SVNLogType.FSFS);
                        }
                        throw svne;
                    }
                }
                parentPath.setParentPath(child, entry, storeParents ? new FSParentPath(parentPath) : null);
                if (storeParents && (copyInheritance = this.getCopyInheritance(parentPath)) != null) {
                    parentPath.setCopyStyle(copyInheritance.getStyle());
                    parentPath.setCopySourcePath(copyInheritance.getCopySourcePath());
                }
                if (cachedRevNode == null) {
                    this.putRevNodeToCache(pathSoFar, child);
                }
            }
            if (next == null || "".equals(next)) break;
            if (child.getType() != SVNNodeKind.DIR) {
                SVNErrorMessage err = FSErrors.errorNotDirectory(pathSoFar, this.getOwner());
                SVNErrorManager.error(err.wrap("Failure opening ''{0}''", path), SVNLogType.FSFS);
            }
            rest = next;
            here = child;
        }
        return parentPath;
    }

    public SVNNodeKind checkNodeKind(String path) throws SVNException {
        FSRevisionNode revNode = null;
        try {
            revNode = this.getRevisionNode(path);
        }
        catch (SVNException svne) {
            if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.FS_NOT_FOUND || svne.getErrorMessage().getErrorCode() == SVNErrorCode.FS_NOT_DIRECTORY) {
                return SVNNodeKind.NONE;
            }
            throw svne;
        }
        return revNode.getType();
    }

    public void putRevNodeToCache(String path, FSRevisionNode node) throws SVNException {
        if (!path.startsWith("/")) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "Invalid path ''{0}''", (Object)path);
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        if (this.myRevNodesCache == null) {
            this.myRevNodesCache = new RevisionCache(100);
        }
        this.myRevNodesCache.put(path, node);
    }

    public void removeRevNodeFromCache(String path) throws SVNException {
        if (!path.startsWith("/")) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "Invalid path ''{0}''", (Object)path);
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        if (this.myRevNodesCache == null) {
            return;
        }
        this.myRevNodesCache.delete(path);
    }

    protected FSRevisionNode fetchRevNodeFromCache(String path) throws SVNException {
        if (this.myRevNodesCache == null) {
            return null;
        }
        if (!path.startsWith("/")) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "Invalid path ''{0}''", (Object)path);
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        return (FSRevisionNode)this.myRevNodesCache.fetch(path);
    }

    private void foldChange(Map mapChanges, FSPathChange change) throws SVNException {
        if (change == null) {
            return;
        }
        mapChanges = mapChanges != null ? mapChanges : new SVNHashMap();
        FSPathChange newChange = null;
        String copyfromPath = null;
        long copyfromRevision = -1L;
        FSPathChange oldChange = (FSPathChange)mapChanges.get(change.getPath());
        if (oldChange != null) {
            SVNErrorMessage err;
            copyfromPath = oldChange.getCopyPath();
            copyfromRevision = oldChange.getCopyRevision();
            if (change.getRevNodeId() == null && FSPathChangeKind.FS_PATH_CHANGE_RESET != change.getChangeKind()) {
                err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Missing required node revision ID");
                SVNErrorManager.error(err, SVNLogType.FSFS);
            }
            if (change.getRevNodeId() != null && !oldChange.getRevNodeId().equals(change.getRevNodeId()) && oldChange.getChangeKind() != FSPathChangeKind.FS_PATH_CHANGE_DELETE) {
                err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Invalid change ordering: new node revision ID without delete");
                SVNErrorManager.error(err, SVNLogType.FSFS);
            }
            if (FSPathChangeKind.FS_PATH_CHANGE_DELETE == oldChange.getChangeKind() && FSPathChangeKind.FS_PATH_CHANGE_REPLACE != change.getChangeKind() && FSPathChangeKind.FS_PATH_CHANGE_RESET != change.getChangeKind() && FSPathChangeKind.FS_PATH_CHANGE_ADD != change.getChangeKind()) {
                err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Invalid change ordering: non-add change on deleted path");
                SVNErrorManager.error(err, SVNLogType.FSFS);
            }
            if (FSPathChangeKind.FS_PATH_CHANGE_MODIFY == change.getChangeKind()) {
                if (change.isTextModified()) {
                    oldChange.setTextModified(true);
                }
                if (change.arePropertiesModified()) {
                    oldChange.setPropertiesModified(true);
                }
            } else if (FSPathChangeKind.FS_PATH_CHANGE_ADD == change.getChangeKind() || FSPathChangeKind.FS_PATH_CHANGE_REPLACE == change.getChangeKind()) {
                oldChange.setChangeKind(FSPathChangeKind.FS_PATH_CHANGE_REPLACE);
                oldChange.setRevNodeId(change.getRevNodeId());
                oldChange.setTextModified(change.isTextModified());
                oldChange.setPropertiesModified(change.arePropertiesModified());
                if (change.getCopyPath() != null) {
                    copyfromPath = change.getCopyPath();
                    copyfromRevision = change.getCopyRevision();
                }
            } else if (FSPathChangeKind.FS_PATH_CHANGE_DELETE == change.getChangeKind()) {
                if (FSPathChangeKind.FS_PATH_CHANGE_ADD == oldChange.getChangeKind()) {
                    oldChange = null;
                    mapChanges.remove(change.getPath());
                } else {
                    oldChange.setChangeKind(FSPathChangeKind.FS_PATH_CHANGE_DELETE);
                    oldChange.setPropertiesModified(change.arePropertiesModified());
                    oldChange.setTextModified(change.isTextModified());
                }
                copyfromPath = null;
                copyfromRevision = -1L;
            } else if (FSPathChangeKind.FS_PATH_CHANGE_RESET == change.getChangeKind()) {
                oldChange = null;
                copyfromPath = null;
                copyfromRevision = -1L;
                mapChanges.remove(change.getPath());
            }
            newChange = oldChange;
        } else {
            copyfromPath = change.getCopyPath();
            copyfromRevision = change.getCopyRevision();
            newChange = change;
        }
        if (newChange != null) {
            newChange.setCopyPath(copyfromPath);
            newChange.setCopyRevision(copyfromRevision);
            SVNNodeKind nodeKind = change.getKind();
            if (nodeKind != null && nodeKind != SVNNodeKind.UNKNOWN) {
                newChange.setNodeKind(nodeKind);
            }
            mapChanges.put(change.getPath(), newChange);
        }
    }

    protected Map fetchAllChanges(FSFile changesFile, boolean prefolded) throws SVNException {
        SVNHashMap changedPaths = new SVNHashMap();
        FSPathChange change = this.readChange(changesFile);
        while (change != null) {
            this.foldChange(changedPaths, change);
            if (!(FSPathChangeKind.FS_PATH_CHANGE_DELETE != change.getChangeKind() && FSPathChangeKind.FS_PATH_CHANGE_REPLACE != change.getChangeKind() || prefolded)) {
                Iterator curIter = changedPaths.keySet().iterator();
                while (curIter.hasNext()) {
                    String hashKeyPath = (String)curIter.next();
                    if (change.getPath().equals(hashKeyPath) || SVNPathUtil.getPathAsChild(change.getPath(), hashKeyPath) == null) continue;
                    curIter.remove();
                }
            }
            change = this.readChange(changesFile);
        }
        return changedPaths;
    }

    public Map detectChanged() throws SVNException {
        Map changes = this.getChangedPaths();
        if (changes.size() == 0) {
            return changes;
        }
        Iterator paths = changes.keySet().iterator();
        while (paths.hasNext()) {
            String changedPath = (String)paths.next();
            FSPathChange change = (FSPathChange)changes.get(changedPath);
            if (change.getChangeKind() != FSPathChangeKind.FS_PATH_CHANGE_RESET) continue;
            paths.remove();
        }
        return changes;
    }

    private FSPathChange readChange(FSFile raReader) throws SVNException {
        String changeLine = null;
        try {
            changeLine = raReader.readLine(4096);
        }
        catch (SVNException svne) {
            if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.STREAM_UNEXPECTED_EOF) {
                return null;
            }
            throw svne;
        }
        if (changeLine == null || changeLine.length() == 0) {
            return null;
        }
        String copyfromLine = raReader.readLine(4096);
        return FSPathChange.fromString(changeLine, copyfromLine);
    }

    public InputStream getFileStreamForPath(SVNDeltaCombiner combiner, String path) throws SVNException {
        FSRevisionNode fileNode = this.getRevisionNode(path);
        return FSInputStream.createDeltaStream(combiner, fileNode, this.getOwner());
    }

    public long getFileSize(String path) throws SVNException {
        FSRevisionNode fileNode = this.getRevisionNode(path);
        return fileNode.getFileLength();
    }

    public boolean isUseLogAddressing() {
        return this.getOwner().isUseLogAddressing();
    }

    public void writeIndexData(CountingOutputStream protoFile, long newRevision, String txnId) throws SVNException {
        long l2pOffset = protoFile.getPosition();
        String l2pChecksum = this.writeL2PIndex(protoFile, newRevision, txnId);
        long p2lOffset = protoFile.getPosition();
        String p2lChecksum = this.writeP2LIndex(protoFile, newRevision, txnId);
        StringBuilder footerBuilder = new StringBuilder();
        footerBuilder.append(l2pOffset);
        footerBuilder.append(' ');
        footerBuilder.append(l2pChecksum);
        footerBuilder.append(' ');
        footerBuilder.append(p2lOffset);
        footerBuilder.append(' ');
        footerBuilder.append(p2lChecksum);
        String footerString = footerBuilder.toString();
        try {
            byte[] footer = footerString.getBytes("UTF-8");
            protoFile.write(footer);
            protoFile.write(footer.length);
        }
        catch (IOException e) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e);
            SVNErrorManager.error(errorMessage, SVNLogType.FSFS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeL2PIndex(CountingOutputStream protoFile, long revision, String txnId) throws SVNException {
        block25: {
            SVNSpillBuffer spillBuffer = null;
            ArrayList<Long> pageCounts = new ArrayList<Long>(16);
            ArrayList<Long> pageSizes = new ArrayList<Long>(16);
            ArrayList<Integer> entryCounts = new ArrayList<Integer>(16);
            ArrayList<Long> entries = new ArrayList<Long>(16);
            byte[] buffer = new byte[10];
            long lastPageCount = 0L;
            long l2pPageSize = this.myFSFS.getL2PPageSize();
            if (l2pPageSize > Integer.MAX_VALUE) {
                SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_OVERFLOW, "L2P index page size  {0} exceeds current limit of 2G entries", (Object)String.valueOf(l2pPageSize));
                SVNErrorManager.error(errorMessage, SVNLogType.FSFS);
            }
            try (FSL2PProtoIndex index = null;){
                String pageSizesSize2;
                Object entry;
                index = FSL2PProtoIndex.open(this.myFSFS, txnId, false);
                assert (index != null);
                spillBuffer = new SVNSpillBuffer(65536, 0x1000000L);
                int entryIndex = 0;
                while (true) {
                    if ((entry = index.readEntry()) == null || entryIndex > 0 && ((FSL2PEntry)entry).getOffset() == 0L) {
                        int entryCount = 0;
                        for (int i = 0; i < entries.size(); i += entryCount) {
                            long lastBufferSize = spillBuffer.getSize();
                            entryCount = this.myFSFS.getL2PPageSize() < (long)(entries.size() - i) ? (int)this.myFSFS.getL2PPageSize() : entries.size() - i;
                            this.encodeL2PPage(buffer, entries, i, i + entryCount, spillBuffer);
                            entryCounts.add(entryCount);
                            pageSizes.add(spillBuffer.getSize() - lastBufferSize);
                        }
                        pageCounts.add((long)pageSizes.size() - lastPageCount);
                        lastPageCount = pageSizes.size();
                    } else {
                        if (((FSL2PEntry)entry).getItemIndex() > Integer.MAX_VALUE) {
                            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_OVERFLOW, "Item index %s too large in l2p proto index for revision %ld", String.valueOf(((FSL2PEntry)entry).getItemIndex()), revision + (long)pageCounts.size());
                            SVNErrorManager.error(errorMessage, SVNLogType.FSFS);
                        }
                        long idx = ((FSL2PEntry)entry).getItemIndex();
                        while (idx >= (long)entries.size()) {
                            entries.add(0L);
                        }
                        entries.set((int)idx, ((FSL2PEntry)entry).getOffset());
                    }
                    if (entry == null) break;
                    ++entryIndex;
                }
                SVNChecksumOutputStream checksumOutputStream = new SVNChecksumOutputStream(protoFile, "MD5", false);
                checksumOutputStream.write("L2P-INDEX\n".getBytes("UTF-8"));
                FSRoot.writeEncoded(checksumOutputStream, buffer, revision);
                FSRoot.writeEncoded(checksumOutputStream, buffer, this.myFSFS.getL2PPageSize());
                FSRoot.writeEncoded(checksumOutputStream, buffer, pageCounts.size());
                FSRoot.writeEncoded(checksumOutputStream, buffer, pageSizes.size());
                entry = pageCounts.iterator();
                while (entry.hasNext()) {
                    long pageCount = (Long)entry.next();
                    FSRoot.writeEncoded(checksumOutputStream, buffer, pageCount);
                }
                int pageSizesSize2 = pageSizes.size();
                for (int i = 0; i < pageSizesSize2; ++i) {
                    Long pageSize = (Long)pageSizes.get(i);
                    FSRoot.writeEncoded(checksumOutputStream, buffer, pageSize);
                    int entryCount = (Integer)entryCounts.get(i);
                    FSRoot.writeEncoded(checksumOutputStream, buffer, entryCount);
                }
                SVNSpillBufferInputStream inputStream = spillBuffer.createInputStream();
                try {
                    SVNTranslator.copy(inputStream, checksumOutputStream);
                    checksumOutputStream.flush();
                    checksumOutputStream.close();
                    pageSizesSize2 = checksumOutputStream.getDigest();
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            SVNFileUtil.closeFile(inputStream);
                            throw throwable;
                        }
                        catch (IOException e) {
                            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e);
                            SVNErrorManager.error(errorMessage, SVNLogType.FSFS);
                            if (spillBuffer != null) {
                                spillBuffer.close();
                            }
                            break block25;
                        }
                    }
                    catch (Throwable throwable2) {
                        if (spillBuffer != null) {
                            spillBuffer.close();
                        }
                        throw throwable2;
                    }
                }
                SVNFileUtil.closeFile(inputStream);
                if (spillBuffer != null) {
                    spillBuffer.close();
                }
                return pageSizesSize2;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeP2LIndex(CountingOutputStream protoFile, long revision, String txnId) throws SVNException {
        block23: {
            SVNSpillBuffer spillBuffer = null;
            spillBuffer = new SVNSpillBuffer(65536, 0x1000000L);
            byte[] buffer = new byte[10];
            try (FSP2LProtoIndex index = null;){
                String tableSize2;
                index = FSP2LProtoIndex.open(this.myFSFS, txnId, false);
                assert (index != null);
                long fileSize = 0L;
                long lastEntryEnd = 0L;
                long pageSize = this.myFSFS.getP2LPageSize();
                long lastRevision = revision;
                long lastCompound = 0L;
                long lastPageEnd = 0L;
                long lastBufferSize = 0L;
                boolean eof = false;
                ArrayList<Long> tableSizes = new ArrayList<Long>();
                do {
                    boolean newPage = spillBuffer.getSize() == 0L;
                    Object entry = index.readEntry();
                    if (entry == null) {
                        fileSize = lastEntryEnd;
                        long entryOffset = lastEntryEnd;
                        long entrySize = FSRepositoryUtil.align(entryOffset, pageSize) - entryOffset;
                        FSP2LProtoIndex.ItemType entryType = FSP2LProtoIndex.ItemType.UNUSED;
                        boolean entryChecksum = false;
                        long entryRevision = lastRevision;
                        long entryNumber = 0L;
                        entry = new FSP2LEntry(entryOffset, entrySize, entryType, 0, entryRevision, 0L);
                        eof = true;
                    } else if (((FSP2LEntry)entry).getRevision() == -1L) {
                        ((FSP2LEntry)entry).setRevision(revision);
                    }
                    long entryEnd = ((FSP2LEntry)entry).getOffset() + ((FSP2LEntry)entry).getSize();
                    while (entryEnd - lastPageEnd > pageSize) {
                        long bufferSize = spillBuffer.getSize();
                        tableSizes.add(bufferSize - lastBufferSize);
                        lastBufferSize = bufferSize;
                        lastPageEnd += pageSize;
                        newPage = true;
                    }
                    if (newPage) {
                        spillBuffer.write(buffer, 0, FSRepositoryUtil.encodeUnsignedInt(buffer, ((FSP2LEntry)entry).getOffset()));
                        lastRevision = revision;
                        lastCompound = 0L;
                    }
                    spillBuffer.write(buffer, 0, FSRepositoryUtil.encodeUnsignedInt(buffer, ((FSP2LEntry)entry).getSize()));
                    long revDiff = ((FSP2LEntry)entry).getRevision() - lastRevision;
                    lastRevision = ((FSP2LEntry)entry).getRevision();
                    long compound = ((FSP2LEntry)entry).getNumber() * 8L + (long)((FSP2LEntry)entry).getType().getCode();
                    long compoundDiff = compound - lastCompound;
                    lastCompound = compound;
                    spillBuffer.write(buffer, 0, FSRepositoryUtil.encodeInt(buffer, compoundDiff));
                    spillBuffer.write(buffer, 0, FSRepositoryUtil.encodeInt(buffer, revDiff));
                    spillBuffer.write(buffer, 0, FSRepositoryUtil.encodeUnsignedInt(buffer, ((FSP2LEntry)entry).getChecksum()));
                    lastEntryEnd = entryEnd;
                } while (!eof);
                tableSizes.add(spillBuffer.getSize() - lastBufferSize);
                SVNChecksumOutputStream checksumOutputStream = new SVNChecksumOutputStream(protoFile, "MD5", false);
                checksumOutputStream.write("P2L-INDEX\n".getBytes("UTF-8"));
                FSRoot.writeEncoded(checksumOutputStream, buffer, revision);
                FSRoot.writeEncoded(checksumOutputStream, buffer, fileSize);
                FSRoot.writeEncoded(checksumOutputStream, buffer, pageSize);
                FSRoot.writeEncoded(checksumOutputStream, buffer, tableSizes.size());
                for (Long tableSize2 : tableSizes) {
                    FSRoot.writeEncoded(checksumOutputStream, buffer, tableSize2);
                }
                SVNSpillBufferInputStream inputStream = spillBuffer.createInputStream();
                try {
                    SVNTranslator.copy(inputStream, checksumOutputStream);
                    checksumOutputStream.flush();
                    checksumOutputStream.close();
                    tableSize2 = checksumOutputStream.getDigest();
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            SVNFileUtil.closeFile(inputStream);
                            throw throwable;
                        }
                        catch (IOException e) {
                            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e);
                            SVNErrorManager.error(errorMessage, SVNLogType.FSFS);
                            if (spillBuffer != null) {
                                spillBuffer.close();
                            }
                            break block23;
                        }
                    }
                    catch (Throwable throwable2) {
                        if (spillBuffer != null) {
                            spillBuffer.close();
                        }
                        throw throwable2;
                    }
                }
                SVNFileUtil.closeFile(inputStream);
                if (spillBuffer != null) {
                    spillBuffer.close();
                }
                return tableSize2;
            }
        }
        return null;
    }

    private void encodeL2PPage(byte[] encoded, List<Long> entries, int start, int end, SVNSpillBuffer spillBuffer) throws SVNException {
        long lastValue = 0L;
        for (int i = start; i < end; ++i) {
            long diff = entries.get(i) - lastValue;
            lastValue = entries.get(i);
            int length = FSRepositoryUtil.encodeInt(encoded, diff);
            spillBuffer.write(encoded, 0, length);
        }
    }

    private static void writeEncoded(OutputStream outputStream, byte[] bytes, long value) throws IOException {
        int length = FSRepositoryUtil.encodeUnsignedInt(bytes, value);
        outputStream.write(bytes, 0, length);
    }

    private static final class RevisionCache {
        private LinkedList myKeys;
        private Map myCache;
        private int mySizeLimit;

        public RevisionCache(int limit) {
            this.mySizeLimit = limit;
            this.myKeys = new LinkedList();
            this.myCache = new TreeMap();
        }

        public void put(Object key, Object value) {
            if (this.mySizeLimit <= 0) {
                return;
            }
            if (this.myKeys.size() == this.mySizeLimit) {
                Object cachedKey = this.myKeys.removeLast();
                this.myCache.remove(cachedKey);
            }
            this.myKeys.addFirst(key);
            this.myCache.put(key, value);
        }

        public void delete(Object key) {
            this.myKeys.remove(key);
            this.myCache.remove(key);
        }

        public Object fetch(Object key) {
            int ind = this.myKeys.indexOf(key);
            if (ind != -1) {
                if (ind != 0) {
                    Object cachedKey = this.myKeys.remove(ind);
                    this.myKeys.addFirst(cachedKey);
                }
                return this.myCache.get(key);
            }
            return null;
        }
    }
}

