/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.applications.management.service;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.api.internal.views.ExternalDeploymentOrderDirection;
import com.xebialabs.xlrelease.api.internal.views.ExternalDeploymentOrderMode;
import com.xebialabs.xlrelease.applications.management.repository.persistence.ApplicationsManagementPersistence;
import com.xebialabs.xlrelease.applications.management.service.ApplicationsManagement;
import com.xebialabs.xlrelease.applications.management.service.ApplicationsManagementService;
import com.xebialabs.xlrelease.applications.management.service.ManagedApplication;
import com.xebialabs.xlrelease.applications.management.service.ManagedApplicationData;
import com.xebialabs.xlrelease.applications.management.service.ManagedApplicationFromExternalDeployment;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.status.service.ConnectionServerData;
import com.xebialabs.xlrelease.status.service.EndpointExternalDeployment;
import com.xebialabs.xlrelease.status.service.EndpointExternalDeploymentService;
import com.xebialabs.xlrelease.status.webhook.configuration.StatusHttpConnection;
import com.xebialabs.xlrelease.status.webhook.events.StatusWebhookEventSource;
import com.xebialabs.xlrelease.status.webhook.events.UpdateStatusEvent;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Date;
import org.slf4j.Marker;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005uc\u0001B\b\u0011\u0001uA\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\to\u0001\u0011\t\u0011)A\u0005q!Aq\b\u0001B\u0001B\u0003%\u0001\tC\u0003H\u0001\u0011\u0005\u0001\nC\u0003N\u0001\u0011\u0005c\nC\u0003n\u0001\u0011\u0005c\u000eC\u0003u\u0001\u0011%Q\u000fC\u0003{\u0001\u0011\u00053\u0010C\u0003\u007f\u0001\u0011\u0005s\u0010C\u0004\u0002\u0004\u0001!\t%!\u0002\t\u000f\u0005=\u0001\u0001\"\u0003\u0002\u0012!9\u0011Q\u0003\u0001\u0005\n\u0005]\u0001bBA\u000e\u0001\u0011\u0005\u0013Q\u0004\u0005\b\u0003K\u0001A\u0011BA\u0014\u0005\u0001\n\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8NC:\fw-Z7f]R\u001cVM\u001d<jG\u0016LU\u000e\u001d7\u000b\u0005E\u0011\u0012aB:feZL7-\u001a\u0006\u0003'Q\t!\"\\1oC\u001e,W.\u001a8u\u0015\t)b#\u0001\u0007baBd\u0017nY1uS>t7O\u0003\u0002\u00181\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u00033i\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003m\t1aY8n\u0007\u0001\u0019B\u0001\u0001\u0010%QA\u0011qDI\u0007\u0002A)\t\u0011%A\u0003tG\u0006d\u0017-\u0003\u0002$A\t1\u0011I\\=SK\u001a\u0004\"!\n\u0014\u000e\u0003AI!a\n\t\u0003;\u0005\u0003\b\u000f\\5dCRLwN\\:NC:\fw-Z7f]R\u001cVM\u001d<jG\u0016\u0004\"!\u000b\u0018\u000e\u0003)R!a\u000b\u0017\u0002\u000bMdg\r\u000e6\u000b\u00035\n\u0001b\u001a:jujdW\rZ\u0005\u0003_)\u0012q\u0001T8hO&tw-A\fd_:4\u0017nZ;sCRLwN\u001c*fa>\u001c\u0018\u000e^8ssB\u0011!'N\u0007\u0002g)\u0011AGF\u0001\u000be\u0016\u0004xn]5u_JL\u0018B\u0001\u001c4\u0005]\u0019uN\u001c4jOV\u0014\u0018\r^5p]J+\u0007o\\:ji>\u0014\u00180A\u0011baBd\u0017nY1uS>t7/T1oC\u001e,W.\u001a8u!\u0016\u00148/[:uK:\u001cW\r\u0005\u0002:{5\t!H\u0003\u0002<y\u0005Y\u0001/\u001a:tSN$XM\\2f\u0015\t!$#\u0003\u0002?u\t\t\u0013\t\u001d9mS\u000e\fG/[8og6\u000bg.Y4f[\u0016tG\u000fU3sg&\u001cH/\u001a8dK\u0006IR\r\u001f;fe:\fG\u000eR3qY>LX.\u001a8u'\u0016\u0014h/[2f!\t\tU)D\u0001C\u0015\t\t2I\u0003\u0002E-\u000511\u000f^1ukNL!A\u0012\"\u0003C\u0015sG\r]8j]R,\u0005\u0010^3s]\u0006dG)\u001a9m_flWM\u001c;TKJ4\u0018nY3\u0002\rqJg.\u001b;?)\u0011I%j\u0013'\u0011\u0005\u0015\u0002\u0001\"\u0002\u0019\u0005\u0001\u0004\t\u0004\"B\u001c\u0005\u0001\u0004A\u0004\"B \u0005\u0001\u0004\u0001\u0015AF4fi6\u000bg.Y4fI\u0006\u0003\b\u000f\\5dCRLwN\\:\u0015\u000b=\u0013v,[6\u0011\u0005\u0015\u0002\u0016BA)\u0011\u0005Y\t\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8t\u001b\u0006t\u0017mZ3nK:$\b\"B*\u0006\u0001\u0004!\u0016\u0001\u00034pY\u0012,'/\u00133\u0011\u0005UcfB\u0001,[!\t9\u0006%D\u0001Y\u0015\tIF$\u0001\u0004=e>|GOP\u0005\u00037\u0002\na\u0001\u0015:fI\u00164\u0017BA/_\u0005\u0019\u0019FO]5oO*\u00111\f\t\u0005\u0006A\u0016\u0001\r!Y\u0001\u0005a\u0006<W\r\u0005\u0002cO6\t1M\u0003\u0002eK\u0006!A.\u00198h\u0015\u00051\u0017\u0001\u00026bm\u0006L!\u0001[2\u0003\t1{gn\u001a\u0005\u0006U\u0016\u0001\r!Y\u0001\u000fe\u0016\u001cX\u000f\u001c;t!\u0016\u0014\b+Y4f\u0011\u001daW\u0001%AA\u0002Q\u000b\u0011bY8oI&$\u0018n\u001c8\u0002+\u001d,G/T1oC\u001e,G-\u00119qY&\u001c\u0017\r^5p]R\u0011qN\u001d\t\u0003KAL!!\u001d\t\u0003-5\u000bg.Y4fI\u0006\u0003\b\u000f\\5dCRLwN\u001c#bi\u0006DQa\u001d\u0004A\u0002Q\u000bA#\\1oC\u001e,G-\u00119qY&\u001c\u0017\r^5p]&#\u0017a\u00064fi\u000eDW*\u00198bO\u0016$\u0017\t\u001d9mS\u000e\fG/[8o)\t1\u0018\u0010\u0005\u0002&o&\u0011\u0001\u0010\u0005\u0002\u0013\u001b\u0006t\u0017mZ3e\u0003B\u0004H.[2bi&|g\u000eC\u0003t\u000f\u0001\u0007A+A\u000bbI\u0012l\u0015M\\1hK\u0012\f\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8\u0015\u0005=d\b\"B?\t\u0001\u00041\u0018AE7b]\u0006<W\rZ!qa2L7-\u0019;j_:\f\u0001$\u001e9eCR,W*\u00198bO\u0016$\u0017\t\u001d9mS\u000e\fG/[8o)\ry\u0017\u0011\u0001\u0005\u0006{&\u0001\rA^\u0001\u0019I\u0016dW\r^3NC:\fw-\u001a3BaBd\u0017nY1uS>tG\u0003BA\u0004\u0003\u001b\u00012aHA\u0005\u0013\r\tY\u0001\t\u0002\u0005+:LG\u000fC\u0003t\u0015\u0001\u0007A+\u0001\u000ewC2LG-\u0019;f\u001b\u0006t\u0017mZ3e\u0003B\u0004H.[2bi&|g\u000e\u0006\u0003\u0002\b\u0005M\u0001\"B?\f\u0001\u00041\u0018AK7b]\u0006<W\rZ!qa2L7-\u0019;j_:$v.T1oC\u001e,G-\u00119qY&\u001c\u0017\r^5p]\u0012\u000bG/\u0019\u000b\u0004_\u0006e\u0001\"B?\r\u0001\u00041\u0018AK2sK\u0006$X-T1oC\u001e,G-\u00119qY&\u001c\u0017\r^5p]N4%o\\7XK\nDwn\\6T_V\u00148-\u001a\u000b\u0007\u0003\u000f\ty\"a\t\t\r\u0005\u0005R\u00021\u0001U\u0003=9XM\u00195p_.\u001cv.\u001e:dK&#\u0007\"B*\u000e\u0001\u0004!\u0016aF4fi\u0006\u0003\b\u000f\\5dCRLwN\u001c*fM\u0016\u0014XM\\2f)\u0015!\u0016\u0011FA\u001f\u0011\u001d\tYC\u0004a\u0001\u0003[\tQ!\u001a<f]R\u0004B!a\f\u0002:5\u0011\u0011\u0011\u0007\u0006\u0005\u0003g\t)$\u0001\u0004fm\u0016tGo\u001d\u0006\u0004\u0003o\u0019\u0015aB<fE\"|wn[\u0005\u0005\u0003w\t\tDA\tVa\u0012\fG/Z*uCR,8/\u0012<f]RDq!a\u0010\u000f\u0001\u0004\t\t%\u0001\u0006d_:tWm\u0019;j_:\u0004B!a\f\u0002D%!\u0011QIA\u0019\u0005a\u0019F/\u0019;vg^+'\r[8pW\u00163XM\u001c;T_V\u00148-\u001a\u0015\u0004\u0001\u0005%\u0003\u0003BA&\u00033j!!!\u0014\u000b\t\u0005=\u0013\u0011K\u0001\u000bgR,'/Z8usB,'\u0002BA*\u0003+\nqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0003\u0003/\n1a\u001c:h\u0013\u0011\tY&!\u0014\u0003\u000fM+'O^5dK\u0002")
public class ApplicationManagementServiceImpl
implements ApplicationsManagementService,
Logging {
    private final ConfigurationRepository configurationRepository;
    private final ApplicationsManagementPersistence applicationsManagementPersistence;
    private final EndpointExternalDeploymentService externalDeploymentService;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public String getManagedApplications$default$4() {
        return ApplicationsManagementService.getManagedApplications$default$4$(this);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ApplicationManagementServiceImpl applicationManagementServiceImpl = this;
        synchronized (applicationManagementServiceImpl) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public ApplicationsManagement getManagedApplications(String folderId, Long page, Long resultsPerPage, String condition) {
        int totalCount = this.applicationsManagementPersistence.countForFolder(folderId);
        int count = this.applicationsManagementPersistence.countForFolderWithCondition(folderId, condition);
        Vector managedApplications = (Vector)this.applicationsManagementPersistence.findForFolder(folderId, Predef$.MODULE$.Long2long(resultsPerPage), Predef$.MODULE$.Long2long(resultsPerPage) * Predef$.MODULE$.Long2long(page), condition).map((Function1 & Serializable)ma -> this.managedApplicationToManagedApplicationData((ManagedApplication)ma));
        return new ApplicationsManagement(totalCount, count, (Vector<ManagedApplicationData>)managedApplications);
    }

    @Override
    public ManagedApplicationData getManagedApplication(String managedApplicationId) {
        return this.managedApplicationToManagedApplicationData(this.fetchManagedApplication(managedApplicationId));
    }

    private ManagedApplication fetchManagedApplication(String managedApplicationId) {
        return (ManagedApplication)this.applicationsManagementPersistence.findById(managedApplicationId).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Managed Application with id [" + managedApplicationId + "] not found", new Object[0]);
        });
    }

    @Override
    public ManagedApplicationData addManagedApplication(ManagedApplication managedApplication) {
        String managedApplicationId = this.applicationsManagementPersistence.create(managedApplication);
        ManagedApplication created = this.fetchManagedApplication(managedApplicationId);
        return this.managedApplicationToManagedApplicationData(created);
    }

    @Override
    public ManagedApplicationData updateManagedApplication(ManagedApplication managedApplication) {
        Checks.checkArgument((boolean)StringUtils.hasText((String)managedApplication.id()), (String)"ID is required", (Object[])new Object[0]);
        this.validateManagedApplication(managedApplication);
        this.applicationsManagementPersistence.update(managedApplication);
        return this.managedApplicationToManagedApplicationData(managedApplication);
    }

    @Override
    public void deleteManagedApplication(String managedApplicationId) {
        Checks.checkArgument((boolean)StringUtils.hasText((String)managedApplicationId), (String)"ID is required", (Object[])new Object[0]);
        this.applicationsManagementPersistence.delete(managedApplicationId);
    }

    private void validateManagedApplication(ManagedApplication managedApplication) {
        Checks.checkArgument((boolean)StringUtils.hasText((String)managedApplication.applicationName()), (String)"Application name cannot be blank", (Object[])new Object[0]);
        Checks.checkArgument((boolean)Option$.MODULE$.apply((Object)managedApplication.connectionServer()).isDefined(), (String)"Connection server must be defined", (Object[])new Object[0]);
    }

    private ManagedApplicationData managedApplicationToManagedApplicationData(ManagedApplication managedApplication) {
        StatusHttpConnection connection = (StatusHttpConnection)this.configurationRepository.read(managedApplication.connectionServer());
        return new ManagedApplicationData(managedApplication.id(), managedApplication.applicationName(), managedApplication.managedBy(), managedApplication.dateCreated(), managedApplication.environmentTag(), managedApplication.applicationReference(), new ConnectionServerData(connection.getId(), connection.getTitle(), connection.getType().toString(), connection.getUrl(), (Option<String>)None$.MODULE$), managedApplication.workflowId(), managedApplication.deleteWorkflowId(), managedApplication.updateWorkflowId(), managedApplication.folderId());
    }

    @Override
    public void createManagedApplicationsFromWebhookSource(String webhookSourceId, String folderId) {
        StatusWebhookEventSource connection = (StatusWebhookEventSource)this.configurationRepository.read(webhookSourceId);
        EndpointExternalDeployment externalDeployment = this.externalDeploymentService.getExternalDeployment((Vector<String>)((Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{webhookSourceId}))), 0L, Predef$.MODULE$.long2Long(0L), Predef$.MODULE$.long2Long(0L), ExternalDeploymentOrderMode.APPLICATION, ExternalDeploymentOrderDirection.ASC, this.externalDeploymentService.getExternalDeployment$default$7());
        ((IterableOps)externalDeployment.states().map((Function1 & Serializable)state -> new ManagedApplicationFromExternalDeployment(state.event().applicationName(), this.getApplicationReference(state.event(), connection)))).groupBy((Function1 & Serializable)x$1 -> x$1.applicationReference()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String ref = (String)tuple2._1();
                Vector apps = (Vector)tuple2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ref), apps.head());
            }
            throw new MatchError((Object)tuple2);
        }).foreach((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                ManagedApplicationFromExternalDeployment application = (ManagedApplicationFromExternalDeployment)tuple2._2();
                if (!$this.applicationsManagementPersistence.existsByApplicationReferenceAndFolderId(application.applicationReference(), folderId)) {
                    return this.addManagedApplication(new ManagedApplication(null, application.applicationName(), "DISCOVERED BY RELEASE", new Date(), "N/A", application.applicationReference(), connection.getSourceServer().getId(), null, null, null, folderId));
                }
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private String getApplicationReference(UpdateStatusEvent event, StatusWebhookEventSource connection) {
        return event.applicationName() + ":" + connection.sourceServer().getId() + ":[" + event.destination() + "]";
    }

    public ApplicationManagementServiceImpl(ConfigurationRepository configurationRepository, ApplicationsManagementPersistence applicationsManagementPersistence, EndpointExternalDeploymentService externalDeploymentService) {
        this.configurationRepository = configurationRepository;
        this.applicationsManagementPersistence = applicationsManagementPersistence;
        this.externalDeploymentService = externalDeploymentService;
        Logging.$init$((Logging)this);
    }
}

