/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scm.connector;

import com.xebialabs.xlrelease.domain.UserProfile;
import com.xebialabs.xlrelease.domain.scm.connector.BitBucketCloudScmConnectorConfig;
import com.xebialabs.xlrelease.scm.connector.BitBucketTag;
import com.xebialabs.xlrelease.scm.connector.HttpClientRequest;
import com.xebialabs.xlrelease.scm.connector.HttpClientRequest$;
import com.xebialabs.xlrelease.scm.connector.RestApiScmConnector;
import com.xebialabs.xlrelease.scm.connector.ScmBlobs;
import com.xebialabs.xlrelease.scm.connector.ScmHttpClientWrapper;
import com.xebialabs.xlrelease.scm.data.GitTag;
import com.xebialabs.xlrelease.scm.data.ValidatedCommitInfo;
import java.io.Serializable;
import java.nio.file.Paths;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ea\u0001\u0002\u0006\f\u0001YA\u0001b\u0007\u0001\u0003\u0002\u0003\u0006I\u0001\b\u0005\u0006I\u0001!\t!\n\u0005\u0006Q\u0001!\t&\u000b\u0005\u0006m\u0001!\tf\u000e\u0005\u0006/\u0002!\t\u0006\u0017\u0005\u0006?\u0002!I\u0001\u0019\u0005\u0006I\u0002!I!\u001a\u0005\u0006y\u0002!I! \u0005\b\u0003\u0003\u0001A\u0011BA\u0002\u0005i\u0011\u0015\u000e\u001e\"vG.,Go\u00117pk\u0012\u001c6-\\\"p]:,7\r^8s\u0015\taQ\"A\u0005d_:tWm\u0019;pe*\u0011abD\u0001\u0004g\u000el'B\u0001\t\u0012\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\u0013'\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002)\u0005\u00191m\\7\u0004\u0001M\u0011\u0001a\u0006\t\u00031ei\u0011aC\u0005\u00035-\u00111CU3ti\u0006\u0003\u0018nU2n\u0007>tg.Z2u_J\faaY8oM&<\u0007CA\u000f#\u001b\u0005q\"B\u0001\u0007 \u0015\tq\u0001E\u0003\u0002\"\u001f\u00051Am\\7bS:L!a\t\u0010\u0003A\tKGOQ;dW\u0016$8\t\\8vIN\u001bWnQ8o]\u0016\u001cGo\u001c:D_:4\u0017nZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u0019:\u0003C\u0001\r\u0001\u0011\u0015Y\"\u00011\u0001\u001d\u00039!Xm\u001d;SKB|7/\u001b;pef,\u0012A\u000b\t\u0004WA\u0012T\"\u0001\u0017\u000b\u00055r\u0013\u0001B;uS2T\u0011aL\u0001\u0006g\u000e\fG.Y\u0005\u0003c1\u00121\u0001\u0016:z!\t\u0019D'D\u0001/\u0013\t)dF\u0001\u0003V]&$\u0018\u0001D2p[6LG/\u00118e)\u0006<G\u0003\u0002\u001dE\u0013F\u00032a\u000b\u0019:!\tQ\u0014I\u0004\u0002<\u007fA\u0011AHL\u0007\u0002{)\u0011a(F\u0001\u0007yI|w\u000e\u001e \n\u0005\u0001s\u0013A\u0002)sK\u0012,g-\u0003\u0002C\u0007\n11\u000b\u001e:j]\u001eT!\u0001\u0011\u0018\t\u000b\u0015#\u0001\u0019\u0001$\u0002\u000b\tdwNY:\u0011\u0005a9\u0015B\u0001%\f\u0005!\u00196-\u001c\"m_\n\u001c\b\"\u0002&\u0005\u0001\u0004Y\u0015AC2p[6LG/\u00138g_B\u0011AjT\u0007\u0002\u001b*\u0011a*D\u0001\u0005I\u0006$\u0018-\u0003\u0002Q\u001b\n\u0019b+\u00197jI\u0006$X\rZ\"p[6LG/\u00138g_\")!\u000b\u0002a\u0001'\u0006!Qo]3s!\t!V+D\u0001!\u0013\t1\u0006EA\u0006Vg\u0016\u0014\bK]8gS2,\u0017!\u0004;bO:{G\u000f\u0015:fg\u0016tG\u000f\u0006\u0002Z;B\u00191\u0006\r.\u0011\u0005MZ\u0016B\u0001//\u0005\u001d\u0011un\u001c7fC:DQAX\u0003A\u0002e\n1\u0001^1h\u0003A\u0011\u0017\u000e\u001e\"vG.,GOU3rk\u0016\u001cH/F\u0001b!\tA\"-\u0003\u0002d\u0017\t!2kY7IiR\u00048\t\\5f]R<&/\u00199qKJ\fqBY5uEV\u001c7.\u001a;D_6l\u0017\u000e\u001e\u000b\u0004MfT\bcA\u00161OB\u0019\u0001n\\9\u000e\u0003%T!A[6\u0002\t!$H\u000f\u001d\u0006\u0003Y6\fqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002]\u0006\u0019qN]4\n\u0005AL'A\u0004*fgB|gn]3F]RLG/\u001f\t\u0003e^l\u0011a\u001d\u0006\u0003iV\fA\u0001\\1oO*\ta/\u0001\u0003kCZ\f\u0017B\u0001=t\u0005\u00111v.\u001b3\t\u000b\u0015;\u0001\u0019\u0001$\t\u000bm<\u0001\u0019A\u001d\u0002\u000f5,7o]1hK\u0006aq-\u001a;D_6l\u0017\u000e^*iCR\u0011\u0001H \u0005\u0006\u007f\"\u0001\raZ\u0001\te\u0016\u001c\bo\u001c8tK\u0006I1M]3bi\u0016$\u0016m\u001a\u000b\u0006M\u0006\u0015\u0011Q\u0002\u0005\u0007=&\u0001\r!a\u0002\u0011\u00071\u000bI!C\u0002\u0002\f5\u0013aaR5u)\u0006<\u0007BBA\b\u0013\u0001\u0007\u0011(A\u0005d_6l\u0017\u000e^*iC\u0002")
public class BitBucketCloudScmConnector
extends RestApiScmConnector {
    private final BitBucketCloudScmConnectorConfig config;

    @Override
    public Try<BoxedUnit> testRepository() {
        return this.bitBucketRequest().get("/repositories/" + this.config.repository() + "/refs").doRequest(ClassTag$.MODULE$.apply(Void.class)).flatMap((Function1 & Serializable)x$1 -> HttpClientRequest$.MODULE$.ResponseEntityExtension(x$1).tried()).map((Function1 & Serializable)x$2 -> {
            BitBucketCloudScmConnector.$anonfun$testRepository$2(x$2);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Try<String> commitAndTag(ScmBlobs blobs, ValidatedCommitInfo commitInfo, UserProfile user) {
        return this.bitbucketCommit(blobs, commitInfo.message()).flatMap((Function1 & Serializable)gitCommitResponse -> this.getCommitSha((ResponseEntity<Void>)gitCommitResponse).flatMap((Function1 & Serializable)commitSha -> this.createTag(commitInfo.tag(), (String)commitSha).map((Function1 & Serializable)x$3 -> {
            ResponseEntity responseEntity = x$3;
            return commitSha;
        })));
    }

    @Override
    public Try<Object> tagNotPresent(String tag) {
        return this.bitBucketRequest().get("/repositories/" + this.config.repository() + "/refs/tags/" + tag).doRequest(ClassTag$.MODULE$.apply(Void.class)).map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)BitBucketCloudScmConnector.$anonfun$tagNotPresent$1(x$4)));
    }

    private ScmHttpClientWrapper bitBucketRequest() {
        return HttpClientRequest$.MODULE$.newRequest(this.config.restApiUrl()).setUriEncoded(false).withAuth(this.config.credential());
    }

    private Try<ResponseEntity<Void>> bitbucketCommit(ScmBlobs blobs, String message) {
        ScmHttpClientWrapper requestBuilder = this.bitBucketRequest().setType(new HttpClientRequest.MULTIPART_BODY_FORM()).addFormData("branch", this.config.branch()).addFormData("message", message);
        blobs.filesToAdd().foreach((Function1 & Serializable)file -> requestBuilder.addFile(file.fileName(), ((Object)Paths.get(file.fileName(), new String[0]).getFileName()).toString(), file.getContent()));
        String string = "/repositories/" + this.config.repository() + "/src";
        requestBuilder.post$default$2();
        return requestBuilder.post(string, null).doRequest(ClassTag$.MODULE$.apply(Void.class)).flatMap((Function1 & Serializable)x$5 -> HttpClientRequest$.MODULE$.ResponseEntityExtension(x$5).checkResponse("Error occurred while trying to commit on BitBucket"));
    }

    private Try<String> getCommitSha(ResponseEntity<Void> response) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> (String)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])((String)response.getHeaders().toSingleValueMap().get("Location")).split("/"))));
    }

    private Try<ResponseEntity<Void>> createTag(GitTag tag, String commitSha) {
        BitBucketTag requestBody = new BitBucketTag(tag.refName());
        requestBody.target().hash_$eq(commitSha);
        return this.bitBucketRequest().post("/repositories/" + this.config.repository() + "/refs/tags", requestBody).doRequest(ClassTag$.MODULE$.apply(Void.class)).flatMap((Function1 & Serializable)x$6 -> HttpClientRequest$.MODULE$.ResponseEntityExtension(x$6).checkResponse("Error occurred while trying to create tag"));
    }

    public static final /* synthetic */ void $anonfun$testRepository$2(Void x$2) {
    }

    public static final /* synthetic */ boolean $anonfun$tagNotPresent$1(ResponseEntity x$4) {
        HttpStatusCode httpStatusCode = x$4.getStatusCode();
        HttpStatus httpStatus = HttpStatus.NOT_FOUND;
        return !(httpStatusCode != null ? !httpStatusCode.equals(httpStatus) : httpStatus != null);
    }

    public BitBucketCloudScmConnector(BitBucketCloudScmConnectorConfig config) {
        this.config = config;
        super(config);
    }
}

