/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.kerberos.authentication.sun;

import com.sun.security.jgss.GSSUtil;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.HashSet;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.kerberos.authentication.JaasSubjectHolder;
import org.springframework.security.kerberos.authentication.KerberosTicketValidation;
import org.springframework.security.kerberos.authentication.KerberosTicketValidator;
import org.springframework.security.kerberos.authentication.sun.JaasUtil;
import org.springframework.util.Assert;

public class SunJaasKerberosTicketValidator
implements KerberosTicketValidator,
InitializingBean {
    private String servicePrincipal;
    private String realmName;
    private Resource keyTabLocation;
    private Subject serviceSubject;
    private boolean holdOnToGSSContext;
    private boolean debug = false;
    private boolean multiTier = false;
    private boolean refreshKrb5Config = false;
    private static final Log LOG = LogFactory.getLog(SunJaasKerberosTicketValidator.class);

    @Override
    public KerberosTicketValidation validateTicket(byte[] token) {
        try {
            if (!this.multiTier) {
                return Subject.doAs(this.serviceSubject, new KerberosValidateAction(token));
            }
            Subject subjectCopy = JaasUtil.copySubject(this.serviceSubject);
            JaasSubjectHolder subjectHolder = new JaasSubjectHolder(subjectCopy);
            return Subject.doAs(subjectHolder.getJaasSubject(), new KerberosMultitierValidateAction(token));
        }
        catch (PrivilegedActionException e) {
            throw new BadCredentialsException("Kerberos validation not successful", (Throwable)e);
        }
    }

    public void afterPropertiesSet() throws Exception {
        String keyTabLocationAsString;
        Assert.notNull((Object)this.servicePrincipal, (String)"servicePrincipal must be specified");
        Assert.notNull((Object)this.keyTabLocation, (String)"keyTab must be specified");
        if (this.keyTabLocation instanceof ClassPathResource) {
            LOG.warn((Object)"Your keytab is in the classpath. This file needs special protection and shouldn't be in the classpath. JAAS may also not be able to load this file from classpath.");
        }
        if ((keyTabLocationAsString = this.keyTabLocation.getURL().toExternalForm()).startsWith("file:")) {
            keyTabLocationAsString = keyTabLocationAsString.substring(5);
        }
        LoginConfig loginConfig = new LoginConfig(keyTabLocationAsString, this.servicePrincipal, this.realmName, this.multiTier, this.debug, this.refreshKrb5Config);
        HashSet<KerberosPrincipal> princ = new HashSet<KerberosPrincipal>(1);
        princ.add(new KerberosPrincipal(this.servicePrincipal));
        Subject sub = new Subject(false, princ, new HashSet(), new HashSet());
        LoginContext lc = new LoginContext("", sub, null, loginConfig);
        lc.login();
        this.serviceSubject = lc.getSubject();
    }

    public void setServicePrincipal(String servicePrincipal) {
        this.servicePrincipal = servicePrincipal;
    }

    public void setRealmName(String realmName) {
        this.realmName = realmName;
    }

    public void setMultiTier(boolean multiTier) {
        this.multiTier = multiTier;
    }

    public void setKeyTabLocation(Resource keyTabLocation) {
        this.keyTabLocation = keyTabLocation;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setHoldOnToGSSContext(boolean holdOnToGSSContext) {
        this.holdOnToGSSContext = holdOnToGSSContext;
    }

    public void setRefreshKrb5Config(boolean refreshKrb5Config) {
        this.refreshKrb5Config = refreshKrb5Config;
    }

    private class KerberosValidateAction
    implements PrivilegedExceptionAction<KerberosTicketValidation> {
        byte[] kerberosTicket;

        public KerberosValidateAction(byte[] kerberosTicket) {
            this.kerberosTicket = kerberosTicket;
        }

        @Override
        public KerberosTicketValidation run() throws Exception {
            byte[] responseToken = new byte[]{};
            GSSName gssName = null;
            GSSContext context = GSSManager.getInstance().createContext((GSSCredential)null);
            boolean first = true;
            while (!context.isEstablished()) {
                responseToken = context.acceptSecContext(this.kerberosTicket, 0, this.kerberosTicket.length);
                gssName = context.getSrcName();
                if (gssName == null) {
                    throw new BadCredentialsException("GSSContext name of the context initiator is null");
                }
                first = false;
            }
            GSSCredential delegationCredential = null;
            if (context.getCredDelegState()) {
                delegationCredential = context.getDelegCred();
            }
            if (!SunJaasKerberosTicketValidator.this.holdOnToGSSContext) {
                context.dispose();
            }
            return new KerberosTicketValidation(gssName.toString(), SunJaasKerberosTicketValidator.this.servicePrincipal, responseToken, context, delegationCredential);
        }
    }

    private class KerberosMultitierValidateAction
    implements PrivilegedExceptionAction<KerberosTicketValidation> {
        byte[] kerberosTicket;

        public KerberosMultitierValidateAction(byte[] kerberosTicket) {
            this.kerberosTicket = kerberosTicket;
        }

        @Override
        public KerberosTicketValidation run() throws Exception {
            byte[] responseToken = new byte[]{};
            GSSManager manager = GSSManager.getInstance();
            GSSContext context = manager.createContext((GSSCredential)null);
            while (!context.isEstablished()) {
                context.acceptSecContext(this.kerberosTicket, 0, this.kerberosTicket.length);
            }
            Subject subject = GSSUtil.createSubject(context.getSrcName(), context.getDelegCred());
            KerberosTicketValidation result = new KerberosTicketValidation(context.getSrcName().toString(), subject, responseToken, context);
            if (!SunJaasKerberosTicketValidator.this.holdOnToGSSContext) {
                context.dispose();
            }
            return result;
        }
    }

    private static class LoginConfig
    extends Configuration {
        private String keyTabLocation;
        private String servicePrincipalName;
        private String realmName;
        private boolean multiTier;
        private boolean debug;
        private boolean refreshKrb5Config;

        public LoginConfig(String keyTabLocation, String servicePrincipalName, String realmName, boolean multiTier, boolean debug, boolean refreshKrb5Config) {
            this.keyTabLocation = keyTabLocation;
            this.servicePrincipalName = servicePrincipalName;
            this.realmName = realmName;
            this.multiTier = multiTier;
            this.debug = debug;
            this.refreshKrb5Config = refreshKrb5Config;
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("useKeyTab", "true");
            options.put("keyTab", this.keyTabLocation);
            options.put("principal", this.servicePrincipalName);
            options.put("storeKey", "true");
            options.put("doNotPrompt", "true");
            if (this.debug) {
                options.put("debug", "true");
            }
            if (this.realmName != null) {
                options.put("realm", this.realmName);
            }
            if (this.refreshKrb5Config) {
                options.put("refreshKrb5Config", "true");
            }
            if (!this.multiTier) {
                options.put("isInitiator", "false");
            }
            return new AppConfigurationEntry[]{new AppConfigurationEntry("com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
        }
    }
}

