/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.hyperic.sigar.FileInfo;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarFileNotFoundException;

public abstract class FileWatcher {
    private Sigar sigar;
    private long interval = 0L;
    private long lastTime = 0L;
    private Set files = Collections.synchronizedSet(new HashSet());

    public abstract void onChange(FileInfo var1);

    public void onNotFound(FileInfo info) {
    }

    public void onException(FileInfo info, SigarException e) {
    }

    public FileWatcher(Sigar sigar) {
        this.sigar = sigar;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public long getInterval() {
        return this.interval;
    }

    public FileInfo add(File file) throws SigarException {
        return this.add(file.getAbsolutePath());
    }

    public FileInfo add(String file) throws SigarException {
        FileInfo info = this.sigar.getFileInfo(file);
        this.files.add(info);
        return info;
    }

    public void add(File[] files) throws SigarException {
        for (int i = 0; i < files.length; ++i) {
            this.add(files[i]);
        }
    }

    public void add(String[] files) throws SigarException {
        for (int i = 0; i < files.length; ++i) {
            this.add(files[i]);
        }
    }

    public void remove(File file) {
        this.remove(file.getAbsolutePath());
    }

    public void remove(String file) {
        FileInfo info = new FileInfo();
        info.name = file;
        this.files.remove(info);
    }

    public void clear() {
        this.files.clear();
    }

    public Set getFiles() {
        return this.files;
    }

    protected boolean changed(FileInfo info) throws SigarException, SigarFileNotFoundException {
        return info.changed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check() {
        if (this.interval != 0L) {
            long timeNow = System.currentTimeMillis();
            long timeDiff = timeNow - this.lastTime;
            if (timeDiff < this.interval) {
                return;
            }
            this.lastTime = timeNow;
        }
        Set set = this.files;
        synchronized (set) {
            Iterator it = this.files.iterator();
            while (it.hasNext()) {
                FileInfo info = (FileInfo)it.next();
                try {
                    if (!this.changed(info)) continue;
                    this.onChange(info);
                }
                catch (SigarFileNotFoundException e) {
                    this.onNotFound(info);
                }
                catch (SigarException e) {
                    this.onException(info, e);
                }
            }
        }
    }
}

