import React from 'react';
import { mount } from 'enzyme';
import { MenuItem } from './menu-item.component';

describe('MenuItem', () => {
    it('should render label', () => {
        const wrapper = mount(<MenuItem label="Duplicate" />);
        expect(wrapper.exists()).toBeTruthy();
        expect(wrapper.contains('Duplicate')).toBeTruthy();
        expect(wrapper.find(`DotIcon`).exists()).toBeFalsy();
    });

    it('should render icon', () => {
        const wrapper = mount(<MenuItem iconId="duplicate" label="Duplicate" />);
        expect(wrapper.exists()).toBeTruthy();
        expect(wrapper.contains('Duplicate')).toBeTruthy();
        expect(wrapper.find(`DotIcon`).exists()).toBeTruthy();
        expect(wrapper.find(`DotIcon`).prop('iconId')).toBe('duplicate');
    });
});
