import React from 'react';
import { mount } from 'enzyme/build';
import { HighlightText } from './hightlight-text';

describe('HighlightText', () => {
    test('should render highlight text component when no matches Found', () => {
        const text = 'FolderA';
        const searchText = 'FolderAA';
        const highlightTextComponent = mount(<HighlightText text={text} searchText={searchText} />);
        expect(highlightTextComponent.exists()).toBeTruthy();
        expect(highlightTextComponent.html()).toContain('<div>FolderA</div>');
    });

    test('should render highlight text component when matches Found', () => {
        const text = 'FolderA';
        const searchText = 'FolderA';
        const highlightTextComponent = mount(<HighlightText text={text} searchText={searchText} />);
        expect(highlightTextComponent.exists()).toBeTruthy();
        expect(highlightTextComponent.html()).toContain('<div><span class="highlight-text">FolderA</span></div>');
    });
});
