/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.ContainerTaskDefinition;
import com.xebialabs.xlrelease.domain.RemoteExecution;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.domain.variables.reference.PropertyUsagePoint;
import com.xebialabs.xlrelease.domain.variables.reference.UsagePoint;
import com.xebialabs.xlrelease.events.TaskStartOrRetryOperation;
import com.xebialabs.xlrelease.repository.CiProperty;
import com.xebialabs.xlrelease.service.ExecuteTaskAction;
import com.xebialabs.xlrelease.utils.PythonScriptCiHelper;
import com.xebialabs.xlrelease.variable.ValueWithInterpolation;
import com.xebialabs.xlrelease.variable.VariableHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(label="Generic containerized task", versioned=false, virtual=true)
public class ContainerTask
extends Task
implements RemoteExecution {
    @Property(category="input", label="Capabilities", description="Route jobs to particular types of remote runners based on capabilities", defaultValue="remote")
    private Set<String> capabilities = new HashSet<String>();
    @Property(required=false, description="Status line of the task that will appear in UI.")
    private String statusLine;
    @Property(required=false, hidden=true, defaultValue="", description="Icon location for the task")
    private String iconLocation;
    @Property(required=false, hidden=true, defaultValue="container-icon", description="Icon class for the task")
    private String iconClass;
    @Property(required=false, hidden=true, defaultValue="#3D6C9E", description="Task color")
    private String taskColor;
    @Property(required=false, hidden=true, defaultValue="The output of the task can be stored in release variables; specify the variables to be used (optional)", description="Help text below output properties section title")
    private String outputVarHelpText;
    @Property(required=false, hidden=true, defaultValue="true", description="Is task automated?")
    private boolean automated;
    @Property(required=false, hidden=true, defaultValue="false")
    private boolean sendNotificationWhenStarted;
    @Property(hidden=true, description="Container image name for the task", isTransient=true)
    private String image;
    @Property(required=false, hidden=true, defaultValue="30", description="Timeout in seconds for abort operation")
    private Integer abortTimeout;
    @Property(required=false, hidden=true, defaultValue="12", description="Max retry attempts in case of connection failure")
    private Integer maxRetryAttempts;
    @Property(required=false, hidden=true, defaultValue="5", description="Delay in seconds between retry attempts in case of connection failure")
    private Integer retryDelay;
    @Property(required=false, description="Keep the previous output properties on retry")
    private boolean keepPreviousOutputPropertiesOnRetry;

    public Set<String> getCapabilities() {
        return this.capabilities;
    }

    public void setCapabilities(Set<String> capabilities) {
        this.capabilities = capabilities;
    }

    @Override
    public Changes retry(String targetId) {
        this.getTransitionalAndOutputProperties().stream().filter(pd -> !this.isKeepPreviousOutputPropertiesOnRetry() || PythonScriptCiHelper.isEmpty((Object)this.getProperty(pd.getName()))).forEach(propertyDescriptor -> propertyDescriptor.set((ConfigurationItem)this, propertyDescriptor.getDefaultValue()));
        this.statusLine = null;
        return super.retry(targetId);
    }

    @Override
    protected Changes execute(String targetId, TaskStartOrRetryOperation operation) {
        Changes changes = super.execute(targetId, operation);
        if (this.getStatus() != TaskStatus.IN_PROGRESS) {
            return changes;
        }
        this.generateExecutionId();
        changes.update(this);
        changes.addPostAction(new ExecuteTaskAction(this));
        return changes;
    }

    @Override
    protected boolean shouldFreezeVariableMapping(CiProperty property) {
        return !"output".equals(property.getDescriptor().getCategory());
    }

    @Override
    public Set<String> freezeVariablesInCustomFields(Map<String, ValueWithInterpolation> variables, Map<String, String> passwordVariables, Changes changes, boolean freezeEvenIfUnresolved) {
        HashSet unresolvedVariables = Sets.newHashSet();
        List propertiesWithVariables = this.getInputProperties().stream().filter(ContainerTaskDefinition.ofKind(PropertyKind.STRING, PropertyKind.LIST_OF_STRING, PropertyKind.SET_OF_STRING, PropertyKind.MAP_STRING_STRING)).collect(Collectors.toList());
        Set variablesInNonInterpolatableValues = this.getRelease().getVariablesKeysInNonInterpolatableVariableValues().stream().map(v -> VariableHelper.withVariableSyntax(v)).collect(Collectors.toSet());
        for (PropertyDescriptor propertyDescriptor : propertiesWithVariables) {
            Object value = this.getProperty(propertyDescriptor.getName());
            Object newValue = propertyDescriptor.isPassword() ? VariableHelper.replaceAll(value, passwordVariables, unresolvedVariables, freezeEvenIfUnresolved) : VariableHelper.replaceAllWithInterpolation(value, variables, unresolvedVariables, freezeEvenIfUnresolved);
            this.setProperty(propertyDescriptor.getName(), newValue);
            if (value == null || value.equals(newValue)) continue;
            Set<String> variablesUsed = VariableHelper.collectVariables(value);
            variablesUsed.removeAll(variablesInNonInterpolatableValues);
            changes.addVariablesUsed(variablesUsed);
        }
        if (!propertiesWithVariables.isEmpty()) {
            changes.update(this);
        }
        return unresolvedVariables;
    }

    @Override
    public List<UsagePoint> getVariableUsages() {
        ArrayList<UsagePoint> usagePoints = new ArrayList<UsagePoint>(super.getVariableUsages());
        usagePoints.addAll(this.getInputProperties().stream().map(pd -> new PropertyUsagePoint(this, pd.getName())).collect(Collectors.toList()));
        usagePoints.addAll(this.getOutputProperties().stream().map(pd -> new PropertyUsagePoint(this, pd.getName())).collect(Collectors.toList()));
        return usagePoints;
    }

    public String getIconLocation() {
        return this.iconLocation;
    }

    public String getOutputVarHelpText() {
        return this.outputVarHelpText;
    }

    public String getTaskColor() {
        return this.taskColor;
    }

    public String getIconClass() {
        return this.iconClass;
    }

    @Override
    public Integer getAbortTimeout() {
        return this.abortTimeout;
    }

    @Override
    public Integer getMaxRetryAttempts() {
        return this.maxRetryAttempts;
    }

    @Override
    public Integer getRetryDelay() {
        return this.retryDelay;
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public boolean hasAbortScript() {
        return true;
    }

    public String getStatusLine() {
        return this.statusLine;
    }

    public void setStatusLine(String statusLine) {
        this.statusLine = statusLine;
    }

    public Collection<PropertyDescriptor> getInputProperties() {
        ContainerTaskDefinition taskDefinition = new ContainerTaskDefinition(this.getType(), true);
        return taskDefinition.getInputProperties();
    }

    private Collection<PropertyDescriptor> getOutputProperties() {
        ContainerTaskDefinition taskDefinition = new ContainerTaskDefinition(this.getType(), true);
        return taskDefinition.getOutputProperties();
    }

    @PublicApiMember
    public boolean isKeepPreviousOutputPropertiesOnRetry() {
        return this.keepPreviousOutputPropertiesOnRetry;
    }

    @PublicApiMember
    public void setKeepPreviousOutputPropertiesOnRetry(boolean keepPreviousOutputPropertiesOnRetry) {
        this.keepPreviousOutputPropertiesOnRetry = keepPreviousOutputPropertiesOnRetry;
    }

    public Collection<PropertyDescriptor> getTransitionalAndOutputProperties() {
        return new ContainerTaskDefinition(this.getType(), true).getTransitionalAndOutputProperties();
    }

    public boolean isUnknown() {
        return this.getType().equals((Object)UNKNOWN_TASK_TYPE);
    }
}

