/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp;

import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.security.SaslFrameBody;
import org.apache.qpid.proton.engine.impl.ProtocolTracer;
import org.apache.qpid.proton.framing.TransportFrame;
import org.slf4j.Logger;

public class AmqpProtocolTracer
implements ProtocolTracer {
    public static final int DEFAULT_PAYLOAD_STRING_LIMIT = 1024;
    private final Logger logger;
    private final int transportIdentifier;
    private final int payloadStringLimit;

    public AmqpProtocolTracer(Logger logger, int transportIdentifier) {
        this(logger, transportIdentifier, 1024);
    }

    public AmqpProtocolTracer(Logger logger, int transportIdentifier, int payloadStringLimit) {
        this.logger = logger;
        this.payloadStringLimit = payloadStringLimit;
        this.transportIdentifier = transportIdentifier;
    }

    public void receivedFrame(TransportFrame transportFrame) {
        this.logger.trace("[{}:{}] RECV: {}{}", new Object[]{this.transportIdentifier, transportFrame.getChannel(), transportFrame.getBody(), this.formatPayload(transportFrame)});
    }

    public void sentFrame(TransportFrame transportFrame) {
        this.logger.trace("[{}:{}] SENT: {}{}", new Object[]{this.transportIdentifier, transportFrame.getChannel(), transportFrame.getBody(), this.formatPayload(transportFrame)});
    }

    public void receivedSaslBody(SaslFrameBody saslFrameBody) {
        this.logger.trace("[{}:0] RECV: {}", (Object)this.transportIdentifier, (Object)saslFrameBody);
    }

    public void sentSaslBody(SaslFrameBody saslFrameBody) {
        this.logger.trace("[{}:0] SENT: {}", (Object)this.transportIdentifier, (Object)saslFrameBody);
    }

    public void receivedHeader(String header) {
        this.logger.trace("[{}:0] RECV: {}", (Object)this.transportIdentifier, (Object)header);
    }

    public void sentHeader(String header) {
        this.logger.trace("[{}:0] SENT: {}", (Object)this.transportIdentifier, (Object)header);
    }

    private String formatPayload(TransportFrame frame) {
        Binary payload = frame.getPayload();
        if (payload == null || payload.getLength() == 0 || this.payloadStringLimit <= 0) {
            return "";
        }
        byte[] binData = payload.getArray();
        int binLength = payload.getLength();
        int offset = payload.getArrayOffset();
        StringBuilder builder = new StringBuilder();
        builder.append(" (").append(payload.getLength()).append(") ").append("\"");
        int size = 0;
        boolean truncated = false;
        for (int i = 0; i < binLength; ++i) {
            byte c = binData[offset + i];
            if (c > 31 && c < 127 && c != 92) {
                if (size + 1 <= this.payloadStringLimit) {
                    ++size;
                    builder.append((char)c);
                    continue;
                }
                truncated = true;
                break;
            }
            if (size + 4 <= this.payloadStringLimit) {
                size += 4;
                builder.append(String.format("\\x%02x", c));
                continue;
            }
            truncated = true;
            break;
        }
        builder.append("\"");
        if (truncated) {
            builder.append("...(truncated)");
        }
        return builder.toString();
    }
}

