/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.environments.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.xlrelease.api.v1.filter.EnvironmentLabelFilters;
import com.xebialabs.xlrelease.domain.environments.EnvironmentLabel;
import com.xebialabs.xlrelease.environments.repository.EnvironmentLabelRepository;
import com.xebialabs.xlrelease.environments.service.package$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import scala.Function0;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005}b\u0001\u0002\u0007\u000e\u0001aA\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\u0006]\u0001!\ta\f\u0005\u0006\u0005\u0002!\ta\u0011\u0005\u0006S\u0002!\tA\u001b\u0005\u0006s\u0002!\tA\u001f\u0005\u0006}\u0002!\ta \u0005\b\u0003\u000f\u0001A\u0011AA\u0005\u0011\u001d\ty\u0001\u0001C\u0001\u0003#Aq!!\b\u0001\t\u0013\ty\u0002C\u0004\u0002$\u0001!I!!\n\t\u000f\u0005%\u0002\u0001\"\u0003\u0002,\t9RI\u001c<je>tW.\u001a8u\u0019\u0006\u0014W\r\\*feZL7-\u001a\u0006\u0003\u001d=\tqa]3sm&\u001cWM\u0003\u0002\u0011#\u0005aQM\u001c<je>tW.\u001a8ug*\u0011!cE\u0001\nq2\u0014X\r\\3bg\u0016T!\u0001F\u000b\u0002\u0013a,'-[1mC\n\u001c(\"\u0001\f\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001Ir\u0004\u0005\u0002\u001b;5\t1DC\u0001\u001d\u0003\u0015\u00198-\u00197b\u0013\tq2D\u0001\u0004B]f\u0014VM\u001a\t\u0003A\u0015j\u0011!\t\u0006\u0003E\r\nQa\u001d7gi)T\u0011\u0001J\u0001\tOJL'P\u001f7fI&\u0011a%\t\u0002\b\u0019><w-\u001b8h\u0003i)gN^5s_:lWM\u001c;MC\n,GNU3q_NLGo\u001c:z!\tIC&D\u0001+\u0015\tYs\"\u0001\u0006sKB|7/\u001b;pefL!!\f\u0016\u00035\u0015sg/\u001b:p]6,g\u000e\u001e'bE\u0016d'+\u001a9pg&$xN]=\u0002\rqJg.\u001b;?)\t\u0001$\u0007\u0005\u00022\u00015\tQ\u0002C\u0003(\u0005\u0001\u0007\u0001\u0006\u000b\u0002\u0003iA\u0011Q\u0007Q\u0007\u0002m)\u0011q\u0007O\u0001\u000bC:tw\u000e^1uS>t'BA\u001d;\u0003\u001d1\u0017m\u0019;pefT!a\u000f\u001f\u0002\u000b\t,\u0017M\\:\u000b\u0005ur\u0014aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003}\n1a\u001c:h\u0013\t\teGA\u0005BkR|w/\u001b:fI\u0006a1/Z1sG\"d\u0015MY3mgR\u0011Ai\u0015\t\u0004\u000b*cU\"\u0001$\u000b\u0005\u001dC\u0015\u0001B;uS2T\u0011!S\u0001\u0005U\u00064\u0018-\u0003\u0002L\r\n!A*[:u!\ti\u0015+D\u0001O\u0015\t\u0001rJ\u0003\u0002Q#\u00051Am\\7bS:L!A\u0015(\u0003!\u0015sg/\u001b:p]6,g\u000e\u001e'bE\u0016d\u0007\"\u0002+\u0004\u0001\u0004)\u0016aF3om&\u0014xN\\7f]Rd\u0015MY3m\r&dG/\u001a:t!\t1V,D\u0001X\u0015\tA\u0016,\u0001\u0004gS2$XM\u001d\u0006\u00035n\u000b!A^\u0019\u000b\u0005q\u000b\u0012aA1qS&\u0011al\u0016\u0002\u0018\u000b:4\u0018N]8o[\u0016tG\u000fT1cK24\u0015\u000e\u001c;feND#a\u00011\u0011\u0005\u0005<W\"\u00012\u000b\u0005]\u001a'B\u00013f\u0003\u001diW\r\u001e:jGNT!AZ\u000b\u0002\u0011\r|G-\u00195bY\u0016L!\u0001\u001b2\u0003\u000bQKW.\u001a3\u0002\u001b\u0019Lg\u000e\u001a'bE\u0016d')_%e)\ta5\u000eC\u0003m\t\u0001\u0007Q.\u0001\nf]ZL'o\u001c8nK:$H*\u00192fY&#\u0007C\u00018v\u001d\ty7\u000f\u0005\u0002q75\t\u0011O\u0003\u0002s/\u00051AH]8pizJ!\u0001^\u000e\u0002\rA\u0013X\rZ3g\u0013\t1xO\u0001\u0004TiJLgn\u001a\u0006\u0003inA#\u0001\u00021\u0002\u0017\u0019Lg\u000e\u001a\"z)&$H.\u001a\u000b\u0003\u0019nDQ\u0001`\u0003A\u00025\fq\"\u001a8wSJ|g.\\3oi:\u000bW.\u001a\u0015\u0003\u000b\u0001\f1b\u0019:fCR,G*\u00192fYR\u0019A*!\u0001\t\r\u0005\ra\u00011\u0001M\u0003A)gN^5s_:lWM\u001c;MC\n,G\u000e\u000b\u0002\u0007A\u0006YQ\u000f\u001d3bi\u0016d\u0015MY3m)\ra\u00151\u0002\u0005\u0007\u0003\u00079\u0001\u0019\u0001')\u0005\u001d\u0001\u0017a\u00033fY\u0016$X\rT1cK2$B!a\u0005\u0002\u001aA\u0019!$!\u0006\n\u0007\u0005]1D\u0001\u0003V]&$\b\"\u00027\t\u0001\u0004i\u0007F\u0001\u0005a\u0003!1\u0018\r\\5eCR,G\u0003BA\n\u0003CAa!a\u0001\n\u0001\u0004a\u0015!\u0004<bY&$\u0017\r^3USRdW\r\u0006\u0003\u0002\u0014\u0005\u001d\u0002BBA\u0002\u0015\u0001\u0007A*A\u0007wC2LG-\u0019;f\u0007>dwN\u001d\u000b\u0005\u0003'\ti\u0003\u0003\u0004\u00020-\u0001\r!\\\u0001\u0006G>dwN\u001d\u0015\u0004\u0001\u0005M\u0002\u0003BA\u001b\u0003wi!!a\u000e\u000b\u0007\u0005eB(\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LA!!\u0010\u00028\t91+\u001a:wS\u000e,\u0007")
public class EnvironmentLabelService
implements Logging {
    private final EnvironmentLabelRepository environmentLabelRepository;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        EnvironmentLabelService environmentLabelService = this;
        synchronized (environmentLabelService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public List<EnvironmentLabel> searchLabels(EnvironmentLabelFilters environmentLabelFilters) {
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.environmentLabelRepository.search(environmentLabelFilters, package$.MODULE$.defaultPage())).asJava();
    }

    @Timed
    public EnvironmentLabel findLabelById(String environmentLabelId) {
        return this.environmentLabelRepository.findById(environmentLabelId);
    }

    @Timed
    public EnvironmentLabel findByTitle(String environmentName) {
        return this.environmentLabelRepository.findByTitle(environmentName);
    }

    @Timed
    public EnvironmentLabel createLabel(EnvironmentLabel environmentLabel) {
        this.logger().debug((Function0 & Serializable)() -> "Creating a new environment label");
        this.validate(environmentLabel);
        return this.environmentLabelRepository.create(environmentLabel);
    }

    @Timed
    public EnvironmentLabel updateLabel(EnvironmentLabel environmentLabel) {
        this.logger().debug((Function0 & Serializable)() -> "Updating environment label [" + environmentLabel + "]");
        Checks.checkArgument((boolean)StringUtils.hasText((String)environmentLabel.getId()), (String)"ID is required", (Object[])new Object[0]);
        this.validate(environmentLabel);
        return this.environmentLabelRepository.update(environmentLabel);
    }

    @Timed
    public void deleteLabel(String environmentLabelId) {
        this.logger().debug((Function0 & Serializable)() -> "Deleting environment label [" + environmentLabelId + "]");
        this.environmentLabelRepository.delete(environmentLabelId);
    }

    private void validate(EnvironmentLabel environmentLabel) {
        this.validateTitle(environmentLabel);
        this.validateColor(environmentLabel.getColor());
    }

    private void validateTitle(EnvironmentLabel environmentLabel) {
        Checks.checkArgument((boolean)StringUtils.hasText((String)environmentLabel.getTitle()), (String)"Title cannot be blank", (Object[])new Object[0]);
    }

    private void validateColor(String color) {
        if (!Pattern.compile("^#([A-Fa-f0-9]{6})$").matcher(color).matches()) {
            throw new Checks.IncorrectArgumentException("Invalid color pattern '" + color + "'", new Object[0]);
        }
    }

    @Autowired
    public EnvironmentLabelService(EnvironmentLabelRepository environmentLabelRepository) {
        this.environmentLabelRepository = environmentLabelRepository;
        Logging.$init$((Logging)this);
    }
}

