/*
 * Decompiled with CFR 0.152.
 */
package akka.remote.transport.netty;

import akka.actor.ActorSystem;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.MarkerLoggingAdapter;
import akka.remote.RemoteTransportException;
import akka.remote.artery.tcp.SecureRandomFactory$;
import akka.remote.transport.netty.SSLEngineProvider;
import akka.remote.transport.netty.SSLSettings;
import akka.stream.Client$;
import akka.stream.Server$;
import akka.stream.TLSRole;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import scala.Function0;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005=b\u0001\u0002\t\u0012\u0001iA\u0001\"\n\u0001\u0003\u0006\u0004%\tB\n\u0005\t[\u0001\u0011\t\u0011)A\u0005O!Aa\u0006\u0001BC\u0002\u0013%q\u0006\u0003\u00054\u0001\t\u0005\t\u0015!\u00031\u0011\u0015!\u0004\u0001\"\u00016\u0011\u0015!\u0004\u0001\"\u0001:\u0011!\u0011\u0005\u0001#b\u0001\n\u0013\u0019\u0005\"\u0002(\u0001\t#y\u0005\"B4\u0001\t#A\u0007\"B8\u0001\t#\u0001\b\"B;\u0001\t\u00031\b\"\u0002>\u0001\t\u0003Z\b\"B@\u0001\t\u0003Z\bbBA\u0001\u0001\u0011%\u00111\u0001\u0005\b\u0003\u0003\u0001A\u0011BA\u000b\u0005]\u0019uN\u001c4jON\u001bF*\u00128hS:,\u0007K]8wS\u0012,'O\u0003\u0002\u0013'\u0005)a.\u001a;us*\u0011A#F\u0001\niJ\fgn\u001d9peRT!AF\f\u0002\rI,Wn\u001c;f\u0015\u0005A\u0012\u0001B1lW\u0006\u001c\u0001aE\u0002\u00017\u0005\u0002\"\u0001H\u0010\u000e\u0003uQ\u0011AH\u0001\u0006g\u000e\fG.Y\u0005\u0003Au\u0011a!\u00118z%\u00164\u0007C\u0001\u0012$\u001b\u0005\t\u0012B\u0001\u0013\u0012\u0005E\u00196\u000bT#oO&tW\r\u0015:pm&$WM]\u0001\u0004Y><W#A\u0014\u0011\u0005!ZS\"A\u0015\u000b\u0005):\u0012!B3wK:$\u0018B\u0001\u0017*\u0005Qi\u0015M]6fe2{wmZ5oO\u0006#\u0017\r\u001d;fe\u0006!An\\4!\u0003!\u0019X\r\u001e;j]\u001e\u001cX#\u0001\u0019\u0011\u0005\t\n\u0014B\u0001\u001a\u0012\u0005-\u00196\u000bT*fiRLgnZ:\u0002\u0013M,G\u000f^5oON\u0004\u0013A\u0002\u001fj]&$h\bF\u00027oa\u0002\"A\t\u0001\t\u000b\u0015*\u0001\u0019A\u0014\t\u000b9*\u0001\u0019\u0001\u0019\u0015\u0005YR\u0004\"B\u001e\u0007\u0001\u0004a\u0014AB:zgR,W\u000e\u0005\u0002>\u00016\taH\u0003\u0002@/\u0005)\u0011m\u0019;pe&\u0011\u0011I\u0010\u0002\f\u0003\u000e$xN]*zgR,W.\u0001\u0006tg2\u001cuN\u001c;fqR,\u0012\u0001\u0012\t\u0003\u000b2k\u0011A\u0012\u0006\u0003\u000f\"\u000b1a]:m\u0015\tI%*A\u0002oKRT\u0011aS\u0001\u0006U\u00064\u0018\r_\u0005\u0003\u001b\u001a\u0013!bU*M\u0007>tG/\u001a=u\u00031aw.\u00193LKf\u001cHo\u001c:f)\r\u0001\u0006,\u001a\t\u0003#Zk\u0011A\u0015\u0006\u0003'R\u000b\u0001b]3dkJLG/\u001f\u0006\u0002+\u0006!!.\u0019<b\u0013\t9&K\u0001\u0005LKf\u001cFo\u001c:f\u0011\u0015I\u0006\u00021\u0001[\u0003!1\u0017\u000e\\3oC6,\u0007CA.c\u001d\ta\u0006\r\u0005\u0002^;5\taL\u0003\u0002`3\u00051AH]8pizJ!!Y\u000f\u0002\rA\u0013X\rZ3g\u0013\t\u0019GM\u0001\u0004TiJLgn\u001a\u0006\u0003CvAQA\u001a\u0005A\u0002i\u000b\u0001\u0002]1tg^|'\u000fZ\u0001\fW\u0016LX*\u00198bO\u0016\u00148/F\u0001j!\ra\"\u000e\\\u0005\u0003Wv\u0011Q!\u0011:sCf\u0004\"!R7\n\u000594%AC&fs6\u000bg.Y4fe\u0006iAO];ti6\u000bg.Y4feN,\u0012!\u001d\t\u00049)\u0014\bCA#t\u0013\t!hI\u0001\u0007UeV\u001cH/T1oC\u001e,'/\u0001\nde\u0016\fG/Z*fGV\u0014XMU1oI>lG#A<\u0011\u0005EC\u0018BA=S\u00051\u0019VmY;sKJ\u000bg\u000eZ8n\u0003U\u0019'/Z1uKN+'O^3s'NcUI\\4j]\u0016$\u0012\u0001 \t\u0003\u000bvL!A $\u0003\u0013M\u001bF*\u00128hS:,\u0017!F2sK\u0006$Xm\u00117jK:$8k\u0015'F]\u001eLg.Z\u0001\u0010GJ,\u0017\r^3T'2+enZ5oKR\u0019A0!\u0002\t\u000f\u0005\u001da\u00021\u0001\u0002\n\u0005!!o\u001c7f!\u0011\tY!!\u0005\u000e\u0005\u00055!bAA\b/\u000511\u000f\u001e:fC6LA!a\u0005\u0002\u000e\t9A\u000bT*S_2,G#\u0002?\u0002\u0018\u0005e\u0001\"\u0002\"\u0010\u0001\u0004!\u0005bBA\u0004\u001f\u0001\u0007\u0011\u0011\u0002\u0015\f\u0001\u0005u\u00111EA\u0013\u0003S\tY\u0003E\u0002\u001d\u0003?I1!!\t\u001e\u0005)!W\r\u001d:fG\u0006$X\rZ\u0001\b[\u0016\u001c8/Y4fC\t\t9#\u0001\u0016DY\u0006\u001c8/[2!e\u0016lw\u000e^5oO\u0002J7\u000f\t3faJ,7-\u0019;fI2\u0002So]3!\u0003J$XM]=\u0002\u000bMLgnY3\"\u0005\u00055\u0012!\u0002\u001a/m9\u0002\u0004")
public class ConfigSSLEngineProvider
implements SSLEngineProvider {
    private SSLContext sslContext;
    private final MarkerLoggingAdapter log;
    private final SSLSettings settings;
    private volatile boolean bitmap$0;

    public MarkerLoggingAdapter log() {
        return this.log;
    }

    private SSLSettings settings() {
        return this.settings;
    }

    private SSLContext sslContext$lzycompute() {
        ConfigSSLEngineProvider configSSLEngineProvider = this;
        synchronized (configSSLEngineProvider) {
            if (!this.bitmap$0) {
                this.sslContext = this.liftedTree1$1();
                this.bitmap$0 = true;
            }
        }
        return this.sslContext;
    }

    private SSLContext sslContext() {
        return !this.bitmap$0 ? this.sslContext$lzycompute() : this.sslContext;
    }

    /*
     * WARNING - void declaration
     */
    public KeyStore loadKeystore(String filename, String password) {
        void var3_3;
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        InputStream fin = Files.newInputStream(Paths.get(filename, new String[0]), new OpenOption[0]);
        try {
            keyStore.load(fin, password.toCharArray());
        }
        finally {
            Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> fin.close());
        }
        return var3_3;
    }

    public KeyManager[] keyManagers() {
        KeyManagerFactory factory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        factory.init(this.loadKeystore(this.settings().SSLKeyStore(), this.settings().SSLKeyStorePassword()), this.settings().SSLKeyPassword().toCharArray());
        return factory.getKeyManagers();
    }

    public TrustManager[] trustManagers() {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(this.loadKeystore(this.settings().SSLTrustStore(), this.settings().SSLTrustStorePassword()));
        return trustManagerFactory.getTrustManagers();
    }

    public SecureRandom createSecureRandom() {
        return SecureRandomFactory$.MODULE$.createSecureRandom(this.settings().SSLRandomNumberGenerator(), this.log());
    }

    @Override
    public SSLEngine createServerSSLEngine() {
        return this.createSSLEngine((TLSRole)Server$.MODULE$);
    }

    @Override
    public SSLEngine createClientSSLEngine() {
        return this.createSSLEngine((TLSRole)Client$.MODULE$);
    }

    private SSLEngine createSSLEngine(TLSRole role) {
        return this.createSSLEngine(this.sslContext(), role);
    }

    /*
     * WARNING - void declaration
     */
    private SSLEngine createSSLEngine(SSLContext sslContext, TLSRole role) {
        void var3_3;
        block0: {
            SSLEngine engine = sslContext.createSSLEngine();
            TLSRole tLSRole = role;
            Client$ client$ = Client$.MODULE$;
            engine.setUseClientMode(!(tLSRole != null ? !tLSRole.equals(client$) : client$ != null));
            engine.setEnabledCipherSuites((String[])this.settings().SSLEnabledAlgorithms().toArray(ClassTag$.MODULE$.apply(String.class)));
            engine.setEnabledProtocols((String[])((Object[])new String[]{this.settings().SSLProtocol()}));
            TLSRole tLSRole2 = role;
            Client$ client$2 = Client$.MODULE$;
            if (!(tLSRole2 == null ? client$2 != null : !tLSRole2.equals(client$2)) || !this.settings().SSLRequireMutualAuthentication()) break block0;
            engine.setNeedClientAuth(true);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private final /* synthetic */ SSLContext liftedTree1$1() {
        void v0;
        try {
            void var2_2;
            SecureRandom rng = this.createSecureRandom();
            SSLContext ctx = SSLContext.getInstance(this.settings().SSLProtocol());
            ctx.init(this.keyManagers(), this.trustManagers(), rng);
            v0 = var2_2;
        }
        catch (FileNotFoundException e) {
            throw new RemoteTransportException("Server SSL connection could not be established because key store could not be loaded", e);
        }
        catch (IOException e) {
            throw new RemoteTransportException(new StringBuilder(56).append("Server SSL connection could not be established because: ").append(e.getMessage()).toString(), e);
        }
        catch (GeneralSecurityException e) {
            throw new RemoteTransportException("Server SSL connection could not be established because SSL context could not be constructed", e);
        }
        return v0;
    }

    public ConfigSSLEngineProvider(MarkerLoggingAdapter log, SSLSettings settings) {
        this.log = log;
        this.settings = settings;
    }

    public ConfigSSLEngineProvider(ActorSystem system) {
        this(Logging$.MODULE$.withMarker(system, (Object)ConfigSSLEngineProvider.class.getName(), LogSource$.MODULE$.fromString()), new SSLSettings(system.settings().config().getConfig("akka.remote.classic.netty.ssl.security")));
    }
}

