/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scheduler.logs;

import akka.actor.ActorRef;
import com.xebialabs.xlrelease.domain.events.TaskJobExecutedEvent;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.events.Subscribe;
import com.xebialabs.xlrelease.scheduler.events.JobFinishedEvent;
import com.xebialabs.xlrelease.scheduler.logs.ExecutionLogWatchActor;
import com.xebialabs.xlrelease.scheduler.logs.ExecutionLogWatcherSupervisor;
import com.xebialabs.xlrelease.scheduler.logs.TaskExecutionEntry;
import com.xebialabs.xlrelease.scheduler.logs.TaskExecutionLog;
import com.xebialabs.xlrelease.scheduler.logs.TaskExecutionLogService$;
import com.xebialabs.xlrelease.scheduler.logs.TaskExecutionRepository;
import com.xebialabs.xlrelease.scheduler.logs.TaskLogCreated;
import com.xebialabs.xlrelease.service.BroadcastService;
import com.xebialabs.xlrelease.service.TaskService;
import com.xebialabs.xlrelease.storage.domain.LogEntry;
import com.xebialabs.xlrelease.storage.domain.StorageEntry;
import com.xebialabs.xlrelease.storage.service.StorageService;
import com.xebialabs.xlrelease.support.akka.spring.SpringExtension;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.views.TaskExecutionLogView;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.time.Instant;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Service
@EventListener
@ScalaSignature(bytes="\u0006\u0005\t\u001da\u0001\u0002\f\u0018\u0001\tB\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\ty\u0001\u0011\t\u0011)A\u0005{!A1\t\u0001B\u0001B\u0003%A\t\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003M\u0011!y\u0005A!A!\u0002\u0013\u0001\u0006\"\u0002+\u0001\t\u0003)\u0006\u0002\u0003/\u0001\u0011\u000b\u0007I\u0011B/\t\u000b\u0015\u0004A\u0011\u00014\t\u000be\u0004A\u0011\u0001>\t\u000bq\u0004A\u0011A?\t\u000f\u00055\u0003\u0001\"\u0001\u0002P!9\u00111\u000b\u0001\u0005\u0002\u0005U\u0003bBA9\u0001\u0011\u0005\u00111\u000f\u0005\b\u0003\u0007\u0003A\u0011AAC\u0011\u001d\t9\n\u0001C\u0001\u00033Cq!a.\u0001\t\u0003\tI\fC\u0004\u0002H\u0002!\t!!3\b\u000f\u0005ex\u0003#\u0001\u0002|\u001a1ac\u0006E\u0001\u0003{Da\u0001V\n\u0005\u0002\u0005}\bb\u0002B\u0001'\u0011\u0005!1\u0001\u0002\u0018)\u0006\u001c8.\u0012=fGV$\u0018n\u001c8M_\u001e\u001cVM\u001d<jG\u0016T!\u0001G\r\u0002\t1|wm\u001d\u0006\u00035m\t\u0011b]2iK\u0012,H.\u001a:\u000b\u0005qi\u0012!\u0003=me\u0016dW-Y:f\u0015\tqr$A\u0005yK\nL\u0017\r\\1cg*\t\u0001%A\u0002d_6\u001c\u0001aE\u0002\u0001G%\u0002\"\u0001J\u0014\u000e\u0003\u0015R\u0011AJ\u0001\u0006g\u000e\fG.Y\u0005\u0003Q\u0015\u0012a!\u00118z%\u00164\u0007C\u0001\u00160\u001b\u0005Y#B\u0001\u0017.\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005q\u0013\u0001C4sSjTH.\u001a3\n\u0005AZ#a\u0002'pO\u001eLgnZ\u0001\u0010gB\u0014\u0018N\\4FqR,gn]5p]B\u00111GO\u0007\u0002i)\u0011QGN\u0001\u0007gB\u0014\u0018N\\4\u000b\u0005]B\u0014\u0001B1lW\u0006T!!O\u000e\u0002\u000fM,\b\u000f]8si&\u00111\b\u000e\u0002\u0010'B\u0014\u0018N\\4FqR,gn]5p]\u0006\u0001\"M]8bI\u000e\f7\u000f^*feZL7-\u001a\t\u0003}\u0005k\u0011a\u0010\u0006\u0003\u0001n\tqa]3sm&\u001cW-\u0003\u0002C\u007f\t\u0001\"I]8bI\u000e\f7\u000f^*feZL7-Z\u0001\u000fgR|'/Y4f'\u0016\u0014h/[2f!\t)\u0015*D\u0001G\u0015\t\u0001uI\u0003\u0002I7\u000591\u000f^8sC\u001e,\u0017B\u0001&G\u00059\u0019Fo\u001c:bO\u0016\u001cVM\u001d<jG\u0016\f1\u0002^1tWN+'O^5dKB\u0011a(T\u0005\u0003\u001d~\u00121\u0002V1tWN+'O^5dK\u00069B/Y:l\u000bb,7-\u001e;j_:\u0014V\r]8tSR|'/\u001f\t\u0003#Jk\u0011aF\u0005\u0003'^\u0011q\u0003V1tW\u0016CXmY;uS>t'+\u001a9pg&$xN]=\u0002\rqJg.\u001b;?)\u00191v\u000bW-[7B\u0011\u0011\u000b\u0001\u0005\u0006c\u0019\u0001\rA\r\u0005\u0006y\u0019\u0001\r!\u0010\u0005\u0006\u0007\u001a\u0001\r\u0001\u0012\u0005\u0006\u0017\u001a\u0001\r\u0001\u0014\u0005\u0006\u001f\u001a\u0001\r\u0001U\u0001\u001cKb,7-\u001e;j_:dunZ,bi\u000eDWM]!di>\u0014(+\u001a4\u0016\u0003y\u0003\"aX2\u000e\u0003\u0001T!!\u00192\u0002\u000b\u0005\u001cGo\u001c:\u000b\u0003]J!\u0001\u001a1\u0003\u0011\u0005\u001bGo\u001c:SK\u001a\fQa^1uG\"$2a\u001a6x!\t!\u0003.\u0003\u0002jK\t!QK\\5u\u0011\u0015Y\u0007\u00021\u0001m\u0003\u0019!\u0018m]6JIB\u0011Q\u000e\u001e\b\u0003]J\u0004\"a\\\u0013\u000e\u0003AT!!]\u0011\u0002\rq\u0012xn\u001c;?\u0013\t\u0019X%\u0001\u0004Qe\u0016$WMZ\u0005\u0003kZ\u0014aa\u0015;sS:<'BA:&\u0011\u0015A\b\u00021\u0001m\u0003-)\u00070Z2vi&|g.\u00133\u0002\u0013M$x\u000e],bi\u000eDGCA4|\u0011\u0015A\u0018\u00021\u0001m\u0003\u00151W\r^2i)%9gp`A\u0001\u0003+\t\u0019\u0005C\u0003l\u0015\u0001\u0007A\u000eC\u0003y\u0015\u0001\u0007A\u000eC\u0004\u0002\u0004)\u0001\r!!\u0002\u0002\u0019=,H\u000f];u'R\u0014X-Y7\u0011\t\u0005\u001d\u0011\u0011C\u0007\u0003\u0003\u0013QA!a\u0003\u0002\u000e\u0005\u0011\u0011n\u001c\u0006\u0003\u0003\u001f\tAA[1wC&!\u00111CA\u0005\u00051yU\u000f\u001e9viN#(/Z1n\u0011\u001d\t9B\u0003a\u0001\u00033\tq\u0001\\1ti*{'\r\u0005\u0003\u0002\u001c\u0005ub\u0002BA\u000f\u0003oqA!a\b\u000229!\u0011\u0011EA\u0017\u001d\u0011\t\u0019#a\u000b\u000f\t\u0005\u0015\u0012\u0011\u0006\b\u0004_\u0006\u001d\u0012\"\u0001\u0011\n\u0005yy\u0012B\u0001\u000f\u001e\u0013\r\tycG\u0001\u0007eVtg.\u001a:\n\t\u0005M\u0012QG\u0001\u0007I>l\u0017-\u001b8\u000b\u0007\u0005=2$\u0003\u0003\u0002:\u0005m\u0012a\u00029bG.\fw-\u001a\u0006\u0005\u0003g\t)$\u0003\u0003\u0002@\u0005\u0005#!\u0002&pE&#'\u0002BA\u001d\u0003wAq!!\u0012\u000b\u0001\u0004\t9%A\u0005mCN$8\t[;oWB\u0019A%!\u0013\n\u0007\u0005-SE\u0001\u0003M_:<\u0017\u0001\u00029p]\u001e$2aZA)\u0011\u0015A8\u00021\u0001m\u0003I1W\r^2i\u00032dW\t_3dkRLwN\\:\u0015\t\u0005]\u0013q\u000e\t\u0007\u00033\ny&a\u0019\u000e\u0005\u0005m#\u0002BA/\u0003\u001b\tA!\u001e;jY&!\u0011\u0011MA.\u0005\u0011a\u0015n\u001d;\u0011\t\u0005\u0015\u00141N\u0007\u0003\u0003OR1!!\u001b\u001c\u0003\u00151\u0018.Z<t\u0013\u0011\ti'a\u001a\u0003)Q\u000b7o[#yK\u000e,H/[8o\u0019><g+[3x\u0011\u0015YG\u00021\u0001m\u0003\rawn\u001a\u000b\u0004O\u0006U\u0004bBA<\u001b\u0001\u0007\u0011\u0011P\u0001\tY><WI\u001c;ssB!\u00111PA@\u001b\t\tiHC\u0002\u00024\u001dKA!!!\u0002~\tAAj\\4F]R\u0014\u00180A\u000bhKR$\u0016m]6Fq\u0016\u001cW\u000f^5p]\u0016sGO]=\u0015\r\u0005\u001d\u00151SAK!\u0015!\u0013\u0011RAG\u0013\r\tY)\n\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007E\u000by)C\u0002\u0002\u0012^\u0011!\u0003V1tW\u0016CXmY;uS>tWI\u001c;ss\")1N\u0004a\u0001Y\")\u0001P\u0004a\u0001Y\u0006iqN\u001c&pE\u001aKg.[:iK\u0012$2aZAN\u0011\u001d\tij\u0004a\u0001\u0003?\u000bQ!\u001a<f]R\u0004B!!)\u0002(6\u0011\u00111\u0015\u0006\u0004\u0003KK\u0012AB3wK:$8/\u0003\u0003\u0002*\u0006\r&\u0001\u0005&pE\u001aKg.[:iK\u0012,e/\u001a8uQ\ry\u0011Q\u0016\t\u0005\u0003_\u000b\u0019,\u0004\u0002\u00022*\u0019\u0011QU\u000e\n\t\u0005U\u0016\u0011\u0017\u0002\n'V\u00147o\u0019:jE\u0016\f\u0001c\u001c8UCN\\Gj\\4De\u0016\fG/\u001a3\u0015\u0007\u001d\fY\fC\u0004\u0002>B\u0001\r!a0\u0002\u0019Q\f7o\u001b'pO\u00163XM\u001c;\u0011\u0007E\u000b\t-C\u0002\u0002D^\u0011a\u0002V1tW2{wm\u0011:fCR,G\rK\u0002\u0011\u0003[\u000b1c\u001c8UCN\\W\t_3dkRLwN\u001c#p]\u0016$2aZAf\u0011\u001d\ti*\u0005a\u0001\u0003\u001b\u0004B!a4\u0002V6\u0011\u0011\u0011\u001b\u0006\u0005\u0003K\u000b\u0019NC\u0002\u00024mIA!a6\u0002R\n!B+Y:l\u0015>\u0014W\t_3dkR,G-\u0012<f]RD3!EAWQ\r\u0001\u0011Q\u001c\t\u0005\u0003?\fi/\u0004\u0002\u0002b*!\u00111]As\u0003)\u0019H/\u001a:f_RL\b/\u001a\u0006\u0005\u0003O\fI/A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\t\tY/A\u0002pe\u001eLA!a<\u0002b\n91+\u001a:wS\u000e,\u0007f\u0001\u0001\u0002tB!\u0011qVA{\u0013\u0011\t90!-\u0003\u001b\u00153XM\u001c;MSN$XM\\3s\u0003]!\u0016m]6Fq\u0016\u001cW\u000f^5p]2{wmU3sm&\u001cW\r\u0005\u0002R'M\u00111c\t\u000b\u0003\u0003w\fA\u0001[1tQR\u0019AN!\u0002\t\u000b-,\u0002\u0019\u00017")
public class TaskExecutionLogService
implements Logging {
    private ActorRef executionLogWatcherActorRef;
    private final SpringExtension springExtension;
    private final BroadcastService broadcastService;
    private final StorageService storageService;
    private final TaskService taskService;
    private final TaskExecutionRepository taskExecutionRepository;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static String hash(String taskId) {
        return TaskExecutionLogService$.MODULE$.hash(taskId);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TaskExecutionLogService taskExecutionLogService = this;
        synchronized (taskExecutionLogService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private ActorRef executionLogWatcherActorRef$lzycompute() {
        TaskExecutionLogService taskExecutionLogService = this;
        synchronized (taskExecutionLogService) {
            if (!this.bitmap$0) {
                this.executionLogWatcherActorRef = this.springExtension.actorOf(ExecutionLogWatcherSupervisor.class, "execution-log-watchers", this.springExtension.actorOf$default$3(), this.springExtension.actorOf$default$4());
                this.bitmap$0 = true;
            }
        }
        return this.executionLogWatcherActorRef;
    }

    private ActorRef executionLogWatcherActorRef() {
        if (!this.bitmap$0) {
            return this.executionLogWatcherActorRef$lzycompute();
        }
        return this.executionLogWatcherActorRef;
    }

    public void watch(String taskId, String executionId) {
        ExecutionLogWatchActor.StartWatch x$1 = new ExecutionLogWatchActor.StartWatch(taskId, executionId, User.AUTHENTICATED_USER.getName());
        ActorRef x$2 = this.executionLogWatcherActorRef().$bang$default$2((Object)x$1);
        this.executionLogWatcherActorRef().$bang((Object)x$1, x$2);
    }

    public void stopWatch(String executionId) {
        ExecutionLogWatchActor.StopWatching x$1 = new ExecutionLogWatchActor.StopWatching(executionId, (Option<String>)new Some((Object)User.AUTHENTICATED_USER.getName()));
        ActorRef x$2 = this.executionLogWatcherActorRef().$bang$default$2((Object)x$1);
        this.executionLogWatcherActorRef().$bang((Object)x$1, x$2);
    }

    public void fetch(String taskId, String executionId, OutputStream outputStream, long lastJob, long lastChunk) {
        new TaskExecutionLog(taskId, executionId).fetch(this.storageService, outputStream, lastJob, lastChunk);
    }

    public void pong(String executionId) {
        ExecutionLogWatchActor.Pong x$1 = new ExecutionLogWatchActor.Pong(executionId);
        ActorRef x$2 = this.executionLogWatcherActorRef().$bang$default$2((Object)x$1);
        this.executionLogWatcherActorRef().$bang((Object)x$1, x$2);
    }

    public List<TaskExecutionLogView> fetchAllExecutions(String taskId) {
        return CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(this.taskExecutionRepository.find(new TaskExecutionRepository.ByTaskId(taskId), Pageable.unpaged()).getContent()).asScala().zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                long l;
                TaskExecutionEntry row = (TaskExecutionEntry)tuple2._1();
                int index = tuple2._2$mcI$sp();
                TaskExecutionLogView view = new TaskExecutionLogView();
                view.setId(row.executionId());
                view.setExecutionNo(Predef$.MODULE$.int2Integer(index + 1));
                view.setLastJob(Predef$.MODULE$.long2Long((long)row.lastJob()));
                view.setLastChunk(Predef$.MODULE$.int2Integer(row.lastChunk()));
                Option option = Option$.MODULE$.apply((Object)row.lastModifiedDate());
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Instant date2 = (Instant)some.value();
                    l = date2.toEpochMilli();
                } else if (None$.MODULE$.equals(option)) {
                    l = Instant.now().toEpochMilli();
                } else {
                    throw new MatchError((Object)option);
                }
                long modifiedDate = l;
                view.setModifiedDate(Predef$.MODULE$.long2Long(modifiedDate));
                Option$.MODULE$.apply((Object)row.endDate()).foreach((Function1 & Serializable)date -> {
                    view.setEndDate(Predef$.MODULE$.long2Long(date.toEpochMilli()));
                    return BoxedUnit.UNIT;
                });
                return view;
            }
            throw new MatchError((Object)tuple2);
        })).asJava();
    }

    public void log(LogEntry logEntry) {
        String x$1 = "xlr-local";
        String x$2 = logEntry.copy$default$1();
        String x$3 = logEntry.copy$default$2();
        long x$4 = logEntry.copy$default$3();
        long x$5 = logEntry.copy$default$4();
        String x$6 = logEntry.copy$default$5();
        byte[] x$7 = logEntry.copy$default$6();
        LogEntry workerLogEntry = logEntry.copy(x$2, x$3, x$4, x$5, x$6, x$7, "xlr-local");
        URI storedEntryUri = this.storageService.store((StorageEntry)workerLogEntry);
        TaskStatus taskStatus = this.taskService.getStatus(logEntry.taskId());
        this.logger().debug((Function0 & Serializable)() -> "Adding log entry: " + logEntry + ", with task status: " + taskStatus);
        Option<TaskExecutionEntry> option = taskStatus.isOneOf(new TaskStatus[]{TaskStatus.COMPLETED, TaskStatus.SKIPPED, TaskStatus.ABORTED, TaskStatus.FAILED, TaskStatus.FAILING, TaskStatus.ABORT_SCRIPT_IN_PROGRESS, TaskStatus.FAILURE_HANDLER_IN_PROGRESS}) ? this.taskExecutionRepository.update(new TaskExecutionRepository.UpdateWithLogEntry(workerLogEntry, (Option<Instant>)new Some((Object)Instant.now()))) : this.taskExecutionRepository.update(new TaskExecutionRepository.UpdateWithLogEntry(workerLogEntry, (Option<Instant>)None$.MODULE$));
        this.broadcastService.broadcast(new TaskLogCreated(logEntry.taskId(), logEntry.executionId(), storedEntryUri), true);
    }

    public Option<TaskExecutionEntry> getTaskExecutionEntry(String taskId, String executionId) {
        return this.taskExecutionRepository.read(taskId, executionId);
    }

    @Subscribe
    public void onJobFinished(JobFinishedEvent event) {
        long jobId = event.jobId();
        String executionId = event.executionId();
        this.logger().debug((Function0 & Serializable)() -> "finishing job " + jobId);
        ExecutionLogWatchActor.Check x$1 = new ExecutionLogWatchActor.Check(executionId);
        ActorRef x$2 = this.executionLogWatcherActorRef().$bang$default$2((Object)x$1);
        this.executionLogWatcherActorRef().$bang((Object)x$1, x$2);
    }

    @Subscribe
    public void onTaskLogCreated(TaskLogCreated taskLogEvent) {
        this.logger().debug((Function0 & Serializable)() -> "processing log event " + taskLogEvent);
        ExecutionLogWatchActor.NewEntry x$1 = new ExecutionLogWatchActor.NewEntry(taskLogEvent.executionId(), taskLogEvent.uri());
        ActorRef x$2 = this.executionLogWatcherActorRef().$bang$default$2((Object)x$1);
        this.executionLogWatcherActorRef().$bang((Object)x$1, x$2);
    }

    @Subscribe
    public void onTaskExecutionDone(TaskJobExecutedEvent event) {
        TaskExecutionRepository.FinishExecution finishExecution = new TaskExecutionRepository.FinishExecution(event.taskId(), event.executionId(), Instant.now());
        this.taskExecutionRepository.update(finishExecution);
    }

    public TaskExecutionLogService(SpringExtension springExtension, BroadcastService broadcastService, StorageService storageService, TaskService taskService, TaskExecutionRepository taskExecutionRepository) {
        this.springExtension = springExtension;
        this.broadcastService = broadcastService;
        this.storageService = storageService;
        this.taskService = taskService;
        this.taskExecutionRepository = taskExecutionRepository;
        Logging.$init$((Logging)this);
    }
}

