/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.Link;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskGroup;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(label="Parallel Group", versioned=false)
public class ParallelGroup
extends TaskGroup {
    @Property(asContainment=true, required=false)
    protected Set<Link> links = Sets.newHashSet();

    @Override
    @PublicApiMember
    public void setTasks(List<Task> tasks) {
        this.tasks = tasks;
    }

    @PublicApiMember
    public Set<Link> getLinks() {
        return this.links;
    }

    @PublicApiMember
    public void setLinks(Set<Link> links) {
        this.links = links;
    }

    public List<Link> getLinksOf(Task task) {
        return this.links.stream().filter(link -> link.references(task)).collect(Collectors.toList());
    }

    public List<Task> getPlanningTargetsOf(Task task) {
        List targetLinks = this.links.stream().filter(link -> link.hasSource(task)).collect(Collectors.toList());
        return targetLinks.stream().map(Link::getTarget).collect(Collectors.toList());
    }

    public List<Task> getPlanningSourceOf(Task task) {
        List sourceLinks = this.links.stream().filter(link -> link.hasTarget(task)).collect(Collectors.toList());
        return sourceLinks.stream().map(Link::getSource).collect(Collectors.toList());
    }

    @Override
    protected Changes tryToStartPlanningTargets(Task task) {
        Changes changes = new Changes();
        for (Task target : this.getPlanningTargetsOf(task)) {
            if (this.hasActiveSource(target) || target.isDefunct()) continue;
            changes.addAll(target.start());
            if (!target.isDone()) continue;
            changes.addAll(this.tryToStartPlanningTargets(target));
        }
        return changes;
    }

    private boolean hasActiveSource(Task task) {
        List<Task> sources = this.getPlanningSourceOf(task);
        return sources.stream().anyMatch(source -> !source.isDefunct());
    }

    @Override
    protected Changes startSubTasksIfPreconditionNotInProgress() {
        Changes changes = new Changes();
        if (this.isPreconditionInProgress() || this.isFacetInProgress()) {
            return changes;
        }
        for (Task subTask : this.tasks) {
            if (!this.getPlanningSourceOf(subTask).isEmpty()) continue;
            changes.addAll(subTask.start());
            if (!subTask.isDone()) continue;
            changes.addAll(this.tryToStartPlanningTargets(subTask));
        }
        return changes;
    }

    public Link findLink(String linkId) {
        return this.links.stream().filter(link -> link.getId().equals(linkId)).findFirst().orElseGet(null);
    }
}

