/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.typesafe.config.Config;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlplatform.cluster.ClusterConfig;
import com.xebialabs.xlplatform.cluster.XlCluster$;
import com.xebialabs.xlplatform.cluster.XlClusterProvider;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.config.XlrConfig$;
import com.xebialabs.xlrelease.events.AsyncSubscribe;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.service.ArchiveCredentialsValidator;
import com.xebialabs.xlrelease.service.BroadcastService;
import com.xebialabs.xlrelease.service.DbConnectingCredentialsValidator;
import com.xebialabs.xlrelease.service.DbCredentialsChangeRequested;
import com.xebialabs.xlrelease.service.DbCredentialsChangeResult;
import com.xebialabs.xlrelease.service.DbCredentialsService$;
import com.xebialabs.xlrelease.service.RepositoryCredentialsValidator;
import com.xebialabs.xlrelease.service.XlrDatabase$;
import com.xebialabs.xlrelease.utils.ConfigEntry;
import com.xebialabs.xlrelease.utils.ConfigUtils$;
import com.xebialabs.xlrelease.utils.ResourceUtils$;
import com.zaxxer.hikari.HikariDataSource;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Component
@EventListener
@ScalaSignature(bytes="\u0006\u0005\u0005%x!\u0002\u000e\u001c\u0011\u0003!c!\u0002\u0014\u001c\u0011\u00039\u0003\"\u0002\u0018\u0002\t\u0003y\u0003b\u0002\u0019\u0002\u0005\u0004%\t!\r\u0005\u0007u\u0005\u0001\u000b\u0011\u0002\u001a\t\u000fm\n!\u0019!C\u0001c!1A(\u0001Q\u0001\nIBq!P\u0001C\u0002\u0013\u0005\u0011\u0007\u0003\u0004?\u0003\u0001\u0006IA\r\u0005\b\u007f\u0005\u0011\r\u0011\"\u00012\u0011\u0019\u0001\u0015\u0001)A\u0005e!)\u0011)\u0001C\u0001\u0005\")q*\u0001C\u0001!\")A+\u0001C\u0001+\u001a!ae\u0007\u0001X\u0011!\u0001gB!A!\u0002\u0013\t\u0007\u0002C>\u000f\u0005\u0003\u0005\u000b\u0011B1\t\u0013}t!\u0011!Q\u0001\n\u0005\u0005\u0001B\u0002\u0018\u000f\t\u0003\t9\u0001C\u0004\u0002\u00169!\t!a\u0006\t\u000f\u0005]b\u0002\"\u0001\u0002:!9\u0011q\u000b\b\u0005\u0002\u0005e\u0003bBA6\u001d\u0011%\u0011Q\u000e\u0005\b\u0003\u007frA\u0011BAA\u0011\u001d\t\u0019J\u0004C\u0005\u0003+Cq!a+\u000f\t\u0013\ti+\u0001\u000bEE\u000e\u0013X\rZ3oi&\fGn]*feZL7-\u001a\u0006\u00039u\tqa]3sm&\u001cWM\u0003\u0002\u001f?\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003A\u0005\n\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003\t\n1aY8n\u0007\u0001\u0001\"!J\u0001\u000e\u0003m\u0011A\u0003\u00122De\u0016$WM\u001c;jC2\u001c8+\u001a:wS\u000e,7CA\u0001)!\tIC&D\u0001+\u0015\u0005Y\u0013!B:dC2\f\u0017BA\u0017+\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001J\u0001\u0017I\u0006$\u0018MY1tKV\u001bXM]\"p]\u001aLw\rU1uQV\t!\u0007\u0005\u00024q5\tAG\u0003\u00026m\u0005!A.\u00198h\u0015\u00059\u0014\u0001\u00026bm\u0006L!!\u000f\u001b\u0003\rM#(/\u001b8h\u0003]!\u0017\r^1cCN,Wk]3s\u0007>tg-[4QCRD\u0007%\u0001\u000eeCR\f'-Y:f!\u0006\u001c8o^8sI\u000e{gNZ5h!\u0006$\b.A\u000eeCR\f'-Y:f!\u0006\u001c8o^8sI\u000e{gNZ5h!\u0006$\b\u000eI\u0001\u0018e\u0016\u0004xN\u001d;j]\u001e,6/\u001a:D_:4\u0017n\u001a)bi\"\f\u0001D]3q_J$\u0018N\\4Vg\u0016\u00148i\u001c8gS\u001e\u0004\u0016\r\u001e5!\u0003m\u0011X\r]8si&tw\rU1tg^|'\u000fZ\"p]\u001aLw\rU1uQ\u0006a\"/\u001a9peRLgn\u001a)bgN<xN\u001d3D_:4\u0017n\u001a)bi\"\u0004\u0013AD:vG\u000e,7o]'fgN\fw-\u001a\u000b\u0003\u00076\u0003\"\u0001R&\u000f\u0005\u0015K\u0005C\u0001$+\u001b\u00059%B\u0001%$\u0003\u0019a$o\\8u}%\u0011!JK\u0001\u0007!J,G-\u001a4\n\u0005eb%B\u0001&+\u0011\u0015q5\u00021\u0001D\u0003\u0019!'MT1nK\u0006I\u0012N\u001c<bY&$7I]3eK:$\u0018.\u00197t\u001b\u0016\u001c8/Y4f)\r\u0019\u0015K\u0015\u0005\u0006\u001d2\u0001\ra\u0011\u0005\u0006'2\u0001\raQ\u0001\b[\u0016\u001c8/Y4f\u0003QIgN^1mS\u0012$%MT1nK6+7o]1hKR\u00111I\u0016\u0005\u0006\u001d6\u0001\raQ\n\u0004\u001d!B\u0006CA-_\u001b\u0005Q&BA.]\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005i\u0016\u0001C4sSjTH.\u001a3\n\u0005}S&a\u0002'pO\u001eLgnZ\u0001\u0018q2\u0014(+\u001a9pg&$xN]=ECR\f7k\\;sG\u0016\u0004\"AY4\u000e\u0003\rT!\u0001Z3\u0002\r!L7.\u0019:j\u0015\t1\u0017%\u0001\u0004{CbDXM]\u0005\u0003Q\u000e\u0014\u0001\u0003S5lCJLG)\u0019;b'>,(oY3)\t=Q\u00070\u001f\t\u0003WZl\u0011\u0001\u001c\u0006\u0003[:\f!\"\u00198o_R\fG/[8o\u0015\ty\u0007/A\u0004gC\u000e$xN]=\u000b\u0005E\u0014\u0018!\u00022fC:\u001c(BA:u\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"A;\u0002\u0007=\u0014x-\u0003\u0002xY\nI\u0011+^1mS\u001aLWM]\u0001\u0006m\u0006dW/Z\u0011\u0002u\u00069\"/Y<SKB|7/\u001b;pef$\u0015\r^1T_V\u00148-Z\u0001\u0014e\u0016\u0004xN\u001d;j]\u001e$\u0015\r^1T_V\u00148-\u001a\u0015\u0005!)DX0I\u0001\u007f\u0003Y\u0011\u0018m\u001e*fa>\u0014H/\u001b8h\t\u0006$\u0018mU8ve\u000e,\u0017\u0001\u00052s_\u0006$7-Y:u'\u0016\u0014h/[2f!\r)\u00131A\u0005\u0004\u0003\u000bY\"\u0001\u0005\"s_\u0006$7-Y:u'\u0016\u0014h/[2f)!\tI!a\u0003\u0002\u0010\u0005M\u0001CA\u0013\u000f\u0011\u0015\u0001'\u00031\u0001bQ\u0015\tYA\u001b=z\u0011\u0015Y(\u00031\u0001bQ\u0015\tyA\u001b=~\u0011\u0019y(\u00031\u0001\u0002\u0002\u0005qrN\u001c#c\u0007J,G-\u001a8uS\u0006d7o\u00115b]\u001e,'+Z9vKN$X\r\u001a\u000b\u0005\u00033\ty\u0002E\u0002*\u00037I1!!\b+\u0005\u0011)f.\u001b;\t\u000f\u0005\u00052\u00031\u0001\u0002$\u0005)QM^3oiB\u0019Q%!\n\n\u0007\u0005\u001d2D\u0001\u000fEE\u000e\u0013X\rZ3oi&\fGn]\"iC:<WMU3rk\u0016\u001cH/\u001a3)\u0007M\tY\u0003\u0005\u0003\u0002.\u0005MRBAA\u0018\u0015\r\t\t$H\u0001\u0007KZ,g\u000e^:\n\t\u0005U\u0012q\u0006\u0002\u000f\u0003NLhnY*vEN\u001c'/\u001b2f\u0003M)\b\u000fZ1uK\u0012\u00137I]3eK:$\u0018.\u00197t)!\tI\"a\u000f\u0002@\u0005\r\u0003BBA\u001f)\u0001\u00071)\u0001\u0005vg\u0016\u0014h.Y7f\u0011\u0019\t\t\u0005\u0006a\u0001\u0007\u0006A\u0001/Y:to>\u0014H\rC\u0004\u0002FQ\u0001\r!a\u0012\u0002\u0011\u0011\fG/\u00192bg\u0016\u0004B!!\u0013\u0002P9\u0019Q%a\u0013\n\u0007\u000553$A\u0006YYJ$\u0015\r^1cCN,\u0017\u0002BA)\u0003'\u0012QAV1mk\u0016L1!!\u0016+\u0005-)e.^7fe\u0006$\u0018n\u001c8\u0002UY\fG.\u001b3bi\u0016\fe\u000e\u001a)vE2L7\u000f[\"sK\u0012,g\u000e^5bYN\u001c\u0005.\u00198hKJ+\u0017/^3tiRA\u00111LA1\u0003K\nI\u0007E\u0002&\u0003;J1!a\u0018\u001c\u0005e!%m\u0011:fI\u0016tG/[1mg\u000eC\u0017M\\4f%\u0016\u001cX\u000f\u001c;\t\r\u0005\rT\u00031\u0001D\u0003)!'-V:fe:\fW.\u001a\u0005\u0007\u0003O*\u0002\u0019A\"\u0002\u0015\u0011\u0014\u0007+Y:to>\u0014H\rC\u0003O+\u0001\u00071)\u0001\tva\u0012\fG/\u001a#bi\u0006\u001cv.\u001e:dKR1\u0011\u0011DA8\u0003cBq!!\u0012\u0017\u0001\u0004\t9\u0005C\u0004\u0002tY\u0001\r!!\u001e\u0002\r\r|gNZ5h!\u0011\t9(a\u001f\u000e\u0005\u0005e$bAA:;%!\u0011QPA=\u0005%AFN]\"p]\u001aLw-A\u0005wC2LG-\u0019;peR!\u00111QAH!\u0015I\u0013QQAE\u0013\r\t9I\u000b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007\u0015\nY)C\u0002\u0002\u000en\u0011\u0001\u0005\u00122D_:tWm\u0019;j]\u001e\u001c%/\u001a3f]RL\u0017\r\\:WC2LG-\u0019;pe\"1\u0011\u0011S\fA\u0002\r\u000bA\u0002\u001a2OC6,7\u000b\u001e:j]\u001e\f1c]3u\u001d\u0016<8I]3eK:$\u0018.\u00197t\u001f:$\u0002\"a&\u0002$\u0006\u001d\u0016\u0011\u0016\t\u0007\u00033\u000by*!\u0007\u000e\u0005\u0005m%bAAOU\u0005!Q\u000f^5m\u0013\u0011\t\t+a'\u0003\u0007Q\u0013\u0018\u0010\u0003\u0004\u0002&b\u0001\r!Y\u0001\u000bI\u0006$\u0018mU8ve\u000e,\u0007BBA21\u0001\u00071\t\u0003\u0004\u0002ha\u0001\raQ\u0001\u0014GJ,\u0017\r^3D_:4\u0017nZ#oiJLWm\u001d\u000b\t\u0003_\u000bi-a4\u0002RB1\u0011\u0011WA^\u0003\u0003tA!a-\u00028:\u0019a)!.\n\u0003-J1!!/+\u0003\u001d\u0001\u0018mY6bO\u0016LA!!0\u0002@\n\u00191+Z9\u000b\u0007\u0005e&\u0006\u0005\u0003\u0002D\u0006%WBAAc\u0015\r\t9-H\u0001\u0006kRLGn]\u0005\u0005\u0003\u0017\f)MA\u0006D_:4\u0017nZ#oiJL\bBBA\u001f3\u0001\u00071\t\u0003\u0004\u0002Be\u0001\ra\u0011\u0005\b\u0003\u000bJ\u0002\u0019AA$Q\rq\u0011Q\u001b\t\u0005\u0003[\t9.\u0003\u0003\u0002Z\u0006=\"!D#wK:$H*[:uK:,'\u000fK\u0002\u000f\u0003;\u0004B!a8\u0002f6\u0011\u0011\u0011\u001d\u0006\u0004\u0003G\u0014\u0018AC:uKJ,w\u000e^=qK&!\u0011q]Aq\u0005%\u0019u.\u001c9p]\u0016tG\u000f")
public class DbCredentialsService
implements Logging {
    @Qualifier(value="rawRepositoryDataSource")
    private final HikariDataSource xlrRepositoryDataSource;
    @Qualifier(value="rawReportingDataSource")
    private final HikariDataSource reportingDataSource;
    private final BroadcastService broadcastService;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public static String invalidDbNameMessage(String dbName) {
        return DbCredentialsService$.MODULE$.invalidDbNameMessage(dbName);
    }

    public static String invalidCredentialsMessage(String dbName, String message) {
        return DbCredentialsService$.MODULE$.invalidCredentialsMessage(dbName, message);
    }

    public static String successMessage(String dbName) {
        return DbCredentialsService$.MODULE$.successMessage(dbName);
    }

    public static String reportingPasswordConfigPath() {
        return DbCredentialsService$.MODULE$.reportingPasswordConfigPath();
    }

    public static String reportingUserConfigPath() {
        return DbCredentialsService$.MODULE$.reportingUserConfigPath();
    }

    public static String databasePasswordConfigPath() {
        return DbCredentialsService$.MODULE$.databasePasswordConfigPath();
    }

    public static String databaseUserConfigPath() {
        return DbCredentialsService$.MODULE$.databaseUserConfigPath();
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DbCredentialsService dbCredentialsService = this;
        synchronized (dbCredentialsService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @AsyncSubscribe
    public void onDbCredentialsChangeRequested(DbCredentialsChangeRequested event) {
        this.updateDbCredentials(event.dbUsername(), event.dbPassword(), event.database());
    }

    public void updateDbCredentials(String username, String password, Enumeration.Value database) {
        Option<File> option = ResourceUtils$.MODULE$.findFirstInClassPath(XlrConfig$.MODULE$.defaultConfigName());
        if (option instanceof Some) {
            Some some = (Some)option;
            File file = (File)some.value();
            Seq<ConfigEntry> configEntries = this.createConfigEntries(username, password, database);
            Config updatedConfig = ConfigUtils$.MODULE$.updateConfig(XlrConfig$.MODULE$.defaultConfigName(), configEntries);
            Try<Path> try_ = ConfigUtils$.MODULE$.writeToFile(file, updatedConfig);
            if (try_ instanceof Success) {
                XlrConfig$.MODULE$.reloadConfig(XlrConfig$.MODULE$.reloadConfig$default$1());
                this.updateDataSource(database, XlrConfig$.MODULE$.getInstance());
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable ex = failure.exception();
                this.logger().error((Function0 & Serializable)() -> "Unable to update DB credentials on " + database, (Function0 & Serializable)() -> ex);
            } else {
                throw new MatchError(try_);
            }
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.warn((Function0<Object>)(Function0 & Serializable)() -> "Configuration file " + XlrConfig$.MODULE$.defaultConfigName() + " cannot be found in file system. Updating the DB credentials aborted!");
            return;
        }
        throw new MatchError(option);
    }

    public DbCredentialsChangeResult validateAndPublishCredentialsChangeRequest(String dbUsername, String dbPassword, String dbName) {
        Option<DbConnectingCredentialsValidator> option = this.validator(dbName);
        if (option instanceof Some) {
            Some some = (Some)option;
            DbConnectingCredentialsValidator validator = (DbConnectingCredentialsValidator)some.value();
            Try<?> try_ = validator.validate(dbUsername, dbPassword);
            if (try_ instanceof Success) {
                String encryptedPassword = PasswordEncrypter.getInstance().encrypt(dbPassword);
                this.broadcastService.broadcast(new DbCredentialsChangeRequested(dbUsername, encryptedPassword, XlrDatabase$.MODULE$.withName(dbName)), true);
                return new DbCredentialsChangeResult(true, DbCredentialsService$.MODULE$.successMessage(dbName));
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable ex = failure.exception();
                this.logger().error((Function0 & Serializable)() -> "Invalid db credentials. Update did not happen.", (Function0 & Serializable)() -> ex);
                return new DbCredentialsChangeResult(false, DbCredentialsService$.MODULE$.invalidCredentialsMessage(dbName, ex.getMessage()));
            }
            throw new MatchError(try_);
        }
        if (None$.MODULE$.equals(option)) {
            return new DbCredentialsChangeResult(false, DbCredentialsService$.MODULE$.invalidDbNameMessage(dbName));
        }
        throw new MatchError(option);
    }

    private void updateDataSource(Enumeration.Value database, XlrConfig config) {
        Enumeration.Value value = database;
        Enumeration.Value value2 = XlrDatabase$.MODULE$.REPOSITORY();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            Try<BoxedUnit> try_ = this.setNewCredentialsOn(this.xlrRepositoryDataSource, config.xlrRepositoryUsername(), config.xlrRepositoryPassword());
            if (try_ instanceof Success) {
                if (XlCluster$.MODULE$.getXlClusterProvider().isDefined()) {
                    ClusterConfig clusterConfig = XlrConfig$.MODULE$.getInstance().cluster();
                    ((XlClusterProvider)XlCluster$.MODULE$.getXlClusterProvider().get()).doWithDatasource((Function1 & Serializable)dataSource -> {
                        DbCredentialsService.$anonfun$updateDataSource$1(this, clusterConfig, dataSource);
                        return BoxedUnit.UNIT;
                    });
                }
                this.logger().info((Function0 & Serializable)() -> "Repository database credentials successfully updated");
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                this.logger().warn((Function0 & Serializable)() -> "Error updating repository DB credentials", (Function0 & Serializable)() -> exception);
            } else {
                throw new MatchError(try_);
            }
            return;
        }
        Enumeration.Value value4 = XlrDatabase$.MODULE$.ARCHIVE();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            Try<BoxedUnit> try_ = this.setNewCredentialsOn(this.reportingDataSource, config.reportingUsername(), config.reportingPassword());
            if (try_ instanceof Success) {
                this.logger().info((Function0 & Serializable)() -> "Archive database credentials successfully updated");
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                this.logger().warn((Function0 & Serializable)() -> "Error updating archive DB credentials", (Function0 & Serializable)() -> exception);
            } else {
                throw new MatchError(try_);
            }
            return;
        }
        throw new MatchError((Object)value);
    }

    private Option<DbConnectingCredentialsValidator> validator(String dbNameString) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> XlrDatabase$.MODULE$.withName(dbNameString));
        if (try_ instanceof Success) {
            Enumeration.Value dbName;
            Success success = (Success)try_;
            Enumeration.Value value = dbName = (Enumeration.Value)success.value();
            Enumeration.Value value2 = XlrDatabase$.MODULE$.REPOSITORY();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                return new Some((Object)new RepositoryCredentialsValidator(XlrConfig$.MODULE$.getInstance().xlrRepositoryJdbcUrl()));
            }
            Enumeration.Value value4 = XlrDatabase$.MODULE$.ARCHIVE();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                return new Some((Object)new ArchiveCredentialsValidator(XlrConfig$.MODULE$.getInstance().reportingUrl()));
            }
            throw new MatchError((Object)value);
        }
        if (try_ instanceof Failure) {
            return None$.MODULE$;
        }
        throw new MatchError((Object)try_);
    }

    private Try<BoxedUnit> setNewCredentialsOn(HikariDataSource dataSource, String dbUsername, String dbPassword) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            dataSource.getHikariPoolMXBean().suspendPool();
            dataSource.getHikariConfigMXBean().setUsername(dbUsername);
            dataSource.getHikariConfigMXBean().setPassword(dbPassword);
            dataSource.getHikariPoolMXBean().softEvictConnections();
            dataSource.getHikariPoolMXBean().resumePool();
        });
    }

    private Seq<ConfigEntry> createConfigEntries(String username, String password, Enumeration.Value database) {
        Enumeration.Value value = database;
        Enumeration.Value value2 = XlrDatabase$.MODULE$.REPOSITORY();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            ConfigEntry usernameEntry = new ConfigEntry(DbCredentialsService$.MODULE$.databaseUserConfigPath(), username);
            ConfigEntry passwordEntry = new ConfigEntry(DbCredentialsService$.MODULE$.databasePasswordConfigPath(), password);
            return new .colon.colon((Object)usernameEntry, (List)new .colon.colon((Object)passwordEntry, (List)Nil$.MODULE$));
        }
        Enumeration.Value value4 = XlrDatabase$.MODULE$.ARCHIVE();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            ConfigEntry usernameEntry = new ConfigEntry(DbCredentialsService$.MODULE$.reportingUserConfigPath(), username);
            ConfigEntry passwordEntry = new ConfigEntry(DbCredentialsService$.MODULE$.reportingPasswordConfigPath(), password);
            return new .colon.colon((Object)usernameEntry, (List)new .colon.colon((Object)passwordEntry, (List)Nil$.MODULE$));
        }
        throw new RuntimeException("Unable to update " + database + " credentials");
    }

    public static final /* synthetic */ void $anonfun$updateDataSource$1(DbCredentialsService $this, ClusterConfig clusterConfig$1, HikariDataSource dataSource) {
        Try<BoxedUnit> try_ = $this.setNewCredentialsOn(dataSource, clusterConfig$1.membership().datasource().username(), clusterConfig$1.membership().datasource().password());
        if (try_ instanceof Success) {
            $this.logger().info((Function0 & Serializable)() -> "Cluster membership database credentials successfully updated");
            return;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            $this.logger().warn((Function0 & Serializable)() -> "Error updating cluster membership database credentials", (Function0 & Serializable)() -> exception);
            return;
        }
        throw new MatchError(try_);
    }

    public DbCredentialsService(@Qualifier(value="rawRepositoryDataSource") HikariDataSource xlrRepositoryDataSource, @Qualifier(value="rawReportingDataSource") HikariDataSource reportingDataSource, BroadcastService broadcastService) {
        this.xlrRepositoryDataSource = xlrRepositoryDataSource;
        this.reportingDataSource = reportingDataSource;
        this.broadcastService = broadcastService;
        Logging.$init$((Logging)this);
    }
}

