/*
 * Decompiled with CFR 0.152.
 */
package akka.persistence.query.internal;

import akka.actor.ActorSystem;
import akka.actor.ExtendedActorSystem;
import akka.annotation.InternalApi;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.persistence.query.NoOffset$;
import akka.persistence.query.Offset;
import akka.persistence.query.Offset$;
import akka.persistence.query.Sequence;
import akka.persistence.query.TimeBasedUUID;
import akka.persistence.query.TimestampOffset;
import akka.persistence.query.TimestampOffset$;
import akka.persistence.query.internal.protobuf.QueryMessages;
import akka.persistence.query.typed.EventEnvelope;
import akka.remote.serialization.WrappedPayloadSupport$;
import akka.serialization.BaseSerializer;
import akka.serialization.Serialization;
import akka.serialization.SerializationExtension$;
import akka.serialization.Serializer;
import akka.serialization.SerializerWithStringManifest;
import akka.serialization.Serializers$;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Base64;
import java.util.UUID;
import scala.;
import scala.$less$colon$less$;
import scala.Array;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005-d!\u0002\u000f\u001e\u0005\r*\u0003\u0002C\u0018\u0001\u0005\u000b\u0007I\u0011A\u0019\t\u0011a\u0002!\u0011!Q\u0001\nIBQ!\u000f\u0001\u0005\u0002iBqA\u0010\u0001C\u0002\u0013%q\b\u0003\u0004G\u0001\u0001\u0006I\u0001\u0011\u0005\tS\u0001A)\u0019!C\u0005\u000f\"91\n\u0001b\u0001\n\u001ba\u0005B\u0002)\u0001A\u00035Q\nC\u0004R\u0001\t\u0007IQ\u0002*\t\rY\u0003\u0001\u0015!\u0004T\u0011\u001d9\u0006A1A\u0005\u000eaCa\u0001\u0018\u0001!\u0002\u001bI\u0006bB/\u0001\u0005\u0004%iA\u0018\u0005\u0007E\u0002\u0001\u000bQB0\t\u000f\r\u0004!\u0019!C\u0007I\"1\u0001\u000e\u0001Q\u0001\u000e\u0015Dq!\u001b\u0001C\u0002\u0013%!\u000e\u0003\u0004r\u0001\u0001\u0006Ia\u001b\u0005\be\u0002\u0011\r\u0011\"\u0003k\u0011\u0019\u0019\b\u0001)A\u0005W\")A\u000f\u0001C!k\"9\u0011Q\u0002\u0001\u0005B\u0005=\u0001bBA\u0010\u0001\u0011\u0005\u0013\u0011\u0005\u0005\b\u0003S\u0001A\u0011BA\u0016\u0011\u001d\tY\u0004\u0001C\u0005\u0003{Aq!!\u0013\u0001\t\u0013\tY\u0005C\u0004\u0002X\u0001!I!!\u0017\u0003\u001fE+XM]=TKJL\u0017\r\\5{KJT!AH\u0010\u0002\u0011%tG/\u001a:oC2T!\u0001I\u0011\u0002\u000bE,XM]=\u000b\u0005\t\u001a\u0013a\u00039feNL7\u000f^3oG\u0016T\u0011\u0001J\u0001\u0005C.\\\u0017mE\u0002\u0001M1\u0002\"a\n\u0016\u000e\u0003!R!!K\u0012\u0002\u001bM,'/[1mSj\fG/[8o\u0013\tY\u0003F\u0001\u000fTKJL\u0017\r\\5{KJ<\u0016\u000e\u001e5TiJLgnZ'b]&4Wm\u001d;\u0011\u0005\u001dj\u0013B\u0001\u0018)\u00059\u0011\u0015m]3TKJL\u0017\r\\5{KJ\faa]=ti\u0016l7\u0001A\u000b\u0002eA\u00111GN\u0007\u0002i)\u0011QgI\u0001\u0006C\u000e$xN]\u0005\u0003oQ\u00121#\u0012=uK:$W\rZ!di>\u00148+_:uK6\fqa]=ti\u0016l\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0003wu\u0002\"\u0001\u0010\u0001\u000e\u0003uAQaL\u0002A\u0002I\n1\u0001\\8h+\u0005\u0001\u0005CA!E\u001b\u0005\u0011%BA\"$\u0003\u0015)g/\u001a8u\u0013\t)%I\u0001\bM_\u001e<\u0017N\\4BI\u0006\u0004H/\u001a:\u0002\t1|w\rI\u000b\u0002\u0011B\u0011q%S\u0005\u0003\u0015\"\u0012QbU3sS\u0006d\u0017N_1uS>t\u0017!F#wK:$XI\u001c<fY>\u0004X-T1oS\u001a,7\u000f^\u000b\u0002\u001b>\ta*I\u0001P\u0003\u0005\t\u0017AF#wK:$XI\u001c<fY>\u0004X-T1oS\u001a,7\u000f\u001e\u0011\u0002-M+\u0017/^3oG\u0016|eMZ:fi6\u000bg.\u001b4fgR,\u0012aU\b\u0002)\u0006\nQ+A\u0002T\u000bF\u000bqcU3rk\u0016t7-Z(gMN,G/T1oS\u001a,7\u000f\u001e\u0011\u00027QKW.\u001a\"bg\u0016$W+V%E\u001f\u001a47/\u001a;NC:Lg-Z:u+\u0005Iv\"\u0001.\"\u0003m\u000b1\u0001\u0016\"V\u0003q!\u0016.\\3CCN,G-V+J\t>3gm]3u\u001b\u0006t\u0017NZ3ti\u0002\nq\u0003V5nKN$\u0018-\u001c9PM\u001a\u001cX\r^'b]&4Wm\u001d;\u0016\u0003}{\u0011\u0001Y\u0011\u0002C\u0006\u0019AkU(\u00021QKW.Z:uC6\u0004xJ\u001a4tKRl\u0015M\\5gKN$\b%\u0001\tO_>3gm]3u\u001b\u0006t\u0017NZ3tiV\tQmD\u0001gC\u00059\u0017A\u0001(P\u0003Equn\u00144gg\u0016$X*\u00198jM\u0016\u001cH\u000fI\u0001\u0012[\u0006t\u0017NZ3tiN+\u0007/\u0019:bi>\u0014X#A6\u0011\u00051|W\"A7\u000b\u00039\fQa]2bY\u0006L!\u0001]7\u0003\t\rC\u0017M]\u0001\u0013[\u0006t\u0017NZ3tiN+\u0007/\u0019:bi>\u0014\b%\u0001\ruS6,7\u000f^1na>3gm]3u'\u0016\u0004\u0018M]1u_J\f\u0011\u0004^5nKN$\u0018-\u001c9PM\u001a\u001cX\r^*fa\u0006\u0014\u0018\r^8sA\u0005AQ.\u00198jM\u0016\u001cH\u000fF\u0002w\u0003\u0007\u0001\"a\u001e@\u000f\u0005ad\bCA=n\u001b\u0005Q(BA>1\u0003\u0019a$o\\8u}%\u0011Q0\\\u0001\u0007!J,G-\u001a4\n\u0007}\f\tA\u0001\u0004TiJLgn\u001a\u0006\u0003{6Dq!!\u0002\u0016\u0001\u0004\t9!A\u0001p!\ra\u0017\u0011B\u0005\u0004\u0003\u0017i'AB!osJ+g-\u0001\u0005u_\nKg.\u0019:z)\u0011\t\t\"!\b\u0011\u000b1\f\u0019\"a\u0006\n\u0007\u0005UQNA\u0003BeJ\f\u0017\u0010E\u0002m\u00033I1!a\u0007n\u0005\u0011\u0011\u0015\u0010^3\t\u000f\u0005\u0015a\u00031\u0001\u0002\b\u0005QaM]8n\u0005&t\u0017M]=\u0015\r\u0005\u001d\u00111EA\u0014\u0011\u001d\t)c\u0006a\u0001\u0003#\tQAY=uKNDQ\u0001^\fA\u0002Y\f\u0011D\u001a:p[N#xN]1hKJ+\u0007O]3tK:$\u0018\r^5p]R1\u0011QFA\u001b\u0003s\u0001B!a\f\u000225\tq$C\u0002\u00024}\u0011aa\u00144gg\u0016$\bBBA\u001c1\u0001\u0007a/A\u0005pM\u001a\u001cX\r^*ue\")A\u000f\u0007a\u0001m\u00069Bo\\*u_J\fw-\u001a*faJ,7/\u001a8uCRLwN\u001c\u000b\u0005\u0003\u007f\t)\u0005E\u0003m\u0003\u00032h/C\u0002\u0002D5\u0014a\u0001V;qY\u0016\u0014\u0004bBA$3\u0001\u0007\u0011QF\u0001\u0007_\u001a47/\u001a;\u0002QQLW.Z:uC6\u0004xJ\u001a4tKR4%o\\7Ti>\u0014\u0018mZ3SKB\u0014Xm]3oi\u0006$\u0018n\u001c8\u0015\t\u00055\u00131\u000b\t\u0005\u0003_\ty%C\u0002\u0002R}\u0011q\u0002V5nKN$\u0018-\u001c9PM\u001a\u001cX\r\u001e\u0005\u0007\u0003+R\u0002\u0019\u0001<\u0002\u0007M$(/\u0001\u0014uS6,7\u000f^1na>3gm]3u)>\u001cFo\u001c:bO\u0016\u0014V\r\u001d:fg\u0016tG/\u0019;j_:$2A^A.\u0011\u001d\t9e\u0007a\u0001\u0003\u001bB3\u0001AA0!\u0011\t\t'a\u001a\u000e\u0005\u0005\r$bAA3G\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005%\u00141\r\u0002\f\u0013:$XM\u001d8bY\u0006\u0003\u0018\u000e")
@InternalApi
public final class QuerySerializer
extends SerializerWithStringManifest
implements BaseSerializer {
    private Serialization serialization;
    private final ExtendedActorSystem system;
    private final LoggingAdapter log;
    private final char manifestSeparator;
    private final char timestampOffsetSeparator;
    private int identifier;
    private volatile boolean bitmap$0;

    @InternalApi
    public int identifierFromConfig() {
        return BaseSerializer.identifierFromConfig$((BaseSerializer)this);
    }

    public int identifier() {
        return this.identifier;
    }

    public void akka$serialization$BaseSerializer$_setter_$identifier_$eq(int x$1) {
        this.identifier = x$1;
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    private LoggingAdapter log() {
        return this.log;
    }

    private Serialization serialization$lzycompute() {
        QuerySerializer querySerializer = this;
        synchronized (querySerializer) {
            if (!this.bitmap$0) {
                this.serialization = (Serialization)SerializationExtension$.MODULE$.apply((ActorSystem)this.system());
                this.bitmap$0 = true;
            }
        }
        return this.serialization;
    }

    private Serialization serialization() {
        return !this.bitmap$0 ? this.serialization$lzycompute() : this.serialization;
    }

    private final String EventEnvelopeManifest() {
        return "a";
    }

    private final String SequenceOffsetManifest() {
        return "SEQ";
    }

    private final String TimeBasedUUIDOffsetManifest() {
        return "TBU";
    }

    private final String TimestampOffsetManifest() {
        return "TSO";
    }

    private final String NoOffsetManifest() {
        return "NO";
    }

    private char manifestSeparator() {
        return this.manifestSeparator;
    }

    private char timestampOffsetSeparator() {
        return this.timestampOffsetSeparator;
    }

    public String manifest(Object o) {
        String string;
        Object object = o;
        if (object instanceof EventEnvelope) {
            string = "a";
        } else if (object instanceof Offset) {
            Offset offset = (Offset)object;
            string = (String)this.toStorageRepresentation(offset)._2();
        } else {
            throw new IllegalArgumentException(new StringBuilder(37).append("Can't serialize object of type ").append(o.getClass()).append(" in [").append(this.getClass().getName()).append("]").toString());
        }
        return string;
    }

    public byte[] toBinary(Object o) {
        byte[] byArray;
        Object object = o;
        if (object instanceof EventEnvelope) {
            EventEnvelope eventEnvelope = (EventEnvelope)object;
            QueryMessages.EventEnvelope.Builder builder = QueryMessages.EventEnvelope.newBuilder();
            Tuple2<String, String> tuple2 = this.toStorageRepresentation(eventEnvelope.offset());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String offset = (String)tuple2._1();
            String offsetManifest = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)offset, (Object)offsetManifest);
            Tuple2 tuple23 = tuple22;
            String offset2 = (String)tuple23._1();
            String offsetManifest2 = (String)tuple23._2();
            builder.setPersistenceId(eventEnvelope.persistenceId()).setEntityType(eventEnvelope.entityType()).setSlice(eventEnvelope.slice()).setSequenceNr(eventEnvelope.sequenceNr()).setTimestamp(eventEnvelope.timestamp()).setOffset(offset2).setOffsetManifest(offsetManifest2);
            eventEnvelope.eventOption().foreach((Function1 & Serializable)event -> builder.setEvent(WrappedPayloadSupport$.MODULE$.payloadBuilder(event, this.serialization(), this.log())));
            eventEnvelope.eventMetadata().foreach((Function1 & Serializable)meta -> builder.setMetadata(WrappedPayloadSupport$.MODULE$.payloadBuilder(meta, this.serialization(), this.log())));
            byArray = builder.build().toByteArray();
        } else if (object instanceof Offset) {
            Offset offset = (Offset)object;
            byArray = ((String)this.toStorageRepresentation(offset)._1()).getBytes(StandardCharsets.UTF_8);
        } else {
            throw new IllegalArgumentException(new StringBuilder(34).append("Cannot serialize object of type [").append(o.getClass().getName()).append("]").toString());
        }
        return byArray;
    }

    public Object fromBinary(byte[] bytes, String manifest) {
        Object object;
        block3: {
            String string = manifest;
            switch (string == null ? 0 : string.hashCode()) {
                case 97: {
                    if (!"a".equals(string)) break;
                    QueryMessages.EventEnvelope env = QueryMessages.EventEnvelope.parseFrom(bytes);
                    Offset offset = this.fromStorageRepresentation(env.getOffset(), env.getOffsetManifest());
                    None$ eventOption = env.hasEvent() ? Option$.MODULE$.apply(WrappedPayloadSupport$.MODULE$.deserializePayload(env.getEvent(), this.serialization())) : None$.MODULE$;
                    None$ metaOption = env.hasMetadata() ? Option$.MODULE$.apply(WrappedPayloadSupport$.MODULE$.deserializePayload(env.getMetadata(), this.serialization())) : None$.MODULE$;
                    object = new EventEnvelope(offset, env.getPersistenceId(), env.getSequenceNr(), eventOption, env.getTimestamp(), (Option<Object>)metaOption, env.getEntityType(), env.getSlice());
                    break block3;
                }
            }
            object = this.fromStorageRepresentation(new String(bytes, StandardCharsets.UTF_8), manifest);
        }
        return object;
    }

    private Offset fromStorageRepresentation(String offsetStr, String manifest) {
        Offset offset;
        block9: {
            Offset offset2;
            Object object;
            String string = manifest;
            switch (string == null ? 0 : string.hashCode()) {
                case 2497: {
                    if (!"NO".equals(string)) break;
                    offset = NoOffset$.MODULE$;
                    break block9;
                }
                case 81983: {
                    if (!"SEQ".equals(string)) break;
                    offset = Offset$.MODULE$.sequence(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(offsetStr)));
                    break block9;
                }
                case 82855: {
                    if (!"TBU".equals(string)) break;
                    offset = Offset$.MODULE$.timeBasedUUID(UUID.fromString(offsetStr));
                    break block9;
                }
                case 83376: {
                    if (!"TSO".equals(string)) break;
                    offset = this.timestampOffsetFromStorageRepresentation(offsetStr);
                    break block9;
                }
            }
            String[] stringArray = StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(manifest), this.manifestSeparator());
            if (stringArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) == 0) {
                Offset offset3;
                String serializerIdStr = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
                String serializerManifest = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
                int serializerId = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(serializerIdStr));
                byte[] bytes = Base64.getDecoder().decode(offsetStr);
                Object object2 = this.serialization().deserialize(bytes, serializerId, serializerManifest).get();
                if (!(object2 instanceof Offset)) {
                    throw new NotSerializableException(new StringBuilder(0).append(new StringBuilder(77).append("Unimplemented deserialization of offset with serializerId [").append(serializerId).append("] and manifest [").append(manifest).append("] ").toString()).append(new StringBuilder(27).append("in [").append(this.getClass().getName()).append("]. [").append(object2.getClass().getName()).append("] is not an Offset.").toString()).toString());
                }
                offset2 = offset3 = (Offset)object2;
            } else {
                throw new NotSerializableException(new StringBuilder(0).append(new StringBuilder(57).append("Unimplemented deserialization of offset with manifest [").append(manifest).append("] ").toString()).append(new StringBuilder(36).append("in [").append(this.getClass().getName()).append("]. [").append(manifest).append("] doesn't contain two parts.").toString()).toString());
            }
            Offset offset4 = offset2;
            offset = offset4;
        }
        return offset;
    }

    private Tuple2<String, String> toStorageRepresentation(Offset offset) {
        Tuple2 tuple2;
        Offset offset2 = offset;
        if (offset2 instanceof TimestampOffset) {
            TimestampOffset timestampOffset = (TimestampOffset)offset2;
            tuple2 = new Tuple2((Object)this.timestampOffsetToStorageRepresentation(timestampOffset), (Object)"TSO");
        } else if (offset2 instanceof Sequence) {
            Sequence sequence = (Sequence)offset2;
            tuple2 = new Tuple2((Object)Long.toString(sequence.value()), (Object)"SEQ");
        } else if (offset2 instanceof TimeBasedUUID) {
            TimeBasedUUID timeBasedUUID = (TimeBasedUUID)offset2;
            tuple2 = new Tuple2((Object)timeBasedUUID.value().toString(), (Object)"TBU");
        } else if (NoOffset$.MODULE$.equals(offset2)) {
            tuple2 = new Tuple2((Object)"", (Object)"NO");
        } else {
            Offset obj = offset;
            Serializer serializer = this.serialization().findSerializerFor((Object)obj);
            int serializerId = serializer.identifier();
            String serializerManifest = Serializers$.MODULE$.manifestFor(serializer, (Object)obj);
            byte[] bytes = serializer.toBinary((Object)obj);
            String offsetStr = Base64.getEncoder().encodeToString(bytes);
            if (StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(serializerManifest), this.manifestSeparator())) {
                throw new IllegalArgumentException(new StringBuilder(0).append(new StringBuilder(27).append("Serializer manifest [").append(serializerManifest).append("] for ").toString()).append(new StringBuilder(40).append("offset [").append(offset.getClass().getName()).append("] must not contain [").append(this.manifestSeparator()).append("] character.").toString()).toString());
            }
            tuple2 = new Tuple2((Object)offsetStr, (Object)new StringBuilder(0).append(serializerId).append(this.manifestSeparator()).append(serializerManifest).toString());
        }
        return tuple2;
    }

    private TimestampOffset timestampOffsetFromStorageRepresentation(String str) {
        TimestampOffset timestampOffset;
        try {
            Object object;
            Object object2;
            TimestampOffset timestampOffset2;
            Object object3;
            String[] stringArray = StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(str), this.timestampOffsetSeparator());
            if (stringArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object3 = Array$.MODULE$.unapplySeq((Object)stringArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object3)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object3), 4) == 0) {
                String timestamp = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object3), 0);
                String readTimestamp = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object3), 1);
                String pid = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object3), 2);
                String seqNr = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object3), 3);
                timestampOffset2 = new TimestampOffset(Instant.parse(timestamp), Instant.parse(readTimestamp), (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)pid), (Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(seqNr))))}))));
            } else if (stringArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object2 = Array$.MODULE$.unapplySeq((Object)stringArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2), 1) == 0) {
                String timestamp = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2), 0);
                timestampOffset2 = TimestampOffset$.MODULE$.apply(Instant.parse(timestamp), (Map<String, Object>)Predef$.MODULE$.Map().empty());
            } else if (stringArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) == 0) {
                String timestamp = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
                String readTimestamp = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
                timestampOffset2 = new TimestampOffset(Instant.parse(timestamp), Instant.parse(readTimestamp), (Map<String, Object>)Predef$.MODULE$.Map().empty());
            } else {
                Map seen = Predef$.MODULE$.wrapRefArray((Object[])stringArray).toList().drop(2).grouped(2).map((Function1 & Serializable)x0$1 -> {
                    String seqNr;
                    String pid;
                    block3: {
                        block2: {
                            List list = x0$1;
                            if (!(list instanceof .colon.colon)) break block2;
                            .colon.colon colon2 = (.colon.colon)list;
                            pid = (String)colon2.head();
                            List list2 = colon2.next$access$1();
                            if (!(list2 instanceof .colon.colon)) break block2;
                            .colon.colon colon3 = (.colon.colon)list2;
                            seqNr = (String)colon3.head();
                            List list3 = colon3.next$access$1();
                            Nil$ nil$ = package$.MODULE$.Nil();
                            List list4 = list3;
                            if (!(nil$ != null ? !nil$.equals(list4) : list4 != null)) break block3;
                        }
                        throw new IllegalArgumentException(new StringBuilder(46).append("Invalid representation of Map(pid -> seqNr) [").append(Predef$.MODULE$.wrapRefArray((Object[])stringArray).toList().drop(1).mkString(",")).append("]").toString());
                    }
                    Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)pid), (Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(seqNr))));
                    return tuple2;
                }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                timestampOffset2 = new TimestampOffset(Instant.parse(stringArray[0]), Instant.parse(stringArray[1]), (Map<String, Object>)seen);
            }
            timestampOffset = timestampOffset2;
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable e = (Throwable)option.get();
                throw new IllegalArgumentException(new StringBuilder(48).append("Unexpected serialized TimestampOffset format [").append(str).append("].").toString(), e);
            }
            throw throwable;
        }
        return timestampOffset;
    }

    private String timestampOffsetToStorageRepresentation(TimestampOffset offset) {
        Object object;
        StringBuilder str = new StringBuilder();
        str.append(offset.timestamp()).append(this.timestampOffsetSeparator()).append(offset.readTimestamp());
        if (offset.seen().size() == 1) {
            String pid = (String)((Tuple2)offset.seen().head())._1();
            this.checkSeparator$1(pid, offset);
            long seqNr = ((Tuple2)offset.seen().head())._2$mcJ$sp();
            object = str.append(this.timestampOffsetSeparator()).append(pid).append(this.timestampOffsetSeparator()).append(seqNr);
        } else {
            if (offset.seen().nonEmpty()) {
                ((List)offset.seen().toList().sortBy((Function1 & Serializable)x$2 -> (String)x$2._1(), (Ordering)Ordering.String$.MODULE$)).foreach((Function1 & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String pid = (String)tuple2._1();
                    long seqNr = tuple2._2$mcJ$sp();
                    this.checkSeparator$1(pid, offset);
                    StringBuilder stringBuilder = str.append(this.timestampOffsetSeparator()).append(pid).append(this.timestampOffsetSeparator()).append(seqNr);
                    return stringBuilder;
                });
            }
            object = BoxedUnit.UNIT;
        }
        return str.toString();
    }

    private final void checkSeparator$1(String pid, TimestampOffset offset$1) {
        if (StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(pid), this.timestampOffsetSeparator())) {
            throw new IllegalArgumentException(new StringBuilder(0).append(new StringBuilder(30).append("persistenceId [").append(pid).append("] in offset [").append(offset$1).append("] ").toString()).append(new StringBuilder(29).append("must not contain [").append(this.timestampOffsetSeparator()).append("] character").toString()).toString());
        }
    }

    public QuerySerializer(ExtendedActorSystem system) {
        this.system = system;
        BaseSerializer.$init$((BaseSerializer)this);
        this.log = Logging$.MODULE$.apply((ActorSystem)system, QuerySerializer.class, LogSource$.MODULE$.fromAnyClass());
        this.manifestSeparator = (char)58;
        this.timestampOffsetSeparator = (char)59;
        Statics.releaseFence();
    }
}

