import { SagaIterator } from 'redux-saga';
import { call, put } from 'redux-saga/effects';
import { dependencySelector } from '../../features/tasks/components/rails/overview/custom/tasks/gate-task/ducks/dependency-selector.reducer';
import { withFlagChangingState } from './saga-utils';

const { setShowLoadingIndicator } = dependencySelector.actions;
describe('saga-utils', () => {
    describe('withFlagChangingState', () => {
        it('should call effect with flag state changing before and after with default flag value', () => {
            const effect = jest.fn();
            const gen: SagaIterator = withFlagChangingState(call(effect), setShowLoadingIndicator);
            expect(gen.next().value).toStrictEqual(put(setShowLoadingIndicator(true)));
            expect(gen.next().value).toStrictEqual(call(effect));
            expect(gen.next().value).toStrictEqual(put(setShowLoadingIndicator(false)));
            expect(gen.next().done).toBeTruthy();
        });
    });
});
