/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.springmvc;

import java.io.IOException;
import java.util.concurrent.CompletionException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.resteasy.core.AsynchronousDispatcher;
import org.jboss.resteasy.core.ServerResponseWriter;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.specimpl.BuiltResponse;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.UnhandledException;
import org.jboss.resteasy.springmvc.ResteasyRequestWrapper;
import org.jboss.resteasy.springmvc.ResteasyView;
import org.jboss.resteasy.springmvc.ResteasyWebHandlerTemplate;
import org.springframework.web.servlet.HandlerAdapter;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

public class ResteasyHandlerAdapter
extends ResteasyWebHandlerTemplate<ModelAndView>
implements HandlerAdapter {
    protected ResteasyDeployment deployment;

    public ResteasyHandlerAdapter(ResteasyDeployment deployment) {
        super(deployment.getProviderFactory());
        this.deployment = deployment;
    }

    public long getLastModified(HttpServletRequest request, Object handler) {
        return -1L;
    }

    public ModelAndView handle(HttpServletRequest servletRequest, HttpServletResponse servletResponse, Object handler) throws Exception {
        ResteasyRequestWrapper requestWrapper = (ResteasyRequestWrapper)handler;
        return (ModelAndView)super.handle(requestWrapper, servletResponse);
    }

    @Override
    protected ModelAndView handle(ResteasyRequestWrapper requestWrapper, HttpResponse response) throws IOException {
        AsynchronousDispatcher asyncDispatcher;
        SynchronousDispatcher dispatcher = (SynchronousDispatcher)this.deployment.getDispatcher();
        if (requestWrapper.getErrorCode() != null) {
            try {
                response.sendError(requestWrapper.getErrorCode().intValue(), requestWrapper.getErrorMessage());
            }
            catch (Exception e) {
                throw new UnhandledException((Throwable)e);
            }
            return null;
        }
        if (requestWrapper.getAbortedResponse() != null) {
            ServerResponseWriter.writeNomapResponse((BuiltResponse)((BuiltResponse)requestWrapper.getAbortedResponse()), (HttpRequest)requestWrapper.getHttpRequest(), (HttpResponse)response, (ResteasyProviderFactory)dispatcher.getProviderFactory(), t -> {});
            return null;
        }
        HttpRequest request = requestWrapper.getHttpRequest();
        if (dispatcher instanceof AsynchronousDispatcher && (asyncDispatcher = (AsynchronousDispatcher)dispatcher).isAsynchrnousRequest(request)) {
            asyncDispatcher.invoke(request, response);
            return null;
        }
        return this.createModelAndView(requestWrapper, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ModelAndView createModelAndView(ResteasyRequestWrapper requestWrapper, HttpResponse response) {
        HttpRequest request = requestWrapper.getHttpRequest();
        SynchronousDispatcher dispatcher = (SynchronousDispatcher)this.deployment.getDispatcher();
        dispatcher.pushContextObjects(request, response);
        try {
            BuiltResponse jaxrsResponse = null;
            try {
                jaxrsResponse = (BuiltResponse)requestWrapper.getInvoker().invoke(request, response);
            }
            catch (CompletionException e) {
                dispatcher.writeException(request, response, e.getCause(), t -> {});
            }
            catch (Exception e) {
                dispatcher.writeException(request, response, (Throwable)e, t -> {});
            }
            if (jaxrsResponse == null) {
                ModelAndView e = null;
                return e;
            }
            Object entity = jaxrsResponse.getEntity();
            if (entity instanceof ModelAndView) {
                ServerResponseWriter.commitHeaders((BuiltResponse)jaxrsResponse, (HttpResponse)response);
                ModelAndView modelAndView = (ModelAndView)entity;
                return modelAndView;
            }
            ModelAndView modelAndView = this.createModelAndView(jaxrsResponse);
            return modelAndView;
        }
        finally {
            dispatcher.clearContextData();
        }
    }

    protected ModelAndView createModelAndView(BuiltResponse serverResponse) {
        View view = this.createView(serverResponse);
        return new ModelAndView(view, "responseInvoker", (Object)serverResponse);
    }

    protected View createView(BuiltResponse serverResponse) {
        String contentType = ServerResponseWriter.resolveContentType((BuiltResponse)serverResponse).toString();
        return new ResteasyView(contentType, this.deployment);
    }

    public boolean supports(Object handler) {
        return handler instanceof ResteasyRequestWrapper;
    }

    private static /* synthetic */ void lambda$createModelAndView$3(Throwable t) {
    }
}

