/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.springboot;

import java.util.Set;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.core.Application;
import org.jboss.resteasy.springboot.common.ResteasyResourcesFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.ConfigurableEnvironment;

public class ResteasyBeanProcessorTomcat
extends ResteasyResourcesFinder
implements BeanFactoryPostProcessor {
    private static final Logger logger = LoggerFactory.getLogger(ResteasyBeanProcessorTomcat.class);
    private static final String JAXRS_DEFAULT_PATH = "resteasy.jaxrs.defaultPath";
    private static final String DEFAULT_BASE_APP_PATH = "/";

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        logger.debug("Post process bean factory has been called");
        this.findJaxrsApplications(beanFactory);
        this.findJaxrsResourcesAndProviderClasses(beanFactory);
        if (this.getApplications().size() == 0) {
            this.registerDefaultJaxrsApp(beanFactory);
            return;
        }
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
        for (Class applicationClass : this.getApplications()) {
            ApplicationPath path = (ApplicationPath)AnnotationUtils.findAnnotation((Class)applicationClass, ApplicationPath.class);
            logger.debug("registering JAX-RS application class " + applicationClass.getName());
            GenericBeanDefinition applicationServletBean = this.createApplicationServlet(applicationClass, path.value());
            registry.registerBeanDefinition(applicationClass.getName(), (BeanDefinition)applicationServletBean);
        }
    }

    private void registerDefaultJaxrsApp(ConfigurableListableBeanFactory beanFactory) {
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
        ConfigurableEnvironment configurableEnvironment = (ConfigurableEnvironment)beanFactory.getBean(ConfigurableEnvironment.class);
        String path = configurableEnvironment.getProperty(JAXRS_DEFAULT_PATH, DEFAULT_BASE_APP_PATH);
        GenericBeanDefinition applicationServletBean = this.createApplicationServlet(Application.class, path);
        logger.info("No JAX-RS Application classes have been found. A default, one mapped to '{}', will be registered.", (Object)path);
        registry.registerBeanDefinition(Application.class.getName(), (BeanDefinition)applicationServletBean);
    }

    private GenericBeanDefinition createApplicationServlet(Class<? extends Application> applicationClass, String path) {
        GenericBeanDefinition applicationServletBean = new GenericBeanDefinition();
        applicationServletBean.setFactoryBeanName("JaxrsApplicationServletBuilder");
        applicationServletBean.setFactoryMethodName("build");
        Set resources = this.getAllResources();
        ConstructorArgumentValues values = new ConstructorArgumentValues();
        values.addIndexedArgumentValue(0, (Object)applicationClass.getName());
        values.addIndexedArgumentValue(1, (Object)path);
        values.addIndexedArgumentValue(2, (Object)resources);
        values.addIndexedArgumentValue(3, (Object)this.getProviders());
        applicationServletBean.setConstructorArgumentValues(values);
        applicationServletBean.setAutowireCandidate(false);
        applicationServletBean.setScope("singleton");
        return applicationServletBean;
    }
}

