/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.CiWithUid;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskContainer;
import com.xebialabs.xlrelease.domain.TaskGroup;
import com.xebialabs.xlrelease.domain.blackout.BlackoutMetadata$;
import com.xebialabs.xlrelease.domain.calendar.Blackout;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.domain.utils.syntax;
import com.xebialabs.xlrelease.domain.utils.syntax$;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.CommentRepository;
import com.xebialabs.xlrelease.repository.FacetRepositoryDispatcher;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PersistenceInterceptor;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.repository.query.TaskBasicData;
import com.xebialabs.xlrelease.repository.sql.BaseReleaseItemRepository;
import com.xebialabs.xlrelease.repository.sql.ConfigurationReferencesSupport;
import com.xebialabs.xlrelease.repository.sql.DeserializationSupport;
import com.xebialabs.xlrelease.repository.sql.InterceptedRepository;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$RichCiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.DependencyPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasesSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.TasksSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.ConfigurationReferencePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ReleaseRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.TaskRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.TaskRow$;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\rud\u0001B\u0017/\u0001eB\u0001b\u0018\u0001\u0003\u0006\u0004%\t\u0001\u0019\u0005\tO\u0002\u0011\t\u0011)A\u0005C\"A\u0001\u000e\u0001BC\u0002\u0013\u0005\u0011\u000e\u0003\u0005n\u0001\t\u0005\t\u0015!\u0003k\u0011!q\u0007A!b\u0001\n\u0003y\u0007\u0002C:\u0001\u0005\u0003\u0005\u000b\u0011\u00029\t\u0011Q\u0004!Q1A\u0005\u0002UD\u0001\"\u001f\u0001\u0003\u0002\u0003\u0006IA\u001e\u0005\tu\u0002\u0011)\u0019!C\u0001w\"Aq\u0010\u0001B\u0001B\u0003%A\u0010\u0003\u0006\u0002\u0002\u0001\u0011)\u0019!C\u0001\u0003\u0007A!\"!\u0005\u0001\u0005\u0003\u0005\u000b\u0011BA\u0003\u0011)\t\u0019\u0002\u0001BC\u0002\u0013\u0005\u0011Q\u0003\u0005\u000b\u0003;\u0001!\u0011!Q\u0001\n\u0005]\u0001BCA\u0010\u0001\t\u0015\r\u0011b\u0001\u0002\"!Q\u0011\u0011\u000b\u0001\u0003\u0002\u0003\u0006I!a\t\t\u000f\u0005M\u0003\u0001\"\u0001\u0002V!9\u0011\u0011\u000e\u0001\u0005B\u0005-\u0004bBA5\u0001\u0011\u0005\u0013\u0011\u0016\u0005\b\u0003\u0017\u0004A\u0011IAg\u0011\u001d\u0011\t\u0001\u0001C!\u0005\u0007AqA!\u0005\u0001\t\u0003\u0012\u0019\u0002C\u0004\u0003\u001c\u0001!\tE!\b\t\u000f\tu\u0002\u0001\"\u0011\u0003@!9!Q\t\u0001\u0005\n\t\u001d\u0003b\u0002B&\u0001\u0011\u0005#Q\n\u0005\b\u00053\u0002A\u0011\tB.\u0011\u001d\u0011\t\u0007\u0001C\u0005\u0005GBqAa\u001a\u0001\t\u0003\u0012I\u0007C\u0004\u0003z\u0001!\tEa\u001f\t\u000f\t\u0005\u0005\u0001\"\u0011\u0003\u0004\"9!\u0011\u0012\u0001\u0005\n\t-\u0005b\u0002BI\u0001\u0011\u0005#1\u0013\u0005\b\u00053\u0003A\u0011\tBN\u0011\u001d\u0011)\f\u0001C!\u0005oCqAa3\u0001\t\u0003\u0012i\rC\u0004\u0003R\u0002!\tEa5\t\u000f\tm\u0007\u0001\"\u0011\u0003^\"9!\u0011\u001f\u0001\u0005B\tM\bbBB\u0006\u0001\u0011\u0005#1\u001f\u0005\b\u0007#\u0001A\u0011IB\n\u0011\u001d\u00199\u0003\u0001C!\u0007SAqa!\u000f\u0001\t\u0003\u001aY\u0004C\u0004\u0004l\u0001!\te!\u001c\u0003#M\u000bH\u000eV1tWJ+\u0007o\\:ji>\u0014\u0018P\u0003\u00020a\u0005\u00191/\u001d7\u000b\u0005E\u0012\u0014A\u0003:fa>\u001c\u0018\u000e^8ss*\u00111\u0007N\u0001\nq2\u0014X\r\\3bg\u0016T!!\u000e\u001c\u0002\u0013a,'-[1mC\n\u001c(\"A\u001c\u0002\u0007\r|Wn\u0001\u0001\u0014\u0011\u0001Q\u0004\t\u0012(R)^\u0003\"a\u000f \u000e\u0003qR\u0011!P\u0001\u0006g\u000e\fG.Y\u0005\u0003\u007fq\u0012a!\u00118z%\u00164\u0007CA!C\u001b\u0005\u0001\u0014BA\"1\u00059!\u0016m]6SKB|7/\u001b;pef\u00042!\u0012$I\u001b\u0005q\u0013BA$/\u0005UIe\u000e^3sG\u0016\u0004H/\u001a3SKB|7/\u001b;pef\u0004\"!\u0013'\u000e\u0003)S!a\u0013\u001a\u0002\r\u0011|W.Y5o\u0013\ti%J\u0001\u0003UCN\\\u0007CA#P\u0013\t\u0001fFA\rCCN,'+\u001a7fCN,\u0017\n^3n%\u0016\u0004xn]5u_JL\bCA#S\u0013\t\u0019fF\u0001\fEKN,'/[1mSj\fG/[8o'V\u0004\bo\u001c:u!\t)U+\u0003\u0002W]\tq2i\u001c8gS\u001e,(/\u0019;j_:\u0014VMZ3sK:\u001cWm]*vaB|'\u000f\u001e\t\u00031vk\u0011!\u0017\u0006\u00035n\u000bQa\u001d7gi)T\u0011\u0001X\u0001\tOJL'P\u001f7fI&\u0011a,\u0017\u0002\b\u0019><w-\u001b8h\u0003I\u0011X\r\\3bg\u0016\u0004VM]:jgR,gnY3\u0016\u0003\u0005\u0004\"AY3\u000e\u0003\rT!\u0001\u001a\u0018\u0002\u0017A,'o]5ti\u0016t7-Z\u0005\u0003M\u000e\u0014!CU3mK\u0006\u001cX\rU3sg&\u001cH/\u001a8dK\u0006\u0019\"/\u001a7fCN,\u0007+\u001a:tSN$XM\\2fA\u0005)B-\u001a9f]\u0012,gnY=QKJ\u001c\u0018n\u001d;f]\u000e,W#\u00016\u0011\u0005\t\\\u0017B\u00017d\u0005U!U\r]3oI\u0016t7-\u001f)feNL7\u000f^3oG\u0016\fa\u0003Z3qK:$WM\\2z!\u0016\u00148/[:uK:\u001cW\rI\u0001\u0010i\u0006\u001c8\u000eU3sg&\u001cH/\u001a8dKV\t\u0001\u000f\u0005\u0002cc&\u0011!o\u0019\u0002\u0010)\u0006\u001c8\u000eU3sg&\u001cH/\u001a8dK\u0006\u0001B/Y:l!\u0016\u00148/[:uK:\u001cW\rI\u0001\u0012G>lW.\u001a8u%\u0016\u0004xn]5u_JLX#\u0001<\u0011\u0005\u0005;\u0018B\u0001=1\u0005E\u0019u.\\7f]R\u0014V\r]8tSR|'/_\u0001\u0013G>lW.\u001a8u%\u0016\u0004xn]5u_JL\b%A\tsKB|7/\u001b;pef\fE-\u00199uKJ,\u0012\u0001 \t\u0003\u000bvL!A \u0018\u0003)M\u000bHNU3q_NLGo\u001c:z\u0003\u0012\f\u0007\u000f^3s\u0003I\u0011X\r]8tSR|'/_!eCB$XM\u001d\u0011\u00021\r|gNZ5hkJ\fG/[8o!\u0016\u00148/[:uK:\u001cW-\u0006\u0002\u0002\u0006A!\u0011qAA\u0007\u001b\t\tIAC\u0002\u0002\f\r\fQbY8oM&<WO]1uS>t\u0017\u0002BA\b\u0003\u0013\u0011\u0011eQ8oM&<WO]1uS>t'+\u001a4fe\u0016t7-\u001a)feNL7\u000f^3oG\u0016\f\u0011dY8oM&<WO]1uS>t\u0007+\u001a:tSN$XM\\2fA\u0005Ib-Y2fiJ+\u0007o\\:ji>\u0014\u0018\u0010R5ta\u0006$8\r[3s+\t\t9\u0002E\u0002B\u00033I1!a\u00071\u0005e1\u0015mY3u%\u0016\u0004xn]5u_JLH)[:qCR\u001c\u0007.\u001a:\u00025\u0019\f7-\u001a;SKB|7/\u001b;pef$\u0015n\u001d9bi\u000eDWM\u001d\u0011\u0002\u000f\u0011L\u0017\r\\3diV\u0011\u00111\u0005\t\u0005\u0003K\tYE\u0004\u0003\u0002(\u0005\u0015c\u0002BA\u0015\u0003\u0003rA!a\u000b\u0002>9!\u0011QFA\u001e\u001d\u0011\ty#!\u000f\u000f\t\u0005E\u0012qG\u0007\u0003\u0003gQ1!!\u000e9\u0003\u0019a$o\\8u}%\tq'\u0003\u00026m%\u00111\u0007N\u0005\u0004\u0003\u007f\u0011\u0014A\u00013c\u0013\ry\u00131\t\u0006\u0004\u0003\u007f\u0011\u0014\u0002BA$\u0003\u0013\n!bU9m\u0005VLG\u000eZ3s\u0015\ry\u00131I\u0005\u0005\u0003\u001b\nyEA\u0004ES\u0006dWm\u0019;\u000b\t\u0005\u001d\u0013\u0011J\u0001\tI&\fG.Z2uA\u00051A(\u001b8jiz\"\"#a\u0016\u0002Z\u0005m\u0013QLA0\u0003C\n\u0019'!\u001a\u0002hA\u0011Q\t\u0001\u0005\u0006?F\u0001\r!\u0019\u0005\u0006QF\u0001\rA\u001b\u0005\u0006]F\u0001\r\u0001\u001d\u0005\u0006iF\u0001\rA\u001e\u0005\u0006uF\u0001\r\u0001 \u0005\b\u0003\u0003\t\u0002\u0019AA\u0003\u0011\u001d\t\u0019\"\u0005a\u0001\u0003/Aq!a\b\u0012\u0001\b\t\u0019#\u0001\u0005gS:$')_%e+\u0011\ti'a\u001d\u0015\t\u0005=\u0014q\u0010\t\u0005\u0003c\n\u0019\b\u0004\u0001\u0005\u000f\u0005U$C1\u0001\u0002x\t\tA+E\u0002\u0002z!\u00032aOA>\u0013\r\ti\b\u0010\u0002\b\u001d>$\b.\u001b8h\u0011\u001d\t\tI\u0005a\u0001\u0003\u0007\u000ba\u0001^1tW&#\u0007\u0003BAC\u0003\u001bsA!a\"\u0002\nB\u0019\u0011\u0011\u0007\u001f\n\u0007\u0005-E(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u001f\u000b\tJ\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u0017c\u0004f\u0001\n\u0002\u0016B!\u0011qSAS\u001b\t\tIJ\u0003\u0003\u0002\u001c\u0006u\u0015AC1o]>$\u0018\r^5p]*!\u0011qTAQ\u0003\u001diW\r\u001e:jGNT1!a)7\u0003!\u0019w\u000eZ1iC2,\u0017\u0002BAT\u00033\u0013Q\u0001V5nK\u0012,B!a+\u00020R1\u0011QVAY\u0003g\u0003B!!\u001d\u00020\u00129\u0011QO\nC\u0002\u0005]\u0004bBAA'\u0001\u0007\u00111\u0011\u0005\b\u0003k\u001b\u0002\u0019AA\\\u00039\u0011Xm]8mm\u0016|\u0005\u000f^5p]N\u0004B!!/\u0002F6\u0011\u00111\u0018\u0006\u0004c\u0005u&\u0002BA`\u0003\u0003\fAA[:p]*\u0019\u00111\u0019\u001a\u0002\u001bM,'/[1mSj\fG/[8o\u0013\u0011\t9-a/\u0003\u001dI+7o\u001c7wK>\u0003H/[8og\"\u001a1#!&\u0002%\u0019Lg\u000e\u001a+bg.\u001c()Y:jG\u0012\u000bG/\u0019\u000b\u0005\u0003\u001f\fY\u000f\u0005\u0004\u0002R\u0006m\u0017q\\\u0007\u0003\u0003'TA!!6\u0002X\u0006!Q\u000f^5m\u0015\t\tI.\u0001\u0003kCZ\f\u0017\u0002BAo\u0003'\u0014A\u0001T5tiB!\u0011\u0011]At\u001b\t\t\u0019OC\u0002\u0002fB\nQ!];fefLA!!;\u0002d\niA+Y:l\u0005\u0006\u001c\u0018n\u0019#bi\u0006Dq!!<\u0015\u0001\u0004\ty/A\u0004uCN\\\u0017\nZ:\u0011\r\u0005E\u00171\\ABQ\r!\u00121\u001f\t\u0005\u0003k\fY0\u0004\u0002\u0002x*!\u0011\u0011`A%\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\n\t\u0005u\u0018q\u001f\u0002\u000b\u0013N\u0014V-\u00193P]2L\bf\u0001\u000b\u0002\u0016\u00061Q\r_5tiN$BA!\u0002\u0003\fA\u00191Ha\u0002\n\u0007\t%AHA\u0004C_>dW-\u00198\t\u000f\u0005\u0005U\u00031\u0001\u0002\u0004\"\u001aQ#a=)\u0007U\t)*\u0001\u0004va\u0012\fG/\u001a\u000b\u0004\u0011\nU\u0001B\u0002B\f-\u0001\u0007\u0001*\u0001\u0003uCN\\\u0007f\u0001\f\u0002\u0016\u0006YQ\u000f\u001d3bi\u0016$\u0016m]6t)\u0011\u0011yB!\n\u0011\u0007m\u0012\t#C\u0002\u0003$q\u0012A!\u00168ji\"9!qE\fA\u0002\t%\u0012!\u0002;bg.\u001c\b\u0003B\u001e\u0003,!K1A!\f=\u0005)a$/\u001a9fCR,GM\u0010\u0015\u0004/\tE\u0002\u0003\u0002B\u001a\u0005oi!A!\u000e\u000b\u0007\u0005mE(\u0003\u0003\u0003:\tU\"a\u0002<be\u0006\u0014xm\u001d\u0015\u0004/\u0005U\u0015\u0001F;qI\u0006$X\rV1tWB\u0013x\u000e]3si&,7\u000f\u0006\u0003\u0003 \t\u0005\u0003B\u0002B\f1\u0001\u0007\u0001\nK\u0002\u0019\u0003+\u000bA$\u001e9eCR,G+Y:l!J|\u0007/\u001a:uS\u0016\u001c\u0018J\u001c;fe:\fG\u000e\u0006\u0003\u0003 \t%\u0003B\u0002B\f3\u0001\u0007\u0001*A\rcCR\u001c\u0007.\u00169eCR,G+Y:l!J|\u0007/\u001a:uS\u0016\u001cH\u0003\u0002B\u0010\u0005\u001fBqAa\n\u001b\u0001\u0004\u0011\t\u0006E\u0003\u0002\u0006\nM\u0003*\u0003\u0003\u0003V\u0005E%aA*fi\"\u001a!$!&\u0002M\t\fGo\u00195Va\u0012\fG/\u001a+bg.\u0004&o\u001c9feRLWm],ji\"LE-\u00118e\u0011\u0006\u001c\b\u000e\u0006\u0003\u0003 \tu\u0003b\u0002B\u00147\u0001\u0007!\u0011\u000b\u0015\u00047\u0005U\u0015a\u00062bi\u000eDW\u000b\u001d3bi\u0016$U\r]3oI\u0016t7-[3t)\u0011\u0011yB!\u001a\t\u000f\t\u001dB\u00041\u0001\u0003R\u0005qR\u000f\u001d3bi\u0016$\u0016m]6B]\u0012\u0014V\r\\3bg\u00164E.Y4Ti\u0006$Xo\u001d\u000b\u0006\u0011\n-$Q\u000e\u0005\u0007\u0005/i\u0002\u0019\u0001%\t\u000f\t=T\u00041\u0001\u0003r\u00059!/\u001a7fCN,\u0007cA%\u0003t%\u0019!Q\u000f&\u0003\u000fI+G.Z1tK\"\u001aQ$!&\u0002\u0015U\u0004H-\u0019;f)f\u0004X\rF\u0002I\u0005{BaAa\u0006\u001f\u0001\u0004A\u0005f\u0001\u0010\u0002\u0016\u00061A-\u001a7fi\u0016$BAa\b\u0003\u0006\"1!qC\u0010A\u0002!C3aHAK\u0003)\u0019'/Z1uKR\u000b7o\u001b\u000b\u0004\u0011\n5\u0005B\u0002BHA\u0001\u0007\u0001*A\u0004oK^$\u0016m]6\u0002\r\r\u0014X-\u0019;f)\rA%Q\u0013\u0005\u0007\u0005\u001f\u000b\u0003\u0019\u0001%)\u0007\u0005\n)*\u0001\u0005n_Z,G+Y:l)%A%Q\u0014BQ\u0005K\u0013y\u000b\u0003\u0004\u0003 \n\u0002\r\u0001S\u0001\u000bi\u0006\u001c8\u000eV8N_Z,\u0007B\u0002BRE\u0001\u0007\u0001*A\u0005n_Z,G\rV1tW\"9!q\u0015\u0012A\u0002\t%\u0016AF;qI\u0006$X\rZ(sS\u001eLgnQ8oi\u0006Lg.\u001a:\u0011\u0007%\u0013Y+C\u0002\u0003.*\u0013Q\u0002V1tW\u000e{g\u000e^1j]\u0016\u0014\bb\u0002BYE\u0001\u0007!\u0011V\u0001\u0017kB$\u0017\r^3e)\u0006\u0014x-\u001a;D_:$\u0018-\u001b8fe\"\u001a!%!&\u0002-\u0019Lg\u000eZ!gM\u0016\u001cG/\u001a3Cs\nc\u0017mY6pkR$B!a<\u0003:\"9!1X\u0012A\u0002\tu\u0016\u0001\u00032mC\u000e\\w.\u001e;\u0011\t\t}&QY\u0007\u0003\u0005\u0003T1Aa1K\u0003!\u0019\u0017\r\\3oI\u0006\u0014\u0018\u0002\u0002Bd\u0005\u0003\u0014\u0001B\u00117bG.|W\u000f\u001e\u0015\u0004G\u0005U\u0015A\u00074j]\u0012\u0004VM\u001c3j]\u001e$\u0016m]6t/&$\bNR1dKR\u001cHCAAxQ\r!\u0013QS\u0001\tO\u0016$H+\u001b;mKR!\u00111\u0011Bk\u0011\u001d\t\t)\na\u0001\u0003\u0007C3!JAzQ\r)\u0013QS\u0001\u000bO\u0016$\u0018\t\u001c7UC\u001e\u001cH\u0003\u0002Bp\u0005G\u0004b!!5\u0003b\u0006\r\u0015\u0002\u0002B+\u0003'DqA!:'\u0001\u0004\u00119/A\u0006mS6LGOT;nE\u0016\u0014\bcA\u001e\u0003j&\u0019!1\u001e\u001f\u0003\u0007%sG\u000fK\u0002'\u0003gD3AJAK\u0003I1\u0017N\u001c3Pm\u0016\u0014H-^3UCN\\\u0017\nZ:\u0015\u0005\tU\bC\u0002B|\u0007\u0003\t\u0019I\u0004\u0003\u0003z\nuh\u0002BA\u0019\u0005wL\u0011!P\u0005\u0004\u0005\u007fd\u0014a\u00029bG.\fw-Z\u0005\u0005\u0007\u0007\u0019)AA\u0002TKFT1Aa@=Q\r9\u00131\u001f\u0015\u0004O\u0005U\u0015A\u00054j]\u0012$U/Z*p_:$\u0016m]6JIND3\u0001KAzQ\rA\u0013QS\u0001\nO\u0016$8\u000b^1ukN$Ba!\u0006\u0004\"A!1qCB\u000f\u001b\t\u0019IBC\u0002\u0004\u001c)\u000baa\u001d;biV\u001c\u0018\u0002BB\u0010\u00073\u0011!\u0002V1tWN#\u0018\r^;t\u0011\u001d\t\t)\u000ba\u0001\u0003\u0007C3!KAzQ\rI\u0013QS\u0001\u0010O\u0016$H+Y:l'R\fG/^:fgR!11FB\u0019!!\t\tn!\f\u0002\u0004\u000eU\u0011\u0002BB\u0018\u0003'\u00141!T1q\u0011\u001d\u0019\u0019D\u000ba\u0001\u0003\u0007\u000b\u0011B]3mK\u0006\u001cX-\u00133)\u0007)\n\u0019\u0010K\u0002+\u0003+\u000bqEZ5oIR\u000b7o[%eg\nKH+Y:l)f\u0004Xm\u0015;biV\u001c\u0018I\u001c3Ti\u0006\u0014H\u000fR1uKRA!Q_B\u001f\u00073\u001ai\u0006C\u0004\u0004@-\u0002\ra!\u0011\u0002\u0011Q\f7o\u001b+za\u0016\u0004Baa\u0011\u0004V5\u00111Q\t\u0006\u0005\u0007\u000f\u001aI%A\u0004sK\u001adWm\u0019;\u000b\t\r-3QJ\u0001\u0004CBL'\u0002BB(\u0007#\na\u0001\u001d7vO&t'bAB*i\u0005AA-\u001a9m_fLG/\u0003\u0003\u0004X\r\u0015#\u0001\u0002+za\u0016Dqaa\u0017,\u0001\u0004\u0019)\"\u0001\u0006uCN\\7\u000b^1ukNDqaa\u0018,\u0001\u0004\u0019\t'A\u0007ti\u0006\u0014H/\u001a3CK\u001a|'/\u001a\t\u0005\u0003#\u001c\u0019'\u0003\u0003\u0004f\u0005M'\u0001\u0002#bi\u0016D3aKAzQ\rY\u0013QS\u0001\u0015kB$\u0017\r^3UCN\\7\u000b^1ukNd\u0015N\\3\u0015\r\t}1qNB9\u0011\u001d\t\t\t\fa\u0001\u0003\u0007Cqaa\u001d-\u0001\u0004\t\u0019)\u0001\u0006ti\u0006$Xo\u001d'j]\u0016D3\u0001AB<!\u0011\t)p!\u001f\n\t\rm\u0014q\u001f\u0002\u0010\u0013N$&/\u00198tC\u000e$\u0018n\u001c8bY\u0002")
public class SqlTaskRepository
implements TaskRepository,
InterceptedRepository<Task>,
BaseReleaseItemRepository,
DeserializationSupport,
ConfigurationReferencesSupport,
Logging {
    private final ReleasePersistence releasePersistence;
    private final DependencyPersistence dependencyPersistence;
    private final TaskPersistence taskPersistence;
    private final CommentRepository commentRepository;
    private final SqlRepositoryAdapter repositoryAdapter;
    private final ConfigurationReferencePersistence configurationPersistence;
    private final FacetRepositoryDispatcher facetRepositoryDispatcher;
    private final SqlBuilder.Dialect dialect;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private scala.collection.immutable.Seq<PersistenceInterceptor<Task>> persistenceInterceptors;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public void updateConfigurationRefs(CiWithUid entity) {
        ConfigurationReferencesSupport.updateConfigurationRefs$(this, entity);
    }

    @Override
    public void deleteConfigurationRefs(Integer uid) {
        ConfigurationReferencesSupport.deleteConfigurationRefs$(this, uid);
    }

    @Override
    public Release deserializeRelease(ReleaseRow releaseData) {
        return DeserializationSupport.deserializeRelease$(this, releaseData);
    }

    @Override
    public Option<Release> tryDeserializeRelease(ReleaseRow releaseData) {
        return DeserializationSupport.tryDeserializeRelease$(this, releaseData);
    }

    @Override
    public Release getRelease(String releaseId, String entityId) {
        return BaseReleaseItemRepository.getRelease$(this, releaseId, entityId);
    }

    @Override
    public Release getRelease(String releaseId, String entityId, ResolveOptions resolveOptions) {
        return BaseReleaseItemRepository.getRelease$(this, releaseId, entityId, resolveOptions);
    }

    @Override
    public <T> T notNull(T ci, String ciId) {
        return (T)BaseReleaseItemRepository.notNull$(this, ci, ciId);
    }

    @Override
    public void insertDependencyWithGateTaskUid(Integer gateTaskUid, Dependency dependency) {
        BaseReleaseItemRepository.insertDependencyWithGateTaskUid$(this, gateTaskUid, dependency);
    }

    @Override
    public void insertDependency(Dependency dependency) {
        BaseReleaseItemRepository.insertDependency$(this, dependency);
    }

    @Override
    public void checkIsNotReferencedByDependencies(String planItemIdOrItsChildren) {
        BaseReleaseItemRepository.checkIsNotReferencedByDependencies$(this, planItemIdOrItsChildren);
    }

    public void registerPersistenceInterceptor(PersistenceInterceptor<Task> persistenceInterceptor) {
        InterceptedRepository.registerPersistenceInterceptor$((InterceptedRepository)this, persistenceInterceptor);
    }

    public void interceptCreate(ConfigurationItem ci) {
        InterceptedRepository.interceptCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void interceptDelete(String ciId) {
        InterceptedRepository.interceptDelete$((InterceptedRepository)this, (String)ciId);
    }

    public void interceptUpdate(ConfigurationItem ci) {
        InterceptedRepository.interceptUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterCreate(ConfigurationItem ci) {
        InterceptedRepository.afterCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterUpdate(ConfigurationItem ci) {
        InterceptedRepository.afterUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterDelete(String ciId) {
        InterceptedRepository.afterDelete$((InterceptedRepository)this, (String)ciId);
    }

    public TaskBasicData findTaskBasicData(String taskId) throws NotFoundException {
        return TaskRepository.findTaskBasicData$((TaskRepository)this, (String)taskId);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlTaskRepository sqlTaskRepository = this;
        synchronized (sqlTaskRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public scala.collection.immutable.Seq<PersistenceInterceptor<Task>> persistenceInterceptors() {
        return this.persistenceInterceptors;
    }

    public void persistenceInterceptors_$eq(scala.collection.immutable.Seq<PersistenceInterceptor<Task>> x$1) {
        this.persistenceInterceptors = x$1;
    }

    public void updateTasks(Task ... tasks) {
        this.updateTasks((scala.collection.immutable.Seq<Task>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])tasks));
    }

    public ReleasePersistence releasePersistence() {
        return this.releasePersistence;
    }

    @Override
    public DependencyPersistence dependencyPersistence() {
        return this.dependencyPersistence;
    }

    public TaskPersistence taskPersistence() {
        return this.taskPersistence;
    }

    public CommentRepository commentRepository() {
        return this.commentRepository;
    }

    @Override
    public SqlRepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    @Override
    public ConfigurationReferencePersistence configurationPersistence() {
        return this.configurationPersistence;
    }

    public FacetRepositoryDispatcher facetRepositoryDispatcher() {
        return this.facetRepositoryDispatcher;
    }

    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    @Timed
    public <T extends Task> T findById(String taskId) {
        return this.findById(taskId, ResolveOptions$.MODULE$.WITH_DECORATORS());
    }

    @Timed
    public <T extends Task> T findById(String taskId, ResolveOptions resolveOptions) {
        if (!this.exists(taskId)) {
            throw new NotFoundException("Repository entity [" + taskId + "] not found", new Object[0]);
        }
        Release release = this.getRelease(Ids.releaseIdFrom((String)taskId), taskId, resolveOptions);
        return (T)((Task)Option$.MODULE$.apply((Object)release.getTask(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(taskId)))).fold((Function0 & Serializable)() -> {
            throw new NotFoundException("Repository entity [" + taskId + "] not found in release", new Object[0]);
        }, (Function1 & Serializable)task -> {
            task.getAllTasks().forEach(t -> this.commentRepository().decorate(t));
            return task;
        }));
    }

    @Timed
    @IsReadOnly
    public java.util.List<TaskBasicData> findTasksBasicData(java.util.List<String> taskIds) {
        if (taskIds.isEmpty()) {
            return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().empty()).asJava();
        }
        scala.collection.immutable.Seq<TaskRow> tasksData = this.taskPersistence().findByIds((Iterable<String>)CollectionConverters$.MODULE$.ListHasAsScala(taskIds).asScala());
        return CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(taskIds).asScala().map((Function1 & Serializable)taskId -> new Tuple2(taskId, (Object)tasksData.find((Function1 & Serializable)data -> BoxesRunTime.boxToBoolean((boolean)taskId.endsWith(data.taskId())))))).flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String id = (String)tuple2._1();
                Option option = (Option)tuple2._2();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    TaskRow data = (TaskRow)some.value();
                    return new Some((Object)TaskRow$.MODULE$.TaskDataOps(data).asTaskData(id));
                }
            }
            return None$.MODULE$;
        })).asJava();
    }

    @Timed
    @IsReadOnly
    public boolean exists(String taskId) {
        this.logger().debug((Function0 & Serializable)() -> "Checking if exists task [" + taskId + "]");
        return this.taskPersistence().exists(taskId);
    }

    @Timed
    public Task update(Task task) {
        Release release = task.getRelease();
        this.interceptUpdate((ConfigurationItem)task);
        this.releasePersistence().update(release);
        this.updateTaskPropertiesInternal(task);
        this.updateConfigurationRefs((CiWithUid)release);
        this.afterUpdate((ConfigurationItem)task);
        return task;
    }

    @Timed
    public void updateTasks(scala.collection.immutable.Seq<Task> tasks) {
        tasks.groupBy((Function1 & Serializable)x$1 -> x$1.getRelease()).foreach((Function1 & Serializable)x0$1 -> {
            SqlTaskRepository.$anonfun$updateTasks$2(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public void updateTaskProperties(Task task) {
        this.interceptUpdate((ConfigurationItem)task);
        this.updateTaskPropertiesInternal(task);
        this.afterUpdate((ConfigurationItem)task);
    }

    private void updateTaskPropertiesInternal(Task task) {
        this.taskPersistence().updateProperties(task);
        syntax.TaskOps$.MODULE$.dependencies$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable)x0$1 -> {
            SqlTaskRepository.$anonfun$updateTaskPropertiesInternal$1(this, task, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public void batchUpdateTaskProperties(scala.collection.immutable.Set<Task> tasks) {
        tasks.foreach((Function1 & Serializable)ci -> {
            this.interceptUpdate((ConfigurationItem)ci);
            return BoxedUnit.UNIT;
        });
        this.taskPersistence().batchUpdateTaskProperties(tasks);
        this.batchUpdateDependencies(tasks);
    }

    @Timed
    public void batchUpdateTaskPropertiesWithIdAndHash(scala.collection.immutable.Set<Task> tasks) {
        tasks.foreach((Function1 & Serializable)ci -> {
            this.interceptUpdate((ConfigurationItem)ci);
            return BoxedUnit.UNIT;
        });
        this.taskPersistence().batchUpdateTaskPropertiesWithIdAndHash(tasks);
        this.batchUpdateDependencies(tasks);
    }

    private void batchUpdateDependencies(scala.collection.immutable.Set<Task> tasks) {
        Tuple2 tuple2 = ((IterableOps)tasks.flatMap((Function1 & Serializable)x$2 -> syntax.TaskOps$.MODULE$.dependencies$extension(syntax$.MODULE$.TaskOps(x$2)))).partition((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isArchived()));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        scala.collection.immutable.Set archivedDeps = (scala.collection.immutable.Set)tuple2._1();
        scala.collection.immutable.Set otherDeps = (scala.collection.immutable.Set)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)archivedDeps, (Object)otherDeps);
        scala.collection.immutable.Set archivedDeps2 = (scala.collection.immutable.Set)tuple22._1();
        scala.collection.immutable.Set otherDeps2 = (scala.collection.immutable.Set)tuple22._2();
        this.dependencyPersistence().batchDeleteDependencies((scala.collection.immutable.Set<Dependency>)archivedDeps2);
        this.dependencyPersistence().batchUpdateDependencies((scala.collection.immutable.Set<Dependency>)otherDeps2);
        tasks.foreach((Function1 & Serializable)ci -> {
            this.afterUpdate((ConfigurationItem)ci);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public Task updateTaskAndReleaseFlagStatus(Task task, Release release) {
        return this.update(task);
    }

    @Timed
    public Task updateType(Task task) {
        Task updated = this.update(task);
        this.taskPersistence().updateType(task);
        return updated;
    }

    @Timed
    public void delete(Task task) {
        String taskId = task.getId();
        this.checkIsNotReferencedByDependencies(taskId);
        this.interceptDelete(taskId);
        this.releasePersistence().update(task.getRelease());
        syntax.TaskOps$.MODULE$.allDependencies$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable)dependency -> {
            SqlTaskRepository.$anonfun$delete$1(this, dependency);
            return BoxedUnit.UNIT;
        });
        task.getAllTasks().forEach(t -> {
            this.commentRepository().deleteByTask(t);
            this.taskPersistence().delete((Task)t);
        });
        this.updateConfigurationRefs((CiWithUid)task.getRelease());
        this.afterDelete(taskId);
    }

    private Task createTask(Task newTask2) {
        this.taskPersistence().insert(newTask2, Predef$.MODULE$.Integer2int(newTask2.getRelease().getCiUid()));
        Object object = newTask2 instanceof TaskGroup ? ((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(newTask2.getAllTasks()).asScala().filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)SqlTaskRepository.$anonfun$createTask$1(newTask2, x$5)))).map((Function1 & Serializable)newTask -> this.createTask((Task)newTask)) : BoxedUnit.UNIT;
        return newTask2;
    }

    @Timed
    public Task create(Task newTask) {
        this.interceptCreate((ConfigurationItem)newTask);
        this.releasePersistence().update(newTask.getRelease());
        Task createdTask = this.createTask(newTask);
        syntax.TaskOps$.MODULE$.allDependencies$extension(syntax$.MODULE$.TaskOps(createdTask)).foreach((Function1 & Serializable)dependency -> {
            this.insertDependency(dependency);
            return BoxedUnit.UNIT;
        });
        this.updateConfigurationRefs((CiWithUid)createdTask.getRelease());
        this.facetRepositoryDispatcher().liveRepository().createFromTasks(CollectionConverters$.MODULE$.ListHasAsScala(newTask.getAllTasks()).asScala().toSeq(), this.facetRepositoryDispatcher().liveRepository().createFromTasks$default$2());
        this.afterCreate((ConfigurationItem)createdTask);
        return createdTask;
    }

    @Timed
    public Task moveTask(Task taskToMove, Task movedTask, TaskContainer updatedOriginContainer, TaskContainer updatedTargetContainer) {
        TaskContainer taskContainer = updatedOriginContainer;
        TaskContainer taskContainer2 = updatedTargetContainer;
        if (taskContainer == null ? taskContainer2 != null : !taskContainer.equals(taskContainer2)) {
            this.checkIsNotReferencedByDependencies(taskToMove.getId());
            CollectionConverters$.MODULE$.ListHasAsScala(taskToMove.getAllTasks()).asScala().foreach((Function1 & Serializable)taskWithOldId -> {
                SqlTaskRepository.$anonfun$moveTask$1(this, taskToMove, movedTask, taskWithOldId);
                return BoxedUnit.UNIT;
            });
        }
        this.releasePersistence().update(movedTask.getRelease());
        return movedTask;
    }

    @Timed
    public java.util.List<String> findAffectedByBlackout(Blackout blackout) {
        Date endDate = BlackoutMetadata$.MODULE$.toStartOfNextMinute(blackout.getEndDate());
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.dialect()).selectReleaseData().withOneOfStatuses((scala.collection.immutable.Seq<ReleaseStatus>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)ReleaseStatus.ACTIVE_STATUSES)).build();
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOps)((IterableOps)((IterableOps)this.releasePersistence().findReleaseDatasByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlWithParams).flatMap((Function1 & Serializable)releaseData -> this.tryDeserializeRelease((ReleaseRow)releaseData))).flatMap((Function1 & Serializable)rel -> CollectionConverters$.MODULE$.ListHasAsScala(rel.getAllTasks()).asScala())).filter((Function1 & Serializable)task -> BoxesRunTime.boxToBoolean((boolean)SqlTaskRepository.$anonfun$findAffectedByBlackout$3(endDate, task)))).map((Function1 & Serializable)x$6 -> x$6.getId())).asJava();
    }

    @Timed
    public java.util.List<String> findPendingTasksWithFacets() {
        Tuple2 sqlWithParams = new TasksSqlBuilder(this.dialect()).selectTaskId().withOneOfTaskStatuses((scala.collection.immutable.Seq<TaskStatus>)new .colon.colon((Object)TaskStatus.PENDING, (List)Nil$.MODULE$)).withAnyFacets().build();
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.taskPersistence().findTaskIdsByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlWithParams).toSet().toList()).asJava();
    }

    @Timed
    @IsReadOnly
    public String getTitle(String taskId) {
        return (String)this.taskPersistence().getTitle(taskId).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Task [%s] not found", new Object[]{taskId});
        });
    }

    @Timed
    @IsReadOnly
    public Set<String> getAllTags(int limitNumber) {
        return CollectionConverters$.MODULE$.SetHasAsJava(this.taskPersistence().findAllTags(limitNumber)).asJava();
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<String> findOverdueTaskIds() {
        return this.taskPersistence().findOverdueTaskIds();
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<String> findDueSoonTaskIds() {
        return this.taskPersistence().findDueSoonTaskIds();
    }

    @Timed
    @IsReadOnly
    public TaskStatus getStatus(String taskId) {
        return (TaskStatus)this.taskPersistence().getStatus(taskId).getOrElse((Function0 & Serializable)() -> {
            throw new LogFriendlyNotFoundException("getStatus: could not find task '" + taskId + "'", new Object[0]);
        });
    }

    @Timed
    @IsReadOnly
    public Map<String, TaskStatus> getTaskStatuses(String releaseId) {
        return this.taskPersistence().getTaskStatuses(releaseId);
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<String> findTaskIdsByTaskTypeStatusAndStartDate(Type taskType, TaskStatus taskStatus, Date startedBefore) {
        return this.taskPersistence().findTaskIdsByTaskTypeStatusAndStartDate(taskType, taskStatus, startedBefore);
    }

    public void updateTaskStatusLine(String taskId, String statusLine) {
        this.taskPersistence().updateStatusLine(taskId, statusLine);
    }

    public static final /* synthetic */ void $anonfun$updateTasks$2(SqlTaskRepository $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Release release = (Release)tuple2._1();
            scala.collection.immutable.Seq tasks = (scala.collection.immutable.Seq)tuple2._2();
            tasks.foreach((Function1 & Serializable)ci -> {
                $this.interceptUpdate((ConfigurationItem)ci);
                return BoxedUnit.UNIT;
            });
            $this.releasePersistence().update(release);
            tasks.foreach((Function1 & Serializable)task -> {
                $this.updateTaskPropertiesInternal(task);
                return BoxedUnit.UNIT;
            });
            tasks.foreach((Function1 & Serializable)ci -> {
                $this.afterUpdate((ConfigurationItem)ci);
                return BoxedUnit.UNIT;
            });
            $this.updateConfigurationRefs((CiWithUid)release);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$updateTaskPropertiesInternal$1(SqlTaskRepository $this, Task task$1, Dependency x0$1) {
        BoxedUnit boxedUnit;
        Dependency dependency = x0$1;
        if (dependency.isArchived()) {
            $this.dependencyPersistence().deleteDependency(dependency);
            return;
        }
        try {
            $this.dependencyPersistence().updateDependency(dependency);
            boxedUnit = BoxedUnit.UNIT;
        }
        catch (NotFoundException e) {
            $this.logger().error((Function0 & Serializable)() -> "Dependency " + dependency + " not found when updating task " + task$1, (Function0 & Serializable)() -> e);
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$delete$1(SqlTaskRepository $this, Dependency dependency) {
        $this.dependencyPersistence().deleteDependency(dependency);
    }

    public static final /* synthetic */ boolean $anonfun$createTask$1(Task newTask$1, Task x$5) {
        String string = x$5.getContainer().getId();
        String string2 = newTask$1.getId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$moveTask$1(SqlTaskRepository $this, Task taskToMove$1, Task movedTask$1, Task taskWithOldId) {
        String oldId = taskWithOldId.getId();
        String newId = oldId.replace(taskToMove$1.getId(), movedTask$1.getId());
        $this.taskPersistence().move(oldId, newId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$findAffectedByBlackout$3(Date endDate$1, Task task) {
        TaskStatus taskStatus = task.getStatus();
        TaskStatus taskStatus2 = TaskStatus.PENDING;
        if (taskStatus == null) {
            if (taskStatus2 != null) {
                return false;
            }
        } else if (!taskStatus.equals(taskStatus2)) return false;
        if (!task.isPostponedDueToBlackout()) return false;
        Date date = task.getScheduledStartDate();
        Date date2 = endDate$1;
        if (date == null) {
            if (date2 == null) return true;
            return false;
        } else {
            if (!((Object)date).equals(date2)) return false;
            return true;
        }
    }

    public SqlTaskRepository(ReleasePersistence releasePersistence, DependencyPersistence dependencyPersistence, TaskPersistence taskPersistence, CommentRepository commentRepository, SqlRepositoryAdapter repositoryAdapter, ConfigurationReferencePersistence configurationPersistence, FacetRepositoryDispatcher facetRepositoryDispatcher, SqlBuilder.Dialect dialect) {
        this.releasePersistence = releasePersistence;
        this.dependencyPersistence = dependencyPersistence;
        this.taskPersistence = taskPersistence;
        this.commentRepository = commentRepository;
        this.repositoryAdapter = repositoryAdapter;
        this.configurationPersistence = configurationPersistence;
        this.facetRepositoryDispatcher = facetRepositoryDispatcher;
        this.dialect = dialect;
        TaskRepository.$init$((TaskRepository)this);
        InterceptedRepository.$init$((InterceptedRepository)this);
        BaseReleaseItemRepository.$init$(this);
        DeserializationSupport.$init$(this);
        ConfigurationReferencesSupport.$init$(this);
        Logging.$init$((Logging)this);
    }
}

