import { all, call, put, takeLatest } from 'redux-saga/effects';
import { PayloadAction } from '@reduxjs/toolkit';
import { IHttpResponse } from 'angular';
import { fetchDeliveries, getDelivery } from '../../../../deliveries/services';
import { searchDeliveryPatterns, fetchDeliveryPattern } from '../../../../delivery-patterns/delivery-pattern.service';

import { deliveryTasks, LoadDeliveryOrPatternAction, SearchDeliveriesOrPatternsAction } from './delivery-tasks.reducer';
import { Delivery } from '../types';

const { loadDeliveryOrPattern, setDeliveryOrPattern, searchDeliveriesOrPatterns, setDeliveriesOrPatterns, setPatterns, searchPatterns } = deliveryTasks.actions;

export function* loadDeliveryOrPatternSaga(action: PayloadAction<LoadDeliveryOrPatternAction>) {
    const { isDelivery, id } = action.payload;
    try {
        let deliveryOrPattern: Delivery;
        if (isDelivery) {
            const { data }: IHttpResponse<Delivery> = yield call(getDelivery, id, true);
            deliveryOrPattern = data;
        } else {
            deliveryOrPattern = yield call(fetchDeliveryPattern, id);
        }
        yield put(setDeliveryOrPattern(deliveryOrPattern));
    } catch (_e) {
        yield put(setDeliveryOrPattern({ id: 'NOT_FOUND', title: '', stages: [] }));
    }
}

export function* searchDeliveriesOrPatternsSaga(action: PayloadAction<SearchDeliveriesOrPatternsAction>) {
    const { isDelivery } = action.payload;
    const deliveriesOrPatterns: Array<Delivery> = [];
    if (isDelivery) {
        const { data }: IHttpResponse<Array<Delivery>> = yield call(
            fetchDeliveries,
            {
                inProgress: true,
                title: '',
            },
            0,
            100,
        );
        deliveriesOrPatterns.push(...data);
    } else {
        const patterns: Array<Delivery> = yield call(searchDeliveryPatterns, { title: '' });
        deliveriesOrPatterns.push(...patterns);
    }
    yield put(setDeliveriesOrPatterns(deliveriesOrPatterns));
}

export function* searchPatternsSaga() {
    const patterns: Array<Delivery> = yield call(searchDeliveryPatterns, { title: '' });
    yield put(setPatterns(patterns));
}

export function* deliveryTasksSaga() {
    yield all([
        takeLatest(loadDeliveryOrPattern, loadDeliveryOrPatternSaga),
        takeLatest(searchDeliveriesOrPatterns, searchDeliveriesOrPatternsSaga),
        takeLatest(searchPatterns, searchPatternsSaga),
    ]);
}
