/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.notifications.email;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.domain.notification.MailPriority;
import com.xebialabs.xlrelease.notifications.configuration.SmtpServer;
import com.xebialabs.xlrelease.notifications.email.Email;
import com.xebialabs.xlrelease.notifications.email.EmailFactory;
import com.xebialabs.xlrelease.notifications.email.RefreshTokenOAuth2Helper;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import javax.mail.Authenticator;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.mail.DefaultAuthenticator;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EmailSender {
    private static final Logger logger = LoggerFactory.getLogger(EmailSender.class);
    private final XlrConfig xlrConfig;
    private ConfigurationRepository configurationRepository;
    private EmailFactory emailFactory;
    private RefreshTokenOAuth2Helper refreshTokenOAuth2Helper;

    @Autowired
    public EmailSender(ConfigurationRepository configurationRepository, EmailFactory emailFactory, RefreshTokenOAuth2Helper refreshTokenOAuth2Helper, XlrConfig xlrConfig) {
        this.configurationRepository = configurationRepository;
        this.emailFactory = emailFactory;
        this.refreshTokenOAuth2Helper = refreshTokenOAuth2Helper;
        this.xlrConfig = xlrConfig;
    }

    public CompletableFuture<Void> scheduleEmail(Email email) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.xlrConfig.auxiliaryExecutor().submit(() -> {
            try {
                this.sendEmailSync(email);
                future.complete(null);
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public void sendEmailSync(Email email) throws EmailException, NotFoundException {
        if (this.xlrConfig.maintenanceModeEnabled()) {
            logger.warn("[MAINTENANCE MODE] Email notification '{}' - DROPPED", (Object)email.subject);
            return;
        }
        if (email.getRecipients() == null || email.getRecipients().isEmpty()) {
            String msg = String.format("Email with subject '%s' not sent, because the recipient is missing.", email.getSubject());
            logger.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        try {
            this.sendHTML(email);
        }
        catch (NotFoundException notFoundException) {
            logger.info("Could not send email: {}. Please configure the SMTP Server", (Object)notFoundException.toString());
            throw notFoundException;
        }
        catch (EmailException e) {
            logger.error("Could not send email ", (Throwable)e);
            throw e;
        }
    }

    void sendHTML(Email email) throws EmailException {
        SmtpServer smtpServer = (SmtpServer)this.configurationRepository.read(SmtpServer.SMTP_SERVER_ID());
        this.sendHTML(smtpServer, email);
    }

    public void sendHTML(SmtpServer smtpServer, Email email) throws EmailException {
        boolean overrideCredentials = this.hasOverriddenCredentials(email);
        if (!overrideCredentials) {
            this.refreshTokenOAuth2Helper.refreshTokenIfRequired(smtpServer);
        }
        HtmlEmail htmlEmail = this.emailFactory.newHtmlEmail(smtpServer);
        this.setRecipients(htmlEmail, email.getRecipients());
        if (email.getFrom().isPresent() && !email.getFrom().get().isEmpty()) {
            this.setFrom(htmlEmail, email.getFrom().get());
        } else {
            this.setFrom(htmlEmail, smtpServer.getFromAddress());
        }
        if (overrideCredentials) {
            DefaultAuthenticator authenticator = new DefaultAuthenticator(email.getSenderUsername().get(), PasswordEncrypter.getInstance().ensureDecrypted(email.getSenderPassword().get()));
            Properties mailProps = htmlEmail.getMailSession().getProperties();
            mailProps.setProperty("mail.smtp.auth.mechanisms", "LOGIN PLAIN DIGEST-MD5 NTLM");
            mailProps.setProperty("mail.smtp.auth.xoauth2.disable", "true");
            Session newSession = Session.getInstance((Properties)mailProps, (Authenticator)authenticator);
            htmlEmail.setMailSession(newSession);
            htmlEmail.setAuthenticator((Authenticator)authenticator);
        }
        this.setMailPriority(htmlEmail, email.getPriority().orElse(MailPriority.Normal));
        if (email.getBcc().isPresent() && !email.getBcc().get().isEmpty()) {
            htmlEmail.setBcc(this.toInternetAddresses(email.getBcc().get()));
        }
        if (email.getCc().isPresent() && !email.getCc().get().isEmpty()) {
            htmlEmail.setCc(this.toInternetAddresses(email.getCc().get()));
        }
        if (email.getReplyTo().isPresent() && !email.getReplyTo().get().isEmpty()) {
            htmlEmail.setReplyTo(this.toInternetAddresses(Lists.newArrayList((Object[])new String[]{email.getReplyTo().get()})));
        }
        htmlEmail.setSubject(email.getSubject());
        htmlEmail.setHtmlMsg(email.getBody());
        htmlEmail.send();
    }

    private boolean hasOverriddenCredentials(Email email) {
        return email.getSenderUsername().isPresent() && !email.getSenderUsername().get().isEmpty() && email.getSenderPassword().isPresent() && !email.getSenderPassword().get().isEmpty();
    }

    void setMailPriority(HtmlEmail htmlEmail, MailPriority mailPriority) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-Priority", mailPriority.getPriority());
        headers.put("Importance", mailPriority.getImportance());
        htmlEmail.setHeaders(headers);
    }

    @VisibleForTesting
    void setRecipients(HtmlEmail htmlEmail, Collection<String> recipients) throws EmailException {
        htmlEmail.setTo(this.toInternetAddresses(recipients));
    }

    @VisibleForTesting
    List<InternetAddress> toInternetAddresses(Collection<String> recipients) throws EmailException {
        ArrayList addresses = Lists.newArrayList();
        for (String recipient : recipients) {
            try {
                addresses.addAll(Arrays.asList(InternetAddress.parse((String)recipient)));
            }
            catch (AddressException e) {
                throw new EmailException((Throwable)e);
            }
        }
        return addresses;
    }

    @VisibleForTesting
    void setFrom(HtmlEmail email, String fromAddress) throws EmailException {
        if (fromAddress == null) {
            return;
        }
        try {
            InternetAddress from = new InternetAddress(fromAddress);
            email.setFrom(from.getAddress(), from.getPersonal());
        }
        catch (AddressException e) {
            throw new EmailException((Throwable)e);
        }
    }
}

