/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scheduler;

import akka.actor.Address;
import com.codahale.metrics.InstrumentedExecutorService;
import com.xebialabs.xlplatform.cluster.ClusterMode;
import com.xebialabs.xlrelease.actors.ActorSystemHolder;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.domain.runner.JobRunner;
import com.xebialabs.xlrelease.metrics.XlrMetricRegistry$;
import com.xebialabs.xlrelease.repository.JobRunnerRepository;
import com.xebialabs.xlrelease.scheduler.Job;
import com.xebialabs.xlrelease.scheduler.JobQueue;
import com.xebialabs.xlrelease.scheduler.JobRecoveryLogic;
import com.xebialabs.xlrelease.scheduler.JobRow;
import com.xebialabs.xlrelease.scheduler.JobStatus;
import com.xebialabs.xlrelease.scheduler.JobType;
import com.xebialabs.xlrelease.scheduler.NodeId;
import com.xebialabs.xlrelease.scheduler.TaskJob;
import com.xebialabs.xlrelease.scheduler.WorkerThread;
import com.xebialabs.xlrelease.scheduler.domain.LocalJobRunner$;
import com.xebialabs.xlrelease.scheduler.service.JobService;
import com.xebialabs.xlrelease.scheduler.workers.CompositeWorker;
import com.xebialabs.xlrelease.script.DefaultScriptService;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.utils.PrefixedThreadFactory$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Marker;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005\rg\u0001\u0002\u0012$\u00011B\u0001b\u000e\u0001\u0003\u0006\u0004%\t\u0001\u000f\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005s!A\u0001\t\u0001BC\u0002\u0013\u0005\u0011\t\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003C\u0011!1\u0005A!b\u0001\n\u00039\u0005\u0002\u0003(\u0001\u0005\u0003\u0005\u000b\u0011\u0002%\t\u0011=\u0003!Q1A\u0005\u0002AC\u0001b\u0016\u0001\u0003\u0002\u0003\u0006I!\u0015\u0005\t1\u0002\u0011)\u0019!C\u00013\"A\u0001\r\u0001B\u0001B\u0003%!\f\u0003\u0005b\u0001\t\u0015\r\u0011\"\u0001c\u0011!I\u0007A!A!\u0002\u0013\u0019\u0007\u0002\u00036\u0001\u0005\u000b\u0007I\u0011A6\t\u0011=\u0004!\u0011!Q\u0001\n1DQ\u0001\u001d\u0001\u0005\u0002ED!\"a\u0004\u0001\u0011\u000b\u0007I\u0011BA\t\u0011-\tI\u0002\u0001a\u0001\u0002\u0004%I!a\u0007\t\u0017\u0005E\u0002\u00011AA\u0002\u0013%\u00111\u0007\u0005\f\u0003\u007f\u0001\u0001\u0019!A!B\u0013\ti\u0002C\u0005\u0002B\u0001\u0011\r\u0011\"\u0003\u0002D!A\u0011\u0011\u000b\u0001!\u0002\u0013\t)\u0005C\u0005\u0002T\u0001\u0011\r\u0011\"\u0003\u0002V!A\u0011Q\u000e\u0001!\u0002\u0013\t9\u0006C\u0004\u0002p\u0001!\t!!\u001d\t\u000f\u0005M\u0004\u0001\"\u0001\u0002r!9\u0011Q\u000f\u0001\u0005\n\u0005E\u0004bBA<\u0001\u0011%\u0011\u0011\u000f\u0005\b\u0003s\u0002A\u0011BA\u000e\u0011\u001d\tY\b\u0001C\u0001\u0003cBq!! \u0001\t\u0003\ty\bC\u0004\u0002\f\u0002!\t!!$\t\u000f\u0005E\u0005\u0001\"\u0001\u0002\u0014\"9\u0011q\u0016\u0001\u0005\n\u0005E&aC,pe.l\u0015M\\1hKJT!\u0001J\u0013\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014(B\u0001\u0014(\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002)S\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002U\u0005\u00191m\\7\u0004\u0001M\u0019\u0001!L\u001a\u0011\u00059\nT\"A\u0018\u000b\u0003A\nQa]2bY\u0006L!AM\u0018\u0003\r\u0005s\u0017PU3g!\t!T'D\u0001$\u0013\t14E\u0001\tK_\n\u0014VmY8wKJLHj\\4jG\u0006I\u0001\u0010\u001c:D_:4\u0017nZ\u000b\u0002sA\u0011!(P\u0007\u0002w)\u0011A(J\u0001\u0007G>tg-[4\n\u0005yZ$!\u0003-me\u000e{gNZ5h\u0003)AHN]\"p]\u001aLw\rI\u0001\tU>\u0014\u0017+^3vKV\t!\t\u0005\u00025\u0007&\u0011Ai\t\u0002\t\u0015>\u0014\u0017+^3vK\u0006I!n\u001c2Rk\u0016,X\rI\u0001\u0010G>l\u0007o\\:ji\u0016<vN]6feV\t\u0001\n\u0005\u0002J\u00196\t!J\u0003\u0002LG\u00059qo\u001c:lKJ\u001c\u0018BA'K\u0005=\u0019u.\u001c9pg&$XmV8sW\u0016\u0014\u0018\u0001E2p[B|7/\u001b;f/>\u00148.\u001a:!\u0003)QwNY*feZL7-Z\u000b\u0002#B\u0011!+V\u0007\u0002'*\u0011AkI\u0001\bg\u0016\u0014h/[2f\u0013\t16K\u0001\u0006K_\n\u001cVM\u001d<jG\u0016\f1B[8c'\u0016\u0014h/[2fA\u0005\u0019\"n\u001c2Sk:tWM\u001d*fa>\u001c\u0018\u000e^8ssV\t!\f\u0005\u0002\\=6\tAL\u0003\u0002^K\u0005Q!/\u001a9pg&$xN]=\n\u0005}c&a\u0005&pEJ+hN\\3s%\u0016\u0004xn]5u_JL\u0018\u0001\u00066pEJ+hN\\3s%\u0016\u0004xn]5u_JL\b%A\nsK2,\u0017m]3BGR|'oU3sm&\u001cW-F\u0001d!\t!w-D\u0001f\u0015\t1W%\u0001\u0004bGR|'o]\u0005\u0003Q\u0016\u00141CU3mK\u0006\u001cX-Q2u_J\u001cVM\u001d<jG\u0016\fAC]3mK\u0006\u001cX-Q2u_J\u001cVM\u001d<jG\u0016\u0004\u0013!E1di>\u00148+_:uK6Du\u000e\u001c3feV\tA\u000e\u0005\u0002e[&\u0011a.\u001a\u0002\u0012\u0003\u000e$xN]*zgR,W\u000eS8mI\u0016\u0014\u0018AE1di>\u00148+_:uK6Du\u000e\u001c3fe\u0002\na\u0001P5oSRtD\u0003\u0003:tiV4x\u000f_=\u0011\u0005Q\u0002\u0001\"B\u001c\u0010\u0001\u0004I\u0004\"\u0002!\u0010\u0001\u0004\u0011\u0005\"\u0002$\u0010\u0001\u0004A\u0005\"B(\u0010\u0001\u0004\t\u0006\"\u0002-\u0010\u0001\u0004Q\u0006\"B1\u0010\u0001\u0004\u0019\u0007\"\u00026\u0010\u0001\u0004a\u0007FA=|!\ra\u00181B\u0007\u0002{*\u0011ap`\u0001\u000bC:tw\u000e^1uS>t'\u0002BA\u0001\u0003\u0007\tqaY8oi\u0016DHO\u0003\u0003\u0002\u0006\u0005\u001d\u0011aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0005\u0005%\u0011aA8sO&\u0019\u0011QB?\u0003\t1\u000b'0_\u0001\u0010[\u0006DH\u000b\u001b:fC\u0012\u001c8i\\;oiV\u0011\u00111\u0003\t\u0004]\u0005U\u0011bAA\f_\t\u0019\u0011J\u001c;\u0002\u0015QD'/Z1e!>|G.\u0006\u0002\u0002\u001eA!\u0011qDA\u0017\u001b\t\t\tC\u0003\u0003\u0002$\u0005\u0015\u0012AC2p]\u000e,(O]3oi*!\u0011qEA\u0015\u0003\u0011)H/\u001b7\u000b\u0005\u0005-\u0012\u0001\u00026bm\u0006LA!a\f\u0002\"\tyQ\t_3dkR|'oU3sm&\u001cW-\u0001\buQJ,\u0017\r\u001a)p_2|F%Z9\u0015\t\u0005U\u00121\b\t\u0004]\u0005]\u0012bAA\u001d_\t!QK\\5u\u0011%\tiDEA\u0001\u0002\u0004\ti\"A\u0002yIE\n1\u0002\u001e5sK\u0006$\u0007k\\8mA\u0005\u00112\u000f[;uI><h.\u00138Qe><'/Z:t+\t\t)\u0005\u0005\u0003\u0002H\u00055SBAA%\u0015\u0011\tY%!\t\u0002\r\u0005$x.\\5d\u0013\u0011\ty%!\u0013\u0003\u001b\u0005#x.\\5d\u0005>|G.Z1o\u0003M\u0019\b.\u001e;e_^t\u0017J\u001c)s_\u001e\u0014Xm]:!\u000359xN]6feRC'/Z1egV\u0011\u0011q\u000b\t\u0007\u00033\n\u0019'a\u001a\u000e\u0005\u0005m#\u0002BA/\u0003?\nq!\\;uC\ndWMC\u0002\u0002b=\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t)'a\u0017\u0003\r\t+hMZ3s!\r!\u0014\u0011N\u0005\u0004\u0003W\u001a#\u0001D,pe.,'\u000f\u00165sK\u0006$\u0017AD<pe.,'\u000f\u00165sK\u0006$7\u000fI\u0001\u0006gR\f'\u000f\u001e\u000b\u0003\u0003k\t1B]3d_Z,'OS8cg\u0006a1\u000f^1siRC'/Z1eg\u0006!1\u000f^8q\u000359W\r\u001e+ie\u0016\fG\rU8pY\u0006A1\u000f[;uI><h.\u0001\u0004tk\nl\u0017\u000e\u001e\u000b\u0005\u0003k\t\t\tC\u0004\u0002\u0004z\u0001\r!!\"\u0002\u0007)|'\rE\u00025\u0003\u000fK1!!#$\u0005\rQuNY\u0001\be\u0016\u0004H.Y2f)\u0011\t)$a$\t\u000f\u0005\ru\u00041\u0001\u0002\u0006\u0006\u0001\u0012MY8si*{'MQ=UCN\\\u0017\n\u001a\u000b\u0005\u0003k\t)\nC\u0004\u0002\u0018\u0002\u0002\r!!'\u0002\rQ\f7o[%e!\u0011\tY*!+\u000f\t\u0005u\u0015Q\u0015\t\u0004\u0003?{SBAAQ\u0015\r\t\u0019kK\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\u001dv&\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003W\u000biK\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003O{\u0013\u0001\u0007:fcV,7\u000f\u001e*v]:,'\u000fV8BE>\u0014H\u000fV1tWR!\u0011QGAZ\u0011\u001d\t9*\ta\u0001\u00033C3\u0001AA\\!\u0011\tI,a0\u000e\u0005\u0005m&\u0002BA_\u0003\u0007\t!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\t\t-a/\u0003\u000fM+'O^5dK\u0002")
public class WorkManager
implements JobRecoveryLogic {
    private int maxThreadsCount;
    private final XlrConfig xlrConfig;
    private final JobQueue jobQueue;
    private final CompositeWorker compositeWorker;
    private final JobService jobService;
    private final JobRunnerRepository jobRunnerRepository;
    private final ReleaseActorService releaseActorService;
    private final ActorSystemHolder actorSystemHolder;
    private ExecutorService threadPool;
    private final AtomicBoolean shutdownInProgress;
    private final Buffer<WorkerThread> workerThreads;
    private String nodeId;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    @Override
    public void recoverAllJobs() {
        JobRecoveryLogic.recoverAllJobs$(this);
    }

    @Override
    public void recoverJobs(String nodeId) {
        JobRecoveryLogic.recoverJobs$(this, nodeId);
    }

    @Override
    public String convertAddressToNodeId(Address address) {
        return NodeId.convertAddressToNodeId$(this, address);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private String nodeId$lzycompute() {
        WorkManager workManager = this;
        synchronized (workManager) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.nodeId = NodeId.nodeId$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.nodeId;
    }

    @Override
    public String nodeId() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.nodeId$lzycompute();
        }
        return this.nodeId;
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        WorkManager workManager = this;
        synchronized (workManager) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public XlrConfig xlrConfig() {
        return this.xlrConfig;
    }

    @Override
    public JobQueue jobQueue() {
        return this.jobQueue;
    }

    public CompositeWorker compositeWorker() {
        return this.compositeWorker;
    }

    @Override
    public JobService jobService() {
        return this.jobService;
    }

    public JobRunnerRepository jobRunnerRepository() {
        return this.jobRunnerRepository;
    }

    @Override
    public ReleaseActorService releaseActorService() {
        return this.releaseActorService;
    }

    @Override
    public ActorSystemHolder actorSystemHolder() {
        return this.actorSystemHolder;
    }

    private int maxThreadsCount$lzycompute() {
        WorkManager workManager = this;
        synchronized (workManager) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.maxThreadsCount = this.xlrConfig().executors().scheduler().maxThreadsCount();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.maxThreadsCount;
    }

    private int maxThreadsCount() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.maxThreadsCount$lzycompute();
        }
        return this.maxThreadsCount;
    }

    private ExecutorService threadPool() {
        return this.threadPool;
    }

    private void threadPool_$eq(ExecutorService x$1) {
        this.threadPool = x$1;
    }

    private AtomicBoolean shutdownInProgress() {
        return this.shutdownInProgress;
    }

    private Buffer<WorkerThread> workerThreads() {
        return this.workerThreads;
    }

    public void start() {
        this.logger().info((Function0 & Serializable)() -> "Starting work manager with " + this.maxThreadsCount() + " threads");
        this.stop();
        this.jobQueue().cancelIf(x$2 -> true);
        this.jobQueue().start();
        if (this.xlrConfig().maintenanceModeEnabled()) {
            this.logger().debug((Function0 & Serializable)() -> "[MAINTENANCE MODE] Job recovery - DISABLED");
        } else {
            this.recoverJobs();
        }
        this.startThreads();
        this.logger().info((Function0 & Serializable)() -> "Started work manager");
    }

    public void recoverJobs() {
        try {
            this.logger().debug((Function0 & Serializable)() -> "Job recovery started");
            ClusterMode clusterMode = this.xlrConfig().cluster().mode();
            if (ClusterMode.Standalone$.MODULE$.equals(clusterMode)) {
                this.recoverAllJobs();
            } else {
                this.recoverJobs(this.nodeId());
                this.recoverJobs(null);
            }
            this.logger().debug((Function0 & Serializable)() -> "Job recovery completed, proceeding with startup");
        }
        catch (Throwable t) {
            this.logger().error((Function0 & Serializable)() -> "Job recovery failed", (Function0 & Serializable)() -> t);
        }
    }

    private void startThreads() {
        this.shutdownInProgress().set(false);
        this.threadPool_$eq(this.getThreadPool());
        this.workerThreads().clear();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.maxThreadsCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$3 -> {
            int n = x$3;
            WorkerThread workerThread = new WorkerThread(this.jobQueue(), this.compositeWorker());
            this.workerThreads().$plus$eq((Object)workerThread);
            this.threadPool().execute(workerThread);
        });
    }

    private void stop() {
        this.workerThreads().foreach((Function1 & Serializable)worker -> {
            worker.stop();
            return BoxedUnit.UNIT;
        });
        this.workerThreads().clear();
        this.jobQueue().stop();
    }

    private ExecutorService getThreadPool() {
        ExecutorService executors = Executors.newFixedThreadPool(this.maxThreadsCount(), PrefixedThreadFactory$.MODULE$.apply("task-execution", PrefixedThreadFactory$.MODULE$.apply$default$2()));
        if (this.xlrConfig().metrics().enabled()) {
            return new InstrumentedExecutorService(executors, XlrMetricRegistry$.MODULE$.metricRegistry(), "taskExecution");
        }
        return executors;
    }

    public void shutdown() {
        if (this.shutdownInProgress().compareAndSet(false, true)) {
            this.logger().info((Function0 & Serializable)() -> "starting shutdown");
            this.stop();
            this.threadPool().shutdown();
            if (!this.threadPool().awaitTermination(this.xlrConfig().taskSchedulerGraceShutdownPeriod(), TimeUnit.SECONDS)) {
                this.logger().warn((Function0 & Serializable)() -> "There are tasks, that did not complete within shutdown grace period, going to interrupt those tasks");
                this.threadPool().shutdownNow();
                if (!this.threadPool().awaitTermination(this.xlrConfig().taskSchedulerGraceShutdownPeriod(), TimeUnit.SECONDS)) {
                    this.logger().error((Function0 & Serializable)() -> "There are tasks, that could not be interrupted, giving up");
                }
            }
            this.jobQueue().cancelIf(x$4 -> true);
            this.shutdownInProgress().set(false);
            return;
        }
        this.logger().info((Function0 & Serializable)() -> "skipping shutdown, because shutdown already happened or in progress");
    }

    public void submit(Job job) {
        this.jobQueue().submit(job);
    }

    public void replace(Job job) {
        this.jobQueue().replace(job);
    }

    public void abortJobByTaskId(String taskId) {
        this.logger().debug((Function0 & Serializable)() -> "Aborting scheduled job " + taskId);
        this.requestRunnerToAbortTask(taskId);
        this.jobService().deleteByTaskId(taskId);
        this.jobQueue().cancelIf(x0$1 -> {
            Job job = x0$1;
            if (job instanceof TaskJob) {
                TaskJob taskJob = (TaskJob)job;
                return taskJob.taskId().equals(taskId);
            }
            return false;
        });
    }

    private void requestRunnerToAbortTask(String taskId) {
        this.jobService().findByTaskId(taskId).foreach((Function1 & Serializable)jobRow -> {
            WorkManager.$anonfun$requestRunnerToAbortTask$1(this, taskId, jobRow);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$requestRunnerToAbortTask$1(WorkManager $this, String taskId$2, JobRow jobRow) {
        JobType jobType = jobRow.jobType();
        JobType jobType2 = JobType.CONTAINER_TASK;
        if (!(jobType != null ? !((Object)((Object)jobType)).equals((Object)jobType2) : jobType2 != null)) {
            if (new .colon.colon((Object)JobStatus.RESERVED, (List)new .colon.colon((Object)JobStatus.RUNNING, (List)Nil$.MODULE$)).contains((Object)jobRow.status()) && jobRow.runnerId() != null) {
                Option<? extends JobRunner> option = $this.jobRunnerRepository().findRunner(jobRow.runnerId());
                if (option instanceof Some) {
                    Some some = (Some)option;
                    JobRunner runner = (JobRunner)some.value();
                    runner.abortJob(jobRow.id(), jobRow.executionId());
                } else if (None$.MODULE$.equals(option)) {
                    $this.logger().error((Function0 & Serializable)() -> "Can't find runner [" + jobRow.runnerId() + "]. Can't request runner to abort the job [" + jobRow.id() + "]");
                } else {
                    throw new MatchError(option);
                }
                JobStatus jobStatus = jobRow.status();
                JobStatus jobStatus2 = JobStatus.RESERVED;
                if (!(jobStatus != null ? !((Object)((Object)jobStatus)).equals((Object)jobStatus2) : jobStatus2 != null)) {
                    $this.releaseActorService().failTaskAsync(taskId$2, "Task was aborted", User.SYSTEM, (Option<DefaultScriptService.BaseScriptTaskResults>)None$.MODULE$);
                    return;
                }
                return;
            }
            JobStatus jobStatus = jobRow.status();
            JobStatus jobStatus3 = JobStatus.QUEUED;
            if (!(jobStatus != null ? !((Object)((Object)jobStatus)).equals((Object)jobStatus3) : jobStatus3 != null)) {
                $this.releaseActorService().failTaskAsync(taskId$2, "Task was aborted", User.SYSTEM, (Option<DefaultScriptService.BaseScriptTaskResults>)None$.MODULE$);
                return;
            }
            return;
        }
        LocalJobRunner$.MODULE$.abortJob(jobRow.id(), jobRow.executionId());
    }

    public WorkManager(XlrConfig xlrConfig, JobQueue jobQueue, CompositeWorker compositeWorker, JobService jobService, JobRunnerRepository jobRunnerRepository, ReleaseActorService releaseActorService, @Lazy ActorSystemHolder actorSystemHolder) {
        this.xlrConfig = xlrConfig;
        this.jobQueue = jobQueue;
        this.compositeWorker = compositeWorker;
        this.jobService = jobService;
        this.jobRunnerRepository = jobRunnerRepository;
        this.releaseActorService = releaseActorService;
        this.actorSystemHolder = actorSystemHolder;
        Logging.$init$((Logging)this);
        NodeId.$init$(this);
        JobRecoveryLogic.$init$(this);
        this.shutdownInProgress = new AtomicBoolean(false);
        this.workerThreads = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

