/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers.saml2;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.Filter;
import org.opensaml.core.Version;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractAuthenticationFilterConfigurer;
import org.springframework.security.config.annotation.web.configurers.CsrfConfigurer;
import org.springframework.security.saml2.provider.service.authentication.AbstractSaml2AuthenticationRequest;
import org.springframework.security.saml2.provider.service.authentication.OpenSamlAuthenticationProvider;
import org.springframework.security.saml2.provider.service.authentication.OpenSamlAuthenticationRequestFactory;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticationRequestFactory;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistrationRepository;
import org.springframework.security.saml2.provider.service.web.DefaultRelyingPartyRegistrationResolver;
import org.springframework.security.saml2.provider.service.web.DefaultSaml2AuthenticationRequestContextResolver;
import org.springframework.security.saml2.provider.service.web.HttpSessionSaml2AuthenticationRequestRepository;
import org.springframework.security.saml2.provider.service.web.RelyingPartyRegistrationResolver;
import org.springframework.security.saml2.provider.service.web.Saml2AuthenticationRequestContextResolver;
import org.springframework.security.saml2.provider.service.web.Saml2AuthenticationRequestRepository;
import org.springframework.security.saml2.provider.service.web.Saml2AuthenticationTokenConverter;
import org.springframework.security.saml2.provider.service.web.Saml2WebSsoAuthenticationRequestFilter;
import org.springframework.security.saml2.provider.service.web.authentication.Saml2AuthenticationRequestResolver;
import org.springframework.security.saml2.provider.service.web.authentication.Saml2WebSsoAuthenticationFilter;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.security.web.authentication.DelegatingAuthenticationEntryPoint;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.ui.DefaultLoginPageGeneratingFilter;
import org.springframework.security.web.util.matcher.AndRequestMatcher;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.NegatedRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestHeaderRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public final class Saml2LoginConfigurer<B extends HttpSecurityBuilder<B>>
extends AbstractAuthenticationFilterConfigurer<B, Saml2LoginConfigurer<B>, Saml2WebSsoAuthenticationFilter> {
    private static final String OPEN_SAML_4_VERSION = "4";
    private String loginPage;
    private String authenticationRequestUri = "/saml2/authenticate/{registrationId}";
    private Saml2AuthenticationRequestResolver authenticationRequestResolver;
    private String loginProcessingUrl = "/login/saml2/sso/{registrationId}";
    private RelyingPartyRegistrationRepository relyingPartyRegistrationRepository;
    private AuthenticationConverter authenticationConverter;
    private AuthenticationManager authenticationManager;
    private Saml2WebSsoAuthenticationFilter saml2WebSsoAuthenticationFilter;

    public Saml2LoginConfigurer<B> authenticationConverter(AuthenticationConverter authenticationConverter) {
        Assert.notNull((Object)authenticationConverter, (String)"authenticationConverter cannot be null");
        this.authenticationConverter = authenticationConverter;
        return this;
    }

    public Saml2LoginConfigurer<B> authenticationManager(AuthenticationManager authenticationManager) {
        Assert.notNull((Object)authenticationManager, (String)"authenticationManager cannot be null");
        this.authenticationManager = authenticationManager;
        return this;
    }

    public Saml2LoginConfigurer<B> relyingPartyRegistrationRepository(RelyingPartyRegistrationRepository repo) {
        this.relyingPartyRegistrationRepository = repo;
        return this;
    }

    @Override
    public Saml2LoginConfigurer<B> loginPage(String loginPage) {
        Assert.hasText((String)loginPage, (String)"loginPage cannot be empty");
        this.loginPage = loginPage;
        return this;
    }

    public Saml2LoginConfigurer<B> authenticationRequestResolver(Saml2AuthenticationRequestResolver authenticationRequestResolver) {
        Assert.notNull((Object)authenticationRequestResolver, (String)"authenticationRequestResolver cannot be null");
        this.authenticationRequestResolver = authenticationRequestResolver;
        return this;
    }

    @Override
    public Saml2LoginConfigurer<B> loginProcessingUrl(String loginProcessingUrl) {
        Assert.hasText((String)loginProcessingUrl, (String)"loginProcessingUrl cannot be empty");
        this.loginProcessingUrl = loginProcessingUrl;
        return this;
    }

    @Override
    protected RequestMatcher createLoginProcessingUrlMatcher(String loginProcessingUrl) {
        return new AntPathRequestMatcher(loginProcessingUrl);
    }

    @Override
    public void init(B http) throws Exception {
        this.registerDefaultCsrfOverride(http);
        this.relyingPartyRegistrationRepository(http);
        this.saml2WebSsoAuthenticationFilter = new Saml2WebSsoAuthenticationFilter(this.getAuthenticationConverter(http), this.loginProcessingUrl);
        this.saml2WebSsoAuthenticationFilter.setSecurityContextHolderStrategy(this.getSecurityContextHolderStrategy());
        this.setAuthenticationRequestRepository(http, this.saml2WebSsoAuthenticationFilter);
        this.setAuthenticationFilter(this.saml2WebSsoAuthenticationFilter);
        super.loginProcessingUrl(this.loginProcessingUrl);
        if (StringUtils.hasText((String)this.loginPage)) {
            super.loginPage(this.loginPage);
            super.init(http);
        } else {
            boolean singleProvider;
            Map<String, String> providerUrlMap = this.getIdentityProviderUrlMap(this.authenticationRequestUri, this.relyingPartyRegistrationRepository);
            boolean bl = singleProvider = providerUrlMap.size() == 1;
            if (singleProvider) {
                this.updateAuthenticationDefaults();
                this.updateAccessDefaults(http);
                String loginUrl = providerUrlMap.entrySet().iterator().next().getKey();
                this.registerAuthenticationEntryPoint(http, this.getLoginEntryPoint(http, loginUrl));
            } else {
                super.init(http);
            }
        }
        this.initDefaultLoginFilter(http);
    }

    @Override
    public void configure(B http) throws Exception {
        Saml2WebSsoAuthenticationRequestFilter filter = this.getAuthenticationRequestFilter(http);
        filter.setAuthenticationRequestRepository(this.getAuthenticationRequestRepository(http));
        http.addFilter((Filter)this.postProcess(filter));
        super.configure(http);
        if (this.authenticationManager == null) {
            this.registerDefaultAuthenticationProvider(http);
        } else {
            this.saml2WebSsoAuthenticationFilter.setAuthenticationManager(this.authenticationManager);
        }
    }

    private RelyingPartyRegistrationResolver relyingPartyRegistrationResolver(B http) {
        RelyingPartyRegistrationRepository registrations = this.relyingPartyRegistrationRepository(http);
        return new DefaultRelyingPartyRegistrationResolver(registrations);
    }

    RelyingPartyRegistrationRepository relyingPartyRegistrationRepository(B http) {
        if (this.relyingPartyRegistrationRepository == null) {
            this.relyingPartyRegistrationRepository = this.getSharedOrBean(http, RelyingPartyRegistrationRepository.class);
        }
        return this.relyingPartyRegistrationRepository;
    }

    private AuthenticationEntryPoint getLoginEntryPoint(B http, String providerLoginPage) {
        AntPathRequestMatcher loginPageMatcher = new AntPathRequestMatcher(this.getLoginPage());
        AntPathRequestMatcher faviconMatcher = new AntPathRequestMatcher("/favicon.ico");
        RequestMatcher defaultEntryPointMatcher = this.getAuthenticationEntryPointMatcher(http);
        AndRequestMatcher defaultLoginPageMatcher = new AndRequestMatcher(new RequestMatcher[]{new OrRequestMatcher(new RequestMatcher[]{loginPageMatcher, faviconMatcher}), defaultEntryPointMatcher});
        NegatedRequestMatcher notXRequestedWith = new NegatedRequestMatcher((RequestMatcher)new RequestHeaderRequestMatcher("X-Requested-With", "XMLHttpRequest"));
        LinkedHashMap<AndRequestMatcher, LoginUrlAuthenticationEntryPoint> entryPoints = new LinkedHashMap<AndRequestMatcher, LoginUrlAuthenticationEntryPoint>();
        entryPoints.put(new AndRequestMatcher(new RequestMatcher[]{notXRequestedWith, new NegatedRequestMatcher((RequestMatcher)defaultLoginPageMatcher)}), new LoginUrlAuthenticationEntryPoint(providerLoginPage));
        DelegatingAuthenticationEntryPoint loginEntryPoint = new DelegatingAuthenticationEntryPoint(entryPoints);
        loginEntryPoint.setDefaultEntryPoint(this.getAuthenticationEntryPoint());
        return loginEntryPoint;
    }

    private void setAuthenticationRequestRepository(B http, Saml2WebSsoAuthenticationFilter saml2WebSsoAuthenticationFilter) {
        saml2WebSsoAuthenticationFilter.setAuthenticationRequestRepository(this.getAuthenticationRequestRepository(http));
    }

    private Saml2WebSsoAuthenticationRequestFilter getAuthenticationRequestFilter(B http) {
        Saml2AuthenticationRequestResolver authenticationRequestResolver = this.getAuthenticationRequestResolver(http);
        if (authenticationRequestResolver != null) {
            return new Saml2WebSsoAuthenticationRequestFilter(authenticationRequestResolver);
        }
        return new Saml2WebSsoAuthenticationRequestFilter(this.getAuthenticationRequestContextResolver(http), this.getAuthenticationRequestFactory(http));
    }

    private Saml2AuthenticationRequestResolver getAuthenticationRequestResolver(B http) {
        if (this.authenticationRequestResolver != null) {
            return this.authenticationRequestResolver;
        }
        return this.getBeanOrNull(http, Saml2AuthenticationRequestResolver.class);
    }

    private Saml2AuthenticationRequestFactory getAuthenticationRequestFactory(B http) {
        Saml2AuthenticationRequestFactory resolver = this.getSharedOrBean(http, Saml2AuthenticationRequestFactory.class);
        if (resolver != null) {
            return resolver;
        }
        if (this.version().startsWith(OPEN_SAML_4_VERSION)) {
            return OpenSaml4LoginSupportFactory.getAuthenticationRequestFactory();
        }
        return new OpenSamlAuthenticationRequestFactory();
    }

    private Saml2AuthenticationRequestContextResolver getAuthenticationRequestContextResolver(B http) {
        Saml2AuthenticationRequestContextResolver resolver = this.getBeanOrNull(http, Saml2AuthenticationRequestContextResolver.class);
        if (resolver != null) {
            return resolver;
        }
        DefaultRelyingPartyRegistrationResolver registrationResolver = new DefaultRelyingPartyRegistrationResolver(this.relyingPartyRegistrationRepository);
        return new DefaultSaml2AuthenticationRequestContextResolver((RelyingPartyRegistrationResolver)registrationResolver);
    }

    private AuthenticationConverter getAuthenticationConverter(B http) {
        if (this.authenticationConverter != null) {
            return this.authenticationConverter;
        }
        AuthenticationConverter authenticationConverterBean = (AuthenticationConverter)this.getBeanOrNull(http, Saml2AuthenticationTokenConverter.class);
        if (authenticationConverterBean == null) {
            Assert.state((boolean)this.loginProcessingUrl.contains("{registrationId}"), (String)"loginProcessingUrl must contain {registrationId} path variable");
            return new Saml2AuthenticationTokenConverter((RelyingPartyRegistrationResolver)new DefaultRelyingPartyRegistrationResolver(this.relyingPartyRegistrationRepository));
        }
        return authenticationConverterBean;
    }

    private void registerDefaultAuthenticationProvider(B http) {
        if (this.version().startsWith(OPEN_SAML_4_VERSION)) {
            http.authenticationProvider(this.postProcess(OpenSaml4LoginSupportFactory.getAuthenticationProvider()));
        } else {
            http.authenticationProvider((AuthenticationProvider)this.postProcess(new OpenSamlAuthenticationProvider()));
        }
    }

    private void registerDefaultCsrfOverride(B http) {
        CsrfConfigurer csrf = http.getConfigurer(CsrfConfigurer.class);
        if (csrf == null) {
            return;
        }
        csrf.ignoringRequestMatchers(new RequestMatcher[]{new AntPathRequestMatcher(this.loginProcessingUrl)});
    }

    private void initDefaultLoginFilter(B http) {
        DefaultLoginPageGeneratingFilter loginPageGeneratingFilter = http.getSharedObject(DefaultLoginPageGeneratingFilter.class);
        if (loginPageGeneratingFilter == null || this.isCustomLoginPage()) {
            return;
        }
        loginPageGeneratingFilter.setSaml2LoginEnabled(true);
        loginPageGeneratingFilter.setSaml2AuthenticationUrlToProviderName(this.getIdentityProviderUrlMap(this.authenticationRequestUri, this.relyingPartyRegistrationRepository));
        loginPageGeneratingFilter.setLoginPageUrl(this.getLoginPage());
        loginPageGeneratingFilter.setFailureUrl(this.getFailureUrl());
    }

    private Map<String, String> getIdentityProviderUrlMap(String authRequestPrefixUrl, RelyingPartyRegistrationRepository idpRepo) {
        LinkedHashMap<String, String> idps = new LinkedHashMap<String, String>();
        if (idpRepo instanceof Iterable) {
            Iterable repo = (Iterable)idpRepo;
            repo.forEach(p -> idps.put(authRequestPrefixUrl.replace("{registrationId}", p.getRegistrationId()), p.getRegistrationId()));
        }
        return idps;
    }

    private Saml2AuthenticationRequestRepository<AbstractSaml2AuthenticationRequest> getAuthenticationRequestRepository(B http) {
        Saml2AuthenticationRequestRepository repository = this.getBeanOrNull(http, Saml2AuthenticationRequestRepository.class);
        if (repository == null) {
            return new HttpSessionSaml2AuthenticationRequestRepository();
        }
        return repository;
    }

    private String version() {
        String version = Version.getVersion();
        if (StringUtils.hasText((String)version)) {
            return version;
        }
        boolean openSaml4ClassPresent = ClassUtils.isPresent((String)"org.opensaml.core.xml.persist.impl.PassthroughSourceStrategy", null);
        if (openSaml4ClassPresent) {
            return OPEN_SAML_4_VERSION;
        }
        throw new IllegalStateException("cannot determine OpenSAML version");
    }

    private <C> C getSharedOrBean(B http, Class<C> clazz) {
        C shared = http.getSharedObject(clazz);
        if (shared != null) {
            return shared;
        }
        return this.getBeanOrNull(http, clazz);
    }

    private <C> C getBeanOrNull(B http, Class<C> clazz) {
        ApplicationContext context = http.getSharedObject(ApplicationContext.class);
        if (context == null) {
            return null;
        }
        try {
            return (C)context.getBean(clazz);
        }
        catch (NoSuchBeanDefinitionException ex) {
            return null;
        }
    }

    private <C> void setSharedObject(B http, Class<C> clazz, C object) {
        if (http.getSharedObject(clazz) == null) {
            http.setSharedObject(clazz, object);
        }
    }

    private static class OpenSaml4LoginSupportFactory {
        private OpenSaml4LoginSupportFactory() {
        }

        private static Saml2AuthenticationRequestFactory getAuthenticationRequestFactory() {
            try {
                Class authenticationRequestFactory = ClassUtils.forName((String)"org.springframework.security.saml2.provider.service.authentication.OpenSaml4AuthenticationRequestFactory", (ClassLoader)OpenSaml4LoginSupportFactory.class.getClassLoader());
                return (Saml2AuthenticationRequestFactory)authenticationRequestFactory.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException ex) {
                throw new IllegalStateException("Could not instantiate OpenSaml4AuthenticationRequestFactory", ex);
            }
        }

        private static AuthenticationProvider getAuthenticationProvider() {
            try {
                Class authenticationProvider = ClassUtils.forName((String)"org.springframework.security.saml2.provider.service.authentication.OpenSaml4AuthenticationProvider", (ClassLoader)OpenSaml4LoginSupportFactory.class.getClassLoader());
                return (AuthenticationProvider)authenticationProvider.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException ex) {
                throw new IllegalStateException("Could not instantiate OpenSaml4AuthenticationProvider", ex);
            }
        }
    }
}

