/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.tmatesoft.svn.core.SVNException;

public class SVNUUIDGenerator {
    public static String generateUUIDString() throws SVNException {
        return UUID.randomUUID().toString();
    }

    public static byte[] generateUUID() throws SVNException {
        UUID uuid = UUID.randomUUID();
        ByteBuffer bb = ByteBuffer.allocate(16);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        return bb.array();
    }

    public static String formatUUID(byte[] uuid) {
        ByteBuffer bb = ByteBuffer.allocate(16);
        bb.put(uuid, 0, Math.min(uuid.length, 16));
        bb.clear();
        long firstLong = bb.getLong();
        long secondLong = bb.getLong();
        return new UUID(firstLong, secondLong).toString();
    }
}

