/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.license.service;

import com.xebialabs.deployit.io.ConfigurationResource;
import com.xebialabs.deployit.repository.RepositoryMetadataService;
import com.xebialabs.license.DummyLicense;
import com.xebialabs.license.License;
import com.xebialabs.license.LicenseParseException;
import com.xebialabs.license.LicenseReader;
import com.xebialabs.license.LicenseViolationException;
import com.xebialabs.license.service.AbstractResourceLicenseService;
import com.xebialabs.license.service.LicenseService;
import java.io.IOException;

public class ResourceRegistrationLicenseService
extends AbstractResourceLicenseService
implements LicenseService {
    private final LicenseReader licenseReader = new LicenseReader();

    public ResourceRegistrationLicenseService(ConfigurationResource licenseResource, String product, RepositoryMetadataService repositoryMetadataService) throws LicenseParseException, LicenseViolationException, IOException {
        super(licenseResource, product, repositoryMetadataService);
        this.license = this.readLicense(licenseResource);
        if (this.license.isDateExpired()) {
            this.logLicenseError(licenseResource);
        }
    }

    @Override
    protected License readLicense(ConfigurationResource licenseResource) throws LicenseParseException, LicenseViolationException {
        try {
            if (!licenseResource.exists()) {
                return DummyLicense.create();
            }
            log.info("Reading license from file {}", (Object)licenseResource.getUrl());
            License license = this.licenseReader.readLicense(licenseResource);
            log.info(license.toLicenseContent());
            if (license.isDateExpired()) {
                log.warn("*** License has expired.");
            }
            return license;
        }
        catch (IOException e) {
            throw new LicenseParseException(e.getMessage(), (Throwable)e);
        }
    }
}

