/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.CheckoutConflictException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuildIterator;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.EmptyTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;

public class ResetCommand
extends GitCommand<Ref> {
    private String ref = null;
    private ResetType mode;
    private Collection<String> filepaths = new LinkedList<String>();
    private boolean isReflogDisabled;
    private ProgressMonitor monitor = NullProgressMonitor.INSTANCE;

    public ResetCommand(Repository repo) {
        super(repo);
    }

    @Override
    public Ref call() throws GitAPIException, CheckoutConflictException {
        this.checkCallable();
        try {
            RepositoryState state = this.repo.getRepositoryState();
            boolean merging = state.equals((Object)RepositoryState.MERGING) || state.equals((Object)RepositoryState.MERGING_RESOLVED);
            boolean cherryPicking = state.equals((Object)RepositoryState.CHERRY_PICKING) || state.equals((Object)RepositoryState.CHERRY_PICKING_RESOLVED);
            boolean reverting = state.equals((Object)RepositoryState.REVERTING) || state.equals((Object)RepositoryState.REVERTING_RESOLVED);
            ObjectId commitId = this.resolveRefToCommitId();
            if (this.ref != null && commitId == null) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().invalidRefName, this.ref));
            }
            RevTree commitTree = commitId != null ? this.parseCommit(commitId).getTree() : null;
            if (!this.filepaths.isEmpty()) {
                this.resetIndexForPaths(commitTree);
                this.setCallable(false);
                return this.repo.exactRef("HEAD");
            }
            if (commitId != null) {
                RefUpdate ru = this.repo.updateRef("HEAD");
                ru.setNewObjectId(commitId);
                String refName = Repository.shortenRefName(this.getRefOrHEAD());
                if (this.isReflogDisabled) {
                    ru.disableRefLog();
                } else {
                    String message = String.valueOf(refName) + ": updating " + "HEAD";
                    ru.setRefLogMessage(message, false);
                }
                if (ru.forceUpdate() == RefUpdate.Result.LOCK_FAILURE) {
                    throw new JGitInternalException(MessageFormat.format(JGitText.get().cannotLock, ru.getName()));
                }
                ObjectId origHead = ru.getOldObjectId();
                if (origHead != null) {
                    this.repo.writeOrigHead(origHead);
                }
            }
            Ref result = this.repo.exactRef("HEAD");
            if (this.mode == null) {
                this.mode = ResetType.MIXED;
            }
            switch (this.mode) {
                case HARD: {
                    this.checkoutIndex(commitTree);
                    break;
                }
                case MIXED: {
                    this.resetIndex(commitTree);
                    break;
                }
                case SOFT: {
                    break;
                }
                case MERGE: 
                case KEEP: {
                    throw new UnsupportedOperationException();
                }
            }
            if (this.mode != ResetType.SOFT) {
                if (merging) {
                    this.resetMerge();
                } else if (cherryPicking) {
                    this.resetCherryPick();
                } else if (reverting) {
                    this.resetRevert();
                } else if (this.repo.readSquashCommitMsg() != null) {
                    this.repo.writeSquashCommitMsg(null);
                }
            }
            this.setCallable(false);
            return result;
        }
        catch (IOException e) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionCaughtDuringExecutionOfResetCommand, e.getMessage()), e);
        }
    }

    private RevCommit parseCommit(ObjectId commitId) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (RevWalk rw = new RevWalk(this.repo);){
                return rw.parseCommit(commitId);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().cannotReadCommit, commitId.toString()), e);
        }
    }

    private ObjectId resolveRefToCommitId() {
        try {
            return this.repo.resolve(String.valueOf(this.getRefOrHEAD()) + "^{commit}");
        }
        catch (IOException e) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().cannotRead, this.getRefOrHEAD()), e);
        }
    }

    public ResetCommand setRef(String ref) {
        this.ref = ref;
        return this;
    }

    public ResetCommand setMode(ResetType mode) {
        if (!this.filepaths.isEmpty()) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().illegalCombinationOfArguments, "[--mixed | --soft | --hard]", "<paths>..."));
        }
        this.mode = mode;
        return this;
    }

    public ResetCommand addPath(String path) {
        if (this.mode != null) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().illegalCombinationOfArguments, "<paths>...", "[--mixed | --soft | --hard]"));
        }
        this.filepaths.add(path);
        return this;
    }

    public ResetCommand disableRefLog(boolean disable) {
        this.isReflogDisabled = disable;
        return this;
    }

    public boolean isReflogDisabled() {
        return this.isReflogDisabled;
    }

    private String getRefOrHEAD() {
        if (this.ref != null) {
            return this.ref;
        }
        return "HEAD";
    }

    public ResetCommand setProgressMonitor(ProgressMonitor monitor) {
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        this.monitor = monitor;
        return this;
    }

    private void resetIndexForPaths(ObjectId commitTree) {
        DirCache dc = null;
        try {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (TreeWalk tw = new TreeWalk(this.repo);){
                    dc = this.repo.lockDirCache();
                    DirCacheBuilder builder = dc.builder();
                    tw.addTree(new DirCacheBuildIterator(builder));
                    if (commitTree != null) {
                        tw.addTree(commitTree);
                    } else {
                        tw.addTree(new EmptyTreeIterator());
                    }
                    tw.setFilter(PathFilterGroup.createFromStrings(this.filepaths));
                    tw.setRecursive(true);
                    while (tw.next()) {
                        CanonicalTreeParser tree = tw.getTree(1, CanonicalTreeParser.class);
                        if (tree == null) continue;
                        DirCacheEntry entry = new DirCacheEntry(tw.getRawPath());
                        entry.setFileMode(tree.getEntryFileMode());
                        entry.setObjectId(tree.getEntryObjectId());
                        builder.add(entry);
                    }
                    builder.commit();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            if (dc != null) {
                dc.unlock();
            }
        }
    }

    private void resetIndex(ObjectId commitTree) throws IOException {
        DirCache dc = this.repo.lockDirCache();
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (TreeWalk walk = new TreeWalk(this.repo);){
                DirCacheBuilder builder = dc.builder();
                if (commitTree != null) {
                    walk.addTree(commitTree);
                } else {
                    walk.addTree(new EmptyTreeIterator());
                }
                walk.addTree(new DirCacheIterator(dc));
                walk.setRecursive(true);
                while (walk.next()) {
                    AbstractTreeIterator cIter = walk.getTree(0, AbstractTreeIterator.class);
                    if (cIter == null) continue;
                    DirCacheEntry entry = new DirCacheEntry(walk.getRawPath());
                    entry.setFileMode(cIter.getEntryFileMode());
                    entry.setObjectIdFromRaw(cIter.idBuffer(), cIter.idOffset());
                    DirCacheIterator dcIter = walk.getTree(1, DirCacheIterator.class);
                    if (dcIter != null && dcIter.idEqual(cIter)) {
                        DirCacheEntry indexEntry = dcIter.getDirCacheEntry();
                        entry.setLastModified(indexEntry.getLastModifiedInstant());
                        entry.setLength(indexEntry.getLength());
                    }
                    builder.add(entry);
                }
                builder.commit();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            dc.unlock();
        }
    }

    private void checkoutIndex(ObjectId commitTree) throws IOException, GitAPIException {
        DirCache dc = this.repo.lockDirCache();
        try {
            DirCacheCheckout checkout = new DirCacheCheckout(this.repo, dc, commitTree);
            checkout.setFailOnConflict(false);
            checkout.setProgressMonitor(this.monitor);
            try {
                checkout.checkout();
            }
            catch (org.eclipse.jgit.errors.CheckoutConflictException cce) {
                throw new CheckoutConflictException(checkout.getConflicts(), cce);
            }
        }
        finally {
            dc.unlock();
        }
    }

    private void resetMerge() throws IOException {
        this.repo.writeMergeHeads(null);
        this.repo.writeMergeCommitMsg(null);
    }

    private void resetCherryPick() throws IOException {
        this.repo.writeCherryPickHead(null);
        this.repo.writeMergeCommitMsg(null);
    }

    private void resetRevert() throws IOException {
        this.repo.writeRevertHead(null);
        this.repo.writeMergeCommitMsg(null);
    }

    public String toString() {
        return "ResetCommand [repo=" + this.repo + ", ref=" + this.ref + ", mode=" + (Object)((Object)this.mode) + ", isReflogDisabled=" + this.isReflogDisabled + ", filepaths=" + this.filepaths + "]";
    }

    public static enum ResetType {
        SOFT,
        MIXED,
        HARD,
        MERGE,
        KEEP;

    }
}

