/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.storage.local;

import com.xebialabs.xlrelease.storage.Storage;
import com.xebialabs.xlrelease.storage.local.LocalStorageConfig;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Marker;
import org.springframework.util.FileSystemUtils;
import org.springframework.util.StreamUtils;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Using;
import scala.util.Using$;

@ScalaSignature(bytes="\u0006\u0005\u0005ec\u0001B\u000b\u0017\u0001\u0005B\u0001\u0002\u000e\u0001\u0003\u0006\u0004%\t!\u000e\u0005\tu\u0001\u0011\t\u0011)A\u0005m!)1\b\u0001C\u0001y!)q\b\u0001C\u0006k!)\u0001\t\u0001C!\u0003\")A\u000b\u0001C!+\")q\u000b\u0001C!1\")Q\f\u0001C!=\")1\r\u0001C!I\")a\r\u0001C\u0005O\")Q\u000e\u0001C!]\u001a!!\u0010A\u0003|\u0011!YEB!A!\u0002\u0013\u0011\u0005\"B\u001e\r\t\u0003a\bbBA\u0001\u0019\u0011\u0005\u00111\u0001\u0005\b\u0003/aA\u0011AA\r\u0011%\ti\u0002AA\u0001\n\u0017\ty\u0002C\u0004\u0002$\u0001!I!!\n\t\u000f\u00055\u0003\u0001\"\u0011\u0002P!9\u00111\u000b\u0001\u0005B\u0005U#\u0001\u0004'pG\u0006d7\u000b^8sC\u001e,'BA\f\u0019\u0003\u0015awnY1m\u0015\tI\"$A\u0004ti>\u0014\u0018mZ3\u000b\u0005ma\u0012!\u0003=me\u0016dW-Y:f\u0015\tib$A\u0005yK\nL\u0017\r\\1cg*\tq$A\u0002d_6\u001c\u0001a\u0005\u0003\u0001E!b\u0003CA\u0012'\u001b\u0005!#\"A\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d\"#AB!osJ+g\r\u0005\u0002*U5\t\u0001$\u0003\u0002,1\t91\u000b^8sC\u001e,\u0007CA\u00173\u001b\u0005q#BA\u00181\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005\t\u0014\u0001C4sSjTH.\u001a3\n\u0005Mr#a\u0002'pO\u001eLgnZ\u0001\u0007G>tg-[4\u0016\u0003Y\u0002\"a\u000e\u001d\u000e\u0003YI!!\u000f\f\u0003%1{7-\u00197Ti>\u0014\u0018mZ3D_:4\u0017nZ\u0001\bG>tg-[4!\u0003\u0019a\u0014N\\5u}Q\u0011QH\u0010\t\u0003o\u0001AQ\u0001N\u0002A\u0002Y\na\"[7qY&\u001c\u0017\u000e^\"p]\u001aLw-A\u0002qkR$2A\u0011&M!\t\u0019\u0005*D\u0001E\u0015\t)e)A\u0002oKRT\u0011aR\u0001\u0005U\u00064\u0018-\u0003\u0002J\t\n\u0019QKU%\t\u000b-+\u0001\u0019\u0001\"\u0002\u0007U\u0014\u0018\u000eC\u0003N\u000b\u0001\u0007a*\u0001\u0003eCR\f\u0007CA(S\u001b\u0005\u0001&BA)G\u0003\tIw.\u0003\u0002T!\nY\u0011J\u001c9viN#(/Z1n\u0003\r9W\r\u001e\u000b\u0003\u001dZCQa\u0013\u0004A\u0002\t\u000bAa]5{KR\u0011\u0011\f\u0018\t\u0003GiK!a\u0017\u0013\u0003\t1{gn\u001a\u0005\u0006\u0017\u001e\u0001\rAQ\u0001\u0007I\u0016dW\r^3\u0015\u0005}\u0013\u0007CA\u0012a\u0013\t\tGEA\u0004C_>dW-\u00198\t\u000b-C\u0001\u0019\u0001\"\u0002\u001b\u0011,G.\u001a;f\u0013\u001a,U\u000e\u001d;z)\tyV\rC\u0003L\u0013\u0001\u0007!)A\bde\u0016\fG/\u001a#je\u0016\u001cGo\u001c:z)\tA7\u000e\u0005\u0002$S&\u0011!\u000e\n\u0002\u0005+:LG\u000fC\u0003m\u0015\u0001\u0007!)\u0001\u0004baB,g\u000eZ\u0001\nkJL7k\u00195f[\u0016,\u0012a\u001c\t\u0003a^t!!];\u0011\u0005I$S\"A:\u000b\u0005Q\u0004\u0013A\u0002\u001fs_>$h(\u0003\u0002wI\u00051\u0001K]3eK\u001aL!\u0001_=\u0003\rM#(/\u001b8h\u0015\t1HE\u0001\u0007Ve&,\u0005\u0010^3og&|gn\u0005\u0002\rEQ\u0011Qp \t\u0003}2i\u0011\u0001\u0001\u0005\u0006\u0017:\u0001\rAQ\u0001\fO\u0016$h)\u001e7m!\u0006$\b\u000e\u0006\u0003\u0002\u0006\u0005U\u0001\u0003BA\u0004\u0003#i!!!\u0003\u000b\t\u0005-\u0011QB\u0001\u0005M&dWMC\u0002\u0002\u0010\u0019\u000b1A\\5p\u0013\u0011\t\u0019\"!\u0003\u0003\tA\u000bG\u000f\u001b\u0005\u0006i=\u0001\u001dAN\u0001\u0018O\u0016$\u0018IY:pYV$X\rU1uQ2{7-\u0019;j_:$2a\\A\u000e\u0011\u0015!\u0004\u0003q\u00017\u00031)&/[#yi\u0016t7/[8o)\ri\u0018\u0011\u0005\u0005\u0006\u0017F\u0001\rAQ\u0001\rY&\u001cHoQ8oi\u0016tGo\u001d\u000b\u0007\u0003O\tI$a\u0011\u0011\u000b\u0005%\u00121\u0007\"\u000f\t\u0005-\u0012q\u0006\b\u0004e\u00065\u0012\"A\u0013\n\u0007\u0005EB%A\u0004qC\u000e\\\u0017mZ3\n\t\u0005U\u0012q\u0007\u0002\u0005\u0019&\u001cHOC\u0002\u00022\u0011Bq!a\u000f\u0013\u0001\u0004\ti$A\u0005eSJ,7\r^8ssB\u0019q*a\u0010\n\u0007\u0005\u0005\u0003K\u0001\u0003GS2,\u0007bBA#%\u0001\u0007\u0011qI\u0001\u000fM&dWM\\1nK\u001aKG\u000e^3s!\ry\u0015\u0011J\u0005\u0004\u0003\u0017\u0002&A\u0004$jY\u0016t\u0017-\\3GS2$XM]\u0001\u0010Y&\u001cH\u000fR5sK\u000e$xN]5fgR!\u0011qEA)\u0011\u0015Y5\u00031\u0001C\u0003%a\u0017n\u001d;GS2,7\u000f\u0006\u0003\u0002(\u0005]\u0003\"B&\u0015\u0001\u0004\u0011\u0005")
public class LocalStorage
implements Storage,
Logging {
    private final LocalStorageConfig config;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        LocalStorage localStorage = this;
        synchronized (localStorage) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public LocalStorageConfig config() {
        return this.config;
    }

    private LocalStorageConfig implicitConfig() {
        return this.config();
    }

    @Override
    public URI put(URI uri, InputStream data) {
        this.createDirectory(uri);
        Using$.MODULE$.resource((Object)new FileOutputStream(this.UriExtension(uri).getFullPath(this.implicitConfig()).toFile()), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)LocalStorage.$anonfun$put$1(data, x$1)), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        return new URI("file", null, this.UriExtension(uri).getFullPath(this.implicitConfig()).toUri().getPath(), null);
    }

    @Override
    public InputStream get(URI uri) {
        URI fileUri = new URI(null, null, uri.getPath(), null);
        return new BufferedInputStream(new FileInputStream(this.UriExtension(fileUri).getAbsolutePathLocation(this.implicitConfig())));
    }

    @Override
    public long size(URI uri) {
        long l;
        try {
            URI fileUri = new URI(null, null, uri.getPath(), null);
            l = Files.size(this.UriExtension(fileUri).getFullPath(this.implicitConfig()));
        }
        catch (NoSuchFileException noSuchFileException) {
            throw new FileNotFoundException("Unable to find file at '" + uri + "'");
        }
        catch (IOException e) {
            throw new IOException("Unable to find file size at '" + uri + "'", e);
        }
        return l;
    }

    @Override
    public boolean delete(URI uri) {
        boolean bl;
        URI fileUri = new URI(null, null, uri.getPath(), null);
        File file = this.UriExtension(fileUri).getFullPath(this.implicitConfig()).toFile();
        try {
            bl = FileSystemUtils.deleteRecursively((File)file);
        }
        catch (Exception ex) {
            this.logger().error((Function0 & Serializable)() -> "Unable to delete " + file.getName(), (Function0 & Serializable)() -> ex);
            throw ex;
        }
        return bl;
    }

    @Override
    public boolean deleteIfEmpty(URI uri) {
        URI fileUri = new URI(null, null, uri.getPath(), null);
        File file = this.UriExtension(fileUri).getFullPath(this.implicitConfig()).toFile();
        if (file.exists() && file.isDirectory() && ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])file.list()))) {
            return file.delete();
        }
        return false;
    }

    private void createDirectory(URI append) {
        File file;
        File file2;
        if (append != null) {
            Path path = this.UriExtension(append).getFullPath(this.implicitConfig());
            file2 = path.getParent().toFile();
        } else {
            file2 = file = new File(this.config().basePath().toUri());
        }
        if (!file.exists() && !file.mkdirs()) {
            if (!file.exists()) {
                throw new RuntimeException("Cannot create directory: " + file.getAbsolutePath());
            }
            return;
        }
    }

    @Override
    public String uriScheme() {
        return this.config().uriScheme();
    }

    private UriExtension UriExtension(URI uri) {
        return new UriExtension(this, uri);
    }

    private List<URI> listContents(File directory, FilenameFilter filenameFilter) {
        String uri = directory.toPath().toUri().toString();
        if (directory.isDirectory()) {
            List dirItems = Predef$.MODULE$.wrapRefArray((Object[])directory.list(filenameFilter)).toList();
            if (dirItems.exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)LocalStorage.$anonfun$listContents$1(x$2)))) {
                return ((List)dirItems.sorted((Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable)name -> URI.create(uri + name));
            }
            return ((List)dirItems.map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$3)))).sorted((Ordering)Ordering.Long$.MODULE$)).map((Function1 & Serializable)name -> LocalStorage.$anonfun$listContents$5(uri, BoxesRunTime.unboxToLong((Object)name)));
        }
        return package$.MODULE$.List().empty();
    }

    @Override
    public List<URI> listDirectories(URI uri) {
        URI fileUri = new URI(null, null, uri.getPath(), null);
        File file = this.UriExtension(fileUri).getFullPath(this.implicitConfig()).toFile();
        return this.listContents(file, (dir, name) -> new File(dir, name).isDirectory());
    }

    @Override
    public List<URI> listFiles(URI uri) {
        URI fileUri = new URI(null, null, uri.getPath(), null);
        File file = this.UriExtension(fileUri).getFullPath(this.implicitConfig()).toFile();
        return this.listContents(file, (dir, name) -> new File(dir, name).isFile());
    }

    public static final /* synthetic */ int $anonfun$put$1(InputStream data$1, FileOutputStream x$1) {
        return StreamUtils.copy((InputStream)data$1, (OutputStream)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$listContents$2(char x$1) {
        return Character.isDigit(x$1);
    }

    public static final /* synthetic */ boolean $anonfun$listContents$1(String x$2) {
        return !StringOps$.MODULE$.forall$extension(Predef$.MODULE$.augmentString(x$2), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)LocalStorage.$anonfun$listContents$2(BoxesRunTime.unboxToChar((Object)x$1))));
    }

    public static final /* synthetic */ URI $anonfun$listContents$5(String uri$1, long name) {
        return URI.create(uri$1 + name);
    }

    public LocalStorage(LocalStorageConfig config) {
        this.config = config;
        Logging.$init$((Logging)this);
        this.createDirectory(null);
    }

    private class UriExtension {
        private final URI uri;
        public final /* synthetic */ LocalStorage $outer;

        public Path getFullPath(LocalStorageConfig config) {
            Path resolvedPath;
            String[] pathChunks = this.uri.getPath().split("/");
            Path path = this.uri.getPath().matches("^/[a-zA-Z]:.*") ? Paths.get("", pathChunks) : Paths.get("/", pathChunks);
            Path basePath = config.basePath().toAbsolutePath();
            Path path2 = resolvedPath = path.startsWith(basePath) ? path : Paths.get(((Object)basePath).toString(), ((Object)path).toString());
            if (!resolvedPath.normalize().startsWith(basePath)) {
                throw new IllegalArgumentException("Resolved path '" + resolvedPath + " for 'URI '" + this.uri + "' is outside of the base path '" + basePath + "'. '");
            }
            return resolvedPath;
        }

        public String getAbsolutePathLocation(LocalStorageConfig config) {
            return ((Object)this.getFullPath(config).toAbsolutePath()).toString();
        }

        public /* synthetic */ LocalStorage com$xebialabs$xlrelease$storage$local$LocalStorage$UriExtension$$$outer() {
            return this.$outer;
        }

        public UriExtension(LocalStorage $outer, URI uri) {
            this.uri = uri;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

